/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal.geomapbrowser;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class TitleControl
extends Canvas {
    private static final int TOP_SPACE = 0;
    private Font font;
    private Color gradient1Color;
    private Color gradient2Color;
    private Color bottomLineColor;
    private Color writingColor;
    private Image image;
    private String text = "";
    private Point size = new Point(1, 1);

    public TitleControl(Composite parent, Image image) {
        super(parent, 0x20000000);
        this.addPaintListener(e -> this.onPaint(e));
        this.addDisposeListener(e -> this.onDispose(e));
        this.font = new Font((Device)this.getDisplay(), "Tahoma", 10, 1);
        this.gradient1Color = new Color((Device)this.getDisplay(), 255, 255, 255);
        this.gradient2Color = new Color((Device)this.getDisplay(), 205, 224, 244);
        this.bottomLineColor = new Color((Device)this.getDisplay(), 200, 195, 216);
        this.writingColor = new Color((Device)this.getDisplay(), 60, 60, 60);
        this.image = image;
        this.measureSize("M");
    }

    private void measureSize(String s) {
        GC gc = new GC((Drawable)this);
        try {
            gc.setFont(this.font);
            this.size = gc.stringExtent(s);
            this.size.y = this.image != null ? Math.max(this.image.getBounds().height + 1, this.size.y) : (this.size.y += 16);
            this.size.y += 0;
        }
        finally {
            gc.dispose();
        }
    }

    private void onDispose(DisposeEvent e) {
        this.font.dispose();
        this.gradient1Color.dispose();
        this.gradient2Color.dispose();
        this.bottomLineColor.dispose();
        this.writingColor.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        Point s = this.getSize();
        int w = s.x;
        int h = s.y;
        gc.setForeground(this.gradient1Color);
        gc.setBackground(this.gradient2Color);
        gc.fillGradientRectangle(0, 0, w, h - 1, true);
        Rectangle imgsize = new Rectangle(0, 0, 0, 0);
        if (this.image != null) {
            imgsize = this.image.getBounds();
            gc.drawImage(this.image, 12, 0);
        }
        gc.setForeground(this.bottomLineColor);
        gc.drawLine(0, h - 1, w, h - 1);
        gc.setFont(this.font);
        gc.setForeground(this.writingColor);
        Point textSize = gc.stringExtent(this.text);
        int ty = (h - textSize.y) / 2;
        gc.drawString(this.text, 22 + imgsize.width, 0 + ty, true);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.measureSize(text);
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.size.x, this.size.y);
    }
}

