/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.PageEnumeration;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.widgets.RotateClockwisePrintPiece;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class PrintPreview
extends Canvas {
    private static final int ALL_PAGES = -1;
    private PrintJob printJob = null;
    private PrinterData printerData = PaperClips.getDefaultPrinterData();
    private int pageIndex = 0;
    private boolean fitHorizontal = true;
    private boolean fitVertical = true;
    private float scale = 1.0f;
    private int horizontalPageCount = 1;
    private int verticalPageCount = 1;
    private boolean lazy = false;
    private Point paperSize = null;
    private Printer printer = null;
    private GC gc = null;
    private PageEnumeration pageEnumeration = null;
    private List<PrintPiece> pages = null;
    private Point pageDisplaySize = null;
    private Point[] pageDisplayLocations = null;
    private Rectangle margins = new Rectangle(10, 10, 10, 10);
    private Point pageSpacing = new Point(10, 10);

    public PrintPreview(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(9, event -> this.paint(event));
        this.addListener(11, event -> {
            this.invalidatePageDisplayBounds();
            this.redraw();
        });
        this.addListener(12, event -> this.disposeResources());
    }

    public PrintJob getPrintJob() {
        this.checkWidget();
        return this.printJob;
    }

    public void setPrintJob(PrintJob printJob) {
        this.checkWidget();
        this.printJob = printJob;
        this.pageIndex = 0;
        this.disposePages();
        this.redraw();
    }

    public PrinterData getPrinterData() {
        this.checkWidget();
        return this.printerData;
    }

    public void setPrinterData(PrinterData printerData) {
        this.checkWidget();
        this.printerData = printerData;
        this.pageIndex = 0;
        this.disposePrinter();
        this.redraw();
    }

    public int getPageIndex() {
        this.checkWidget();
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.checkWidget();
        this.pageIndex = pageIndex;
        this.redraw();
    }

    public int getPageCount() {
        this.checkWidget();
        this.fetchPages(this.lazy ? this.horizontalPageCount * this.verticalPageCount : -1);
        return this.pages == null ? 0 : this.pages.size();
    }

    public boolean isPageLayoutComplete() {
        this.checkWidget();
        this.fetchPages(this.horizontalPageCount * this.verticalPageCount);
        return this.pageEnumeration == null || !this.pageEnumeration.hasNext();
    }

    public boolean isFitHorizontal() {
        this.checkWidget();
        return this.fitHorizontal;
    }

    public void setFitHorizontal(boolean fitHorizontal) {
        this.checkWidget();
        if (this.fitHorizontal != fitHorizontal) {
            this.fitHorizontal = fitHorizontal;
            this.invalidatePageDisplayBounds();
            this.redraw();
        }
    }

    public boolean isFitVertical() {
        this.checkWidget();
        return this.fitVertical;
    }

    public void setFitVertical(boolean fitVertical) {
        this.checkWidget();
        if (this.fitVertical != fitVertical) {
            this.fitVertical = fitVertical;
            this.invalidatePageDisplayBounds();
            this.redraw();
        }
    }

    public float getScale() {
        this.checkWidget();
        return this.scale;
    }

    public void setScale(float scale) {
        this.checkWidget();
        this.scale = PrintPreview.checkScale(scale);
        if (!this.fitVertical && !this.fitHorizontal) {
            this.invalidatePageDisplayBounds();
            this.redraw();
        }
    }

    private static float checkScale(float scale) {
        if (!(scale > 0.0f)) {
            PaperClips.error((int)5, (String)"Scale must be > 0");
        }
        return scale;
    }

    public int getHorizontalPageCount() {
        this.checkWidget();
        return this.horizontalPageCount;
    }

    public void setHorizontalPageCount(int horizontalPages) {
        this.checkWidget();
        if (horizontalPages < 1) {
            horizontalPages = 1;
        }
        this.horizontalPageCount = horizontalPages;
        this.invalidatePageDisplayBounds();
        this.redraw();
    }

    public int getVerticalPageCount() {
        this.checkWidget();
        return this.verticalPageCount;
    }

    public void setVerticalPageCount(int verticalPages) {
        this.checkWidget();
        if (verticalPages < 1) {
            verticalPages = 1;
        }
        this.verticalPageCount = verticalPages;
        this.invalidatePageDisplayBounds();
        this.redraw();
    }

    public boolean isLazyPageLayout() {
        this.checkWidget();
        return this.lazy;
    }

    public void setLazyPageLayout(boolean lazy) {
        this.checkWidget();
        this.lazy = lazy;
    }

    public void startBackgroundLayout(final Runnable callback) {
        if (this.isPageLayoutComplete()) {
            return;
        }
        int DELAY = 10;
        this.getDisplay().timerExec(10, new Runnable(){

            @Override
            public void run() {
                if (PrintPreview.this.isDisposed()) {
                    return;
                }
                if (!PrintPreview.this.isPageLayoutComplete() && PrintPreview.this.pages != null) {
                    PrintPreview.this.fetchPages(PrintPreview.this.pages.size() + 1);
                    if (!PrintPreview.this.isPageLayoutComplete()) {
                        PrintPreview.this.getDisplay().timerExec(10, (Runnable)this);
                    }
                }
                callback.run();
            }
        });
    }

    private void invalidatePageDisplayBounds() {
        this.pageDisplaySize = null;
        this.pageDisplayLocations = null;
    }

    private void paint(Event event) {
        this.drawBackground(event);
        if (this.printJob == null || this.printerData == null) {
            return;
        }
        this.getPrinter();
        this.getPaperSize();
        this.fetchPages(this.pageIndex + this.verticalPageCount * this.horizontalPageCount);
        this.getPageDisplaySize();
        this.getPageDisplayLocations();
        if (this.printer == null || this.paperSize == null || this.pages == null || this.pageDisplaySize == null || this.pageDisplayLocations == null || this.pageIndex < 0 || this.pageIndex >= this.pages.size()) {
            return;
        }
        int count = Math.min(this.verticalPageCount * this.horizontalPageCount, this.pages.size() - this.pageIndex);
        int i = 0;
        while (i < count) {
            this.paintPage(event, this.pages.get(this.pageIndex + i), this.pageDisplayLocations[i]);
            ++i;
        }
    }

    private void paintPage(Event event, PrintPiece page, Point location) {
        Rectangle rectangle = new Rectangle(location.x, location.y, this.pageDisplaySize.x, this.pageDisplaySize.y);
        Rectangle dirtyBounds = new Rectangle(event.x, event.y, event.width, event.height);
        Rectangle dirtyPaperBounds = dirtyBounds.intersection(rectangle);
        if (dirtyPaperBounds.width == 0 || dirtyPaperBounds.height == 0) {
            return;
        }
        Image printerImage = null;
        GC printerGC = null;
        Transform printerTransform = null;
        Image displayImage = null;
        try {
            printerImage = new Image((Device)this.printer, dirtyPaperBounds.width, dirtyPaperBounds.height);
            printerGC = new GC((Drawable)printerImage);
            this.configureAntialiasing(printerGC);
            printerTransform = new Transform((Device)this.printer);
            printerGC.getTransform(printerTransform);
            printerTransform.translate((float)(rectangle.x - dirtyPaperBounds.x), (float)(rectangle.y - dirtyPaperBounds.y));
            printerTransform.scale((float)rectangle.width / (float)this.paperSize.x, (float)rectangle.height / (float)this.paperSize.y);
            printerGC.setTransform(printerTransform);
            page.paint(printerGC, 0, 0);
            displayImage = new Image((Device)event.display, printerImage.getImageData());
            event.gc.drawImage(displayImage, dirtyPaperBounds.x, dirtyPaperBounds.y);
        }
        catch (Throwable throwable) {
            this.disposeResources(printerImage, printerGC, printerTransform, displayImage, page);
            throw throwable;
        }
        this.disposeResources(printerImage, printerGC, printerTransform, displayImage, page);
    }

    private void disposeResources(Image printerImage, GC printerGC, Transform printerTransform, Image displayImage, PrintPiece page) {
        if (printerImage != null) {
            printerImage.dispose();
        }
        if (displayImage != null) {
            displayImage.dispose();
        }
        if (printerGC != null) {
            printerGC.dispose();
        }
        if (printerTransform != null) {
            printerTransform.dispose();
        }
        page.dispose();
    }

    private void configureAntialiasing(GC printerGC) {
        printerGC.setAdvanced(true);
        printerGC.setAntialias(1);
        printerGC.setTextAntialias(1);
        printerGC.setInterpolation(2);
    }

    private Printer getPrinter() {
        if (this.printer == null && this.printerData != null) {
            this.printer = new Printer(this.printerData);
            PaperClips.startDummyJob((Printer)this.printer, (String)"");
            this.disposePages();
            this.pageDisplaySize = null;
            this.pageDisplayLocations = null;
        }
        return this.printer;
    }

    private GC getGC() {
        if (this.gc == null && this.printer != null) {
            this.gc = new GC((Drawable)this.printer);
            this.gc.setAdvanced(true);
        }
        return this.gc;
    }

    private boolean orientationRequiresRotate() {
        int orientation = this.printJob.getOrientation();
        Rectangle bounds = PaperClips.getPaperBounds((Printer)this.printer);
        return orientation == 512 && bounds.width > bounds.height || orientation == 256 && bounds.height > bounds.width;
    }

    private Point getPaperSize() {
        Printer printer = this.getPrinter();
        if (this.paperSize == null && printer != null && this.printJob != null) {
            Rectangle paperBounds = PaperClips.getPaperBounds((Printer)printer);
            this.paperSize = this.orientationRequiresRotate() ? new Point(paperBounds.height, paperBounds.width) : new Point(paperBounds.width, paperBounds.height);
        }
        return this.paperSize;
    }

    private void fetchPages(int endIndex) {
        if (this.getPrintJob() == null || this.getPrinter() == null) {
            return;
        }
        if (this.pageEnumeration == null) {
            if (this.getGC() == null) {
                return;
            }
            this.pageEnumeration = PaperClips.getPageEnumeration((PrintJob)this.printJob, (Printer)this.printer, (GC)this.gc);
        }
        if (this.pages == null) {
            this.pages = new ArrayList<PrintPiece>();
        }
        boolean doRotate = this.orientationRequiresRotate();
        boolean allPages = endIndex == -1 || !this.lazy;
        while (this.pageEnumeration.hasNext() && (allPages || this.pages.size() < endIndex)) {
            PrintPiece page = this.pageEnumeration.nextPage();
            if (page == null) continue;
            if (doRotate) {
                page = new RotateClockwisePrintPiece((Device)this.printer, page);
            }
            this.pages.add(page);
        }
        if (!this.pageEnumeration.hasNext()) {
            this.disposeGC();
        }
    }

    private void drawBackground(Event event) {
        Color oldBackground = event.gc.getBackground();
        Color bg = event.display.getSystemColor(18);
        try {
            event.gc.setBackground(bg);
            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
            event.gc.setBackground(oldBackground);
        }
        finally {
            bg.dispose();
        }
    }

    public float getAbsoluteScale() {
        this.checkWidget();
        return this.getAbsoluteScale(this.getSize());
    }

    public Rectangle getMargins() {
        this.checkWidget();
        return new Rectangle(this.margins.x, this.margins.y, this.margins.width, this.margins.height);
    }

    public void setMargins(Rectangle margins) {
        this.checkWidget();
        if (margins == null) {
            SWT.error((int)4);
        }
        this.margins = new Rectangle(margins.x, margins.y, margins.width, margins.height);
        this.invalidatePageDisplayBounds();
        this.redraw();
    }

    public Point getPageSpacing() {
        return new Point(this.pageSpacing.x, this.pageSpacing.y);
    }

    public void setPageSpacing(Point pageSpacing) {
        this.checkWidget();
        if (pageSpacing == null) {
            SWT.error((int)4);
        }
        this.pageSpacing = new Point(pageSpacing.x, pageSpacing.y);
        this.invalidatePageDisplayBounds();
        this.redraw();
    }

    private Point getBoilerplateSize() {
        return new Point(this.margins.x + this.margins.width + (this.horizontalPageCount - 1) * this.pageSpacing.x, this.margins.y + this.margins.height + (this.verticalPageCount - 1) * this.pageSpacing.y);
    }

    private float getAbsoluteScale(Point controlSize) {
        float result = this.scale;
        if (this.getPrinter() != null && (this.fitHorizontal || this.fitVertical)) {
            Rectangle trim = this.computeTrim(0, 0, 0, 0);
            controlSize.x -= trim.width;
            controlSize.y -= trim.height;
            Point boilerplate = this.getBoilerplateSize();
            controlSize.x -= boilerplate.x;
            controlSize.x /= this.horizontalPageCount;
            controlSize.y -= boilerplate.y;
            controlSize.y /= this.verticalPageCount;
            Point displayDPI = this.getDisplay().getDPI();
            Point printerDPI = this.getPrinter().getDPI();
            Point paperSize = this.getPaperSize();
            if (this.fitHorizontal) {
                float screenWidth = (float)controlSize.x / (float)displayDPI.x;
                float paperWidth = (float)paperSize.x / (float)printerDPI.x;
                float scaleX = screenWidth / paperWidth;
                if (this.fitVertical) {
                    float screenHeight = (float)controlSize.y / (float)displayDPI.y;
                    float paperHeight = (float)paperSize.y / (float)printerDPI.y;
                    float scaleY = screenHeight / paperHeight;
                    result = Math.min(scaleX, scaleY);
                } else {
                    result = scaleX;
                }
            } else {
                float scaleY;
                float screenHeight = (float)controlSize.y / (float)displayDPI.y;
                float paperHeight = (float)paperSize.y / (float)printerDPI.y;
                result = scaleY = screenHeight / paperHeight;
            }
        }
        return result;
    }

    private Point getPageDisplaySize() {
        if (this.pageDisplaySize == null) {
            Point size = this.getSize();
            Point displayDPI = this.getDisplay().getDPI();
            Point printerDPI = this.printer.getDPI();
            float absoluteScale = this.getAbsoluteScale(size);
            float scaleX = absoluteScale * (float)displayDPI.x / (float)printerDPI.x;
            float scaleY = absoluteScale * (float)displayDPI.y / (float)printerDPI.y;
            this.pageDisplaySize = new Point((int)(scaleX * (float)this.paperSize.x), (int)(scaleY * (float)this.paperSize.y));
        }
        return this.pageDisplaySize;
    }

    private Point[] getPageDisplayLocations() {
        if (this.pageDisplayLocations == null) {
            Rectangle clientArea = this.getClientArea();
            int x0 = clientArea.x + this.margins.x;
            clientArea.width -= this.getBoilerplateSize().x;
            clientArea.width -= this.pageDisplaySize.x * this.horizontalPageCount;
            if (clientArea.width > 0) {
                x0 += clientArea.width / 2;
            }
            this.pageDisplayLocations = new Point[this.horizontalPageCount * this.verticalPageCount];
            int y = clientArea.y + this.margins.y;
            int r = 0;
            while (r < this.verticalPageCount) {
                int x = x0;
                int c = 0;
                while (c < this.horizontalPageCount) {
                    this.pageDisplayLocations[r * this.horizontalPageCount + c] = new Point(x, y);
                    x += this.pageDisplaySize.x + this.pageSpacing.x;
                    ++c;
                }
                y += this.pageDisplaySize.y + this.pageSpacing.y;
                ++r;
            }
        }
        return this.pageDisplayLocations;
    }

    private void disposePages() {
        if (this.pages != null) {
            this.pageEnumeration = null;
            int i = 0;
            while (i < this.pages.size()) {
                this.pages.get(i).dispose();
                ++i;
            }
            this.pages = null;
            this.paperSize = null;
            this.invalidatePageDisplayBounds();
        }
    }

    private void disposePrinter() {
        this.disposePages();
        if (this.printer != null) {
            this.disposeGC();
            PaperClips.endDummyJob((Printer)this.printer);
            this.printer.dispose();
            this.printer = null;
        }
    }

    private void disposeGC() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
    }

    private void disposeResources() {
        this.disposePages();
        this.disposePrinter();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        double scale;
        this.checkWidget();
        Point size = new Point(wHint, hHint);
        this.fetchPages(this.horizontalPageCount * this.verticalPageCount);
        if (this.getPrinter() == null || this.pages == null) {
            Point boilerplate = this.getBoilerplateSize();
            if (wHint == -1) {
                size.x = boilerplate.x;
            }
            if (hHint == -1) {
                size.y = boilerplate.y;
            }
            return this.addTrim(size);
        }
        if (wHint != -1) {
            if (hHint != -1) {
                return this.addTrim(size);
            }
            size.y = Integer.MAX_VALUE;
            scale = this.getAbsoluteScale(size);
        } else if (hHint != -1) {
            size.x = Integer.MAX_VALUE;
            scale = this.getAbsoluteScale(size);
        } else {
            scale = this.scale;
        }
        return this.computeSize(scale);
    }

    public Point computeSize(double scale) {
        this.checkWidget();
        Point size = this.getBoilerplateSize();
        this.fetchPages(this.horizontalPageCount * this.verticalPageCount);
        if (this.getPrinter() != null && this.pages != null) {
            Point displayDPI = this.getDisplay().getDPI();
            Point printerDPI = this.getPrinter().getDPI();
            Point paperSize = this.getPaperSize();
            size.x += this.horizontalPageCount * (int)(scale * (double)paperSize.x * (double)displayDPI.x / (double)printerDPI.x);
            size.y += this.verticalPageCount * (int)(scale * (double)paperSize.y * (double)displayDPI.y / (double)printerDPI.y);
        }
        return this.addTrim(size);
    }

    private Point addTrim(Point size) {
        Rectangle trim = this.computeTrim(0, 0, 0, 0);
        return new Point(size.x + trim.width, size.y + trim.height);
    }
}

