/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.nebula.widgets.timeline.ILane;
import org.eclipse.nebula.widgets.timeline.ITimed;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelinePackage;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.impl.Colored;

public class TimelineEvent
extends Colored
implements ITimelineEvent {
    protected static final long START_TIMESTAMP_EDEFAULT = 0L;
    protected long startTimestamp = 0L;
    protected static final long END_TIMESTAMP_EDEFAULT = 0L;
    protected long endTimestamp = 0L;
    protected static final String TITLE_EDEFAULT = null;
    protected String title = TITLE_EDEFAULT;
    protected static final String MESSAGE_EDEFAULT = null;
    protected String message = MESSAGE_EDEFAULT;

    protected TimelineEvent() {
    }

    @Override
    protected EClass eStaticClass() {
        return ITimelinePackage.Literals.TIMELINE_EVENT;
    }

    @Override
    public ILane getLane() {
        if (this.eContainerFeatureID() != 2) {
            return null;
        }
        return (ILane)this.eInternalContainer();
    }

    public NotificationChain basicSetLane(ILane newLane, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newLane, 2, msgs);
        return msgs;
    }

    @Override
    public void setLane(ILane newLane) {
        if (newLane != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newLane != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newLane)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newLane != null) {
                msgs = ((InternalEObject)newLane).eInverseAdd((InternalEObject)this, 3, ILane.class, msgs);
            }
            if ((msgs = this.basicSetLane(newLane, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newLane, (Object)newLane));
        }
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public void setStartTimestamp(long newStartTimestamp) {
        long oldStartTimestamp = this.startTimestamp;
        this.startTimestamp = newStartTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldStartTimestamp, this.startTimestamp));
        }
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public void setEndTimestamp(long newEndTimestamp) {
        long oldEndTimestamp = this.endTimestamp;
        this.endTimestamp = newEndTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldEndTimestamp, this.endTimestamp));
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldTitle, (Object)this.title));
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String newMessage) {
        String oldMessage = this.message;
        this.message = newMessage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMessage, (Object)this.message));
        }
    }

    @Override
    public long getDuration() {
        return this.getEndTimestamp() - this.getStartTimestamp();
    }

    @Override
    public void setStartTimestamp(long value, TimeUnit timeUnit) {
        this.setStartTimestamp(timeUnit.toNanos(value));
    }

    @Override
    public void setEndTimestamp(long value, TimeUnit timeUnit) {
        this.setEndTimestamp(timeUnit.toNanos(value));
    }

    @Override
    public void setDuration(long value, TimeUnit timeUnit) {
        this.setEndTimestamp(this.getStartTimestamp() + timeUnit.toNanos(value));
    }

    @Override
    public void setDuration(long value) {
        this.setDuration(value, TimeUnit.NANOSECONDS);
    }

    @Override
    public Timing getTiming() {
        return new Timing(this.getStartTimestamp(), this.getDuration());
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetLane((ILane)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetLane(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 3, ILane.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getLane();
            }
            case 3: {
                return this.getStartTimestamp();
            }
            case 4: {
                return this.getEndTimestamp();
            }
            case 5: {
                return this.getTitle();
            }
            case 6: {
                return this.getMessage();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setLane((ILane)newValue);
                return;
            }
            case 3: {
                this.setStartTimestamp((Long)newValue);
                return;
            }
            case 4: {
                this.setEndTimestamp((Long)newValue);
                return;
            }
            case 5: {
                this.setTitle((String)newValue);
                return;
            }
            case 6: {
                this.setMessage((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setLane(null);
                return;
            }
            case 3: {
                this.setStartTimestamp(0L);
                return;
            }
            case 4: {
                this.setEndTimestamp(0L);
                return;
            }
            case 5: {
                this.setTitle(TITLE_EDEFAULT);
                return;
            }
            case 6: {
                this.setMessage(MESSAGE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.getLane() != null;
            }
            case 3: {
                return this.startTimestamp != 0L;
            }
            case 4: {
                return this.endTimestamp != 0L;
            }
            case 5: {
                return TITLE_EDEFAULT == null ? this.title != null : !TITLE_EDEFAULT.equals(this.title);
            }
            case 6: {
                return MESSAGE_EDEFAULT == null ? this.message != null : !MESSAGE_EDEFAULT.equals(this.message);
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ITimed.class) {
            switch (baseOperationID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getDuration();
            }
            case 2: {
                this.setStartTimestamp((Long)arguments.get(0), (TimeUnit)((Object)arguments.get(1)));
                return null;
            }
            case 3: {
                this.setEndTimestamp((Long)arguments.get(0), (TimeUnit)((Object)arguments.get(1)));
                return null;
            }
            case 4: {
                this.setDuration((Long)arguments.get(0), (TimeUnit)((Object)arguments.get(1)));
                return null;
            }
            case 5: {
                this.setDuration((Long)arguments.get(0));
                return null;
            }
            case 0: {
                return this.getTiming();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }
}

