/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.cursor;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.nebula.widgets.timeline.listeners.CursorMover;

public class CursorFigure
extends Figure
implements IStyledFigure {
    private static final int CURSOR_WIDTH = 13;
    private static final int TRIANGLE_SIZE = 6;
    private final RectangleFigure fLineFigure;

    public CursorFigure(ITimelineStyleProvider styleProvider) {
        this.setLayoutManager((LayoutManager)new CursorFigureLayout());
        this.updateStyle(styleProvider);
        Triangle topTriangle = new Triangle();
        topTriangle.setSize(6, 6);
        topTriangle.setOpaque(true);
        topTriangle.setDirection(4);
        this.add((IFigure)topTriangle, BorderLayout.TOP);
        Triangle bottomTriangle = new Triangle();
        bottomTriangle.setSize(6, 6);
        topTriangle.setOpaque(true);
        bottomTriangle.setDirection(1);
        this.add((IFigure)bottomTriangle, BorderLayout.BOTTOM);
        this.fLineFigure = new RectangleFigure();
        this.fLineFigure.setLineWidth(1);
        this.add((IFigure)this.fLineFigure, BorderLayout.CENTER);
        new CursorMover(this);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(13, hHint);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public long getEventTime() {
        ICursor cursor = (ICursor)this.getParent().getLayoutManager().getConstraint((IFigure)this);
        return cursor.getTimestamp();
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setForegroundColor(styleProvider.getCursorColor());
        this.setBackgroundColor(styleProvider.getCursorColor());
    }

    private class CursorFigureLayout
    extends BorderLayout {
        private CursorFigureLayout() {
        }

        public void layout(IFigure container) {
            super.layout(container);
            Rectangle bounds = CursorFigure.this.fLineFigure.getBounds();
            bounds.performTranslate(bounds.width() / 2, 0);
            bounds.setWidth(1);
            bounds.setY(0);
            bounds.setHeight(container.getBounds().height());
        }
    }
}

