/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.CAUUID;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IMoniker;
import org.eclipse.swt.internal.ole.win32.IOleCommandTarget;
import org.eclipse.swt.internal.ole.win32.IOleDocument;
import org.eclipse.swt.internal.ole.win32.IOleDocumentView;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceObject;
import org.eclipse.swt.internal.ole.win32.IOleLink;
import org.eclipse.swt.internal.ole.win32.IOleObject;
import org.eclipse.swt.internal.ole.win32.IPersist;
import org.eclipse.swt.internal.ole.win32.IPersistFile;
import org.eclipse.swt.internal.ole.win32.IPersistStorage;
import org.eclipse.swt.internal.ole.win32.ISpecifyPropertyPages;
import org.eclipse.swt.internal.ole.win32.IStorage;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.IViewObject2;
import org.eclipse.swt.internal.ole.win32.OLECMD;
import org.eclipse.swt.internal.ole.win32.OLEINPLACEFRAMEINFO;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class OleClientSite
extends Composite {
    private COMObject iUnknown;
    COMObject iOleClientSite;
    private COMObject iAdviseSink;
    private COMObject iOleInPlaceSite;
    private COMObject iOleDocumentSite;
    protected GUID appClsid;
    private GUID objClsid;
    private int refCount;
    protected OleFrame frame;
    protected IUnknown objIUnknown;
    protected IOleObject objIOleObject;
    protected IViewObject2 objIViewObject2;
    protected IOleInPlaceObject objIOleInPlaceObject;
    protected IOleCommandTarget objIOleCommandTarget;
    protected IOleDocumentView objDocumentView;
    protected IStorage tempStorage;
    private int aspect;
    private int type;
    private boolean isStatic;
    boolean isActivated;
    private RECT borderWidths = new RECT();
    private RECT indent = new RECT();
    private boolean inUpdate = false;
    private boolean inInit = true;
    private boolean inDispose = false;
    private static final String WORDPROGID = "Word.Document";
    private Listener listener;
    static final int STATE_NONE = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_INPLACEACTIVE = 2;
    static final int STATE_UIACTIVE = 3;
    static final int STATE_ACTIVE = 4;
    int state = 0;

    protected OleClientSite(Composite composite, int n) {
        super(composite, n);
        this.createCOMInterfaces();
        while (composite != null) {
            if (composite instanceof OleFrame) {
                this.frame = (OleFrame)composite;
                break;
            }
            composite = composite.getParent();
        }
        if (this.frame == null) {
            OLE.error(5);
        }
        this.frame.AddRef();
        this.aspect = 1;
        this.type = 1;
        this.isStatic = false;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 10: 
                    case 11: {
                        OleClientSite.this.onResize(event);
                        break;
                    }
                    case 12: {
                        OleClientSite.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        OleClientSite.this.onFocusIn(event);
                        break;
                    }
                    case 16: {
                        OleClientSite.this.onFocusOut(event);
                        break;
                    }
                    case 9: {
                        OleClientSite.this.onPaint(event);
                        break;
                    }
                    case 31: {
                        OleClientSite.this.onTraverse(event);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 26: {
                        OleClientSite.this.isActivated = true;
                        break;
                    }
                    case 27: {
                        OleClientSite.this.isActivated = false;
                        break;
                    }
                    default: {
                        OLE.error(20);
                    }
                }
            }
        };
        this.frame.addListener(11, this.listener);
        this.frame.addListener(10, this.listener);
        this.addListener(12, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(9, this.listener);
        this.addListener(31, this.listener);
        this.addListener(1, this.listener);
        this.addListener(26, this.listener);
        this.addListener(27, this.listener);
    }

    public OleClientSite(Composite composite, int n, File file) {
        this(composite, n);
        try {
            String string;
            if (file == null || file.isDirectory() || !file.exists()) {
                OLE.error(5);
            }
            GUID gUID = new GUID();
            char[] cArray = (String.valueOf(file.getAbsolutePath()) + "\u0000").toCharArray();
            int n2 = COM.GetClassFile(cArray, gUID);
            if (n2 != 0) {
                OLE.error(1004, n2);
            }
            if ((string = this.getProgID(gUID)) == null) {
                OLE.error(1004, n2);
            }
            this.appClsid = gUID;
            this.OleCreate(this.appClsid, gUID, cArray, file);
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    public OleClientSite(Composite composite, int n, String string) {
        this(composite, n);
        try {
            this.appClsid = this.getClassID(string);
            if (this.appClsid == null) {
                OLE.error(1004);
            }
            this.tempStorage = this.createTempStorage();
            int[] nArray = new int[1];
            int n2 = COM.OleCreate(this.appClsid, COM.IIDIUnknown, 1, null, this.iOleClientSite.getAddress(), this.tempStorage.getAddress(), nArray);
            if (n2 != 0) {
                OLE.error(1001, n2);
            }
            this.objIUnknown = new IUnknown(nArray[0]);
            this.addObjectReferences();
            if (COM.OleRun(this.objIUnknown.getAddress()) == 0) {
                this.state = 1;
            }
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    public OleClientSite(Composite composite, int n, String string, File file) {
        this(composite, n);
        try {
            if (file == null || file.isDirectory() || !file.exists()) {
                OLE.error(5);
            }
            this.appClsid = this.getClassID(string);
            if (this.appClsid == null) {
                OLE.error(1004);
            }
            char[] cArray = (String.valueOf(file.getAbsolutePath()) + "\u0000").toCharArray();
            GUID gUID = new GUID();
            COM.GetClassFile(cArray, gUID);
            this.OleCreate(this.appClsid, gUID, cArray, file);
        }
        catch (SWTException sWTException) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTException;
        }
    }

    void OleCreate(GUID gUID, GUID gUID2, char[] cArray, File file) {
        boolean bl = this.isOffice2007(true);
        if (!bl && COM.IsEqualGUID(gUID, gUID2)) {
            this.tempStorage = this.createTempStorage();
            int[] nArray = new int[1];
            int n = COM.OleCreateFromFile(gUID, cArray, COM.IIDIUnknown, 1, null, this.iOleClientSite.getAddress(), this.tempStorage.getAddress(), nArray);
            if (n != 0) {
                OLE.error(1001, n);
            }
            this.objIUnknown = new IUnknown(nArray[0]);
        } else {
            int[] nArray;
            int n;
            int[] nArray2;
            int n2;
            IStorage iStorage = null;
            if (COM.StgIsStorageFile(cArray) == 0) {
                n2 = 65552;
                nArray2 = new int[1];
                n = COM.StgOpenStorage(cArray, 0, n2, 0, 0, nArray2);
                if (n != 0) {
                    OLE.error(1002, n);
                }
                iStorage = new IStorage(nArray2[0]);
            } else {
                n2 = 4114;
                nArray2 = new int[1];
                n = COM.StgCreateDocfile(null, n2 | 0x4000000, 0, nArray2);
                if (n != 0) {
                    OLE.error(1002, n);
                }
                iStorage = new IStorage(nArray2[0]);
                String string = "CONTENTS";
                GUID gUID3 = this.getClassID(WORDPROGID);
                if (gUID3 != null && COM.IsEqualGUID(gUID, gUID3)) {
                    string = "WordDocument";
                }
                if (bl) {
                    string = "Package";
                }
                if ((n = iStorage.CreateStream(string, n2, 0, 0, nArray2 = new int[1])) != 0) {
                    iStorage.Release();
                    OLE.error(1002, n);
                }
                IStream iStream = new IStream(nArray2[0]);
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n3 = 4096;
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while ((n4 = fileInputStream.read(byArray)) > 0) {
                        int n5 = COM.CoTaskMemAlloc(n4);
                        OS.MoveMemory(n5, byArray, n4);
                        n = iStream.Write(n5, n4, null);
                        COM.CoTaskMemFree(n5);
                        if (n == 0) continue;
                        fileInputStream.close();
                        iStream.Release();
                        iStorage.Release();
                        OLE.error(1002, n);
                    }
                    fileInputStream.close();
                    iStream.Commit(0);
                    iStream.Release();
                }
                catch (IOException iOException) {
                    iStream.Release();
                    iStorage.Release();
                    OLE.error(1002);
                }
            }
            this.tempStorage = this.createTempStorage();
            int n6 = iStorage.CopyTo(0, null, null, this.tempStorage.getAddress());
            iStorage.Release();
            if (n6 != 0) {
                OLE.error(1002, n6);
            }
            if ((n6 = COM.CoCreateInstance(gUID, 0, 3, COM.IIDIUnknown, nArray = new int[1])) != 0) {
                OLE.error(1001, n6);
            }
            this.objIUnknown = new IUnknown(nArray[0]);
            nArray = new int[1];
            n6 = this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray);
            if (n6 != 0) {
                OLE.error(1001, n6);
            }
            IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
            n6 = iPersistStorage.Load(this.tempStorage.getAddress());
            iPersistStorage.Release();
            if (n6 != 0) {
                OLE.error(1001, n6);
            }
        }
        this.addObjectReferences();
        if (COM.OleRun(this.objIUnknown.getAddress()) == 0) {
            this.state = 1;
        }
    }

    protected void addObjectReferences() {
        int n;
        Object object;
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIPersist, nArray) == 0) {
            IPersist iPersist = new IPersist(nArray[0]);
            object = new GUID();
            if (iPersist.GetClassID((GUID)object) == 0) {
                this.objClsid = object;
            }
            iPersist.Release();
        }
        if ((n = this.objIUnknown.QueryInterface(COM.IIDIViewObject2, nArray = new int[1])) != 0) {
            OLE.error(1003, n);
        }
        this.objIViewObject2 = new IViewObject2(nArray[0]);
        this.objIViewObject2.SetAdvise(this.aspect, 0, this.iAdviseSink.getAddress());
        nArray = new int[1];
        n = this.objIUnknown.QueryInterface(COM.IIDIOleObject, nArray);
        if (n != 0) {
            OLE.error(1003, n);
        }
        this.objIOleObject = new IOleObject(nArray[0]);
        object = new int[1];
        n = this.objIOleObject.GetClientSite((int[])object);
        if (object[0] == false) {
            this.objIOleObject.SetClientSite(this.iOleClientSite.getAddress());
        } else {
            this.Release();
        }
        int[] nArray2 = new int[1];
        this.objIOleObject.Advise(this.iAdviseSink.getAddress(), nArray2);
        this.objIOleObject.SetHostNames("main", "main");
        COM.OleSetContainedObject(this.objIUnknown.getAddress(), true);
        nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIOleLink, nArray) == 0) {
            IOleLink iOleLink = new IOleLink(nArray[0]);
            int[] nArray3 = new int[1];
            if (iOleLink.GetSourceMoniker(nArray3) == 0) {
                IMoniker iMoniker = new IMoniker(nArray3[0]);
                iMoniker.Release();
                this.type = 0;
                iOleLink.BindIfRunning();
            } else {
                this.isStatic = true;
            }
            iOleLink.Release();
        }
    }

    protected int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int CanInPlaceActivate() {
        if (this.aspect == 1 && this.type == 1) {
            return 0;
        }
        return 1;
    }

    private int ContextSensitiveHelp(int n) {
        return 0;
    }

    protected void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.iUnknown = new COMObject(nArray){

            public int method0(int[] nArray) {
                return OleClientSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleClientSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleClientSite.this.Release();
            }
        };
        int[] nArray2 = new int[9];
        nArray2[0] = 2;
        nArray2[4] = 3;
        nArray2[5] = 1;
        nArray2[7] = 1;
        this.iOleClientSite = new COMObject(nArray2){

            public int method0(int[] nArray) {
                return OleClientSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleClientSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleClientSite.this.Release();
            }

            public int method3(int[] nArray) {
                return OleClientSite.this.SaveObject();
            }

            public int method5(int[] nArray) {
                return OleClientSite.this.GetContainer(nArray[0]);
            }

            public int method6(int[] nArray) {
                return OleClientSite.this.ShowObject();
            }

            public int method7(int[] nArray) {
                return OleClientSite.this.OnShowWindow(nArray[0]);
            }
        };
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[3] = 2;
        nArray3[4] = 2;
        nArray3[5] = 1;
        this.iAdviseSink = new COMObject(nArray3){

            public int method0(int[] nArray) {
                return OleClientSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleClientSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleClientSite.this.Release();
            }

            public int method3(int[] nArray) {
                return OleClientSite.this.OnDataChange(nArray[0], nArray[1]);
            }

            public int method4(int[] nArray) {
                return OleClientSite.this.OnViewChange(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                OleClientSite.this.OnSave();
                return 0;
            }

            public int method7(int[] nArray) {
                return OleClientSite.this.OnClose();
            }
        };
        int[] nArray4 = new int[15];
        nArray4[0] = 2;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[8] = 5;
        nArray4[9] = C.PTR_SIZEOF == 4 ? 2 : 1;
        nArray4[10] = 1;
        nArray4[14] = 1;
        this.iOleInPlaceSite = new COMObject(nArray4){

            public int method0(int[] nArray) {
                return OleClientSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleClientSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleClientSite.this.Release();
            }

            public int method3(int[] nArray) {
                return OleClientSite.this.GetWindow(nArray[0]);
            }

            public int method4(int[] nArray) {
                return OleClientSite.this.ContextSensitiveHelp(nArray[0]);
            }

            public int method5(int[] nArray) {
                return OleClientSite.this.CanInPlaceActivate();
            }

            public int method6(int[] nArray) {
                return OleClientSite.this.OnInPlaceActivate();
            }

            public int method7(int[] nArray) {
                return OleClientSite.this.OnUIActivate();
            }

            public int method8(int[] nArray) {
                return OleClientSite.this.GetWindowContext(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method9(int[] nArray) {
                if (nArray.length == 2) {
                    return OleClientSite.this.Scroll(nArray[0], nArray[1]);
                }
                return OleClientSite.this.Scroll_64(nArray[0]);
            }

            public int method10(int[] nArray) {
                return OleClientSite.this.OnUIDeactivate(nArray[0]);
            }

            public int method11(int[] nArray) {
                return OleClientSite.this.OnInPlaceDeactivate();
            }

            public int method14(int[] nArray) {
                return OleClientSite.this.OnPosRectChange(nArray[0]);
            }
        };
        int[] nArray5 = new int[4];
        nArray5[0] = 2;
        nArray5[3] = 1;
        this.iOleDocumentSite = new COMObject(nArray5){

            public int method0(int[] nArray) {
                return OleClientSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleClientSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleClientSite.this.Release();
            }

            public int method3(int[] nArray) {
                return OleClientSite.this.ActivateMe(nArray[0]);
            }
        };
    }

    protected IStorage createTempStorage() {
        int n = 67108882;
        int[] nArray = new int[1];
        int n2 = COM.StgCreateDocfile(null, n, 0, nArray);
        if (n2 != 0) {
            OLE.error(1000, n2);
        }
        return new IStorage(nArray[0]);
    }

    public void deactivateInPlaceClient() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.InPlaceDeactivate();
        }
    }

    private void deleteTempStorage() {
        if (this.tempStorage != null) {
            this.tempStorage.Release();
        }
        this.tempStorage = null;
    }

    protected void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleClientSite != null) {
            this.iOleClientSite.dispose();
        }
        this.iOleClientSite = null;
        if (this.iAdviseSink != null) {
            this.iAdviseSink.dispose();
        }
        this.iAdviseSink = null;
        if (this.iOleInPlaceSite != null) {
            this.iOleInPlaceSite.dispose();
        }
        this.iOleInPlaceSite = null;
        if (this.iOleDocumentSite != null) {
            this.iOleDocumentSite.dispose();
        }
        this.iOleDocumentSite = null;
    }

    public int doVerb(int n) {
        if (this.state == 0 && COM.OleRun(this.objIUnknown.getAddress()) == 0) {
            this.state = 1;
        }
        if (this.state == 0 || this.isStatic) {
            return -2147467259;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n2 = this.objIOleObject.DoVerb(n, null, this.iOleClientSite.getAddress(), 0, this.handle, rECT);
        if (this.state != 1 && this.inInit) {
            this.updateStorage();
            this.inInit = false;
        }
        return n2;
    }

    public int exec(int n, int n2, Variant variant, Variant variant2) {
        if (this.objIOleCommandTarget == null) {
            int[] nArray = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleCommandTarget, nArray) != 0) {
                return 1003;
            }
            this.objIOleCommandTarget = new IOleCommandTarget(nArray[0]);
        }
        int n3 = 0;
        if (variant != null) {
            n3 = OS.GlobalAlloc(64, VARIANT.sizeof);
            variant.getData(n3);
        }
        int n4 = 0;
        if (variant2 != null) {
            n4 = OS.GlobalAlloc(64, VARIANT.sizeof);
            variant2.getData(n4);
        }
        int n5 = this.objIOleCommandTarget.Exec(null, n, n2, n3, n4);
        if (n3 != 0) {
            COM.VariantClear(n3);
            OS.GlobalFree(n3);
        }
        if (n4 != 0) {
            variant2.setData(n4);
            COM.VariantClear(n4);
            OS.GlobalFree(n4);
        }
        return n5;
    }

    IDispatch getAutomationObject() {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIDispatch, nArray) != 0) {
            return null;
        }
        return new IDispatch(nArray[0]);
    }

    protected GUID getClassID(String string) {
        int n;
        GUID gUID = new GUID();
        char[] cArray = null;
        if (string != null) {
            n = string.length();
            cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
        }
        if (COM.CLSIDFromProgID(cArray, gUID) != 0 && (n = COM.CLSIDFromString(cArray, gUID)) != 0) {
            return null;
        }
        return gUID;
    }

    private int GetContainer(int n) {
        if (n != 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
        }
        return -2147467262;
    }

    private SIZE getExtent() {
        SIZE sIZE = new SIZE();
        if (this.objIOleObject != null) {
            if (this.objIViewObject2 != null && !COM.OleIsRunning(this.objIOleObject.getAddress())) {
                this.objIViewObject2.GetExtent(this.aspect, -1, null, sIZE);
            } else {
                this.objIOleObject.GetExtent(this.aspect, sIZE);
            }
        }
        return this.xFormHimetricToPixels(sIZE);
    }

    public Rectangle getIndent() {
        return new Rectangle(this.indent.left, this.indent.right, this.indent.top, this.indent.bottom);
    }

    public String getProgramID() {
        return this.getProgID(this.appClsid);
    }

    String getProgID(GUID gUID) {
        int[] nArray;
        if (gUID != null && COM.ProgIDFromCLSID(gUID, nArray = new int[1]) == 0) {
            int n = nArray[0];
            int n2 = OS.GlobalSize(n);
            int n3 = OS.GlobalLock(n);
            char[] cArray = new char[n2];
            COM.MoveMemory(cArray, n3, n2);
            OS.GlobalUnlock(n);
            OS.GlobalFree(n);
            String string = new String(cArray);
            int n4 = string.indexOf("\u0000");
            return string.substring(0, n4);
        }
        return null;
    }

    int ActivateMe(int n) {
        Object object;
        if (n == 0) {
            object = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleDocument, (int[])object) != 0) {
                return -2147467259;
            }
            IOleDocument iOleDocument = new IOleDocument(object[0]);
            if (iOleDocument.CreateView(this.iOleInPlaceSite.getAddress(), 0, 0, (int[])object) != 0) {
                return -2147467259;
            }
            iOleDocument.Release();
            this.objDocumentView = new IOleDocumentView(object[0]);
        } else {
            this.objDocumentView = new IOleDocumentView(n);
            this.objDocumentView.AddRef();
            this.objDocumentView.SetInPlaceSite(this.iOleInPlaceSite.getAddress());
        }
        this.objDocumentView.UIActivate(1);
        object = this.getRect();
        this.objDocumentView.SetRect((RECT)object);
        this.objDocumentView.Show(1);
        return 0;
    }

    protected int GetWindow(int n) {
        if (n == 0) {
            return -2147024809;
        }
        if (this.frame == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return -2147467263;
        }
        COM.MoveMemory(n, new int[]{this.handle}, OS.PTR_SIZEOF);
        return 0;
    }

    RECT getRect() {
        Rectangle rectangle = this.getClientArea();
        RECT rECT = new RECT();
        rECT.left = rectangle.x;
        rECT.top = rectangle.y;
        rECT.right = rectangle.x + rectangle.width;
        rECT.bottom = rectangle.y + rectangle.height;
        return rECT;
    }

    private int GetWindowContext(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        if (this.frame == null || n == 0) {
            return -2147467263;
        }
        int n9 = this.frame.getIOleInPlaceFrame();
        COM.MoveMemory(n, new int[]{n9}, OS.PTR_SIZEOF);
        this.frame.AddRef();
        if (n2 != 0) {
            COM.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        }
        RECT rECT = this.getRect();
        if (n3 != 0) {
            OS.MoveMemory(n3, rECT, RECT.sizeof);
        }
        if (n4 != 0) {
            OS.MoveMemory(n4, rECT, RECT.sizeof);
        }
        OLEINPLACEFRAMEINFO oLEINPLACEFRAMEINFO = new OLEINPLACEFRAMEINFO();
        oLEINPLACEFRAMEINFO.cb = OLEINPLACEFRAMEINFO.sizeof;
        oLEINPLACEFRAMEINFO.fMDIApp = 0;
        oLEINPLACEFRAMEINFO.hwndFrame = this.frame.handle;
        Shell shell = this.getShell();
        Menu menu = shell.getMenuBar();
        if (menu != null && !menu.isDisposed() && (n8 = OS.SendMessage(n7 = shell.handle, 32768, 0, 0)) != 0 && (n6 = OS.SendMessage(n7, 32769, 0, 0)) != 0) {
            oLEINPLACEFRAMEINFO.cAccelEntries = n8;
            oLEINPLACEFRAMEINFO.haccel = n6;
        }
        COM.MoveMemory(n5, oLEINPLACEFRAMEINFO, OLEINPLACEFRAMEINFO.sizeof);
        return 0;
    }

    public boolean isDirty() {
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIPersistFile, nArray) != 0) {
            return true;
        }
        IPersistFile iPersistFile = new IPersistFile(nArray[0]);
        int n = iPersistFile.IsDirty();
        iPersistFile.Release();
        return n != 1;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        int n = OS.GetFocus();
        if (this.objIOleInPlaceObject == null) {
            return this.handle == n;
        }
        int[] nArray = new int[1];
        this.objIOleInPlaceObject.GetWindow(nArray);
        while (n != 0) {
            if (nArray[0] == n) {
                return true;
            }
            n = OS.GetParent(n);
        }
        return false;
    }

    private boolean isOffice2007(boolean bl) {
        int n;
        String string = this.getProgramID();
        if (string == null) {
            return false;
        }
        if (bl && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
            GUID gUID = this.getClassID(string);
            if ((string = this.getProgID(gUID)) == null) {
                return false;
            }
        }
        if (string.equals("Word.Document.12")) {
            return true;
        }
        if (string.equals("Excel.Sheet.12")) {
            return true;
        }
        return string.equals("PowerPoint.Show.12");
    }

    private int OnClose() {
        return 0;
    }

    private int OnDataChange(int n, int n2) {
        return 0;
    }

    private void onDispose(Event event) {
        this.inDispose = true;
        this.removeListener(12, this.listener);
        this.removeListener(15, this.listener);
        this.removeListener(16, this.listener);
        this.removeListener(9, this.listener);
        this.removeListener(31, this.listener);
        this.removeListener(1, this.listener);
        if (this.state != 0) {
            this.doVerb(-6);
        }
        this.deactivateInPlaceClient();
        this.releaseObjectInterfaces();
        this.deleteTempStorage();
        this.frame.removeListener(11, this.listener);
        this.frame.removeListener(10, this.listener);
        this.frame.Release();
        this.frame = null;
    }

    void onFocusIn(Event event) {
        int[] nArray;
        if (this.inDispose) {
            return;
        }
        if (this.state != 3 && this.objIUnknown.QueryInterface(COM.IIDIOleInPlaceObject, nArray = new int[1]) == 0) {
            IOleInPlaceObject iOleInPlaceObject = new IOleInPlaceObject(nArray[0]);
            iOleInPlaceObject.Release();
            this.doVerb(-1);
        }
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        if (this.isFocusControl()) {
            return;
        }
        nArray = new int[1];
        this.objIOleInPlaceObject.GetWindow(nArray);
        if (nArray[0] == 0) {
            return;
        }
        OS.SetFocus(nArray[0]);
    }

    void onFocusOut(Event event) {
    }

    private int OnInPlaceActivate() {
        this.state = 2;
        this.frame.setCurrentDocument(this);
        if (this.objIOleObject == null) {
            return 0;
        }
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIOleInPlaceObject, nArray) == 0) {
            this.objIOleInPlaceObject = new IOleInPlaceObject(nArray[0]);
        }
        return 0;
    }

    private int OnInPlaceDeactivate() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.Release();
        }
        this.objIOleInPlaceObject = null;
        this.state = 1;
        this.redraw();
        Shell shell = this.getShell();
        if (this.isFocusControl() || this.frame.isFocusControl()) {
            shell.traverse(16);
        }
        return 0;
    }

    private int OnPosRectChange(int n) {
        Point point = this.getSize();
        this.setExtent(point.x, point.y);
        return 0;
    }

    private void onPaint(Event event) {
        if (this.state == 1 || this.state == 2) {
            SIZE sIZE = this.getExtent();
            Rectangle rectangle = this.getClientArea();
            RECT rECT = new RECT();
            if (this.getProgramID().startsWith("Excel.Sheet")) {
                rECT.left = rectangle.x;
                rECT.right = rectangle.x + rectangle.height * sIZE.cx / sIZE.cy;
                rECT.top = rectangle.y;
                rECT.bottom = rectangle.y + rectangle.height;
            } else {
                rECT.left = rectangle.x;
                rECT.right = rectangle.x + sIZE.cx;
                rECT.top = rectangle.y;
                rECT.bottom = rectangle.y + sIZE.cy;
            }
            int n = OS.GlobalAlloc(64, RECT.sizeof);
            OS.MoveMemory(n, rECT, RECT.sizeof);
            COM.OleDraw(this.objIUnknown.getAddress(), this.aspect, event.gc.handle, n);
            OS.GlobalFree(n);
        }
    }

    private void onResize(Event event) {
        this.setBounds();
    }

    private void OnSave() {
    }

    private int OnShowWindow(int n) {
        return 0;
    }

    private int OnUIActivate() {
        if (this.objIOleInPlaceObject == null) {
            return -2147467259;
        }
        this.state = 3;
        int[] nArray = new int[1];
        if (this.objIOleInPlaceObject.GetWindow(nArray) == 0) {
            OS.SetWindowPos(nArray[0], 0, 0, 0, 0, 0, 3);
        }
        return 0;
    }

    int OnUIDeactivate(int n) {
        Menu menu;
        if (this.frame == null || this.frame.isDisposed()) {
            return 0;
        }
        this.state = 2;
        this.frame.SetActiveObject(0, 0);
        this.redraw();
        Shell shell = this.getShell();
        if (this.isFocusControl() || this.frame.isFocusControl()) {
            shell.traverse(16);
        }
        if ((menu = shell.getMenuBar()) == null || menu.isDisposed()) {
            return 0;
        }
        int n2 = shell.handle;
        OS.SetMenu(n2, menu.handle);
        return COM.OleSetMenuDescriptor(0, n2, 0, 0, 0);
    }

    private void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 128: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    private int OnViewChange(int n, int n2) {
        return 0;
    }

    protected int QueryInterface(int n, int n2) {
        String string;
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iUnknown.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAdviseSink)) {
            COM.MoveMemory(n2, new int[]{this.iAdviseSink.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIOleClientSite)) {
            COM.MoveMemory(n2, new int[]{this.iOleClientSite.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIOleInPlaceSite)) {
            COM.MoveMemory(n2, new int[]{this.iOleInPlaceSite.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIOleDocumentSite) && !(string = this.getProgramID()).startsWith("PowerPoint")) {
            COM.MoveMemory(n2, new int[]{this.iOleDocumentSite.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    public int queryStatus(int n) {
        Object object;
        if (this.objIOleCommandTarget == null) {
            object = new int[1];
            if (this.objIUnknown.QueryInterface(COM.IIDIOleCommandTarget, (int[])object) != 0) {
                return 0;
            }
            this.objIOleCommandTarget = new IOleCommandTarget(object[0]);
        }
        object = new OLECMD();
        object.cmdID = n;
        int n2 = this.objIOleCommandTarget.QueryStatus(null, 1, (OLECMD)object, null);
        if (n2 != 0) {
            return 0;
        }
        return object.cmdf;
    }

    protected int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    protected void releaseObjectInterfaces() {
        if (this.objIOleInPlaceObject != null) {
            this.objIOleInPlaceObject.Release();
        }
        this.objIOleInPlaceObject = null;
        if (this.objIOleObject != null) {
            this.objIOleObject.Close(1);
            this.objIOleObject.Release();
        }
        this.objIOleObject = null;
        if (this.objDocumentView != null) {
            this.objDocumentView.Release();
        }
        this.objDocumentView = null;
        if (this.objIViewObject2 != null) {
            this.objIViewObject2.SetAdvise(this.aspect, 0, 0);
            this.objIViewObject2.Release();
        }
        this.objIViewObject2 = null;
        if (this.objIOleCommandTarget != null) {
            this.objIOleCommandTarget.Release();
        }
        this.objIOleCommandTarget = null;
        if (this.objIUnknown != null) {
            this.objIUnknown.Release();
        }
        this.objIUnknown = null;
        if (COM.FreeUnusedLibraries) {
            COM.CoFreeUnusedLibraries();
        }
    }

    public boolean save(File file, boolean bl) {
        if (this.isOffice2007(false)) {
            return this.saveOffice2007(file);
        }
        if (bl) {
            return this.saveToStorageFile(file);
        }
        return this.saveToTraditionalFile(file);
    }

    private boolean saveFromContents(int n, File file) {
        boolean bl = false;
        IStream iStream = new IStream(n);
        iStream.AddRef();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n2 = 4096;
            int n3 = COM.CoTaskMemAlloc(n2);
            int[] nArray = new int[1];
            while (iStream.Read(n3, n2, nArray) == 0 && nArray[0] > 0) {
                byte[] byArray = new byte[nArray[0]];
                OS.MoveMemory(byArray, n3, nArray[0]);
                fileOutputStream.write(byArray);
                bl = true;
            }
            COM.CoTaskMemFree(n3);
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        iStream.Release();
        return bl;
    }

    private boolean saveFromOle10Native(int n, File file) {
        boolean bl = false;
        IStream iStream = new IStream(n);
        iStream.AddRef();
        int n2 = COM.CoTaskMemAlloc(4);
        int[] nArray = new int[1];
        int n3 = iStream.Read(n2, 4, null);
        OS.MoveMemory(nArray, n2, 4);
        COM.CoTaskMemFree(n2);
        if (n3 == 0 && nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            n2 = COM.CoTaskMemAlloc(nArray[0]);
            n3 = iStream.Read(n2, nArray[0], null);
            OS.MoveMemory(byArray, n2, nArray[0]);
            COM.CoTaskMemFree(n2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                bl = true;
            }
            catch (IOException iOException) {}
        }
        iStream.Release();
        return bl;
    }

    private int SaveObject() {
        this.updateStorage();
        return 0;
    }

    private boolean saveOffice2007(File file) {
        int[] nArray;
        int n;
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!this.updateStorage()) {
            return false;
        }
        boolean bl = false;
        int[] nArray2 = new int[1];
        IPersistStorage iPersistStorage = null;
        if (this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray2) == 0) {
            iPersistStorage = new IPersistStorage(nArray2[0]);
            this.tempStorage.AddRef();
            iPersistStorage.HandsOffStorage();
        }
        if (this.tempStorage.OpenStream("Package", 0, n = 16, 0, nArray = new int[1]) == 0) {
            bl = this.saveFromContents(nArray[0], file);
        }
        if (iPersistStorage != null) {
            iPersistStorage.SaveCompleted(this.tempStorage.getAddress());
            this.tempStorage.Release();
            iPersistStorage.Release();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveToStorageFile(File file) {
        if (file == null) return false;
        if (file.isDirectory()) {
            return false;
        }
        if (!this.updateStorage()) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.objIOleObject.QueryInterface(COM.IIDIPersistStorage, nArray) != 0) {
            return false;
        }
        IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
        try {
            IStorage iStorage;
            block10: {
                nArray = new int[1];
                char[] cArray = (String.valueOf(file.getAbsolutePath()) + "\u0000").toCharArray();
                int n = 69650;
                int n2 = COM.StgCreateDocfile(cArray, n, 0, nArray);
                if (n2 != 0) {
                    Object var10_7 = null;
                    iPersistStorage.Release();
                    return false;
                }
                iStorage = new IStorage(nArray[0]);
                try {
                    if (COM.OleSave(iPersistStorage.getAddress(), iStorage.getAddress(), false) != 0 || iStorage.Commit(0) != 0) break block10;
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    iStorage.Release();
                    throw throwable;
                }
                iStorage.Release();
                Object var10_8 = null;
                iPersistStorage.Release();
                return true;
            }
            Object var8_14 = null;
            iStorage.Release();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            iPersistStorage.Release();
            throw throwable;
        }
        iPersistStorage.Release();
        return false;
    }

    private boolean saveToTraditionalFile(File file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!this.updateStorage()) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.tempStorage.OpenStream("CONTENTS", 0, 16, 0, nArray) == 0) {
            return this.saveFromContents(nArray[0], file);
        }
        if (this.tempStorage.OpenStream("\u0001Ole10Native", 0, 16, 0, nArray) == 0) {
            return this.saveFromOle10Native(nArray[0], file);
        }
        return false;
    }

    private int Scroll_64(int n) {
        return 0;
    }

    private int Scroll(int n, int n2) {
        return 0;
    }

    void setBorderSpace(RECT rECT) {
        this.borderWidths = rECT;
        this.setBounds();
    }

    void setBounds() {
        Rectangle rectangle = this.frame.getClientArea();
        this.setBounds(this.borderWidths.left, this.borderWidths.top, rectangle.width - this.borderWidths.left - this.borderWidths.right, rectangle.height - this.borderWidths.top - this.borderWidths.bottom);
        this.setObjectRects();
    }

    private void setExtent(int n, int n2) {
        if (this.objIOleObject == null || this.isStatic || this.inUpdate) {
            return;
        }
        SIZE sIZE = this.getExtent();
        if (n == sIZE.cx && n2 == sIZE.cy) {
            return;
        }
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n;
        sIZE2.cy = n2;
        sIZE2 = this.xFormPixelsToHimetric(sIZE2);
        boolean bl = COM.OleIsRunning(this.objIOleObject.getAddress());
        if (!bl) {
            COM.OleRun(this.objIOleObject.getAddress());
        }
        if (this.objIOleObject.SetExtent(this.aspect, sIZE2) == 0) {
            this.inUpdate = true;
            this.objIOleObject.Update();
            this.inUpdate = false;
            if (!bl) {
                this.objIOleObject.Close(0);
            }
        }
    }

    public void setIndent(Rectangle rectangle) {
        this.indent = new RECT();
        this.indent.left = rectangle.x;
        this.indent.right = rectangle.width;
        this.indent.top = rectangle.y;
        this.indent.bottom = rectangle.height;
    }

    private void setObjectRects() {
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        RECT rECT = this.getRect();
        this.objIOleInPlaceObject.SetObjectRects(rECT, rECT);
    }

    private int ShowObject() {
        this.setBounds();
        return 0;
    }

    public void showProperties(String string) {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDISpecifyPropertyPages, nArray) != 0) {
            return;
        }
        ISpecifyPropertyPages iSpecifyPropertyPages = new ISpecifyPropertyPages(nArray[0]);
        CAUUID cAUUID = new CAUUID();
        int n = iSpecifyPropertyPages.GetPages(cAUUID);
        iSpecifyPropertyPages.Release();
        if (n != 0) {
            return;
        }
        char[] cArray = null;
        if (string != null) {
            cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
        }
        n = COM.OleCreatePropertyFrame(this.frame.handle, 10, 10, cArray, 1, new int[]{this.objIUnknown.getAddress()}, cAUUID.cElems, cAUUID.pElems, 2048, 0, 0);
        COM.CoTaskMemFree(cAUUID.pElems);
    }

    private boolean updateStorage() {
        if (this.tempStorage == null) {
            return false;
        }
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray) != 0) {
            return false;
        }
        IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
        int n = COM.OleSave(iPersistStorage.getAddress(), this.tempStorage.getAddress(), true);
        if (n != 0) {
            COM.WriteClassStg(this.tempStorage.getAddress(), this.objClsid);
            n = iPersistStorage.Save(this.tempStorage.getAddress(), true);
        }
        this.tempStorage.Commit(0);
        n = iPersistStorage.SaveCompleted(0);
        iPersistStorage.Release();
        return true;
    }

    private SIZE xFormHimetricToPixels(SIZE sIZE) {
        int n = OS.GetDC(0);
        int n2 = OS.GetDeviceCaps(n, 88);
        int n3 = OS.GetDeviceCaps(n, 90);
        OS.ReleaseDC(0, n);
        int n4 = Compatibility.round(sIZE.cx * n2, 2540);
        int n5 = Compatibility.round(sIZE.cy * n3, 2540);
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n4;
        sIZE2.cy = n5;
        return sIZE2;
    }

    private SIZE xFormPixelsToHimetric(SIZE sIZE) {
        int n = OS.GetDC(0);
        int n2 = OS.GetDeviceCaps(n, 88);
        int n3 = OS.GetDeviceCaps(n, 90);
        OS.ReleaseDC(0, n);
        int n4 = Compatibility.round(sIZE.cx * 2540, n2);
        int n5 = Compatibility.round(sIZE.cy * 2540, n3);
        SIZE sIZE2 = new SIZE();
        sIZE2.cx = n4;
        sIZE2.cy = n5;
        return sIZE2;
    }
}

