/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.internal.motif.XmSpinBoxCallbackStruct;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        Object object2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            Object object3;
            Object object4;
            n3 = 64;
            int[] nArray = new int[4];
            nArray[0] = OS.XmNmaximumValue;
            nArray[2] = OS.XmNdecimalPoints;
            object2 = nArray;
            OS.XtGetValues(this.handle, (int[])object2, ((Object)object2).length / 2);
            object = String.valueOf((int)object2[1]);
            if (object2[3] > 0) {
                object4 = new StringBuffer();
                ((StringBuffer)object4).append((String)object);
                ((StringBuffer)object4).append(this.getDecimalSeparator());
                object3 = object2[3] - ((String)object).length();
                while (object3 >= 0) {
                    ((StringBuffer)object4).append("0");
                    --object3;
                }
                object = ((StringBuffer)object4).toString();
            }
            object4 = Converter.wcsToMbcs(this.getCodePage(), (String)object, true);
            object3 = OS.XmStringCreateLocalized((byte[])object4);
            int n5 = this.font.handle;
            n3 = OS.XmStringWidth(n5, object3);
            OS.XmStringFree(object3);
        }
        if (n2 == -1) {
            n4 = this.getFontHeight(this.font.handle);
        }
        object2 = this.computeTrim(0, 0, n3, n4);
        if (n2 == -1) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowSize;
            object = nArray;
            OS.XtGetValues(this.handle, (int[])object, ((int[])object).length / 2);
            ((Rectangle)object2).height = Math.max(((Rectangle)object2).height, object[1] * 2);
        }
        return new Point(((Rectangle)object2).width, ((Rectangle)object2).height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int[] nArray = new int[8];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNarrowSize;
        nArray[4] = OS.XmNmarginWidth;
        nArray[6] = OS.XmNmarginHeight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNshadowThickness;
        nArray3[2] = OS.XmNhighlightThickness;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
        XRectangle xRectangle = new XRectangle();
        OS.XmWidgetGetDisplayRect(nArray2[1], xRectangle);
        return new Rectangle(n -= nArray2[5] + nArray4[1] + nArray4[3] + xRectangle.x, n2 -= nArray2[7] + nArray4[1] + nArray4[3] + xRectangle.y, n3 += (nArray2[5] + nArray4[1] + nArray4[3] + xRectangle.x) * 2 + nArray2[3], n4 += (nArray2[7] + nArray4[1] + nArray4[3] + xRectangle.y) * 2);
    }

    public void copy() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextCopy(nArray2[1], OS.XtLastTimestampProcessed(n));
    }

    void createHandle(int n) {
        int[] nArray = new int[18];
        nArray[0] = OS.XmNcolumns;
        nArray[1] = 2;
        nArray[2] = OS.XmNdecimalPoints;
        nArray[4] = OS.XmNincrementValue;
        nArray[5] = 1;
        nArray[6] = OS.XmNminimumValue;
        nArray[8] = OS.XmNmaximumValue;
        nArray[9] = 100;
        nArray[10] = OS.XmNspinBoxChildType;
        nArray[11] = 3;
        nArray[12] = OS.XmNeditable;
        nArray[13] = (this.style & 8) != 0 ? 0 : 1;
        nArray[14] = OS.XmNshadowThickness;
        nArray[16] = OS.XmNancestorSensitive;
        nArray[17] = 1;
        int[] nArray2 = nArray;
        int n2 = this.parent.handle;
        this.handle = OS.XmCreateSimpleSpinBox(n2, null, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNtextField;
        int[] nArray4 = nArray3;
        OS.XtGetValues(this.handle, nArray4, nArray4.length / 2);
        int n3 = nArray4[1];
        int[] nArray5 = new int[4];
        nArray5[0] = OS.XmNverifyBell;
        nArray5[2] = OS.XmNcursorPositionVisible;
        nArray5[3] = (this.style & 8) != 0 ? 0 : 1;
        int[] nArray6 = nArray5;
        OS.XtSetValues(n3, nArray6, nArray6.length / 2);
        if ((this.style & 0x800) == 0) {
            int[] nArray7 = new int[4];
            nArray7[0] = OS.XmNmarginHeight;
            nArray7[2] = OS.XmNshadowThickness;
            int[] nArray8 = nArray7;
            OS.XtSetValues(n3, nArray8, nArray8.length / 2);
        }
        OS.XmDropSiteUnregister(n3);
    }

    public void cut() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextCut(nArray2[1], OS.XtLastTimestampProcessed(n));
    }

    void deregister() {
        super.deregister();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.removeWidget(nArray2[1]);
    }

    int fontHandle() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getDigits() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNdecimalPoints;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    String getDecimalSeparator() {
        int n = OS.localeconv_decimal_point();
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrementValue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximumValue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimumValue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return 1;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNposition;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public String getText() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = OS.XmTextGetString(nArray2[1]);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        OS.XtFree(n);
        return new String(Converter.mbcsToWcs(this.getCodePage(), byArray));
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return OS.XmTextGetMaxLength(nArray2[1]);
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(this.handle, OS.XmNmodifyVerifyCallback, n, 19);
        OS.XtAddCallback(n2, OS.XmNactivateCallback, n, 9);
        OS.XtAddCallback(n2, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(n2, OS.XmNmodifyVerifyCallback, n, 19);
        OS.XtAddEventHandler(n2, 4, false, n, 1);
        OS.XtAddEventHandler(n2, 8, false, n, 2);
        OS.XtAddEventHandler(n2, 16, false, n, 4);
        OS.XtAddEventHandler(n2, 32, false, n, 8);
        OS.XtAddEventHandler(n2, 1, false, n, 6);
        OS.XtAddEventHandler(n2, 2, false, n, 7);
        OS.XtInsertEventHandler(n2, 0x200000, false, n, 5, 1);
    }

    public void paste() {
        this.checkWidget();
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextFieldPaste(nArray2[1]);
        this.display.setWarnings(bl);
    }

    void register() {
        super.register();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.addWidget(nArray2[1], this);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNforeground;
        nArray3[2] = OS.XmNhighlightColor;
        int[] nArray4 = nArray3;
        OS.XtGetValues(n2, nArray4, nArray4.length / 2);
        OS.XmChangeColor(n2, n);
        OS.XtSetValues(n2, nArray4, nArray4.length / 2);
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl2) {
            int[] nArray = new int[8];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNarrowSize;
            nArray[4] = OS.XmNmarginWidth;
            nArray[6] = OS.XmNmarginHeight;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int[] nArray3 = new int[6];
            nArray3[0] = OS.XmNwidth;
            nArray3[2] = OS.XmNheight;
            nArray3[4] = OS.XmNborderWidth;
            int[] nArray4 = nArray3;
            OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
            int n5 = Math.max(n3 - nArray2[3] - 2 * nArray2[5], 0);
            int n6 = Math.max(n4 - 2 * nArray2[7], 0);
            if (n5 != nArray4[1] || n6 != nArray4[3]) {
                OS.XtResizeWidget(nArray2[1], n5, n6, nArray4[5]);
            }
        }
        return super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNposition;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[]{OS.XmNdecimalPoints, n, OS.XmNposition, nArray2[1]};
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
    }

    void setForegroundPixel(int n) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[]{OS.XmNforeground, n};
        OS.XtSetValues(nArray2[1], nArray3, nArray3.length / 2);
        super.setForegroundPixel(n);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNincrementValue, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimumValue;
        nArray[2] = OS.XmNposition;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n <= nArray2[1]) {
            return;
        }
        int n2 = nArray2[3];
        if (n < n2) {
            n2 = n;
        }
        int[] nArray3 = new int[]{OS.XmNposition, n2, OS.XmNmaximumValue, n};
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNmaximumValue;
        nArray[2] = OS.XmNposition;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n >= nArray2[1]) {
            return;
        }
        int n2 = nArray2[3];
        if (n > n2) {
            n2 = n;
        }
        int[] nArray3 = new int[]{OS.XmNposition, n2, OS.XmNminimumValue, n};
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNmaximumValue;
        nArray[2] = OS.XmNminimumValue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        n = Math.min(Math.max(nArray2[3], n), nArray2[1]);
        int[] nArray3 = new int[]{OS.XmNposition, n};
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextSetMaxLength(nArray2[1], n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 <= n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        int[] nArray = new int[]{OS.XmNposition, n, OS.XmNmaximumValue, n3, OS.XmNminimumValue, n2, OS.XmNincrementValue, n5, OS.XmNdecimalPoints, n4};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    void updateText() {
        Object object;
        int[] nArray = new int[10];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNminimumValue;
        nArray[4] = OS.XmNmaximumValue;
        nArray[6] = OS.XmNposition;
        nArray[8] = OS.XmNdecimalPoints;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = OS.XmTextGetString(nArray2[1]);
        int n2 = nArray2[7];
        int n3 = nArray2[9];
        if (n != 0) {
            int n4 = OS.strlen(n);
            object = new byte[n4];
            OS.memmove(object, n, n4);
            OS.XtFree(n);
            String string = new String(Converter.mbcsToWcs(this.getCodePage(), object));
            try {
                int n5;
                if (n3 > 0) {
                    int n6;
                    String string2 = this.getDecimalSeparator();
                    int n7 = string.indexOf(string2);
                    if (n7 != -1) {
                        int n8;
                        int n9;
                        n6 = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                        String string3 = n6 != n7 ? string.substring(n6, n7) : "0";
                        String string4 = string.substring(n7 + 1);
                        if (string4.length() > n3) {
                            string4 = string4.substring(0, n3);
                        } else {
                            n9 = n3 - string4.length();
                            n8 = 0;
                            while (n8 < n9) {
                                string4 = String.valueOf(string4) + "0";
                                ++n8;
                            }
                        }
                        n9 = Integer.parseInt(string3);
                        n8 = Integer.parseInt(string4);
                        int n10 = 0;
                        while (n10 < n3) {
                            n9 *= 10;
                            ++n10;
                        }
                        n5 = n9 + n8;
                        if (string.startsWith("-")) {
                            n5 = -n5;
                        }
                    } else {
                        n5 = Integer.parseInt(string);
                        n6 = 0;
                        while (n6 < n3) {
                            n5 *= 10;
                            ++n6;
                        }
                    }
                } else {
                    n5 = Integer.parseInt(string);
                }
                if (nArray2[3] <= n5 && n5 <= nArray2[5]) {
                    n2 = n5;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n2 == nArray2[7]) {
            String string;
            if (n3 == 0) {
                string = String.valueOf(n2);
            } else {
                string = String.valueOf(Math.abs(n2));
                object = this.getDecimalSeparator();
                int n11 = string.length() - n3;
                StringBuffer stringBuffer = new StringBuffer();
                if (n2 < 0) {
                    stringBuffer.append("-");
                }
                if (n11 > 0) {
                    stringBuffer.append(string.substring(0, n11));
                    stringBuffer.append((String)object);
                    stringBuffer.append(string.substring(n11));
                } else {
                    stringBuffer.append("0");
                    stringBuffer.append((String)object);
                    while (n11++ < 0) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                string = stringBuffer.toString();
            }
            object = Converter.wcsToMbcs(this.getCodePage(), string, true);
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(nArray2[1], object);
            this.display.setWarnings(bl);
        } else {
            int[] nArray3 = new int[]{OS.XmNposition, n2};
            OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        }
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        this.postEvent(14);
        this.updateText();
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        this.updateText();
        return super.xFocusOut(xFocusChangeEvent);
    }

    int XmNmodifyVerifyCallback(int n, int n2, int n3) {
        String string;
        Object object;
        if (n == this.handle) {
            if ((this.style & 0x40) == 0) {
                XmSpinBoxCallbackStruct xmSpinBoxCallbackStruct = new XmSpinBoxCallbackStruct();
                OS.memmove(xmSpinBoxCallbackStruct, n3, 28);
                if (xmSpinBoxCallbackStruct.crossed_boundary != 0) {
                    xmSpinBoxCallbackStruct.doit = 0;
                    OS.memmove(n3, xmSpinBoxCallbackStruct, 28);
                }
            }
            return 0;
        }
        int n4 = super.XmNmodifyVerifyCallback(n, n2, n3);
        if (n4 != 0) {
            return n4;
        }
        if (this.font == null) {
            return n4;
        }
        XmTextVerifyCallbackStruct xmTextVerifyCallbackStruct = new XmTextVerifyCallbackStruct();
        OS.memmove(xmTextVerifyCallbackStruct, n3, 32);
        XmTextBlockRec xmTextBlockRec = new XmTextBlockRec();
        OS.memmove(xmTextBlockRec, xmTextVerifyCallbackStruct.text, 12);
        byte[] byArray = new byte[xmTextBlockRec.length];
        OS.memmove(byArray, xmTextBlockRec.ptr, xmTextBlockRec.length);
        String string2 = this.getCodePage();
        String string3 = new String(Converter.mbcsToWcs(string2, byArray));
        Event event = new Event();
        if (xmTextVerifyCallbackStruct.event != 0) {
            object = new XKeyEvent();
            OS.memmove((XKeyEvent)object, xmTextVerifyCallbackStruct.event, 60);
            event.time = ((XKeyEvent)object).time;
            this.setKeyState(event, (XKeyEvent)object);
        }
        event.start = xmTextVerifyCallbackStruct.startPos;
        event.end = xmTextVerifyCallbackStruct.endPos;
        event.text = string3;
        object = string3;
        int n5 = 0;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNdecimalPoints;
        nArray[2] = OS.XmNminimumValue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] > 0) {
            string = this.getDecimalSeparator();
            n5 = ((String)object).indexOf(string);
            if (n5 != -1) {
                object = String.valueOf(((String)object).substring(0, n5)) + ((String)object).substring(n5 + 1);
            }
            n5 = 0;
        }
        if (((String)object).length() > 0 && nArray2[3] < 0 && ((String)object).charAt(0) == '-') {
            ++n5;
        }
        while (n5 < ((String)object).length()) {
            if (!Character.isDigit(((String)object).charAt(n5))) break;
            ++n5;
        }
        event.doit = n5 == ((String)object).length();
        this.sendEvent(25, event);
        string = event.text;
        xmTextVerifyCallbackStruct.doit = (byte)(event.doit && string != null ? 1 : 0);
        if (string != null && string != string3) {
            OS.XtFree(xmTextBlockRec.ptr);
            byte[] byArray2 = Converter.wcsToMbcs(string2, string, true);
            int n6 = byArray2.length;
            int n7 = OS.XtMalloc(n6);
            OS.memmove(n7, byArray2, n6);
            xmTextBlockRec.ptr = n7;
            xmTextBlockRec.length = byArray2.length - 1;
            OS.memmove(xmTextVerifyCallbackStruct.text, xmTextBlockRec, 12);
        }
        OS.memmove(n3, xmTextVerifyCallbackStruct, 32);
        return n4;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n == nArray2[1]) {
            this.sendEvent(24);
        } else {
            XmAnyCallbackStruct xmAnyCallbackStruct = new XmAnyCallbackStruct();
            OS.memmove(xmAnyCallbackStruct, n3, 8);
            if (xmAnyCallbackStruct.reason == 31) {
                this.postEvent(13);
            }
        }
        return 0;
    }
}

