/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragSent = false;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        int n6 = this.display.scrolledMarginX;
        int n7 = this.display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            n4 += n6 * 10;
            n5 += n7;
        } else {
            n4 += n6;
            n5 += n7 * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        int[] nArray = new int[]{OS.XmNancestorSensitive, 1, OS.XmNhighlightThickness, this.display.textHighlightThickness, OS.XmNborderWidth, (this.style & 0x800) != 0 ? 1 : 0, OS.XmNorientation, (this.style & 0x100) != 0 ? 2 : 1, OS.XmNtraversalOn, 1};
        int n2 = this.parent.handle;
        this.handle = OS.XmCreateScrollBar(n2, null, nArray, nArray.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrement;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNpageIncrement;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvalue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getThumb() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsliderSize;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, n, 15);
        OS.XtAddCallback(this.handle, OS.XmNtoBottomCallback, n, 22);
        OS.XtAddCallback(this.handle, OS.XmNtoTopCallback, n, 23);
        OS.XtAddCallback(this.handle, OS.XmNincrementCallback, n, 18);
        OS.XtAddCallback(this.handle, OS.XmNdecrementCallback, n, 13);
        OS.XtAddCallback(this.handle, OS.XmNpageIncrementCallback, n, 21);
        OS.XtAddCallback(this.handle, OS.XmNpageDecrementCallback, n, 20);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendScrollEvent(int n) {
        Event event = new Event();
        event.detail = n;
        this.postEvent(13, event);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNincrement, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNmaximum, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        nArray[4] = OS.XmNsliderSize;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[3] - n - nArray2[5] < 0) {
            nArray2[5] = nArray2[3] - n;
        }
        nArray2[1] = n;
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.setWarnings(bl);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNpageIncrement, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNvalue, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        n = Math.min(n, nArray2[3] - nArray2[1]);
        int[] nArray3 = new int[]{OS.XmNsliderSize, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        this.display.setWarnings(bl);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        int[] nArray = new int[]{OS.XmNvalue, n, OS.XmNminimum, n2, OS.XmNmaximum, n3, OS.XmNsliderSize, n4, OS.XmNincrement, n5, OS.XmNpageIncrement, n6};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        this.dragSent = false;
        return n5;
    }

    int XmNdecrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000001);
        return 0;
    }

    int XmNdragCallback(int n, int n2, int n3) {
        this.dragSent = true;
        this.sendScrollEvent(1);
        return 0;
    }

    int XmNincrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000002);
        return 0;
    }

    int XmNpageDecrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000005);
        return 0;
    }

    int XmNpageIncrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000006);
        return 0;
    }

    int XmNtoBottomCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000008);
        return 0;
    }

    int XmNtoTopCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000007);
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        if (!this.dragSent) {
            this.sendScrollEvent(1);
            this.dragSent = false;
        }
        this.sendScrollEvent(0);
        return 0;
    }
}

