/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    NSView contentView;
    String text = "";

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        NSBox nSBox = (NSBox)this.view;
        int n5 = (int)Math.ceil(nSBox.borderWidth());
        NSSize nSSize = nSBox.contentViewMargins();
        NSRect nSRect = this.contentView.frame();
        n3 = (int)((float)n3 + (nSSize.width + (float)n5) * 2.0f);
        n4 = (int)((float)n4 + ((nSSize.height + (float)n5) * 2.0f + nSRect.y));
        return super.computeTrim(n, n2, n3, n4);
    }

    NSView contentView() {
        return this.contentView;
    }

    void createHandle() {
        this.state |= 0x800;
        NSBox nSBox = (NSBox)new SWTBox().alloc();
        nSBox.init();
        nSBox.setTitlePosition(0);
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        nSBox.setContentView(nSView);
        this.contentView = nSView;
        this.view = nSBox;
    }

    NSFont defaultNSFont() {
        return this.display.boxFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.contentView);
        SWTBox sWTBox = (SWTBox)this.view;
        this.display.removeWidget(sWTBox.titleCell());
    }

    void drawBackground(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    NSView eventView() {
        return this.contentView;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect nSRect = this.contentView.bounds();
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    void register() {
        super.register();
        this.display.addWidget(this.contentView, this);
        SWTBox sWTBox = (SWTBox)this.view;
        this.display.addWidget(sWTBox.titleCell(), this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.contentView != null) {
            this.contentView.release();
        }
        this.contentView = null;
    }

    void setFont(NSFont nSFont) {
        ((NSBox)this.view).setTitleFont(nSFont);
    }

    void setForeground(float[] fArray) {
        NSColor nSColor = fArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], 1.0f);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(((NSBox)this.view).titleCell().id);
        nSTextFieldCell.setTextColor(nSColor);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        NSBox nSBox = (NSBox)this.view;
        nSBox.setTitlePosition(n == 0 ? 0 : 2);
        nSBox.setTitle(NSString.stringWithCharacters(cArray, n));
    }
}

