/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            fArray[n10] = n + n7 * n9;
            fArray[n10 + 1] = n4;
            fArray[n10 + 2] = fArray[n10] + (float)(n7 / 2);
            fArray[n10 + 3] = n2;
            ++n9;
        }
        fArray[n5 - 2] = n + n7 * n8;
        fArray[n5 - 1] = n4;
        return fArray;
    }

    void computeRuns() {
        NSObject nSObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        if (this.textStorage != null) {
            return;
        }
        String string = this.getSegmentsText();
        NSString nSString = NSString.stringWith(string);
        this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
        this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = this.wrapWidth != -1 ? (float)this.wrapWidth : Float.MAX_VALUE;
        nSSize.height = Float.MAX_VALUE;
        this.textContainer.initWithContainerSize(nSSize);
        this.textStorage.addLayoutManager(this.layoutManager);
        this.layoutManager.addTextContainer(this.textContainer);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
        nSMutableAttributedString.beginEditing();
        Font font = this.font != null ? this.font : this.device.systemFont;
        NSRange nSRange = new NSRange();
        nSRange.length = nSString.length();
        nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
        font.addTraits(nSMutableAttributedString, nSRange);
        NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int n3 = 0;
        if (this.justify) {
            n3 = 3;
        } else {
            switch (this.alignment) {
                case 0x1000000: {
                    n3 = 2;
                    break;
                }
                case 131072: {
                    n3 = 1;
                }
            }
        }
        nSMutableParagraphStyle.setAlignment(n3);
        nSMutableParagraphStyle.setLineSpacing(this.spacing);
        nSMutableParagraphStyle.setFirstLineHeadIndent(this.indent);
        nSMutableParagraphStyle.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        if (this.tabs != null) {
            n2 = this.tabs.length;
            n = 0;
            int n4 = 0;
            while (n < n2) {
                object4 = (NSTextTab)new NSTextTab().alloc();
                object4 = ((NSTextTab)object4).initWithType(0, n4 += this.tabs[n]);
                nSMutableParagraphStyle.addTabStop((NSTextTab)object4);
                ((NSObject)object4).release();
                ++n;
            }
            n = n2 - 2 >= 0 ? this.tabs[n2 - 1] - this.tabs[n2 - 2] : this.tabs[n2 - 1];
            nSMutableParagraphStyle.setDefaultTabInterval(n);
        }
        nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
        nSMutableParagraphStyle.release();
        n2 = nSString.length();
        n = 0;
        while (n < this.styles.length - 1) {
            StyleItem styleItem = this.styles[n];
            if (styleItem.style != null) {
                Object object5;
                object4 = styleItem.style;
                nSRange.location = n2 != 0 ? this.translateOffset(styleItem.start) : 0;
                nSRange.length = this.translateOffset(this.styles[n + 1].start) - nSRange.location;
                Font font2 = ((TextStyle)object4).font;
                if (font2 != null) {
                    nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font2.handle, nSRange);
                    font2.addTraits(nSMutableAttributedString, nSRange);
                }
                if ((object3 = ((TextStyle)object4).foreground) != null) {
                    object2 = NSColor.colorWithDeviceRed(((Color)object3).handle[0], ((Color)object3).handle[1], ((Color)object3).handle[2], 1.0f);
                    nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object2, nSRange);
                }
                if ((object2 = ((TextStyle)object4).background) != null) {
                    object5 = NSColor.colorWithDeviceRed(((Color)object2).handle[0], ((Color)object2).handle[1], ((Color)object2).handle[2], 1.0f);
                    nSMutableAttributedString.addAttribute(OS.NSBackgroundColorAttributeName, (id)object5, nSRange);
                }
                if (((TextStyle)object4).strikeout) {
                    nSMutableAttributedString.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), nSRange);
                    object5 = ((TextStyle)object4).strikeoutColor;
                    if (object5 != null) {
                        object = NSColor.colorWithDeviceRed(((Color)object5).handle[0], ((Color)object5).handle[1], ((Color)object5).handle[2], 1.0f);
                        nSMutableAttributedString.addAttribute(OS.NSStrikethroughColorAttributeName, (id)object, nSRange);
                    }
                }
                if (this.isUnderlineSupported((TextStyle)object4)) {
                    int n5 = 0;
                    switch (((TextStyle)object4).underlineStyle) {
                        case 0: {
                            n5 = 1;
                            break;
                        }
                        case 1: {
                            n5 = 9;
                            break;
                        }
                        case 65536: {
                            n5 = 2;
                            break;
                        }
                        case 4: {
                            n5 = 1;
                            if (object3 != null) break;
                            object = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0f);
                            nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object, nSRange);
                        }
                    }
                    if (n5 != 0) {
                        nSMutableAttributedString.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(n5), nSRange);
                        object = ((TextStyle)object4).underlineColor;
                        if (object != null) {
                            nSObject = NSColor.colorWithDeviceRed(((Color)object).handle[0], ((Color)object).handle[1], ((Color)object).handle[2], 1.0f);
                            nSMutableAttributedString.addAttribute(OS.NSUnderlineColorAttributeName, nSObject, nSRange);
                        }
                    }
                }
                if (((TextStyle)object4).rise != 0) {
                    nSMutableAttributedString.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(((TextStyle)object4).rise), nSRange);
                }
                GlyphMetrics cfr_ignored_0 = ((TextStyle)object4).metrics;
            }
            ++n;
        }
        nSMutableAttributedString.endEditing();
        this.textStorage.setAttributedString(nSMutableAttributedString);
        nSMutableAttributedString.release();
        this.textContainer.setLineFragmentPadding(0.0f);
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        int n6 = this.layoutManager.numberOfGlyphs();
        int n7 = OS.malloc(NSRange.sizeof);
        object3 = new NSRange();
        n = 0;
        int n8 = 0;
        while (n8 < n6) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n8, n7, true);
            OS.memmove((NSRange)object3, n7, NSRange.sizeof);
            n8 = ((NSRange)object3).location + ((NSRange)object3).length;
            ++n;
        }
        if (n == 0) {
            ++n;
        }
        object2 = new int[n + 1];
        NSRect[] nSRectArray = new NSRect[n];
        n = 0;
        n8 = 0;
        while (n8 < n6) {
            nSRectArray[n] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n8, n7, true);
            if (n < nSRectArray.length - 1) {
                nSRectArray[n].height -= (float)this.spacing;
            }
            OS.memmove((NSRange)object3, n7, NSRange.sizeof);
            object2[n] = ((NSRange)object3).location;
            n8 = ((NSRange)object3).location + ((NSRange)object3).length;
            ++n;
        }
        if (n == 0) {
            object = this.font != null ? this.font : this.device.systemFont;
            nSObject = ((Font)object).handle;
            nSRectArray[0] = new NSRect();
            nSRectArray[0].height = Math.max(this.layoutManager.defaultLineHeightForFont((NSFont)nSObject), (float)(this.ascent + this.descent));
        }
        OS.free(n7);
        object2[n] = this.textStorage.length();
        this.lineOffsets = (int[])object2;
        this.lineBounds = nSRectArray;
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.styles = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = gC.checkGC(3073);
        try {
            int n6;
            Object object;
            int n7;
            Object object2;
            Object object3;
            boolean bl;
            this.computeRuns();
            int n8 = this.translateOffset(this.text.length());
            if (n8 == 0 && n5 == 0) {
                Object var44_11 = null;
                gC.uncheckGC(nSAutoreleasePool);
                return;
            }
            gC.handle.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            NSRange nSRange = new NSRange();
            int n9 = this.layoutManager.numberOfGlyphs();
            if (n9 > 0) {
                nSRange.location = 0;
                nSRange.length = n9;
                this.layoutManager.drawBackgroundForGlyphRange(nSRange, nSPoint);
            }
            boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
            if (bl || (n5 & 0x100000) != 0) {
                if (color2 == null) {
                    color2 = this.device.getSystemColor(26);
                }
                object3 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], color2.handle[3]);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                object2 = new NSRect();
                if (bl) {
                    n7 = OS.malloc(C.PTR_SIZEOF);
                    nSRange.location = this.translateOffset(n3);
                    nSRange.length = this.translateOffset(n4 - n3 + 1);
                    int n10 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, n7);
                    object = new int[1];
                    OS.memmove((int[])object, n7, C.PTR_SIZEOF);
                    OS.free(n7);
                    n6 = 0;
                    while (n6 < object[0]) {
                        OS.memmove((NSRect)object2, n10, NSRect.sizeof);
                        this.fixRect((NSRect)object2);
                        ((NSRect)object2).x += nSPoint.x;
                        ((NSRect)object2).y += nSPoint.y;
                        ((NSRect)object2).height = Math.max(((NSRect)object2).height, (float)(this.ascent + this.descent));
                        nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                        ++n6;
                        n10 += NSRect.sizeof;
                    }
                }
                if ((n5 & 0x100000) != 0) {
                    NSRect nSRect = this.lineBounds[this.lineBounds.length - 1];
                    ((NSRect)object2).x = nSPoint.x + nSRect.x + nSRect.width;
                    ((NSRect)object2).y = (float)n2 + nSRect.y;
                    ((NSRect)object2).width = (n5 & 0x10000) != 0 ? 2.1474836E9f : nSRect.height / 3.0f;
                    ((NSRect)object2).height = Math.max(nSRect.height, (float)(this.ascent + this.descent));
                    nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                }
                object3.setFill();
                nSBezierPath.fill();
            }
            if (n9 > 0) {
                boolean bl3;
                nSRange.location = 0;
                nSRange.length = n9;
                object3 = gC.data.foreground;
                boolean bl4 = bl3 = object3[0] == 0.0f && object3[1] == 0.0f && object3[2] == 0.0f && object3[3] == 1.0f;
                if (!bl3) {
                    int n11 = 0;
                    while (n11 < this.styles.length - 1) {
                        StyleItem styleItem = this.styles[n11];
                        if (!(styleItem.style != null && styleItem.style.foreground != null || styleItem.style != null && styleItem.style.underline && styleItem.style.underlineStyle == 4)) {
                            nSRange.location = n8 != 0 ? this.translateOffset(styleItem.start) : 0;
                            nSRange.length = this.translateOffset(this.styles[n11 + 1].start) - nSRange.location;
                            this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gC.data.fg, nSRange);
                        }
                        ++n11;
                    }
                }
                nSRange.location = 0;
                nSRange.length = n9;
                this.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
                if (!bl3) {
                    nSRange.location = 0;
                    nSRange.length = n8;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, nSRange);
                }
                object2 = new NSPoint();
                n7 = 0;
                while (n7 < this.styles.length) {
                    StyleItem styleItem = this.styles[n7];
                    object = styleItem.style;
                    if (object != null) {
                        n6 = ((TextStyle)object).underline && !this.isUnderlineSupported((TextStyle)object) ? 1 : 0;
                        n6 = n6 != 0 && (n7 + 1 == this.styles.length || !((TextStyle)object).isAdherentUnderline(this.styles[n7 + 1].style)) ? 1 : 0;
                        boolean bl5 = ((TextStyle)object).borderStyle != 0;
                        boolean bl6 = bl5 = bl5 && (n7 + 1 == this.styles.length || !((TextStyle)object).isAdherentBorder(this.styles[n7 + 1].style));
                        if (n6 != 0 || bl5) {
                            int n12 = n7 + 1 < this.styles.length ? this.translateOffset(this.styles[n7 + 1].start - 1) : n8;
                            int n13 = 0;
                            while (n13 < this.lineOffsets.length - 1) {
                                NSBezierPath nSBezierPath;
                                NSRect nSRect;
                                int[] nArray;
                                int n14;
                                int n15;
                                int n16;
                                int n17 = this.untranslateOffset(this.lineOffsets[n13]);
                                int n18 = this.untranslateOffset(this.lineOffsets[n13 + 1] - 1);
                                if (n6 != 0) {
                                    n16 = styleItem.start;
                                    n15 = n7;
                                    while (n15 > 0 && ((TextStyle)object).isAdherentUnderline(this.styles[n15 - 1].style)) {
                                        n16 = this.styles[n15 - 1].start;
                                        --n15;
                                    }
                                    if ((n16 = this.translateOffset(n16)) <= n18 && n12 >= n17) {
                                        nSRange.location = Math.max(n17, n16);
                                        nSRange.length = Math.min(n18, n12) + 1 - nSRange.location;
                                        if (nSRange.length > 0) {
                                            n15 = OS.malloc(C.PTR_SIZEOF);
                                            n14 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, n15);
                                            nArray = new int[1];
                                            OS.memmove(nArray, n15, C.PTR_SIZEOF);
                                            OS.free(n15);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            float f = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, n17);
                                            float[] fArray = null;
                                            if (((TextStyle)object).underlineColor != null) {
                                                fArray = ((TextStyle)object).underlineColor.handle;
                                            }
                                            if (fArray == null && ((TextStyle)object).foreground != null) {
                                                fArray = ((TextStyle)object).foreground.handle;
                                            }
                                            if (fArray != null) {
                                                NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]).setStroke();
                                            }
                                            int n19 = 0;
                                            while (n19 < nArray[0]) {
                                                OS.memmove(nSRect, n14, NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                float f2 = nSPoint.x + nSRect.x;
                                                float f3 = nSPoint.y + nSRect.y + nSRect.height - f + 1.0f;
                                                nSBezierPath = NSBezierPath.bezierPath();
                                                switch (((TextStyle)object).underlineStyle) {
                                                    case 2: {
                                                        nSBezierPath.setLineWidth(2.0f);
                                                        nSBezierPath.setLineCapStyle(1);
                                                        nSBezierPath.setLineJoinStyle(1);
                                                        nSBezierPath.setLineDash(new float[]{1.0f, 3.0f}, 2, 0.0f);
                                                        ((NSPoint)object2).x = f2;
                                                        ((NSPoint)object2).y = f3 + 0.5f;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        ((NSPoint)object2).x = f2 + nSRect.width;
                                                        ((NSPoint)object2).y = f3 + 0.5f;
                                                        nSBezierPath.lineToPoint((NSPoint)object2);
                                                        break;
                                                    }
                                                    case 3: {
                                                        gC.handle.setShouldAntialias(false);
                                                        nSBezierPath.setLineWidth(1.0f);
                                                        nSBezierPath.setLineCapStyle(0);
                                                        nSBezierPath.setLineJoinStyle(0);
                                                        float f4 = nSPoint.y + nSRect.y + nSRect.height;
                                                        float f5 = 1.0f;
                                                        float f6 = 2.0f * f5;
                                                        float f7 = Math.min(f3 - f6 / 2.0f, f4 - f6 - 1.0f);
                                                        float[] fArray2 = this.computePolyline((int)f2, (int)f7, (int)(f2 + nSRect.width), (int)(f7 + f6));
                                                        ((NSPoint)object2).x = fArray2[0] + 0.5f;
                                                        ((NSPoint)object2).y = fArray2[1] + 0.5f;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        int n20 = 2;
                                                        while (n20 < fArray2.length) {
                                                            ((NSPoint)object2).x = fArray2[n20] + 0.5f;
                                                            ((NSPoint)object2).y = fArray2[n20 + 1] + 0.5f;
                                                            nSBezierPath.lineToPoint((NSPoint)object2);
                                                            n20 += 2;
                                                        }
                                                        break;
                                                    }
                                                }
                                                nSBezierPath.stroke();
                                                ++n19;
                                                n14 += NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                if (bl5) {
                                    n16 = styleItem.start;
                                    n15 = n7;
                                    while (n15 > 0 && ((TextStyle)object).isAdherentBorder(this.styles[n15 - 1].style)) {
                                        n16 = this.styles[n15 - 1].start;
                                        --n15;
                                    }
                                    if ((n16 = this.translateOffset(n16)) <= n18 && n12 >= n17) {
                                        nSRange.location = Math.max(n17, n16);
                                        nSRange.length = Math.min(n18, n12) + 1 - nSRange.location;
                                        if (nSRange.length > 0) {
                                            n15 = OS.malloc(C.PTR_SIZEOF);
                                            n14 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, n15);
                                            nArray = new int[1];
                                            OS.memmove(nArray, n15, C.PTR_SIZEOF);
                                            OS.free(n15);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            float[] fArray = null;
                                            if (((TextStyle)object).borderColor != null) {
                                                fArray = ((TextStyle)object).borderColor.handle;
                                            }
                                            if (fArray == null && ((TextStyle)object).foreground != null) {
                                                fArray = ((TextStyle)object).foreground.handle;
                                            }
                                            if (fArray != null) {
                                                NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]).setStroke();
                                            }
                                            boolean bl7 = true;
                                            float[] fArray3 = null;
                                            switch (((TextStyle)object).borderStyle) {
                                                case 1: {
                                                    break;
                                                }
                                                case 2: {
                                                    fArray3 = bl7 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                                    break;
                                                }
                                                case 4: {
                                                    fArray3 = bl7 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                                    break;
                                                }
                                            }
                                            float[] fArray4 = null;
                                            if (fArray3 != null) {
                                                fArray4 = new float[fArray3.length];
                                                int n21 = 0;
                                                while (n21 < fArray4.length) {
                                                    fArray4[n21] = !bl7 ? fArray3[n21] : fArray3[n21] * (float)bl7;
                                                    ++n21;
                                                }
                                            }
                                            int n22 = 0;
                                            while (n22 < nArray[0]) {
                                                OS.memmove(nSRect, n14, NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                nSRect.x += nSPoint.x + 0.5f;
                                                nSRect.y += nSPoint.y + 0.5f;
                                                nSRect.width -= 0.5f;
                                                nSRect.height -= 0.5f;
                                                nSBezierPath = NSBezierPath.bezierPath();
                                                nSBezierPath.setLineDash(fArray4, fArray4 != null ? fArray4.length : 0, 0.0f);
                                                nSBezierPath.appendBezierPathWithRect(nSRect);
                                                nSBezierPath.stroke();
                                                ++n22;
                                                n14 += NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                ++n13;
                            }
                        }
                    }
                    ++n7;
                }
            }
            gC.handle.restoreGraphicsState();
            Object var44_13 = null;
            gC.uncheckGC(nSAutoreleasePool);
            return;
        }
        catch (Throwable throwable) {
            Object var44_12 = null;
            gC.uncheckGC(nSAutoreleasePool);
            throw throwable;
        }
    }

    void fixRect(NSRect nSRect) {
        int n = 0;
        while (n < this.lineBounds.length) {
            NSRect nSRect2 = this.lineBounds[n];
            if (nSRect2.y <= nSRect.y && nSRect.y < nSRect2.y + nSRect2.height && nSRect.x + nSRect.width > nSRect2.x + nSRect2.width) {
                nSRect.width = nSRect2.x + nSRect2.width - nSRect.x;
            }
            ++n;
        }
    }

    void freeRuns() {
        if (this.textStorage == null) {
            return;
        }
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        if (this.layoutManager != null) {
            this.layoutManager.release();
        }
        if (this.textContainer != null) {
            this.textContainer.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        Rectangle rectangle;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect nSRect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    nSRect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    Font font = this.font != null ? this.font : this.device.systemFont;
                    NSFont nSFont = font.handle;
                    nSRect.height = this.layoutManager.defaultLineHeightForFont(nSFont);
                }
                nSRect.height = Math.max(nSRect.height, (float)(this.ascent + this.descent)) + (float)this.spacing;
                rectangle = new Rectangle(0, 0, (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle;
        block10: {
            int n3;
            NSAutoreleasePool nSAutoreleasePool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            n3 = this.text.length();
                            if (n3 != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var15_8 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        return rectangle3;
                    }
                    if (n <= n2) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var15_9 = null;
                    if (nSAutoreleasePool == null) break block9;
                    nSAutoreleasePool.release();
                }
                return rectangle2;
            }
            try {
                n = Math.min(Math.max(0, n), n3 - 1);
                n2 = Math.min(Math.max(0, n2), n3 - 1);
                n = this.translateOffset(n);
                n2 = this.translateOffset(n2);
                NSRange nSRange = new NSRange();
                nSRange.location = n;
                nSRange.length = n2 - n + 1;
                int n4 = OS.malloc(C.PTR_SIZEOF);
                int n5 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, n4);
                int[] nArray = new int[1];
                OS.memmove(nArray, n4, C.PTR_SIZEOF);
                OS.free(n4);
                NSRect nSRect = new NSRect();
                int n6 = Integer.MAX_VALUE;
                int n7 = 0;
                int n8 = Integer.MAX_VALUE;
                int n9 = 0;
                int n10 = 0;
                while (n10 < nArray[0]) {
                    OS.memmove(nSRect, n5, NSRect.sizeof);
                    this.fixRect(nSRect);
                    n6 = Math.min(n6, (int)nSRect.x);
                    n7 = Math.max(n7, (int)Math.ceil(nSRect.x + nSRect.width));
                    n8 = Math.min(n8, (int)nSRect.y);
                    n9 = Math.max(n9, (int)Math.ceil(nSRect.y + nSRect.height));
                    ++n10;
                    n5 += NSRect.sizeof;
                }
                rectangle = new Rectangle(n6, n8, n7 - n6, n9 - n8);
                Object var15_10 = null;
                if (nSAutoreleasePool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var15_11 = null;
                    if (nSAutoreleasePool == null) break block11;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int n) {
        byte by;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n2 = this.text.length();
                if (n < 0 || n > n2) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                int n3 = this.layoutManager.glyphIndexForCharacterAtIndex(n);
                NSRange nSRange = new NSRange();
                nSRange.location = n3;
                nSRange.length = 1;
                int n4 = OS.malloc(1);
                byte[] byArray = new byte[1];
                int n5 = this.layoutManager.getGlyphsInRange(nSRange, 0, 0, 0, 0, n4);
                if (n5 > 0) {
                    OS.memmove(byArray, n4, 1);
                }
                OS.free(n4);
                by = byArray[0];
                Object var9_10 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_11 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return by;
    }

    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] nArray2 = new int[this.lineOffsets.length];
                int n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = this.untranslateOffset(this.lineOffsets[n]);
                    ++n;
                }
                nArray = nArray2;
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int n) {
        int n2;
        NSAutoreleasePool nSAutoreleasePool;
        block7: {
            int n3;
            this.checkLayout();
            nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n4 = this.text.length();
                if (n < 0 || n > n4) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                int n5 = 0;
                while (true) {
                    if (n5 >= this.lineOffsets.length - 1) {
                        n2 = this.lineBounds.length - 1;
                        break block7;
                    }
                    if (this.lineOffsets[n5 + 1] > n) {
                        n3 = n5;
                        Object var5_7 = null;
                        if (nSAutoreleasePool == null) return n3;
                        break;
                    }
                    ++n5;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (nSAutoreleasePool == null) throw throwable;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return n3;
        }
        Object var5_8 = null;
        if (nSAutoreleasePool == null) return n2;
        nSAutoreleasePool.release();
        return n2;
    }

    public Rectangle getLineBounds(int n) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (n < 0 || n >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect nSRect = this.lineBounds[n];
                int n2 = Math.max((int)Math.ceil(nSRect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSRect.width), n2);
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getLineCount() {
        int n;
        block3: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n = this.lineOffsets.length - 1;
                Object var2_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var2_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    public FontMetrics getLineMetrics(int n) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int n2;
                        this.computeRuns();
                        int n3 = this.getLineCount();
                        if (n < 0 || n >= n3) {
                            SWT.error(6);
                        }
                        if ((n2 = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        NSFont nSFont = font.handle;
                        int n4 = (int)(0.5f + nSFont.ascender());
                        int n5 = (int)(0.5f + (-nSFont.descender() + nSFont.leading()));
                        n4 = Math.max(n4, this.ascent);
                        n5 = Math.max(n5, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(n4, n5, 0, 0, n4 + n5);
                        Object var9_13 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var9_15 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return fontMetrics2;
            }
            Rectangle rectangle = this.getLineBounds(n);
            int n6 = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[n]);
            fontMetrics = FontMetrics.cocoa_new(rectangle.height - n6, n6, 0, 0, rectangle.height);
            Object var9_14 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return fontMetrics;
    }

    public Point getLocation(int n, boolean bl) {
        Point point;
        block9: {
            NSAutoreleasePool nSAutoreleasePool;
            block7: {
                Point point2;
                block8: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        int n2 = this.text.length();
                        if (n < 0 || n > n2) {
                            SWT.error(6);
                        }
                        if (n2 != 0) break block7;
                        point2 = new Point(0, 0);
                        Object var13_7 = null;
                        if (nSAutoreleasePool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var13_9 = null;
                            if (nSAutoreleasePool == null) break block10;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return point2;
            }
            n = this.translateOffset(n);
            int n3 = this.layoutManager.glyphIndexForCharacterAtIndex(n);
            NSRect nSRect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n3, 0);
            NSPoint nSPoint = this.layoutManager.locationForGlyphAtIndex(n3);
            if (bl) {
                NSRange nSRange = new NSRange();
                nSRange.location = n;
                nSRange.length = 1;
                int n4 = OS.malloc(C.PTR_SIZEOF);
                int n5 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, n4);
                int[] nArray = new int[1];
                OS.memmove(nArray, n4, C.PTR_SIZEOF);
                OS.free(n4);
                if (nArray[0] > 0) {
                    NSRect nSRect2 = new NSRect();
                    OS.memmove(nSRect2, n5, NSRect.sizeof);
                    this.fixRect(nSRect2);
                    nSPoint.x += nSRect2.width;
                }
            }
            point = new Point((int)nSPoint.x, (int)nSRect.y);
            Object var13_8 = null;
            if (nSAutoreleasePool == null) break block9;
            nSAutoreleasePool.release();
        }
        return point;
    }

    public int getNextOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, true);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    int _getOffset(int n, int n2, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n3 = this.text.length();
        if (n < 0 || n > n3) {
            SWT.error(6);
        }
        if (n3 == 0) {
            return 0;
        }
        n = this.translateOffset(n);
        n3 = this.translateOffset(n3);
        switch (n2) {
            case 1: 
            case 2: {
                boolean bl2 = false;
                block6: do {
                    int n4 = n;
                    if (bl) {
                        if (n4 < n3) {
                            ++n4;
                        }
                    } else if (n4 > 0) {
                        --n4;
                    }
                    if (n4 == n) break;
                    n = n4;
                    bl2 = false;
                    if (this.invalidOffsets == null) continue;
                    int n5 = 0;
                    while (n5 < this.invalidOffsets.length) {
                        if (n == this.invalidOffsets[n5]) {
                            bl2 = true;
                            continue block6;
                        }
                        ++n5;
                    }
                } while (bl2);
                return this.untranslateOffset(n);
            }
            case 4: {
                return this.untranslateOffset(this.textStorage.nextWordFromIndex(n, bl));
            }
            case 8: {
                NSRange nSRange = this.textStorage.doubleClickAtIndex(n3 == n ? n3 - 1 : n);
                return this.untranslateOffset(nSRange.location + nSRange.length);
            }
            case 16: {
                NSRange nSRange = this.textStorage.doubleClickAtIndex(n3 == n ? n3 - 1 : n);
                return this.untranslateOffset(nSRange.location);
            }
        }
        return this.untranslateOffset(n);
    }

    public int getOffset(Point point, int[] nArray) {
        int n;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (point == null) {
                    SWT.error(4);
                }
                n = this.getOffset(point.x, point.y, nArray);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        block8: {
            int n4;
            NSAutoreleasePool nSAutoreleasePool;
            block6: {
                block7: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (nArray != null && nArray.length < 1) {
                            SWT.error(5);
                        }
                        if ((n4 = this.text.length()) != 0) break block6;
                        Object var10_6 = null;
                        if (nSAutoreleasePool == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var10_8 = null;
                            if (nSAutoreleasePool == null) break block9;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return 0;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            float[] fArray = new float[1];
            int n5 = this.layoutManager.glyphIndexForPoint(nSPoint, this.textContainer, fArray);
            int n6 = this.layoutManager.characterIndexForGlyphAtIndex(n5);
            if (nArray != null) {
                nArray[0] = Math.round(fArray[0]);
            }
            n3 = Math.min(this.untranslateOffset(n6), n4 - 1);
            Object var10_7 = null;
            if (nSAutoreleasePool == null) break block8;
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, false);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        this.invalidOffsets = new int[n];
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                this.invalidOffsets[n4] = n3 + n4;
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.invalidOffsets[n4] = n3 + n4;
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        if (n4 != n) {
            int[] nArray = new int[n4];
            System.arraycopy(this.invalidOffsets, 0, nArray, 0, n4);
            this.invalidOffsets = nArray;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle textStyle) {
        if (textStyle != null && textStyle.underline) {
            int n = textStyle.underlineStyle;
            return n == 0 || n == 1 || n == 4 || n == 65536;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void setAlignment(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setAscent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setDescent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setFont(Font var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 100->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setIndent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setJustify(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setOrientation(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSegments(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSpacing(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 77->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setStyle(TextStyle var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 650->654)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setTabs(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setText(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setWidth(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 82->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n < this.invalidOffsets[n3]) break;
            ++n;
            ++n3;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        int n3 = 0;
        while (n3 < this.invalidOffsets.length) {
            if (n == this.invalidOffsets[n3]) {
                ++n;
            } else if (n < this.invalidOffsets[n3]) {
                return n - n3;
            }
            ++n3;
        }
        return n - this.invalidOffsets.length;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

