/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    NSView view;
    NSButton button;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int INSET = 3;
    static final int ARROW_WIDTH = 5;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        NSString nsAttributeName = new NSString(arg0);
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute) || nsAttributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString roleText;
            NSString nSString = (this.style & 8) != 0 ? OS.NSAccessibilityButtonRole : ((this.style & 0x10) != 0 ? OS.NSAccessibilityRadioButtonRole : ((this.style & 0x20) != 0 ? OS.NSAccessibilityCheckBoxRole : (roleText = (this.style & 4) != 0 ? OS.NSAccessibilityMenuButtonRole : null)));
            if (roleText != null) {
                if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                    return roleText.id;
                }
                long description = OS.NSAccessibilityRoleDescription(roleText.id, 0L);
                return description;
            }
        } else {
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityTitleAttribute) || nsAttributeName.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
                String accessibleText = this.toolTipText;
                if (accessibleText == null || accessibleText.equals("")) {
                    accessibleText = this.text;
                }
                if (accessibleText != null && !accessibleText.equals("")) {
                    return NSString.stringWith((String)accessibleText).id;
                }
                return NSString.stringWith((String)"").id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityValueAttribute) && (this.style & 0x30) != 0) {
                NSNumber value = NSNumber.numberWithInt(this.selection ? 1 : 0);
                return value.id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
                NSNumber value = NSNumber.numberWithInt(this.getEnabled() ? 1 : 0);
                return value.id;
            }
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Point computeSize() {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                width = this.getWidth();
                height = 22;
            } else {
                width = 24;
                height = this.getWidth();
            }
            if (this.control != null) {
                height = Math.max(height, this.control.getMininumHeight());
            }
        } else {
            if (this.text.length() != 0 || this.image != null) {
                NSButton widget = this.button;
                NSSize size = widget.cell().cellSize();
                width = (int)Math.ceil(size.width);
                height = (int)Math.ceil(size.height);
            } else {
                width = 24;
                height = 22;
            }
            if ((this.style & 4) != 0) {
                width += 8;
            }
            width += 6;
            height += 6;
        }
        return new Point(width, height);
    }

    void createHandle() {
        if ((this.style & 2) != 0) {
            NSBox widget = (NSBox)new SWTBox().alloc();
            widget.init();
            widget.setBoxType(2L);
            widget.setBorderWidth(0.0);
            this.view = widget;
        } else {
            NSView widget = (NSView)new SWTView().alloc();
            widget.init();
            this.button = (NSButton)new SWTButton().alloc();
            this.button.init();
            NSButtonCell cell = (NSButtonCell)new SWTButtonCell().alloc().init();
            this.button.setCell(cell);
            cell.release();
            this.button.setBordered(false);
            this.button.setAction(OS.sel_sendSelection);
            this.button.setTarget(this.button);
            Font font = this.parent.font != null ? this.parent.font : this.parent.defaultFont();
            this.button.setFont(font.handle);
            this.button.setImagePosition(6L);
            NSString emptyStr = NSString.stringWith("");
            this.button.setTitle(emptyStr);
            this.button.setEnabled(this.parent.getEnabled());
            widget.addSubview(this.button);
            this.view = widget;
        }
    }

    NSAttributedString createString() {
        NSAttributedString attribStr = this.parent.createString(this.text, null, this.parent.foreground, 0x1000000, false, true, true);
        attribStr.autorelease();
        return attribStr;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        if (this.button != null) {
            this.display.removeWidget(this.button);
            this.display.removeWidget(this.button.cell());
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawImageWithFrameInView(long id2, long sel, long image, NSRect rect, long view) {
        if (this.text.length() > 0) {
            if ((this.parent.style & 0x20000) != 0) {
                rect.x += 3.0;
            } else {
                rect.y += 3.0;
            }
        }
        this.callSuper(id2, sel, image, rect, view);
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 == this.view.id) {
            NSRect bounds;
            if (this.getSelection()) {
                bounds = this.view.bounds();
                context.saveGraphicsState();
                NSColor.colorWithDeviceRed(0.1f, 0.1f, 0.1f, 0.1f).setFill();
                NSColor.colorWithDeviceRed(0.2f, 0.2f, 0.2f, 0.2f).setStroke();
                NSBezierPath.fillRect(bounds);
                bounds.x += 0.5;
                bounds.y += 0.5;
                bounds.width -= 1.0;
                bounds.height -= 1.0;
                NSBezierPath.strokeRect(bounds);
                context.restoreGraphicsState();
            }
            if ((this.style & 4) != 0) {
                bounds = this.view.bounds();
                context.saveGraphicsState();
                NSBezierPath path = NSBezierPath.bezierPath();
                NSPoint pt = new NSPoint();
                path.moveToPoint(pt);
                pt.x += 5.0;
                path.lineToPoint(pt);
                pt.y += 4.0;
                pt.x -= 2.5;
                path.lineToPoint(pt);
                path.closePath();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.translateXBy((int)bounds.width - 5 - 3, (int)(bounds.height - 2.0) / 2);
                transform.concat();
                NSColor color = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
                color.set();
                path.fill();
                context.restoreGraphicsState();
            }
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.style & 2) == 0) {
            this.button.setEnabled(enabled);
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect rect = this.view.frame();
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    void setClipRegion(double x, double y) {
        NSRect frame = this.view.frame();
        this.parent.setClipRegion(frame.x + x, frame.y + y);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    long menuForEvent(long id2, long sel, long theEvent) {
        return this.parent.menuForEvent(id2, sel, theEvent);
    }

    void mouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        Display display = this.display;
        display.trackingControl = this.parent;
        super.mouseDown(id2, sel, theEvent);
        display.trackingControl = null;
        if ((this.style & 4) != 0 && id2 == this.view.id) {
            NSRect frame = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)frame.x;
            event.y = (int)(frame.y + frame.height);
            this.postEvent(13, event);
        }
    }

    void mouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.mouseUp(id2, sel, theEvent);
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.mouseDragged(id2, sel, theEvent);
    }

    void rightMouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        super.rightMouseDown(id2, sel, theEvent);
    }

    void rightMouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.rightMouseUp(id2, sel, theEvent);
    }

    void rightMouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.rightMouseDragged(id2, sel, theEvent);
    }

    void otherMouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        super.otherMouseDown(id2, sel, theEvent);
    }

    void otherMouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.otherMouseUp(id2, sel, theEvent);
    }

    void otherMouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.otherMouseDragged(id2, sel, theEvent);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        if (this.button != null) {
            this.display.addWidget(this.button, this);
            this.display.addWidget(this.button.cell(), this);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        if (this.button != null) {
            this.button.release();
        }
        this.button = null;
        this.view = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.postEvent(13);
    }

    void setBounds(int x, int y, int width, int height) {
        NSRect rect = new NSRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        this.view.setFrame(rect);
        if (this.button != null) {
            rect.x = 0.0;
            rect.y = 0.0;
            rect.width = width;
            rect.height = height;
            if ((this.style & 4) != 0) {
                rect.width -= 8.0;
            }
            this.button.setFrame(rect);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        NSBox widget = (NSBox)this.view;
        if (control == null) {
            widget.setBoxType(2L);
        } else {
            widget.setBoxType(4L);
        }
        this.control = control;
        this.view.setHidden(control != null);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 && enabled) {
            return;
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = selected;
        this.view.setNeedsDisplay(true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        NSButton widget = this.button;
        widget.setAttributedTitle(this.createString());
        if (this.text.length() != 0 && this.image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                widget.setImagePosition(2L);
            } else {
                widget.setImagePosition(5L);
            }
        } else {
            widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    void setVisible(boolean visible) {
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.view.setHidden(!visible);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0 || this.width == width) {
            return;
        }
        this.width = width;
        this.parent.relayout();
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void updateImage(boolean layout) {
        if ((this.style & 2) != 0) {
            return;
        }
        Image image = null;
        image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
        NSButton widget = this.button;
        widget.setImage(image != null ? image.handle : null);
        widget.setNeedsDisplay(true);
        if (this.text.length() != 0 && image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                widget.setImagePosition(2L);
            } else {
                this.button.setImagePosition(5L);
            }
        } else {
            widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }
}

