/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTCanvasView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        NSArray views = this.contentView().subviews();
        int count = (int)views.count();
        Control[] children = new Control[count];
        if (count == 0) {
            return children;
        }
        int j = 0;
        int i = 0;
        while (i < count) {
            Widget widget = this.display.getWidget(views.objectAtIndex((long)((long)(count - i - 1))).id);
            if (widget != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
        }
        if (j == count) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return null;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    boolean acceptsFirstResponder(long id2, long sel) {
        if ((this.state & 2) != 0) {
            return (this.style & 0x80000) == 0 && this.hooksKeys() && this.contentView().subviews().count() == 0L;
        }
        return super.acceptsFirstResponder(id2, sel);
    }

    long accessibilityAttributeNames(long id2, long sel) {
        NSArray returnObject;
        if (id2 == this.view.id && this.accessible != null && (returnObject = this.accessible.internal_accessibilityAttributeNames(-1)) != null) {
            return returnObject.id;
        }
        return super.accessibilityAttributeNames(id2, sel);
    }

    boolean accessibilityIsIgnored(long id2, long sel) {
        id role;
        if (this.view != null && id2 == this.view.id && this.accessible != null && (role = this.accessible.internal_accessibilityAttributeValue(OS.NSAccessibilityRoleAttribute, -1)) != null) {
            return false;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x2000;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x2000) != 0);
                this.state &= 0xFFFFDFFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected void checkSubclass() {
    }

    Widget[] computeTabList() {
        Widget[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length != 0) {
                Widget[] newResult = new Widget[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void createHandle() {
        boolean scrolled;
        this.state |= 2;
        boolean bl = scrolled = (this.style & 0x300) != 0;
        if (!scrolled) {
            this.state |= 0x800;
        }
        NSRect rect = new NSRect();
        if (scrolled || this.hasBorder()) {
            NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
            scrollWidget.initWithFrame(rect);
            scrollWidget.setDrawsBackground(false);
            if ((this.style & 0x100) != 0) {
                scrollWidget.setHasHorizontalScroller(true);
            }
            if ((this.style & 0x200) != 0) {
                scrollWidget.setHasVerticalScroller(true);
            }
            scrollWidget.setBorderType(this.hasBorder() ? 2 : 0);
            this.scrollView = scrollWidget;
        }
        NSView widget = (NSView)new SWTCanvasView().alloc();
        widget.initWithFrame(rect);
        this.view = widget;
        if (this.scrollView != null) {
            NSClipView contentView = this.scrollView.contentView();
            contentView.setAutoresizesSubviews(true);
            this.view.setAutoresizingMask(18L);
        }
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if ((this.state & 2) != 0 && (this.style & 0x40000) == 0) {
            this.fillBackground(this.view, context, rect, -1);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    void invalidateChildrenVisibleRegion() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            child.resetVisibleRegion();
            child.invalidateChildrenVisibleRegion();
            ++i;
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isOpaque(long id2, long sel) {
        if ((this.state & 2) != 0 && id2 == this.view.id && this.region == null && this.background != null && this.background[3] == 1.0) {
            return true;
        }
        return super.isOpaque(id2, sel);
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    void keyDown(long id2, long sel, long theEvent) {
        if (this.view.window().firstResponder().id == id2 && (this.state & 2) != 0) {
            Shell s = this.getShell();
            NSArray array = NSArray.arrayWithObject(new NSEvent(theEvent));
            s.keyInputHappened = false;
            this.view.interpretKeyEvents(array);
            if (this.imeInComposition()) {
                return;
            }
            if (!s.keyInputHappened) {
                NSEvent nsEvent = new NSEvent(theEvent);
                boolean[] consume = new boolean[1];
                if (this.translateTraversal(nsEvent.keyCode(), nsEvent, consume)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nsEvent, 1)) {
                    return;
                }
                if (consume[0]) {
                    return;
                }
            }
            return;
        }
        super.keyDown(id2, sel, theEvent);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        int updateCount = 0;
        Composite[] update = new Composite[16];
        int i2 = 0;
        while (i2 < changed.length) {
            Control child = changed[i2];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout != null) {
                    composite.state |= 0x1000;
                    if (!composite.layout.flushCache(child)) {
                        composite.state |= 0x2000;
                    }
                }
                if (updateCount == update.length) {
                    Composite[] newUpdate = new Composite[update.length + 16];
                    System.arraycopy(update, 0, newUpdate, 0, update.length);
                    update = newUpdate;
                }
                int n = updateCount++;
                Composite composite2 = composite;
                update[n] = composite2;
                child = composite2;
                composite = child.parent;
            }
            ++i2;
        }
        i2 = updateCount - 1;
        while (i2 >= 0) {
            update[i2].updateLayout(false);
            --i2;
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x1000;
            if (changed) {
                this.state |= 0x2000;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize(int wHint, int Hint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    boolean mouseEvent(long id2, long sel, long theEvent, int type) {
        boolean result = super.mouseEvent(id2, sel, theEvent, type);
        return (this.state & 2) == 0 ? result : new NSEvent(theEvent).type() != 1L;
    }

    void pageDown(long id2, long sel, long sender) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageDown(id2, sel, sender);
    }

    void pageUp(long id2, long sel, long sender) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.pageUp(id2, sel, sender);
    }

    void reflectScrolledClipView(long id2, long sel, long aClipView) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.reflectScrolledClipView(id2, sel, aClipView);
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resized() {
        super.resized();
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void scrollWheel(long id2, long sel, long theEvent) {
        if ((this.state & 2) != 0) {
            NSView view;
            NSView nSView = view = this.scrollView != null ? this.scrollView : this.view;
            if (id2 == view.id) {
                Event event;
                int selection;
                NSEvent nsEvent = new NSEvent(theEvent);
                double delta = nsEvent.deltaY();
                if (delta != 0.0 && (this.hooks(37) || this.filters(37)) && !this.sendMouseEvent(nsEvent, 37, true)) {
                    return;
                }
                boolean handled = false;
                ScrollBar bar = this.verticalBar;
                if (delta != 0.0 && bar != null && bar.getEnabled()) {
                    if (-1.0 < delta && delta < 0.0) {
                        delta = -1.0;
                    }
                    if (0.0 < delta && delta < 1.0) {
                        delta = 1.0;
                    }
                    selection = Math.max(0, (int)((double)(0.5f + (float)bar.getSelection()) - (double)bar.getIncrement() * delta));
                    bar.setSelection(selection);
                    event = new Event();
                    event.detail = delta > 0.0 ? 0x1000005 : 0x1000006;
                    bar.sendEvent(13, event);
                    handled = true;
                }
                bar = this.horizontalBar;
                delta = nsEvent.deltaX();
                if (delta != 0.0 && bar != null && bar.getEnabled()) {
                    selection = Math.max(0, (int)((double)(0.5f + (float)bar.getSelection()) - (double)bar.getIncrement() * delta));
                    bar.setSelection(selection);
                    event = new Event();
                    event.detail = delta > 0.0 ? 0x1000005 : 0x1000006;
                    bar.sendEvent(13, event);
                    handled = true;
                }
                if (!handled) {
                    view.superview().scrollWheel(nsEvent);
                }
                return;
            }
            this.callSuper(id2, sel, theEvent);
            return;
        }
        super.scrollWheel(id2, sel, theEvent);
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x4000) != 0 || (this.state & 0x1000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    int traversalCode(int key, NSEvent theEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, theEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            control.updateCursorRects(enabled && control.isEnabled());
            ++i;
        }
    }

    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x4000;
            return;
        }
        if ((this.state & 0x1000) != 0) {
            boolean changed = (this.state & 0x2000) != 0;
            this.state &= 0xFFFFCFFF;
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFBFFF;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }
}

