/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSDirectoryEnumerator;
import org.eclipse.swt.internal.cocoa.NSEnumerator;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableSet;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String fullPath;
    String identifier;
    static final String PREFIX_FILE = "file:";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            long appName = OS.malloc(C.PTR_SIZEOF);
            long type = OS.malloc(C.PTR_SIZEOF);
            NSString temp = new NSString(OS.NSTemporaryDirectory());
            NSString fileName = NSString.stringWith("swt" + System.currentTimeMillis() + extension);
            NSString fullPath = temp.stringByAppendingPathComponent(fileName);
            NSFileManager fileManager = NSFileManager.defaultManager();
            fileManager.createFileAtPath(fullPath, null, null);
            if (!workspace.getInfoForFile(fullPath, appName, type)) {
                return null;
            }
            fileManager.removeItemAtPath(fullPath, 0L);
            long[] buffer = new long[1];
            long[] buffer2 = new long[1];
            OS.memmove(buffer, appName, (long)C.PTR_SIZEOF);
            OS.memmove(buffer2, type, (long)C.PTR_SIZEOF);
            OS.free(appName);
            OS.free(type);
            if (buffer[0] != 0L) {
                NSString appPath = new NSString(buffer[0]);
                NSString appType = new NSString(buffer2[0]);
                NSBundle bundle = NSBundle.bundleWithPath(appPath);
                if (bundle != null) {
                    NSString textEditId = NSString.stringWith("com.apple.TextEdit");
                    NSString bundleId = NSString.stringWith("CFBundleIdentifier");
                    NSDictionary infoDictionary = bundle.infoDictionary();
                    boolean textEdit = textEditId.isEqual(infoDictionary.objectForKey(bundleId));
                    if (!textEdit) {
                        Program program = Program.getProgram(bundle);
                        return program;
                    }
                    NSString CFBundleDocumentTypes = NSString.stringWith("CFBundleDocumentTypes");
                    NSString CFBundleTypeExtensions = NSString.stringWith("CFBundleTypeExtensions");
                    id id2 = infoDictionary.objectForKey(CFBundleDocumentTypes);
                    if (id2 != null) {
                        NSDictionary documentTypes = new NSDictionary(id2.id);
                        NSEnumerator documentTypesEnumerator = documentTypes.objectEnumerator();
                        while ((id2 = documentTypesEnumerator.nextObject()) != null) {
                            NSEnumerator supportedExtensionsEnumerator;
                            NSDictionary documentType = new NSDictionary(id2.id);
                            NSDictionary supportedExtensions = new NSDictionary(documentType.objectForKey(CFBundleTypeExtensions));
                            if (supportedExtensions == null || (supportedExtensionsEnumerator = supportedExtensions.objectEnumerator()) == null) continue;
                            id ext = null;
                            while ((ext = supportedExtensionsEnumerator.nextObject()) != null) {
                                NSString strExt = new NSString(ext);
                                if (!appType.isEqual(strExt)) continue;
                                Program program = Program.getProgram(bundle);
                                return program;
                            }
                        }
                    }
                }
            }
            return null;
        }
        finally {
            pool.release();
        }
    }

    public static String[] getExtensions() {
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            id id2;
            NSMutableSet supportedDocumentTypes = (NSMutableSet)NSMutableSet.set();
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSString CFBundleDocumentTypes = NSString.stringWith("CFBundleDocumentTypes");
            NSString CFBundleTypeExtensions = NSString.stringWith("CFBundleTypeExtensions");
            NSArray array = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int count = (int)array.count();
            int i = 0;
            while (i < count) {
                NSString path = new NSString(array.objectAtIndex(i));
                NSFileManager fileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator enumerator = fileManager.enumeratorAtPath(path);
                if (enumerator != null) {
                    id id3;
                    while ((id3 = enumerator.nextObject()) != null) {
                        NSBundle bundle;
                        enumerator.skipDescendents();
                        NSString filePath = new NSString(id3.id);
                        NSString fullPath = path.stringByAppendingPathComponent(filePath);
                        if (!workspace.isFilePackageAtPath(fullPath) || (id3 = (bundle = NSBundle.bundleWithPath(fullPath)).infoDictionary().objectForKey(CFBundleDocumentTypes)) == null) continue;
                        NSDictionary documentTypes = new NSDictionary(id3.id);
                        NSEnumerator documentTypesEnumerator = documentTypes.objectEnumerator();
                        while ((id3 = documentTypesEnumerator.nextObject()) != null) {
                            NSDictionary documentType = new NSDictionary(id3.id);
                            id3 = documentType.objectForKey(CFBundleTypeExtensions);
                            if (id3 == null) continue;
                            supportedDocumentTypes.addObjectsFromArray(new NSArray(id3.id));
                        }
                    }
                }
                ++i;
            }
            i = 0;
            String[] exts = new String[(int)supportedDocumentTypes.count()];
            NSEnumerator enumerator = supportedDocumentTypes.objectEnumerator();
            while ((id2 = enumerator.nextObject()) != null) {
                String ext = new NSString(id2.id).getString();
                if (ext.equals("*")) continue;
                exts[i++] = "." + ext;
            }
            if (i != exts.length) {
                String[] temp = new String[i];
                System.arraycopy(exts, 0, temp, 0, i);
                exts = temp;
            }
            String[] stringArray = exts;
            return stringArray;
        }
        finally {
            pool.release();
        }
    }

    static Program getProgram(NSBundle bundle) {
        NSString CFBundleName = NSString.stringWith("CFBundleName");
        NSString CFBundleDisplayName = NSString.stringWith("CFBundleDisplayName");
        NSString fullPath = bundle.bundlePath();
        NSString identifier = bundle.bundleIdentifier();
        id bundleName = bundle.objectForInfoDictionaryKey(CFBundleDisplayName);
        if (bundleName == null) {
            bundleName = bundle.objectForInfoDictionaryKey(CFBundleName);
        }
        if (bundleName == null) {
            bundleName = fullPath.lastPathComponent().stringByDeletingPathExtension();
        }
        NSString name = new NSString(bundleName.id);
        Program program = new Program();
        program.name = name.getString();
        program.fullPath = fullPath.getString();
        program.identifier = identifier != null ? identifier.getString() : "";
        return program;
    }

    public static Program[] getPrograms() {
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            Vector<Program> vector = new Vector<Program>();
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSArray array = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int count = (int)array.count();
            int i = 0;
            while (i < count) {
                NSString path = new NSString(array.objectAtIndex(i));
                NSFileManager fileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator enumerator = fileManager.enumeratorAtPath(path);
                if (enumerator != null) {
                    id id2;
                    while ((id2 = enumerator.nextObject()) != null) {
                        NSBundle bundle;
                        enumerator.skipDescendents();
                        NSString fullPath = path.stringByAppendingPathComponent(new NSString(id2.id));
                        if (!workspace.isFilePackageAtPath(fullPath) || (bundle = NSBundle.bundleWithPath(fullPath)) == null) continue;
                        vector.addElement(Program.getProgram(bundle));
                    }
                }
                ++i;
            }
            Object[] programs = new Program[vector.size()];
            vector.copyInto(programs);
            Object[] objectArray = programs;
            return objectArray;
        }
        finally {
            pool.release();
        }
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSString unescapedStr = NSString.stringWith("%");
            String lowercaseName = fileName.toLowerCase();
            if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
                unescapedStr = NSString.stringWith("%#");
            } else if (!lowercaseName.startsWith(PREFIX_FILE)) {
                fileName = PREFIX_FILE + fileName;
            }
            NSString fullPath = NSString.stringWith(fileName);
            long ptr = OS.CFURLCreateStringByAddingPercentEscapes(0L, fullPath.id, unescapedStr.id, 0L, 0x8000100);
            NSString escapedString = new NSString(ptr);
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            boolean result = workspace.openURL(NSURL.URLWithString(escapedString));
            OS.CFRelease(ptr);
            boolean bl = result;
            return bl;
        }
        finally {
            pool.release();
        }
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            String lowercaseName = fileName.toLowerCase();
            if (lowercaseName.startsWith(PREFIX_HTTP) || lowercaseName.startsWith(PREFIX_HTTPS)) {
                NSString fullPath = NSString.stringWith(fileName);
                NSString unescapedStr = NSString.stringWith("%#");
                long ptr = OS.CFURLCreateStringByAddingPercentEscapes(0L, fullPath.id, unescapedStr.id, 0L, 0x8000100);
                NSString escapedString = new NSString(ptr);
                NSArray urls = NSArray.arrayWithObject(NSURL.URLWithString(escapedString));
                OS.CFRelease(ptr);
                boolean bl = workspace.openURLs(urls, NSString.stringWith(this.identifier), 0L, null, 0L);
                return bl;
            }
            if (fileName.startsWith(PREFIX_FILE)) {
                fileName = fileName.substring(PREFIX_FILE.length());
            }
            NSString fullPath = NSString.stringWith(fileName);
            boolean bl = workspace.openFile(fullPath, NSString.stringWith(this.name));
            return bl;
        }
        finally {
            pool.release();
        }
    }

    public ImageData getImageData() {
        NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSImage nsImage;
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            NSString fullPath = this.fullPath != null ? NSString.stringWith(this.fullPath) : workspace.fullPathForApplication(NSString.stringWith(this.name));
            if (fullPath != null && (nsImage = workspace.iconForFile(fullPath)) != null) {
                NSSize size = new NSSize();
                size.height = 16.0;
                size.width = 16.0;
                nsImage.setSize(size);
                nsImage.retain();
                Image image = Image.cocoa_new(Display.getCurrent(), 0, nsImage);
                ImageData imageData = image.getImageData();
                image.dispose();
                ImageData imageData2 = imageData;
                return imageData2;
            }
            return null;
        }
        finally {
            pool.release();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

