/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right - left, width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new float[0];
        }
        float[] coordinates = new float[length];
        int i = 0;
        while (i < peaks) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + (float)(width / 2);
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    void computeRuns() {
        if (this.textStorage != null) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        NSString str = NSString.stringWith(segmentsText);
        this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
        this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
        NSSize size = new NSSize();
        size.width = this.wrapWidth != -1 ? (float)this.wrapWidth : Float.MAX_VALUE;
        size.height = 3.4028234663852886E38;
        this.textContainer.initWithContainerSize(size);
        this.textStorage.addLayoutManager(this.layoutManager);
        this.layoutManager.addTextContainer(this.textContainer);
        NSMutableAttributedString attrStr = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        attrStr.id = attrStr.initWithString((NSString)str).id;
        attrStr.beginEditing();
        Font defaultFont = this.font != null ? this.font : this.device.systemFont;
        NSRange range = new NSRange();
        range.length = str.length();
        attrStr.addAttribute(OS.NSFontAttributeName, defaultFont.handle, range);
        defaultFont.addTraits(attrStr, range);
        NSMutableParagraphStyle paragraph = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int align = 0;
        if (this.justify) {
            align = 3;
        } else {
            switch (this.alignment) {
                case 0x1000000: {
                    align = 2;
                    break;
                }
                case 131072: {
                    align = 1;
                }
            }
        }
        paragraph.setAlignment(align);
        paragraph.setLineSpacing(this.spacing);
        paragraph.setFirstLineHeadIndent(this.indent);
        paragraph.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        paragraph.setTabStops(NSArray.array());
        if (this.tabs != null) {
            int count = this.tabs.length;
            int i = 0;
            int pos = 0;
            while (i < count) {
                NSTextTab tab = (NSTextTab)new NSTextTab().alloc();
                tab = tab.initWithType(0L, pos += this.tabs[i]);
                paragraph.addTabStop(tab);
                tab.release();
                ++i;
            }
            int width = count - 2 >= 0 ? this.tabs[count - 1] - this.tabs[count - 2] : this.tabs[count - 1];
            paragraph.setDefaultTabInterval(width);
        }
        attrStr.addAttribute(OS.NSParagraphStyleAttributeName, paragraph, range);
        paragraph.release();
        long textLength = str.length();
        int i = 0;
        while (i < this.styles.length - 1) {
            StyleItem run = this.styles[i];
            if (run.style != null) {
                NSColor color;
                Color background;
                Color foreground;
                TextStyle style = run.style;
                range.location = textLength != 0L ? this.translateOffset(run.start) : 0;
                range.length = (long)this.translateOffset(this.styles[i + 1].start) - range.location;
                Font font = style.font;
                if (font != null) {
                    attrStr.addAttribute(OS.NSFontAttributeName, font.handle, range);
                    font.addTraits(attrStr, range);
                }
                if ((foreground = style.foreground) != null) {
                    NSColor color2 = NSColor.colorWithDeviceRed(foreground.handle[0], foreground.handle[1], foreground.handle[2], 1.0);
                    attrStr.addAttribute(OS.NSForegroundColorAttributeName, color2, range);
                }
                if ((background = style.background) != null) {
                    NSColor color3 = NSColor.colorWithDeviceRed(background.handle[0], background.handle[1], background.handle[2], 1.0);
                    attrStr.addAttribute(OS.NSBackgroundColorAttributeName, color3, range);
                }
                if (style.strikeout) {
                    attrStr.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), range);
                    Color strikeColor = style.strikeoutColor;
                    if (strikeColor != null) {
                        color = NSColor.colorWithDeviceRed(strikeColor.handle[0], strikeColor.handle[1], strikeColor.handle[2], 1.0);
                        attrStr.addAttribute(OS.NSStrikethroughColorAttributeName, color, range);
                    }
                }
                if (this.isUnderlineSupported(style)) {
                    int underlineStyle = 0;
                    switch (style.underlineStyle) {
                        case 0: {
                            underlineStyle = 1;
                            break;
                        }
                        case 1: {
                            underlineStyle = 9;
                            break;
                        }
                        case 65536: {
                            underlineStyle = 2;
                            break;
                        }
                        case 4: {
                            underlineStyle = 1;
                            if (foreground != null) break;
                            color = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0);
                            attrStr.addAttribute(OS.NSForegroundColorAttributeName, color, range);
                        }
                    }
                    if (underlineStyle != 0) {
                        attrStr.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(underlineStyle), range);
                        Color underlineColor = style.underlineColor;
                        if (underlineColor != null) {
                            NSColor color4 = NSColor.colorWithDeviceRed(underlineColor.handle[0], underlineColor.handle[1], underlineColor.handle[2], 1.0);
                            attrStr.addAttribute(OS.NSUnderlineColorAttributeName, color4, range);
                        }
                    }
                }
                if (style.rise != 0) {
                    attrStr.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(style.rise), range);
                }
                GlyphMetrics cfr_ignored_0 = style.metrics;
            }
            ++i;
        }
        attrStr.endEditing();
        this.textStorage.setAttributedString(attrStr);
        attrStr.release();
        this.textContainer.setLineFragmentPadding(0.0);
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        long numberOfGlyphs = this.layoutManager.numberOfGlyphs();
        long rangePtr = OS.malloc(NSRange.sizeof);
        NSRange lineRange = new NSRange();
        int numberOfLines = 0;
        long index = 0L;
        while (index < numberOfGlyphs) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            ++numberOfLines;
        }
        int[] offsets = new int[numberOfLines + 1];
        NSRect[] bounds = new NSRect[numberOfLines];
        numberOfLines = 0;
        index = 0L;
        while (index < numberOfGlyphs) {
            bounds[numberOfLines] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            if (numberOfLines < bounds.length - 1) {
                bounds[numberOfLines].height -= (double)this.spacing;
            }
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            offsets[numberOfLines] = (int)lineRange.location;
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            Font font = this.font != null ? this.font : this.device.systemFont;
            NSFont nsFont = font.handle;
            bounds[0] = new NSRect();
            bounds[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nsFont), (double)(this.ascent + this.descent));
        }
        OS.free(rangePtr);
        offsets[numberOfLines] = (int)this.textStorage.length();
        this.lineOffsets = offsets;
        this.lineBounds = bounds;
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.styles = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = gc.checkGC(3073);
        try {
            boolean hasSelection;
            this.computeRuns();
            int length = this.translateOffset(this.text.length());
            if (length == 0 && flags == 0) {
                return;
            }
            gc.handle.saveGraphicsState();
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            NSRange range = new NSRange();
            long numberOfGlyphs = this.layoutManager.numberOfGlyphs();
            if (numberOfGlyphs > 0L) {
                range.location = 0L;
                range.length = numberOfGlyphs;
                this.layoutManager.drawBackgroundForGlyphRange(range, pt);
            }
            boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            if (hasSelection || (flags & 0x100000) != 0) {
                if (selectionBackground == null) {
                    selectionBackground = this.device.getSystemColor(26);
                }
                NSColor selectionColor = NSColor.colorWithDeviceRed(selectionBackground.handle[0], selectionBackground.handle[1], selectionBackground.handle[2], selectionBackground.handle[3]);
                NSBezierPath path = NSBezierPath.bezierPath();
                NSRect rect = new NSRect();
                if (hasSelection) {
                    long pRectCount = OS.malloc(C.PTR_SIZEOF);
                    range.location = this.translateOffset(selectionStart);
                    range.length = this.translateOffset(selectionEnd - selectionStart + 1);
                    long pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, pRectCount);
                    long[] rectCount = new long[1];
                    OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
                    OS.free(pRectCount);
                    int k = 0;
                    while ((long)k < rectCount[0]) {
                        OS.memmove(rect, pArray, (long)NSRect.sizeof);
                        this.fixRect(rect);
                        rect.x += pt.x;
                        rect.y += pt.y;
                        rect.height = Math.max(rect.height, (double)(this.ascent + this.descent));
                        path.appendBezierPathWithRect(rect);
                        ++k;
                        pArray += (long)NSRect.sizeof;
                    }
                }
                if ((flags & 0x100000) != 0) {
                    NSRect bounds = this.lineBounds[this.lineBounds.length - 1];
                    rect.x = pt.x + bounds.x + bounds.width;
                    rect.y = (double)y + bounds.y;
                    rect.width = (flags & 0x10000) != 0 ? 2.147483647E9 : bounds.height / 3.0;
                    rect.height = Math.max(bounds.height, (double)(this.ascent + this.descent));
                    path.appendBezierPathWithRect(rect);
                }
                selectionColor.setFill();
                path.fill();
            }
            if (numberOfGlyphs > 0L) {
                boolean defaultFg;
                range.location = 0L;
                range.length = numberOfGlyphs;
                double[] fg = gc.data.foreground;
                boolean bl2 = defaultFg = fg[0] == 0.0 && fg[1] == 0.0 && fg[2] == 0.0 && fg[3] == 1.0;
                if (!defaultFg) {
                    int i = 0;
                    while (i < this.styles.length - 1) {
                        StyleItem run = this.styles[i];
                        if (!(run.style != null && run.style.foreground != null || run.style != null && run.style.underline && run.style.underlineStyle == 4)) {
                            range.location = length != 0 ? this.translateOffset(run.start) : 0;
                            range.length = (long)this.translateOffset(this.styles[i + 1].start) - range.location;
                            this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gc.data.fg, range);
                        }
                        ++i;
                    }
                }
                range.location = 0L;
                range.length = numberOfGlyphs;
                this.layoutManager.drawGlyphsForGlyphRange(range, pt);
                if (!defaultFg) {
                    range.location = 0L;
                    range.length = length;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, range);
                }
                NSPoint point = new NSPoint();
                int j = 0;
                while (j < this.styles.length) {
                    StyleItem run = this.styles[j];
                    TextStyle style = run.style;
                    if (style != null) {
                        boolean drawUnderline = style.underline && !this.isUnderlineSupported(style);
                        drawUnderline = drawUnderline && (j + 1 == this.styles.length || !style.isAdherentUnderline(this.styles[j + 1].style));
                        boolean drawBorder = style.borderStyle != 0;
                        boolean bl3 = drawBorder = drawBorder && (j + 1 == this.styles.length || !style.isAdherentBorder(this.styles[j + 1].style));
                        if (drawUnderline || drawBorder) {
                            int end = j + 1 < this.styles.length ? this.translateOffset(this.styles[j + 1].start - 1) : length;
                            int i = 0;
                            while (i < this.lineOffsets.length - 1) {
                                NSRect rect;
                                long[] rectCount;
                                long pArray;
                                int start;
                                int lineStart = this.untranslateOffset(this.lineOffsets[i]);
                                int lineEnd = this.untranslateOffset(this.lineOffsets[i + 1] - 1);
                                if (drawUnderline) {
                                    start = run.start;
                                    int k = j;
                                    while (k > 0 && style.isAdherentUnderline(this.styles[k - 1].style)) {
                                        start = this.styles[k - 1].start;
                                        --k;
                                    }
                                    if ((start = this.translateOffset(start)) <= lineEnd && end >= lineStart) {
                                        range.location = Math.max(lineStart, start);
                                        range.length = (long)(Math.min(lineEnd, end) + 1) - range.location;
                                        if (range.length > 0L) {
                                            long pRectCount = OS.malloc(C.PTR_SIZEOF);
                                            pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, pRectCount);
                                            rectCount = new long[1];
                                            OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
                                            OS.free(pRectCount);
                                            rect = new NSRect();
                                            gc.handle.saveGraphicsState();
                                            double baseline = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, lineStart);
                                            double[] color = null;
                                            if (style.underlineColor != null) {
                                                color = style.underlineColor.handle;
                                            }
                                            if (color == null && style.foreground != null) {
                                                color = style.foreground.handle;
                                            }
                                            if (color != null) {
                                                NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                                            }
                                            int k2 = 0;
                                            while ((long)k2 < rectCount[0]) {
                                                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                                                this.fixRect(rect);
                                                double underlineX = pt.x + rect.x;
                                                double underlineY = pt.y + rect.y + rect.height - baseline + 1.0;
                                                NSBezierPath path = NSBezierPath.bezierPath();
                                                switch (style.underlineStyle) {
                                                    case 2: {
                                                        path.setLineWidth(2.0);
                                                        path.setLineCapStyle(1L);
                                                        path.setLineJoinStyle(1L);
                                                        path.setLineDash(new double[]{1.0, 3.0}, 2L, 0.0);
                                                        point.x = underlineX;
                                                        point.y = underlineY + 0.5;
                                                        path.moveToPoint(point);
                                                        point.x = underlineX + rect.width;
                                                        point.y = underlineY + 0.5;
                                                        path.lineToPoint(point);
                                                        break;
                                                    }
                                                    case 3: {
                                                        gc.handle.setShouldAntialias(false);
                                                        path.setLineWidth(1.0);
                                                        path.setLineCapStyle(0L);
                                                        path.setLineJoinStyle(0L);
                                                        double lineBottom = pt.y + rect.y + rect.height;
                                                        float squigglyThickness = 1.0f;
                                                        float squigglyHeight = 2.0f * squigglyThickness;
                                                        double squigglyY = Math.min(underlineY - (double)(squigglyHeight / 2.0f), lineBottom - (double)squigglyHeight - 1.0);
                                                        float[] points = this.computePolyline((int)underlineX, (int)squigglyY, (int)(underlineX + rect.width), (int)(squigglyY + (double)squigglyHeight));
                                                        point.x = points[0] + 0.5f;
                                                        point.y = points[1] + 0.5f;
                                                        path.moveToPoint(point);
                                                        int p = 2;
                                                        while (p < points.length) {
                                                            point.x = points[p] + 0.5f;
                                                            point.y = points[p + 1] + 0.5f;
                                                            path.lineToPoint(point);
                                                            p += 2;
                                                        }
                                                        break;
                                                    }
                                                }
                                                path.stroke();
                                                ++k2;
                                                pArray += (long)NSRect.sizeof;
                                            }
                                            gc.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                if (drawBorder) {
                                    start = run.start;
                                    int k = j;
                                    while (k > 0 && style.isAdherentBorder(this.styles[k - 1].style)) {
                                        start = this.styles[k - 1].start;
                                        --k;
                                    }
                                    if ((start = this.translateOffset(start)) <= lineEnd && end >= lineStart) {
                                        range.location = Math.max(lineStart, start);
                                        range.length = (long)(Math.min(lineEnd, end) + 1) - range.location;
                                        if (range.length > 0L) {
                                            long pRectCount = OS.malloc(C.PTR_SIZEOF);
                                            pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, pRectCount);
                                            rectCount = new long[1];
                                            OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
                                            OS.free(pRectCount);
                                            rect = new NSRect();
                                            gc.handle.saveGraphicsState();
                                            double[] color = null;
                                            if (style.borderColor != null) {
                                                color = style.borderColor.handle;
                                            }
                                            if (color == null && style.foreground != null) {
                                                color = style.foreground.handle;
                                            }
                                            if (color != null) {
                                                NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                                            }
                                            boolean width = true;
                                            float[] dashes = null;
                                            switch (style.borderStyle) {
                                                case 1: {
                                                    break;
                                                }
                                                case 2: {
                                                    dashes = width ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                                    break;
                                                }
                                                case 4: {
                                                    dashes = width ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                                }
                                            }
                                            double[] lengths = null;
                                            if (dashes != null) {
                                                lengths = new double[dashes.length];
                                                int k3 = 0;
                                                while (k3 < lengths.length) {
                                                    lengths[k3] = !width ? dashes[k3] : dashes[k3] * (float)width;
                                                    ++k3;
                                                }
                                            }
                                            int k4 = 0;
                                            while ((long)k4 < rectCount[0]) {
                                                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                                                this.fixRect(rect);
                                                rect.x += pt.x + 0.5;
                                                rect.y += pt.y + 0.5;
                                                rect.width -= 0.5;
                                                rect.height -= 0.5;
                                                NSBezierPath path = NSBezierPath.bezierPath();
                                                path.setLineDash(lengths, lengths != null ? lengths.length : 0, 0.0);
                                                path.appendBezierPathWithRect(rect);
                                                path.stroke();
                                                ++k4;
                                                pArray += (long)NSRect.sizeof;
                                            }
                                            gc.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    ++j;
                }
            }
            gc.handle.restoreGraphicsState();
        }
        finally {
            gc.uncheckGC(pool);
        }
    }

    void fixRect(NSRect rect) {
        int j = 0;
        while (j < this.lineBounds.length) {
            NSRect line = this.lineBounds[j];
            if (line.y <= rect.y && rect.y < line.y + line.height && rect.x + rect.width > line.x + line.width) {
                rect.width = line.x + line.width - rect.x;
            }
            ++j;
        }
    }

    void freeRuns() {
        if (this.textStorage == null) {
            return;
        }
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        if (this.layoutManager != null) {
            this.layoutManager.release();
        }
        if (this.textContainer != null) {
            this.textContainer.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            NSRect rect = this.layoutManager.usedRectForTextContainer(this.textContainer);
            if (this.wrapWidth != -1) {
                rect.width = this.wrapWidth;
            }
            if (this.text.length() == 0) {
                Font font = this.font != null ? this.font : this.device.systemFont;
                NSFont nsFont = font.handle;
                rect.height = this.layoutManager.defaultLineHeightForFont(nsFont);
            }
            rect.height = Math.max(rect.height, (double)(this.ascent + this.descent)) + (double)this.spacing;
            Rectangle rectangle = new Rectangle(0, 0, (int)Math.ceil(rect.width), (int)Math.ceil(rect.height));
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (length == 0) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                return rectangle;
            }
            if (start > end) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                return rectangle;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            start = this.translateOffset(start);
            end = this.translateOffset(end);
            NSRange range = new NSRange();
            range.location = start;
            range.length = end - start + 1;
            long pRectCount = OS.malloc(C.PTR_SIZEOF);
            long pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, pRectCount);
            long[] rectCount = new long[1];
            OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
            OS.free(pRectCount);
            NSRect rect = new NSRect();
            int left = Integer.MAX_VALUE;
            int right = 0;
            int top = Integer.MAX_VALUE;
            int bottom = 0;
            int i = 0;
            while ((long)i < rectCount[0]) {
                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                this.fixRect(rect);
                left = Math.min(left, (int)rect.x);
                right = Math.max(right, (int)Math.ceil(rect.x + rect.width));
                top = Math.min(top, (int)rect.y);
                bottom = Math.max(bottom, (int)Math.ceil(rect.y + rect.height));
                ++i;
                pArray += (long)NSRect.sizeof;
            }
            Rectangle rectangle = new Rectangle(left, top, right - left, bottom - top);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            offset = this.translateOffset(offset);
            long glyphOffset = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
            NSRange range = new NSRange();
            range.location = glyphOffset;
            range.length = 1L;
            long pBidiLevels = OS.malloc(1L);
            byte[] bidiLevels = new byte[1];
            long result = this.layoutManager.getGlyphsInRange(range, 0L, 0L, 0L, 0L, pBidiLevels);
            if (result > 0L) {
                OS.memmove(bidiLevels, pBidiLevels, 1L);
            }
            OS.free(pBidiLevels);
            byte by = bidiLevels[0];
            return by;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int[] offsets = new int[this.lineOffsets.length];
            int i = 0;
            while (i < offsets.length) {
                offsets[i] = this.untranslateOffset(this.lineOffsets[i]);
                ++i;
            }
            int[] nArray = offsets;
            return nArray;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            offset = this.translateOffset(offset);
            int line = 0;
            while (line < this.lineOffsets.length - 1) {
                if (this.lineOffsets[line + 1] > offset) {
                    int n = line;
                    return n;
                }
                ++line;
            }
            int n = this.lineBounds.length - 1;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            if (lineIndex < 0 || lineIndex >= this.lineBounds.length) {
                SWT.error(6);
            }
            NSRect rect = this.lineBounds[lineIndex];
            int height = Math.max((int)Math.ceil(rect.height), this.ascent + this.descent);
            Rectangle rectangle = new Rectangle((int)rect.x, (int)rect.y, (int)Math.ceil(rect.width), height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getLineCount() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int n = this.lineOffsets.length - 1;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int length;
            this.computeRuns();
            int lineCount = this.getLineCount();
            if (lineIndex < 0 || lineIndex >= lineCount) {
                SWT.error(6);
            }
            if ((length = this.text.length()) == 0) {
                Font font = this.font != null ? this.font : this.device.systemFont;
                NSFont nsFont = font.handle;
                int ascent = (int)(0.5 + nsFont.ascender());
                int descent = (int)(0.5 + (-nsFont.descender() + nsFont.leading()));
                ascent = Math.max(ascent, this.ascent);
                descent = Math.max(descent, this.descent);
                FontMetrics fontMetrics = FontMetrics.cocoa_new(ascent, descent, 0, 0, ascent + descent);
                return fontMetrics;
            }
            Rectangle rect = this.getLineBounds(lineIndex);
            int baseline = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[lineIndex]);
            FontMetrics fontMetrics = FontMetrics.cocoa_new(rect.height - baseline, baseline, 0, 0, rect.height);
            return fontMetrics;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            if (length == 0) {
                Point point = new Point(0, 0);
                return point;
            }
            offset = this.translateOffset(offset);
            long glyphIndex = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
            NSRect rect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(glyphIndex, 0L);
            NSPoint point = this.layoutManager.locationForGlyphAtIndex(glyphIndex);
            if (trailing) {
                NSRange range = new NSRange();
                range.location = offset;
                range.length = 1L;
                long pRectCount = OS.malloc(C.PTR_SIZEOF);
                long pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, pRectCount);
                long[] rectCount = new long[1];
                OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
                OS.free(pRectCount);
                if (rectCount[0] > 0L) {
                    NSRect bounds = new NSRect();
                    OS.memmove(bounds, pArray, (long)NSRect.sizeof);
                    this.fixRect(bounds);
                    point.x += bounds.width;
                }
            }
            Point point2 = new Point((int)point.x, (int)rect.y);
            return point2;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getNextOffset(int offset, int movement) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n = this._getOffset(offset, movement, true);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    int _getOffset(int offset, int movement, boolean forward) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (length == 0) {
            return 0;
        }
        offset = this.translateOffset(offset);
        length = this.translateOffset(length);
        switch (movement) {
            case 1: 
            case 2: {
                boolean invalid = false;
                block6: do {
                    int newOffset = offset;
                    if (forward) {
                        if (newOffset < length) {
                            ++newOffset;
                        }
                    } else if (newOffset > 0) {
                        --newOffset;
                    }
                    if (newOffset == offset) break;
                    offset = newOffset;
                    invalid = false;
                    if (this.invalidOffsets == null) continue;
                    int i = 0;
                    while (i < this.invalidOffsets.length) {
                        if (offset == this.invalidOffsets[i]) {
                            invalid = true;
                            continue block6;
                        }
                        ++i;
                    }
                } while (invalid);
                return this.untranslateOffset(offset);
            }
            case 4: {
                return this.untranslateOffset((int)this.textStorage.nextWordFromIndex(offset, forward));
            }
            case 8: {
                NSRange range = this.textStorage.doubleClickAtIndex(length == offset ? length - 1 : offset);
                return this.untranslateOffset((int)(range.location + range.length));
            }
            case 16: {
                NSRange range = this.textStorage.doubleClickAtIndex(length == offset ? length - 1 : offset);
                return this.untranslateOffset((int)range.location);
            }
        }
        return this.untranslateOffset(offset);
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            if (point == null) {
                SWT.error(4);
            }
            int n = this.getOffset(point.x, point.y, trailing);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int length;
            this.computeRuns();
            if (trailing != null && trailing.length < 1) {
                SWT.error(5);
            }
            if ((length = this.text.length()) == 0) {
                return 0;
            }
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            double[] partialFration = new double[1];
            long glyphIndex = this.layoutManager.glyphIndexForPoint(pt, this.textContainer, partialFration);
            long offset = this.layoutManager.characterIndexForGlyphAtIndex(glyphIndex);
            if (trailing != null) {
                trailing[0] = Math.round((float)partialFration[0]);
            }
            int n = Math.min(this.untranslateOffset((int)offset), length - 1);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int index, int movement) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n = this._getOffset(index, movement, false);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        this.invalidOffsets = new int[nSegments];
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                this.invalidOffsets[segmentCount] = charCount + segmentCount;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.invalidOffsets[segmentCount] = charCount + segmentCount;
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        if (segmentCount != nSegments) {
            int[] tmp = new int[segmentCount];
            System.arraycopy(this.invalidOffsets, 0, tmp, 0, segmentCount);
            this.invalidOffsets = tmp;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle style) {
        if (style != null && style.underline) {
            int uStyle = style.underlineStyle;
            return uStyle == 0 || uStyle == 1 || uStyle == 4 || uStyle == 65536;
        }
        return false;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.alignment = alignment;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.ascent = ascent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.descent = descent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.indent = indent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (justify == this.justify) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.justify = justify;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segments = segments;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.spacing == spacing) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.spacing = spacing;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStyle(TextStyle style, int start, int end) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int modifyStart;
            int length = this.text.length();
            if (length == 0) {
                return;
            }
            if (start > end) {
                return;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            int low = -1;
            int high = this.styles.length;
            while (high - low > 1) {
                int index = (high + low) / 2;
                if (this.styles[index + 1].start > start) {
                    high = index;
                    continue;
                }
                low = index;
            }
            if (high >= 0 && high < this.styles.length) {
                StyleItem item = this.styles[high];
                if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                    return;
                }
            }
            this.freeRuns();
            int modifyEnd = modifyStart = high;
            while (modifyEnd < this.styles.length) {
                if (this.styles[modifyEnd + 1].start > end) break;
                ++modifyEnd;
            }
            if (modifyStart == modifyEnd) {
                int styleStart = this.styles[modifyStart].start;
                int styleEnd = this.styles[modifyEnd + 1].start - 1;
                if (styleStart == start && styleEnd == end) {
                    this.styles[modifyStart].style = style;
                    return;
                }
                if (styleStart != start && styleEnd != end) {
                    StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                    System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                    StyleItem item = new StyleItem();
                    item.start = start;
                    item.style = style;
                    newStyles[modifyStart + 1] = item;
                    item = new StyleItem();
                    item.start = end + 1;
                    item.style = this.styles[modifyStart].style;
                    newStyles[modifyStart + 2] = item;
                    System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                    this.styles = newStyles;
                    return;
                }
            }
            if (start == this.styles[modifyStart].start) {
                --modifyStart;
            }
            if (end == this.styles[modifyEnd + 1].start - 1) {
                ++modifyEnd;
            }
            int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
            StyleItem[] newStyles = new StyleItem[newLength];
            System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
            StyleItem item = new StyleItem();
            item.start = start;
            item.style = style;
            newStyles[modifyStart + 1] = item;
            this.styles[modifyEnd].start = end + 1;
            System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
            this.styles = newStyles;
            return;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.tabs = tabs;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.text = text;
            this.styles = new StyleItem[2];
            this.styles[0] = new StyleItem();
            this.styles[1] = new StyleItem();
            this.styles[this.styles.length - 1].start = text.length();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapWidth = width;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset < this.invalidOffsets[i]) break;
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset == this.invalidOffsets[i]) {
                ++offset;
            } else if (offset < this.invalidOffsets[i]) {
                return offset - i;
            }
            ++i;
        }
        return offset - this.invalidOffsets.length;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

