/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Vector;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String cacheParentPath;
    String[] pluginDirs;
    boolean isXULRunner;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";
    static boolean IsSparc;

    AppFileLocProvider(String string, String string2, String string3, boolean bl) {
        this.mozillaPath = string + SEPARATOR_OS;
        this.profilePath = string2 + SEPARATOR_OS;
        this.cacheParentPath = string3;
        this.isXULRunner = bl;
        if (!Compatibility.fileExists(string2, "")) {
            int[] nArray = new int[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
            if (n != 0) {
                Mozilla.error(n);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
            n = nsILocalFile2.Create(1, 448);
            if (n != 0) {
                Mozilla.error(n);
            }
            nsILocalFile2.Release();
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }
        };
        this.directoryServiceProvider = new XPCOMObject(new int[]{2, 0, 0, 3}){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return AppFileLocProvider.this.getFile(nArray[0], nArray[1], nArray[2]);
            }
        };
        this.directoryServiceProvider2 = new XPCOMObject(new int[]{2, 0, 0, 3, 2}){

            public int method0(int[] nArray) {
                return AppFileLocProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return AppFileLocProvider.this.getFile(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return AppFileLocProvider.this.getFiles(nArray[0], nArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    int getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n2, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(n2, new int[]{this.directoryServiceProvider.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(n2, new int[]{this.directoryServiceProvider2.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(int n, int n2) {
        Object object;
        Object object2;
        int n3;
        int n4 = XPCOM.strlen(n);
        byte[] byArray = new byte[n4];
        XPCOM.memmove(byArray, n, n4);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n5 = 0;
                int n6 = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZ_PLUGIN_PATH", true));
                if (n6 != 0) {
                    n3 = C.strlen(n6);
                    byte[] byArray2 = new byte[n3];
                    C.memmove(byArray2, n6, n3);
                    object2 = new String(MozillaDelegate.mbcsToWcs(null, byArray2));
                    if (((String)object2).length() > 0) {
                        String string2 = System.getProperty("path.separator");
                        object = new Vector();
                        int n7 = -1;
                        do {
                            int n8;
                            String string3;
                            if ((string3 = (n7 = ((String)object2).indexOf(string2, n8 = n7 + 1)) == -1 ? ((String)object2).substring(n8) : ((String)object2).substring(n8, n7)).length() <= 0) continue;
                            ((Vector)object).addElement(string3);
                        } while (n7 != -1);
                        int n9 = ((Vector)object).size();
                        this.pluginDirs = new String[n9 + (IsSparc ? 1 : 2)];
                        for (n5 = 0; n5 < n9; ++n5) {
                            this.pluginDirs[n5] = (String)((Vector)object).elementAt(n5);
                        }
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[IsSparc ? 1 : 2];
                }
                if (!IsSparc) {
                    this.pluginDirs[n5++] = this.mozillaPath + PLUGINS_DIR;
                }
                this.pluginDirs[n5++] = System.getProperty("user.home") + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(n2, new int[]{0}, C.PTR_SIZEOF);
        if (stringArray != null) {
            int[] nArray = new int[1];
            nsISupports[] nsISupportsArray = new nsISupports[stringArray.length];
            n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = new nsEmbedString(stringArray[i]);
                int n10 = XPCOM.NS_NewLocalFile(((nsEmbedString)object2).getAddress(), 1, nArray);
                if (n10 != -2142109695) {
                    if (n10 != 0) {
                        Mozilla.error(n10);
                    }
                    if (nArray[0] == 0) {
                        Mozilla.error(-2147467261);
                    }
                    object = new nsILocalFile(nArray[0]);
                    nArray[0] = 0;
                    n10 = ((nsISupports)object).QueryInterface(Mozilla.IsPre_17 ? nsIFile.NS_IFILE_IID : nsIFile.NS_IFILE_17_IID, nArray);
                    if (n10 != 0) {
                        Mozilla.error(n10);
                    }
                    if (nArray[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    ((nsISupports)object).Release();
                    nsIFile nsIFile2 = new nsIFile(nArray[0]);
                    nsISupportsArray[n3++] = nsIFile2;
                }
                ((nsEmbedString)object2).dispose();
                nArray[0] = 0;
            }
            if (n3 < stringArray.length) {
                nsISupports[] nsISupportsArray2 = new nsISupports[n3];
                System.arraycopy(nsISupportsArray, 0, nsISupportsArray2, 0, n3);
                nsISupportsArray = nsISupportsArray2;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray);
            simpleEnumerator.AddRef();
            XPCOM.memmove(n2, new int[]{simpleEnumerator.getAddress()}, C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(int n, int n2, int n3) {
        int n4 = XPCOM.strlen(n);
        byte[] byArray = new byte[n4];
        XPCOM.memmove(byArray, n, n4);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = this.profilePath + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = this.profilePath + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = this.profilePath + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = this.profilePath + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = this.profilePath + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.cacheParentPath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = this.profilePath + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = this.mozillaPath + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("PrfDef") && this.isXULRunner) {
            string2 = this.profilePath;
        }
        XPCOM.memmove(n2, new boolean[]{true});
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            int[] nArray = new int[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n5 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
            if (n5 != 0) {
                Mozilla.error(n5);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
            nArray[0] = 0;
            n5 = nsILocalFile2.QueryInterface(Mozilla.IsPre_17 ? nsIFile.NS_IFILE_IID : nsIFile.NS_IFILE_17_IID, nArray);
            if (n5 != 0) {
                Mozilla.error(n5);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467262);
            }
            XPCOM.memmove(n3, new int[]{nArray[0]}, C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }
}

