/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    static RTFTransfer _instance = new RTFTransfer();
    static final String TEXT_RTF = "text/rtf";
    static final int TEXT_RTF_ID = RTFTransfer.registerType("text/rtf");
    static final String TEXT_RTF2 = "TEXT/RTF";
    static final int TEXT_RTF2_ID = RTFTransfer.registerType("TEXT/RTF");
    static final String APPLICATION_RTF = "application/rtf";
    static final int APPLICATION_RTF_ID = RTFTransfer.registerType("application/rtf");

    RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] byArray;
        int n;
        transferData.result = 0;
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((n = OS.XtMalloc((byArray = Converter.wcsToMbcs(null, string = (String)object, true)).length)) == 0) {
            return;
        }
        OS.memmove(n, byArray, byArray.length);
        transferData.length = byArray.length - 1;
        transferData.format = 8;
        transferData.pValue = n;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.format * transferData.length / 8;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, transferData.pValue, n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        String string = new String(cArray);
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    protected int[] getTypeIds() {
        return new int[]{TEXT_RTF_ID, TEXT_RTF2_ID, APPLICATION_RTF_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TEXT_RTF, TEXT_RTF2, APPLICATION_RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

