/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public long handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int SKIN_NEEDED = 0x1000000;
    static final int CHECK_SUBWINDOW = 0x2000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int DRAW = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_SET = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int VISIBILITY_NOTIFY_EVENT = 58;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int ICON_RELEASE = 67;
    static final int SELECTION_DONE = 68;
    static final int START_INTERACTIVE_SEARCH = 69;
    static final int BACKSPACE = 70;
    static final int BACKSPACE_INVERSE = 71;
    static final int COPY_CLIPBOARD = 72;
    static final int COPY_CLIPBOARD_INVERSE = 73;
    static final int CUT_CLIPBOARD = 74;
    static final int CUT_CLIPBOARD_INVERSE = 75;
    static final int PASTE_CLIPBOARD = 76;
    static final int PASTE_CLIPBOARD_INVERSE = 77;
    static final int DELETE_FROM_CURSOR = 78;
    static final int DELETE_FROM_CURSOR_INVERSE = 79;
    static final int MOVE_CURSOR = 80;
    static final int MOVE_CURSOR_INVERSE = 81;
    static final int DIRECTION_CHANGED = 82;
    static final int CREATE_MENU_PROXY = 83;
    static final int LAST_SIGNAL = 84;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
        this.reskinWidget();
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    long paintWindow() {
        return 0L;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.style &= 0xFBFFFFFF;
            this.style |= 0x2000000;
        }
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int n) {
    }

    void createWidget(int n) {
        this.createHandle(n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        long l = this.topHandle();
        this.releaseHandle();
        if (l != 0L && (this.state & 8) != 0) {
            OS.gtk_widget_destroy(l);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int n) {
        SWT.error(n);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(KEY_CHECK_SUBWINDOW)) {
            return new Boolean((this.state & 0x2000000) != 0);
        }
        if (string.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!string.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.length();
        while (--n > 0 && string.charAt(n) != '.') {
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    long gtk_activate(long l) {
        return 0L;
    }

    void gtk_adjustment_get(long l, GtkAdjustment gtkAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            gtkAdjustment.lower = OS.gtk_adjustment_get_lower(l);
            gtkAdjustment.upper = OS.gtk_adjustment_get_upper(l);
            gtkAdjustment.page_increment = OS.gtk_adjustment_get_page_increment(l);
            gtkAdjustment.step_increment = OS.gtk_adjustment_get_step_increment(l);
            gtkAdjustment.page_size = OS.gtk_adjustment_get_page_size(l);
            gtkAdjustment.value = OS.gtk_adjustment_get_value(l);
        } else {
            OS.memmove(gtkAdjustment, l);
        }
    }

    double gtk_adjustment_get_step_increment(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_step_increment(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.step_increment;
    }

    double gtk_adjustment_get_page_increment(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_page_increment(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.page_increment;
    }

    double gtk_adjustment_get_lower(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_lower(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.lower;
    }

    double gtk_adjustment_get_upper(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_upper(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.upper;
    }

    double gtk_adjustment_get_page_size(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_page_size(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.page_size;
    }

    double gtk_adjustment_get_value(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_value(l);
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.value;
    }

    void gtk_adjustment_configure(long l, GtkAdjustment gtkAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        } else {
            OS.memmove(l, gtkAdjustment);
            OS.gtk_adjustment_changed(l);
        }
    }

    long gtk_button_press_event(long l, long l2) {
        return 0L;
    }

    long gtk_button_release_event(long l, long l2) {
        return 0L;
    }

    long gtk_changed(long l) {
        return 0L;
    }

    long gtk_change_value(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_clicked(long l) {
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        return 0L;
    }

    long gtk_configure_event(long l, long l2) {
        return 0L;
    }

    long gtk_create_menu_proxy(long l) {
        return 0L;
    }

    long gtk_day_selected(long l) {
        return 0L;
    }

    long gtk_day_selected_double_click(long l) {
        return 0L;
    }

    long gtk_delete_event(long l, long l2) {
        return 0L;
    }

    long gtk_delete_range(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_enter_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_event(long l, long l2) {
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        return 0L;
    }

    long gtk_expand_collapse_cursor_row(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_draw(long l, long l2) {
        return 0L;
    }

    long gtk_expose_event(long l, long l2) {
        return 0L;
    }

    long gtk_focus(long l, long l2) {
        return 0L;
    }

    long gtk_focus_in_event(long l, long l2) {
        return 0L;
    }

    long gtk_focus_out_event(long l, long l2) {
        return 0L;
    }

    long gtk_grab_focus(long l) {
        return 0L;
    }

    long gtk_hide(long l) {
        return 0L;
    }

    long gtk_icon_release(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_input(long l, long l2) {
        return 0L;
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        return this.sendKeyEvent(1, gdkEventKey) ? 0L : 1L;
    }

    long gtk_key_release_event(long l, long l2) {
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        return this.sendKeyEvent(2, gdkEventKey) ? 0L : 1L;
    }

    long gtk_leave_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_map(long l) {
        return 0L;
    }

    long gtk_map_event(long l, long l2) {
        return 0L;
    }

    long gtk_mnemonic_activate(long l, long l2) {
        return 0L;
    }

    long gtk_month_changed(long l) {
        return 0L;
    }

    long gtk_motion_notify_event(long l, long l2) {
        return 0L;
    }

    long gtk_move_focus(long l, long l2) {
        return 0L;
    }

    long gtk_output(long l) {
        return 0L;
    }

    long gtk_populate_popup(long l, long l2) {
        return 0L;
    }

    long gtk_popup_menu(long l) {
        return 0L;
    }

    long gtk_preedit_changed(long l) {
        return 0L;
    }

    long gtk_realize(long l) {
        return 0L;
    }

    long gtk_row_activated(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_row_deleted(long l, long l2) {
        return 0L;
    }

    long gtk_row_inserted(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_scroll_child(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_scroll_event(long l, long l2) {
        return 0L;
    }

    long gtk_select(long l) {
        return 0L;
    }

    long gtk_selection_done(long l) {
        return 0L;
    }

    long gtk_show(long l) {
        return 0L;
    }

    long gtk_show_help(long l, long l2) {
        return 0L;
    }

    long gtk_size_allocate(long l, long l2) {
        return 0L;
    }

    long gtk_status_icon_popup_menu(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_start_interactive_search(long l) {
        return 0L;
    }

    long gtk_style_set(long l, long l2) {
        return 0L;
    }

    long gtk_switch_page(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_test_collapse_row(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_test_expand_row(long l, long l2, long l3) {
        return 0L;
    }

    long gtk_text_buffer_insert_text(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long gtk_timer() {
        return 0L;
    }

    long gtk_toggled(long l, long l2) {
        return 0L;
    }

    long gtk_unmap(long l) {
        return 0L;
    }

    long gtk_unmap_event(long l, long l2) {
        return 0L;
    }

    long gtk_unrealize(long l) {
        return 0L;
    }

    long gtk_value_changed(long l) {
        return 0L;
    }

    long gtk_visibility_notify_event(long l, long l2) {
        return 0L;
    }

    void gtk_widget_get_allocation(long l, GtkAllocation gtkAllocation) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_get_allocation(l, gtkAllocation);
        } else {
            gtkAllocation.x = OS.GTK_WIDGET_X(l);
            gtkAllocation.y = OS.GTK_WIDGET_Y(l);
            gtkAllocation.width = OS.GTK_WIDGET_WIDTH(l);
            gtkAllocation.height = OS.GTK_WIDGET_HEIGHT(l);
        }
    }

    boolean gtk_widget_get_mapped(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            return OS.gtk_widget_get_mapped(l);
        }
        return OS.GTK_WIDGET_MAPPED(l);
    }

    boolean gtk_widget_has_focus(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_has_focus(l);
        }
        return OS.GTK_WIDGET_HAS_FOCUS(l);
    }

    long gtk_window_state_event(long l, long l2) {
        return 0L;
    }

    int fontHeight(long l, long l2) {
        long l3 = OS.gtk_widget_get_pango_context(l2);
        long l4 = OS.pango_context_get_language(l3);
        long l5 = OS.pango_context_get_metrics(l3, l, l4);
        int n = OS.pango_font_metrics_get_ascent(l5);
        int n2 = OS.pango_font_metrics_get_descent(l5);
        OS.pango_font_metrics_unref(l5);
        return OS.PANGO_PIXELS(n + n2);
    }

    long filterProc(long l, long l2, long l3) {
        return 0L;
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    long fixedMapProc(long l) {
        return 0L;
    }

    long fixedSizeAllocateProc(long l, long l2) {
        return OS.Call(Display.oldFixedSizeAllocateProc, l, l2);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[n * 2];
        block4: while (n2 < n) {
            switch (cArray[n2]) {
                case '&': {
                    if (n2 + 1 < n && cArray[n2 + 1] == '&') {
                        cArray2[n3++] = cArray[n2++];
                    } else if (bl) {
                        cArray2[n3++] = 95;
                    }
                    ++n2;
                    continue block4;
                }
                case '_': {
                    if (!bl) break;
                    cArray2[n3++] = 95;
                }
            }
            cArray2[n3++] = cArray[n2++];
        }
        return cArray2;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    long hoverProc(long l) {
        return 0L;
    }

    long menuPositionProc(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    boolean mnemonicHit(long l, char c) {
        if (!this.mnemonicMatch(l, c)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 32L);
        boolean bl = OS.gtk_widget_mnemonic_activate(l, false);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 32L);
        return bl;
    }

    boolean mnemonicMatch(long l, char c) {
        int n;
        int n2 = OS.gdk_keyval_to_lower(OS.gdk_unicode_to_keyval(c));
        return n2 == (n = OS.gdk_keyval_to_lower(OS.gtk_label_get_mnemonic_keyval(l)));
    }

    void modifyStyle(long l, long l2) {
        OS.gtk_widget_modify_style(l, l2);
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void register() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean bl) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.handle = 0L;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        return 0L;
    }

    long rendererGetSizeProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        return 0L;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        return 0L;
    }

    public void reskin(int n) {
        this.checkWidget();
        this.reskinWidget();
        if ((n & 1) != 0) {
            this.reskinChildren(n);
        }
    }

    void reskinChildren(int n) {
    }

    void reskinWidget() {
        if ((this.state & 0x1000000) != 0x1000000) {
            this.state |= 0x1000000;
            this.display.addSkinnableWidget(this);
        }
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, GdkEventKey gdkEventKey) {
        int n2 = gdkEventKey.length;
        if (gdkEventKey.string == 0L || OS.g_utf16_strlen(gdkEventKey.string, n2) <= 1L) {
            Event event = new Event();
            event.time = gdkEventKey.time;
            if (!this.setKeyState(event, gdkEventKey)) {
                return true;
            }
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
            return event.doit;
        }
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, gdkEventKey.string, (long)n2);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        return this.sendIMKeyEvent(n, gdkEventKey, cArray) != null;
    }

    char[] sendIMKeyEvent(int n, GdkEventKey gdkEventKey, char[] cArray) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        if (gdkEventKey == null && (l = OS.gtk_get_current_event()) != 0L) {
            gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: 
                case 9: {
                    n4 = gdkEventKey.state;
                    break;
                }
                default: {
                    gdkEventKey = null;
                }
            }
        }
        if (gdkEventKey == null) {
            object = new int[1];
            OS.gtk_get_current_event_state(object);
            n4 = object[0];
        }
        while (n2 < cArray.length) {
            object = new Event();
            if (gdkEventKey != null && cArray.length <= 1) {
                this.setKeyState((Event)object, gdkEventKey);
            } else {
                this.setInputState((Event)object, n4);
            }
            object.character = cArray[n2];
            this.sendEvent(n, (Event)object);
            if (this.isDisposed()) {
                if (l != 0L) {
                    OS.gdk_event_free(l);
                }
                return null;
            }
            if (object.doit) {
                cArray[n3++] = cArray[n2];
            }
            ++n2;
        }
        if (l != 0L) {
            OS.gdk_event_free(l);
        }
        if (n3 == 0) {
            return null;
        }
        if (n2 != n3) {
            object = new char[n3];
            System.arraycopy(cArray, 0, object, 0, n3);
            return object;
        }
        return cArray;
    }

    void sendSelectionEvent(int n) {
        this.sendSelectionEvent(n, null, false);
    }

    void sendSelectionEvent(int n, Event event, boolean bl) {
        long l;
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((l = OS.gtk_get_current_event()) != 0L) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, l, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    int[] nArray = new int[1];
                    OS.gdk_event_get_state(l, nArray);
                    this.setInputState(event, nArray[0]);
                    break;
                }
            }
            OS.gdk_event_free(l);
        }
        this.sendEvent(n, event, bl);
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(KEY_CHECK_SUBWINDOW)) {
            if (object != null && object instanceof Boolean) {
                this.state = ((Boolean)object).booleanValue() ? (this.state |= 0x2000000) : (this.state &= 0xFDFFFFFF);
            }
            return;
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n = 1; n < objectArray.length && !string.equals(objectArray[n]); n += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setFontDescription(long l, long l2) {
        if (OS.GTK3) {
            OS.gtk_widget_override_font(l, l2);
            long l3 = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_invalidate(l3);
        } else {
            OS.gtk_widget_modify_font(l, l2);
        }
    }

    void setForegroundColor(long l, GdkColor gdkColor) {
        this.setForegroundColor(l, gdkColor, true);
    }

    void setForegroundColor(long l, GdkColor gdkColor, boolean bl) {
        if (OS.GTK3) {
            GdkRGBA gdkRGBA = null;
            if (gdkColor != null) {
                gdkRGBA = new GdkRGBA();
                gdkRGBA.alpha = 1.0;
                gdkRGBA.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
                gdkRGBA.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
                gdkRGBA.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
            }
            OS.gtk_widget_override_color(l, 0, gdkRGBA);
            long l2 = OS.gtk_widget_get_style_context(l);
            OS.gtk_style_context_invalidate(l2);
            return;
        }
        long l3 = OS.gtk_widget_get_modifier_style(l);
        OS.gtk_rc_style_set_fg(l3, 0, gdkColor);
        if (bl) {
            OS.gtk_rc_style_set_fg(l3, 1, gdkColor);
        }
        OS.gtk_rc_style_set_fg(l3, 2, gdkColor);
        int n = OS.gtk_rc_style_get_color_flags(l3, 0);
        n = gdkColor == null ? n & 0xFFFFFFFE : n | 1;
        OS.gtk_rc_style_set_color_flags(l3, 0, n);
        if (bl) {
            n = OS.gtk_rc_style_get_color_flags(l3, 1);
            n = gdkColor == null ? n & 0xFFFFFFFE : n | 1;
            OS.gtk_rc_style_set_color_flags(l3, 1, n);
        }
        n = OS.gtk_rc_style_get_color_flags(l3, 2);
        n = gdkColor == null ? n & 0xFFFFFFFE : n | 1;
        OS.gtk_rc_style_set_color_flags(l3, 2, n);
        OS.gtk_rc_style_set_text(l3, 0, gdkColor);
        if (bl) {
            OS.gtk_rc_style_set_text(l3, 1, gdkColor);
        }
        OS.gtk_rc_style_set_text(l3, 2, gdkColor);
        n = OS.gtk_rc_style_get_color_flags(l3, 0);
        n = gdkColor == null ? n & 0xFFFFFFFB : n | 4;
        OS.gtk_rc_style_set_color_flags(l3, 0, n);
        n = OS.gtk_rc_style_get_color_flags(l3, 2);
        n = gdkColor == null ? n & 0xFFFFFFFB : n | 4;
        OS.gtk_rc_style_set_color_flags(l3, 2, n);
        if (bl) {
            n = OS.gtk_rc_style_get_color_flags(l3, 1);
            n = gdkColor == null ? n & 0xFFFFFFFB : n | 4;
            OS.gtk_rc_style_set_color_flags(l3, 1, n);
        }
        this.modifyStyle(l, l3);
    }

    boolean setInputState(Event event, int n) {
        if ((n & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, GdkEventKey gdkEventKey) {
        if (gdkEventKey.string != 0L && OS.g_utf16_strlen(gdkEventKey.string, gdkEventKey.length) > 1L) {
            return false;
        }
        boolean bl = false;
        event.keyCode = Display.translateKey(gdkEventKey.keyval);
        switch (gdkEventKey.keyval) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    if (OS.gdk_keymap_translate_keyboard_state(OS.gdk_keymap_get_default(), gdkEventKey.hardware_keycode, 0, gdkEventKey.group, nArray, nArray2, nArray3, nArray4)) {
                        event.keyCode = OS.gdk_keyval_to_unicode(nArray[0]);
                    }
                }
                int n = gdkEventKey.keyval;
                if ((gdkEventKey.state & 4) != 0 && 0 <= n && n <= 127) {
                    if (97 <= n && n <= 122) {
                        n -= 32;
                    }
                    if (64 <= n && n <= 95) {
                        n -= 64;
                    }
                    event.character = (char)n;
                    bl = gdkEventKey.keyval == 64 && n == 0;
                    break;
                }
                event.character = (char)OS.gdk_keyval_to_unicode(n);
            }
        }
        this.setLocationState(event, gdkEventKey);
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        return this.setInputState(event, gdkEventKey.state);
    }

    void setLocationState(Event event, GdkEventKey gdkEventKey) {
        switch (gdkEventKey.keyval) {
            case 65505: 
            case 65507: 
            case 65513: {
                event.keyLocation = 16384;
                break;
            }
            case 65506: 
            case 65508: 
            case 65514: {
                event.keyLocation = 131072;
                break;
            }
            case 65407: 
            case 65421: 
            case 65429: 
            case 65430: 
            case 65431: 
            case 65432: 
            case 65433: 
            case 65434: 
            case 65435: 
            case 65436: 
            case 65438: 
            case 65439: 
            case 65450: 
            case 65451: 
            case 65453: 
            case 65454: 
            case 65455: 
            case 65456: 
            case 65457: 
            case 65458: 
            case 65459: 
            case 65460: 
            case 65461: 
            case 65462: 
            case 65463: 
            case 65464: 
            case 65465: 
            case 65469: {
                event.keyLocation = 2;
            }
        }
    }

    void setOrientation(boolean bl) {
    }

    boolean setTabGroupFocus(boolean bl) {
        return this.setTabItemFocus(bl);
    }

    boolean setTabItemFocus(boolean bl) {
        return false;
    }

    long shellMapProc(long l, long l2, long l3) {
        return 0L;
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        return 0L;
    }

    long sizeRequestProc(long l, long l2, long l3) {
        return 0L;
    }

    long g_object_ref_sink(long l) {
        if (OS.GLIB_VERSION >= OS.VERSION(2, 10, 0)) {
            return OS.g_object_ref_sink(l);
        }
        OS.gtk_object_sink(l);
        return 0L;
    }

    boolean gtk_widget_get_sensitive(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_sensitive(l);
        }
        return OS.GTK_WIDGET_SENSITIVE(l);
    }

    boolean gtk_widget_get_visible(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_visible(l);
        }
        return (OS.GTK_WIDGET_FLAGS(l) & 0x100) != 0;
    }

    boolean gtk_widget_get_realized(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            return OS.gtk_widget_get_realized(l);
        }
        return (OS.GTK_WIDGET_FLAGS(l) & 0x40) != 0;
    }

    boolean gtk_widget_get_can_default(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_can_default(l);
        }
        return (OS.GTK_WIDGET_FLAGS(l) & 0x2000) != 0;
    }

    boolean gtk_widget_get_has_window(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_has_window(l);
        }
        return (OS.GTK_WIDGET_FLAGS(l) & 0x20) == 0;
    }

    long gtk_widget_get_window(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return OS.gtk_widget_get_window(l);
        }
        return OS.GTK_WIDGET_WINDOW(l);
    }

    void gtk_widget_set_can_default(long l, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_can_default(l, bl);
        } else if (bl) {
            OS.GTK_WIDGET_SET_FLAGS(l, 8192);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(l, 8192);
        }
    }

    void gtk_widget_set_can_focus(long l, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_can_focus(l, bl);
        } else if (bl) {
            OS.GTK_WIDGET_SET_FLAGS(l, 2048);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(l, 2048);
        }
    }

    void gtk_widget_set_mapped(long l, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            OS.gtk_widget_set_mapped(l, bl);
        } else if (bl) {
            OS.GTK_WIDGET_SET_FLAGS(l, 128);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(l, 128);
        }
    }

    void gtk_widget_set_visible(long l, boolean bl) {
        if (OS.GTK3) {
            OS.gtk_widget_set_visible(l, bl);
        } else if (bl) {
            OS.GTK_WIDGET_SET_FLAGS(l, 256);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(l, 256);
        }
    }

    void gtk_widget_set_receives_default(long l, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_receives_default(l, bl);
        } else if (bl) {
            OS.GTK_WIDGET_SET_FLAGS(l, 0x100000);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(l, 0x100000);
        }
    }

    void gdk_pixmap_get_size(long l, int[] nArray, int[] nArray2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(l, nArray, nArray2);
        } else {
            OS.gdk_drawable_get_size(l, nArray, nArray2);
        }
    }

    void gdk_window_get_size(long l, int[] nArray, int[] nArray2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            nArray[0] = OS.gdk_window_get_width(l);
            nArray2[0] = OS.gdk_window_get_height(l);
        } else {
            OS.gdk_drawable_get_size(l, nArray, nArray2);
        }
    }

    long gtk_box_new(int n, boolean bl, int n2) {
        long l = 0L;
        if (OS.GTK3) {
            l = OS.gtk_box_new(n, n2);
            OS.gtk_box_set_homogeneous(l, bl);
        } else {
            l = n == 0 ? OS.gtk_hbox_new(bl, n2) : OS.gtk_vbox_new(bl, n2);
        }
        return l;
    }

    int gdk_pointer_grab(long l, int n, boolean bl, int n2, long l2, long l3, int n3) {
        if (OS.GTK3) {
            long l4 = 0L;
            if (l != 0L) {
                l4 = OS.gdk_window_get_display(l);
            } else {
                l = OS.gdk_get_default_root_window();
                l4 = OS.gdk_window_get_display(l);
            }
            long l5 = OS.gdk_display_get_device_manager(l4);
            long l6 = OS.gdk_device_manager_get_client_pointer(l5);
            return OS.gdk_device_grab(l6, l, n, bl, n2, l3, n3);
        }
        return OS.gdk_pointer_grab(l, bl, n2, l2, l3, n3);
    }

    void gdk_pointer_ungrab(long l, int n) {
        if (OS.GTK3) {
            long l2 = OS.gdk_window_get_display(l);
            long l3 = OS.gdk_display_get_device_manager(l2);
            long l4 = OS.gdk_device_manager_get_client_pointer(l3);
            OS.gdk_device_ungrab(l4, n);
        } else {
            OS.gdk_pointer_ungrab(n);
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    long topHandle() {
        return this.handle;
    }

    long timerProc(long l) {
        return 0L;
    }

    boolean translateTraversal(int n) {
        return false;
    }

    long windowProc(long l, long l2) {
        switch ((int)l2) {
            case 1: {
                return this.gtk_activate(l);
            }
            case 6: {
                return this.gtk_changed(l);
            }
            case 8: {
                return this.gtk_clicked(l);
            }
            case 83: {
                return this.gtk_create_menu_proxy(l);
            }
            case 61: {
                return this.gtk_day_selected(l);
            }
            case 66: {
                return this.gtk_day_selected_double_click(l);
            }
            case 24: {
                return this.gtk_hide(l);
            }
            case 23: {
                return this.gtk_grab_focus(l);
            }
            case 30: {
                return this.gtk_map(l);
            }
            case 62: {
                return this.gtk_month_changed(l);
            }
            case 36: {
                return this.gtk_output(l);
            }
            case 38: {
                return this.gtk_popup_menu(l);
            }
            case 39: {
                return this.gtk_preedit_changed(l);
            }
            case 40: {
                return this.gtk_realize(l);
            }
            case 69: {
                return this.gtk_start_interactive_search(l);
            }
            case 44: {
                return this.gtk_select(l);
            }
            case 68: {
                return this.gtk_selection_done(l);
            }
            case 45: {
                return this.gtk_show(l);
            }
            case 57: {
                return this.gtk_value_changed(l);
            }
            case 54: {
                return this.gtk_unmap(l);
            }
            case 56: {
                return this.gtk_unrealize(l);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 19: {
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
                long l4 = this.paintWindow();
                long l5 = gdkEventExpose.window;
                if (l5 != l4) {
                    return 0L;
                }
                return (this.state & 0x40) != 0 ? 1L : 0L;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1L;
            }
            case 2: {
                return this.gtk_button_press_event(l, l2);
            }
            case 4: {
                return this.gtk_button_release_event(l, l2);
            }
            case 9: {
                return this.gtk_commit(l, l2);
            }
            case 10: {
                return this.gtk_configure_event(l, l2);
            }
            case 11: {
                return this.gtk_delete_event(l, l2);
            }
            case 14: {
                return this.gtk_enter_notify_event(l, l2);
            }
            case 15: {
                return this.gtk_event(l, l2);
            }
            case 16: {
                return this.gtk_event_after(l, l2);
            }
            case 18: {
                if (OS.GTK3) {
                    return this.gtk_draw(l, l2);
                }
                return this.gtk_expose_event(l, l2);
            }
            case 20: {
                return this.gtk_focus(l, l2);
            }
            case 21: {
                return this.gtk_focus_in_event(l, l2);
            }
            case 22: {
                return this.gtk_focus_out_event(l, l2);
            }
            case 27: {
                return this.gtk_key_press_event(l, l2);
            }
            case 28: {
                return this.gtk_key_release_event(l, l2);
            }
            case 25: {
                return this.gtk_input(l, l2);
            }
            case 29: {
                return this.gtk_leave_notify_event(l, l2);
            }
            case 31: {
                return this.gtk_map_event(l, l2);
            }
            case 32: {
                return this.gtk_mnemonic_activate(l, l2);
            }
            case 33: {
                return this.gtk_motion_notify_event(l, l2);
            }
            case 35: {
                return this.gtk_move_focus(l, l2);
            }
            case 37: {
                return this.gtk_populate_popup(l, l2);
            }
            case 43: {
                return this.gtk_scroll_event(l, l2);
            }
            case 46: {
                return this.gtk_show_help(l, l2);
            }
            case 47: {
                return this.gtk_size_allocate(l, l2);
            }
            case 48: {
                return this.gtk_style_set(l, l2);
            }
            case 53: {
                return this.gtk_toggled(l, l2);
            }
            case 55: {
                return this.gtk_unmap_event(l, l2);
            }
            case 58: {
                return this.gtk_visibility_notify_event(l, l2);
            }
            case 59: {
                return this.gtk_window_state_event(l, l2);
            }
            case 65: {
                return this.gtk_row_deleted(l, l2);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3, long l4) {
        switch ((int)l4) {
            case 12: {
                return this.gtk_delete_range(l, l2, l3);
            }
            case 13: {
                return this.gtk_delete_text(l, l2, l3);
            }
            case 67: {
                return this.gtk_icon_release(l, l2, l3);
            }
            case 41: {
                return this.gtk_row_activated(l, l2, l3);
            }
            case 42: {
                return this.gtk_scroll_child(l, l2, l3);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(l, l2, l3);
            }
            case 49: {
                return this.gtk_switch_page(l, l2, l3);
            }
            case 50: {
                return this.gtk_test_collapse_row(l, l2, l3);
            }
            case 51: {
                return this.gtk_test_expand_row(l, l2, l3);
            }
            case 64: {
                return this.gtk_row_inserted(l, l2, l3);
            }
        }
        return 0L;
    }

    long windowProc(long l, long l2, long l3, long l4, long l5) {
        switch ((int)l5) {
            case 7: {
                return this.gtk_change_value(l, l2, l3, l4);
            }
            case 17: {
                return this.gtk_expand_collapse_cursor_row(l, l2, l3, l4);
            }
            case 26: {
                return this.gtk_insert_text(l, l2, l3, l4);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(l, l2, l3, l4);
            }
        }
        return 0L;
    }

    void gdk_cursor_unref(long l) {
        if (OS.GTK3) {
            OS.g_object_unref(l);
        } else {
            OS.gdk_cursor_unref(l);
        }
    }

    long gdk_window_get_device_position(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        if (OS.GTK3) {
            long l2 = 0L;
            if (l != 0L) {
                l2 = OS.gdk_window_get_display(l);
            } else {
                l = OS.gdk_get_default_root_window();
                l2 = OS.gdk_window_get_display(l);
            }
            long l3 = OS.gdk_display_get_device_manager(l2);
            long l4 = OS.gdk_device_manager_get_client_pointer(l3);
            return OS.gdk_window_get_device_position(l, l4, nArray, nArray2, nArray3);
        }
        return OS.gdk_window_get_pointer(l, nArray, nArray2, nArray3);
    }

    void gtk_cell_renderer_get_preferred_size(long l, long l2, int[] nArray, int[] nArray2) {
        if (OS.GTK3) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_cell_renderer_get_preferred_size(l, l2, gtkRequisition, null);
            if (nArray != null) {
                nArray[0] = gtkRequisition.width;
            }
            if (nArray2 != null) {
                nArray2[0] = gtkRequisition.height;
            }
        } else {
            OS.gtk_cell_renderer_get_size(l, l2, null, null, null, nArray, nArray2);
        }
    }

    void gtk_widget_get_preferred_size(long l, GtkRequisition gtkRequisition) {
        if (OS.GTK3) {
            OS.gtk_widget_get_preferred_size(l, gtkRequisition, null);
        } else {
            OS.gtk_widget_size_request(l, gtkRequisition);
        }
    }
}

