/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableTreeItem
extends Item {
    TableItem tableItem;
    TableTree parent;
    TableTreeItem parentItem;
    TableTreeItem[] items = TableTree.EMPTY_ITEMS;
    String[] texts = TableTree.EMPTY_TEXTS;
    Image[] images = TableTree.EMPTY_IMAGES;
    Color background;
    Color foreground;
    Font font;
    boolean expanded;
    boolean checked;
    boolean grayed;

    public TableTreeItem(TableTree tableTree, int n) {
        this(tableTree, n, tableTree.getItemCount());
    }

    public TableTreeItem(TableTree tableTree, int n, int n2) {
        this(tableTree, null, n, n2);
    }

    public TableTreeItem(TableTreeItem tableTreeItem, int n) {
        this(tableTreeItem, n, tableTreeItem.getItemCount());
    }

    public TableTreeItem(TableTreeItem tableTreeItem, int n, int n2) {
        this(tableTreeItem.getParent(), tableTreeItem, n, n2);
    }

    TableTreeItem(TableTree tableTree, TableTreeItem tableTreeItem, int n, int n2) {
        super(tableTree, n);
        this.parent = tableTree;
        this.parentItem = tableTreeItem;
        if (tableTreeItem == null) {
            int n3 = tableTree.addItem(this, n2);
            this.tableItem = new TableItem(tableTree.getTable(), n, n3);
            this.tableItem.setData("TableTreeItemID", this);
            this.addCheck();
            if (tableTree.sizeImage == null) {
                int n4 = tableTree.getItemHeight();
                tableTree.sizeImage = new Image((Device)tableTree.getDisplay(), n4, n4);
                GC gC = new GC(tableTree.sizeImage);
                gC.setBackground(tableTree.getBackground());
                gC.fillRectangle(0, 0, n4, n4);
                gC.dispose();
                this.tableItem.setImage(0, tableTree.sizeImage);
            }
        } else {
            tableTreeItem.addItem(this, n2);
        }
    }

    void addCheck() {
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        this.tableItem.setChecked(this.checked);
        this.tableItem.setGrayed(this.grayed);
    }

    void addItem(TableTreeItem tableTreeItem, int n) {
        Object object;
        if (tableTreeItem == null) {
            SWT.error(4);
        }
        if (n < 0 || n > this.items.length) {
            SWT.error(5);
        }
        if (this.items.length == 0 && n == 0 && this.tableItem != null) {
            object = this.expanded ? this.parent.getMinusImage() : this.parent.getPlusImage();
            this.tableItem.setImage(0, (Image)object);
        }
        object = new TableTreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, object, 0, n);
        object[n] = tableTreeItem;
        System.arraycopy(this.items, n, object, n + 1, this.items.length - n);
        this.items = object;
        if (this.expanded) {
            tableTreeItem.setVisible(true);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background == null ? this.parent.getBackground() : this.background;
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (this.tableItem != null) {
            return this.tableItem.getBounds(n);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (this.tableItem == null) {
            return this.checked;
        }
        return this.tableItem.getChecked();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (this.tableItem == null) {
            return this.grayed;
        }
        return this.tableItem.getGrayed();
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == null ? this.parent.getFont() : this.font;
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground == null ? this.parent.getForeground() : this.foreground;
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int n) {
        if (0 < n && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    int getIndent() {
        if (this.parentItem == null) {
            return 0;
        }
        return this.parentItem.getIndent() + 1;
    }

    public TableTreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.items.length;
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        return this.items.length;
    }

    public TableTreeItem[] getItems() {
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, this.items.length);
        return tableTreeItemArray;
    }

    TableTreeItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        if (this.tableItem == tableItem) {
            return this;
        }
        for (int i = 0; i < this.items.length; ++i) {
            TableTreeItem tableTreeItem = this.items[i].getItem(tableItem);
            if (tableTreeItem == null) continue;
            return tableTreeItem;
        }
        return null;
    }

    public TableTree getParent() {
        return this.parent;
    }

    public TableTreeItem getParentItem() {
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int n) {
        if (0 <= n && n < this.texts.length) {
            return this.texts[n];
        }
        return null;
    }

    boolean getVisible() {
        return this.tableItem != null;
    }

    public int indexOf(TableTreeItem tableTreeItem) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != tableTreeItem) continue;
            return i;
        }
        return -1;
    }

    void expandAll(boolean bl) {
        if (this.items.length == 0) {
            return;
        }
        if (!this.expanded) {
            this.setExpanded(true);
            if (bl) {
                Event event = new Event();
                event.item = this;
                this.parent.notifyListeners(17, event);
            }
        }
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].expandAll(bl);
        }
    }

    int expandedIndexOf(TableTreeItem tableTreeItem) {
        int n = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == tableTreeItem) {
                return n;
            }
            if (this.items[i].expanded) {
                n += this.items[i].visibleChildrenCount();
            }
            ++n;
        }
        return -1;
    }

    int visibleChildrenCount() {
        int n = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].getVisible()) continue;
            n += 1 + this.items[i].visibleChildrenCount();
        }
        return n;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        for (int i = this.items.length - 1; i >= 0; --i) {
            this.items[i].dispose();
        }
        super.dispose();
        if (!this.parent.inDispose) {
            if (this.parentItem != null) {
                this.parentItem.removeItem(this);
            } else {
                this.parent.removeItem(this);
            }
            if (this.tableItem != null) {
                this.tableItem.dispose();
            }
        }
        this.items = null;
        this.parentItem = null;
        this.parent = null;
        this.images = null;
        this.texts = null;
        this.tableItem = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
    }

    void removeItem(TableTreeItem tableTreeItem) {
        int n;
        for (n = 0; n < this.items.length && this.items[n] != tableTreeItem; ++n) {
        }
        if (n == this.items.length) {
            return;
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n);
        System.arraycopy(this.items, n + 1, tableTreeItemArray, n, this.items.length - n - 1);
        this.items = tableTreeItemArray;
        if (this.items.length == 0 && this.tableItem != null) {
            this.tableItem.setImage(0, null);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setBackground(color);
        }
        this.background = color;
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.tableItem != null) {
            this.tableItem.setChecked(bl);
        }
        this.checked = bl;
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        Table table = this.parent.getTable();
        if ((table.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.tableItem != null) {
            this.tableItem.setGrayed(bl);
        }
        this.grayed = bl;
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        if (this.expanded == bl) {
            return;
        }
        this.expanded = bl;
        if (this.tableItem == null) {
            return;
        }
        this.parent.setRedraw(false);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setVisible(bl);
        }
        Image image = bl ? this.parent.getMinusImage() : this.parent.getPlusImage();
        this.tableItem.setImage(0, image);
        this.parent.setRedraw(true);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setFont(font);
        }
        this.font = font;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.tableItem != null) {
            this.tableItem.setForeground(color);
        }
        this.foreground = color;
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        int n2 = Math.max(this.parent.getTable().getColumnCount(), 1);
        if (n <= 0 || n >= n2) {
            return;
        }
        if (this.images.length < n2) {
            Image[] imageArray = new Image[n2];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n] = image;
        if (this.tableItem != null) {
            this.tableItem.setImage(n, image);
        }
    }

    public void setImage(Image image) {
        this.setImage(0, image);
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n2 = Math.max(this.parent.getTable().getColumnCount(), 1);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.texts.length < n2) {
            String[] stringArray = new String[n2];
            System.arraycopy(this.texts, 0, stringArray, 0, this.texts.length);
            this.texts = stringArray;
        }
        this.texts[n] = string;
        if (this.tableItem != null) {
            this.tableItem.setText(n, string);
        }
    }

    public void setText(String string) {
        this.setText(0, string);
    }

    void setVisible(boolean bl) {
        if (this.parentItem == null) {
            return;
        }
        if (this.getVisible() == bl) {
            return;
        }
        if (bl) {
            int n;
            if (!this.parentItem.getVisible()) {
                return;
            }
            Table table = this.parent.getTable();
            int n2 = table.indexOf(this.parentItem.tableItem);
            int n3 = this.parentItem.expandedIndexOf(this) + n2 + 1;
            if (n3 < 0) {
                return;
            }
            this.tableItem = new TableItem(table, this.getStyle(), n3);
            this.tableItem.setData("TableTreeItemID", this);
            this.tableItem.setImageIndent(this.getIndent());
            if (this.background != null) {
                this.tableItem.setBackground(this.background);
            }
            if (this.foreground != null) {
                this.tableItem.setForeground(this.foreground);
            }
            if (this.font != null) {
                this.tableItem.setFont(this.font);
            }
            this.addCheck();
            int n4 = Math.max(table.getColumnCount(), 1);
            for (n = 0; n < n4; ++n) {
                if (n < this.texts.length && this.texts[n] != null) {
                    this.setText(n, this.texts[n]);
                }
                if (n >= this.images.length || this.images[n] == null) continue;
                this.setImage(n, this.images[n]);
            }
            if (this.items.length != 0) {
                if (this.expanded) {
                    this.tableItem.setImage(0, this.parent.getMinusImage());
                    int n5 = this.items.length;
                    for (n = 0; n < n5; ++n) {
                        this.items[n].setVisible(true);
                    }
                } else {
                    this.tableItem.setImage(0, this.parent.getPlusImage());
                }
            }
        } else {
            int n = this.items.length;
            for (int i = 0; i < n; ++i) {
                this.items[i].setVisible(false);
            }
            this.tableItem.dispose();
            this.tableItem = null;
        }
    }
}

