/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;
    static final int DEFAULT_WIDTH = 1;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget(0);
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int n = this.parent.paintWindow();
        if (OS.USE_CAIRO) {
            int n2 = OS.gdk_cairo_create(n);
            if (n2 == 0) {
                this.error(2);
            }
            Cairo.cairo_set_source_rgb(n2, 1.0, 1.0, 1.0);
            Cairo.cairo_set_operator(n2, 23);
            if (this.image != null && !this.image.isDisposed() && this.image.mask == 0) {
                int n3 = Cairo.cairo_get_target(n2);
                int n4 = 0;
                switch (Cairo.cairo_surface_get_type(n3)) {
                    case 0: {
                        n4 = Cairo.cairo_image_surface_get_width(n3);
                        break;
                    }
                    case 3: {
                        n4 = Cairo.cairo_xlib_surface_get_width(n3);
                    }
                }
                int n5 = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    n5 = this.parent.getClientWidth() - n4 - n5;
                }
                Cairo.cairo_translate(n2, n5, this.y);
                Cairo.cairo_set_source_surface(n2, this.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(n2);
            } else {
                int n6 = this.width;
                int n7 = this.height;
                if (n6 <= 0) {
                    n6 = 1;
                }
                int n8 = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    n8 = this.parent.getClientWidth() - n6 - n8;
                }
                Cairo.cairo_rectangle(n2, n8, this.y, n6, n7);
            }
            Cairo.cairo_fill(n2);
            Cairo.cairo_destroy(n2);
            return true;
        }
        int n9 = OS.gdk_gc_new(n);
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        int n10 = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(n10, gdkColor, true, true);
        OS.gdk_gc_set_foreground(n9, gdkColor);
        OS.gdk_gc_set_function(n9, 2);
        if (this.image != null && !this.image.isDisposed() && this.image.mask == 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gdk_pixmap_get_size(this.image.pixmap, nArray, nArray2);
            int n11 = this.x;
            if ((this.parent.style & 0x8000000) != 0) {
                n11 = this.parent.getClientWidth() - nArray[0] - n11;
            }
            OS.gdk_draw_drawable(n, n9, this.image.pixmap, 0, 0, n11, this.y, nArray[0], nArray2[0]);
        } else {
            int n12 = this.width;
            int n13 = this.height;
            if (n12 <= 0) {
                n12 = 1;
            }
            int n14 = this.x;
            if ((this.parent.style & 0x8000000) != 0) {
                n14 = this.parent.getClientWidth() - n12 - n14;
            }
            OS.gdk_draw_rectangle(n, n9, 1, n14, this.y, n12, n13);
        }
        OS.g_object_unref(n9);
        OS.gdk_colormap_free_colors(n10, gdkColor, 1);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Rectangle(this.x, this.y, 1, this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Point(1, this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        boolean bl = this.isFocusCaret();
        if (bl && this.isVisible) {
            this.hideCaret();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.parent.updateCaret();
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean bl;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((bl = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

