/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    int webView;
    int webViewData;
    int scrolledWindow;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    String postData;
    String[] headers;
    boolean ignoreDispose;
    boolean loadingText;
    boolean untrustedText;
    byte[] htmlBytes;
    BrowserFunction eventFunction;
    static int DisabledJSCount;
    static int ExternalClass;
    static int PostString;
    static int WebViewType;
    static boolean IsWebKit14orNewer;
    static boolean LibraryLoaded;
    static Hashtable WindowMappings;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_CONTENTTYPE = "content-type";
    static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final int SENTINEL_KEYPRESS = -1;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int HOVERING_OVER_LINK = 1;
    static final int NOTIFY_PROGRESS = 2;
    static final int NAVIGATION_POLICY_DECISION_REQUESTED = 3;
    static final int NOTIFY_TITLE = 4;
    static final int POPULATE_POPUP = 5;
    static final int STATUS_BAR_TEXT_CHANGED = 6;
    static final int CREATE_WEB_VIEW = 7;
    static final int WEB_VIEW_READY = 8;
    static final int NOTIFY_LOAD_STATUS = 9;
    static final int RESOURCE_REQUEST_STARTING = 10;
    static final int DOWNLOAD_REQUESTED = 11;
    static final int MIME_TYPE_POLICY_DECISION_REQUESTED = 12;
    static final int CLOSE_WEB_VIEW = 13;
    static final int WINDOW_OBJECT_CLEARED = 14;
    static final int CONSOLE_MESSAGE = 15;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback Proc6;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static Callback JSDOMEventProc;
    static /* synthetic */ Class class$org$eclipse$swt$browser$WebKit;

    WebKit() {
    }

    static Browser FindBrowser(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = OS.gtk_widget_get_parent(n);
        n2 = OS.gtk_widget_get_parent(n2);
        return (Browser)Display.getCurrent().findWidget(n2);
    }

    static boolean IsInstalled() {
        if (!LibraryLoaded) {
            return false;
        }
        int n = WebKitGTK.webkit_major_version();
        int n2 = WebKitGTK.webkit_minor_version();
        int n3 = WebKitGTK.webkit_micro_version();
        IsWebKit14orNewer = n > 1 || n == 1 && n2 > 4 || n == 1 && n2 == 4 && n3 >= 0;
        return n > MIN_VERSION[0] || n == MIN_VERSION[0] && n2 > MIN_VERSION[1] || n == MIN_VERSION[0] && n2 == MIN_VERSION[1] && n3 >= MIN_VERSION[2];
    }

    static int JSObjectCallAsFunctionProc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (WebKitGTK.JSValueIsObjectOfClass(n, n3, ExternalClass) == 0) {
            return WebKitGTK.JSValueMakeUndefined(n);
        }
        int n7 = WebKitGTK.JSObjectGetPrivate(n3);
        int[] nArray = new int[1];
        C.memmove(nArray, n7, C.PTR_SIZEOF);
        Browser browser = WebKit.FindBrowser(nArray[0]);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(n, n2, n3, n4, n5, n6);
    }

    static int JSObjectGetPropertyProc(int n, int n2, int n3, int n4) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        int n5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        int n6 = WebKitGTK.JSObjectMakeFunctionWithCallback(n, n5, JSObjectCallAsFunctionProc.getAddress());
        WebKitGTK.JSStringRelease(n5);
        return n6;
    }

    static int JSObjectHasPropertyProc(int n, int n2, int n3) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, FUNCTIONNAME_CALLJAVA, true);
        }
        return WebKitGTK.JSStringIsEqualToUTF8CString(n3, byArray);
    }

    static int JSDOMEventProc(int n, int n2, int n3) {
        block14: {
            block15: {
                Browser browser;
                block16: {
                    if (OS.GTK_IS_SCROLLED_WINDOW(n)) {
                        return n3;
                    }
                    if (!OS.G_TYPE_CHECK_INSTANCE_TYPE(n, WebViewType)) break block14;
                    if (DisabledJSCount <= 0 || (browser = WebKit.FindBrowser(n)) == null || browser.webBrowser.jsEnabled) break block15;
                    block0 : switch (OS.GDK_EVENT_TYPE(n2)) {
                        case 8: {
                            if (!browser.isFocusControl()) break;
                            final GdkEventKey gdkEventKey = new GdkEventKey();
                            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
                            switch (gdkEventKey.keyval) {
                                case 65056: 
                                case 65289: {
                                    if ((gdkEventKey.state & 0xC) == 0) {
                                        browser.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                if (browser.isDisposed()) {
                                                    return;
                                                }
                                                if (browser.getDisplay().getFocusControl() == null) {
                                                    int n = (gdkEventKey.state & 1) != 0 ? 8 : 16;
                                                    browser.traverse(n);
                                                }
                                            }
                                        });
                                        break block0;
                                    }
                                    break block16;
                                }
                                case 65307: {
                                    Event event = new Event();
                                    event.widget = browser;
                                    event.type = 1;
                                    event.character = (char)27;
                                    event.keyCode = 27;
                                    if ((gdkEventKey.state & 8) != 0) {
                                        event.stateMask |= 0x10000;
                                    }
                                    if ((gdkEventKey.state & 1) != 0) {
                                        event.stateMask |= 0x20000;
                                    }
                                    if ((gdkEventKey.state & 4) != 0) {
                                        event.stateMask |= 0x40000;
                                    }
                                    browser.webBrowser.sendKeyEvent(event);
                                    return 1;
                                }
                            }
                        }
                    }
                }
                OS.gtk_widget_event(browser.handle, n2);
            }
            return 0;
        }
        LONG lONG = (LONG)WindowMappings.get(new LONG(n));
        if (lONG == null) {
            return 0;
        }
        Browser browser = WebKit.FindBrowser(lONG.value);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.handleDOMEvent(n2, n3) ? 0 : 1;
    }

    static int Proc(int n, int n2) {
        Browser browser = WebKit.FindBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2);
    }

    static int Proc(int n, int n2, int n3) {
        int n4 = OS.G_TYPE_CHECK_INSTANCE_TYPE(n, WebKitGTK.webkit_web_frame_get_type()) ? WebKitGTK.webkit_web_frame_get_web_view(n) : n;
        Browser browser = WebKit.FindBrowser(n4);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (n4 == n) {
            return webKit.webViewProc(n, n2, n3);
        }
        return webKit.webFrameProc(n, n2, n3);
    }

    static int Proc(int n, int n2, int n3, int n4) {
        Browser browser = WebKit.FindBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2, n3, n4);
    }

    static int Proc(int n, int n2, int n3, int n4, int n5) {
        int n6 = OS.G_TYPE_CHECK_INSTANCE_TYPE(n, WebKitGTK.soup_session_get_type()) ? n5 : n;
        Browser browser = WebKit.FindBrowser(n6);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        if (n6 == n) {
            return webKit.webViewProc(n, n2, n3, n4, n5);
        }
        return webKit.sessionProc(n, n2, n3, n4, n5);
    }

    static int Proc(int n, int n2, int n3, int n4, int n5, int n6) {
        Browser browser = WebKit.FindBrowser(n);
        if (browser == null) {
            return 0;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(n, n2, n3, n4, n5, n6);
    }

    int sessionProc(int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0;
        }
        int n6 = WebKitGTK.soup_message_get_uri(n2);
        int n7 = WebKitGTK.soup_uri_to_string(n6, 0);
        int n8 = C.strlen(n7);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n7, n8);
        OS.g_free(n7);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        for (int i = 0; i < this.authenticationListeners.length; ++i) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            this.authenticationListeners[i].authenticate(authenticationEvent);
            if (!authenticationEvent.doit) {
                OS.g_signal_stop_emission_by_name(n, WebKitGTK.authenticate);
                return 0;
            }
            if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
            byte[] byArray2 = Converter.wcsToMbcs(null, authenticationEvent.user, true);
            byte[] byArray3 = Converter.wcsToMbcs(null, authenticationEvent.password, true);
            WebKitGTK.soup_auth_authenticate(n3, byArray2, byArray3);
            OS.g_signal_stop_emission_by_name(n, WebKitGTK.authenticate);
            return 0;
        }
        return 0;
    }

    int webFrameProc(int n, int n2, int n3) {
        switch (n3) {
            case 9: {
                return this.webframe_notify_load_status(n, n2);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2) {
        switch (n2) {
            case 13: {
                return this.webkit_close_web_view(n);
            }
            case 8: {
                return this.webkit_web_view_ready(n);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3) {
        switch (n3) {
            case 7: {
                return this.webkit_create_web_view(n, n2);
            }
            case 11: {
                return this.webkit_download_requested(n, n2);
            }
            case 9: {
                return this.webkit_notify_load_status(n, n2);
            }
            case 2: {
                return this.webkit_notify_progress(n, n2);
            }
            case 4: {
                return this.webkit_notify_title(n, n2);
            }
            case 5: {
                return this.webkit_populate_popup(n, n2);
            }
            case 6: {
                return this.webkit_status_bar_text_changed(n, n2);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                return this.webkit_hovering_over_link(n, n2, n3);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 15: {
                return this.webkit_console_message(n, n2, n3, n4);
            }
            case 14: {
                return this.webkit_window_object_cleared(n, n2, n3, n4);
            }
        }
        return 0;
    }

    int webViewProc(int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n6) {
            case 12: {
                return this.webkit_mime_type_policy_decision_requested(n, n2, n3, n4, n5);
            }
            case 3: {
                return this.webkit_navigation_policy_decision_requested(n, n2, n3, n4, n5);
            }
            case 10: {
                return this.webkit_resource_request_starting(n, n2, n3, n4, n5);
            }
        }
        return 0;
    }

    public void create(Composite composite, int n) {
        int n2;
        byte[] byArray;
        if (ExternalClass == 0) {
            int n3;
            if (Device.DEBUG) {
                int n4 = WebKitGTK.webkit_major_version();
                int n5 = WebKitGTK.webkit_minor_version();
                n3 = WebKitGTK.webkit_micro_version();
                System.out.println("WebKit version " + n4 + "." + n5 + "." + n3);
            }
            JSClassDefinition jSClassDefinition = new JSClassDefinition();
            byArray = Converter.wcsToMbcs(null, CLASSNAME_EXTERNAL, true);
            jSClassDefinition.className = C.malloc(byArray.length);
            OS.memmove(jSClassDefinition.className, byArray, byArray.length);
            jSClassDefinition.hasProperty = JSObjectHasPropertyProc.getAddress();
            jSClassDefinition.getProperty = JSObjectGetPropertyProc.getAddress();
            n3 = C.malloc(JSClassDefinition.sizeof);
            WebKitGTK.memmove(n3, jSClassDefinition, JSClassDefinition.sizeof);
            ExternalClass = WebKitGTK.JSClassCreate(n3);
            byArray = Converter.wcsToMbcs(null, "POST", true);
            PostString = C.malloc(byArray.length);
            C.memmove(PostString, byArray, byArray.length);
        }
        this.scrolledWindow = OS.gtk_scrolled_window_new(0, 0);
        OS.gtk_scrolled_window_set_policy(this.scrolledWindow, 1, 1);
        this.webView = WebKitGTK.webkit_web_view_new();
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new int[]{this.webView}, C.PTR_SIZEOF);
        OS.gtk_container_add(this.scrolledWindow, this.webView);
        OS.gtk_container_add(this.browser.handle, this.scrolledWindow);
        OS.gtk_widget_show(this.scrolledWindow);
        OS.gtk_widget_show(this.webView);
        OS.g_signal_connect(this.webView, WebKitGTK.close_web_view, Proc2.getAddress(), 13);
        OS.g_signal_connect(this.webView, WebKitGTK.console_message, Proc5.getAddress(), 15);
        OS.g_signal_connect(this.webView, WebKitGTK.create_web_view, Proc3.getAddress(), 7);
        OS.g_signal_connect(this.webView, WebKitGTK.download_requested, Proc3.getAddress(), 11);
        OS.g_signal_connect(this.webView, WebKitGTK.hovering_over_link, Proc4.getAddress(), 1);
        OS.g_signal_connect(this.webView, WebKitGTK.mime_type_policy_decision_requested, Proc6.getAddress(), 12);
        OS.g_signal_connect(this.webView, WebKitGTK.navigation_policy_decision_requested, Proc6.getAddress(), 3);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_progress, Proc3.getAddress(), 2);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 4);
        OS.g_signal_connect(this.webView, WebKitGTK.populate_popup, Proc3.getAddress(), 5);
        OS.g_signal_connect(this.webView, WebKitGTK.resource_request_starting, Proc6.getAddress(), 10);
        OS.g_signal_connect(this.webView, WebKitGTK.status_bar_text_changed, Proc3.getAddress(), 6);
        OS.g_signal_connect(this.webView, WebKitGTK.web_view_ready, Proc2.getAddress(), 8);
        OS.g_signal_connect(this.webView, WebKitGTK.window_object_cleared, Proc5.getAddress(), 14);
        OS.g_signal_connect(this.webView, OS.button_press_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.button_release_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.key_press_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.key_release_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.scroll_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.webView, OS.motion_notify_event, JSDOMEventProc.getAddress(), 0);
        OS.g_signal_connect(this.scrolledWindow, OS.button_press_event, JSDOMEventProc.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.button_release_event, JSDOMEventProc.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_press_event, JSDOMEventProc.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.key_release_event, JSDOMEventProc.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.scroll_event, JSDOMEventProc.getAddress(), 1);
        OS.g_signal_connect(this.scrolledWindow, OS.motion_notify_event, JSDOMEventProc.getAddress(), 1);
        int n6 = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(n6, WebKitGTK.javascript_can_open_windows_automatically, 1, 0);
        OS.g_object_set(n6, WebKitGTK.enable_universal_access_from_file_uris, 1, 0);
        byArray = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
        OS.g_object_set(n6, WebKitGTK.default_encoding, byArray, 0);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        OS.gtk_widget_grab_focus(WebKit.this.webView);
                        break;
                    }
                    case 11: {
                        WebKit.this.onResize(event);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        int n7 = WebKitGTK.webkit_get_default_session();
        int n8 = WebKitGTK.soup_session_get_feature(n7, WebKitGTK.webkit_soup_auth_dialog_get_type());
        if (n8 != 0) {
            WebKitGTK.soup_session_feature_detach(n8, n7);
        }
        OS.g_signal_connect(n7, WebKitGTK.authenticate, Proc5.getAddress(), this.webView);
        if (n8 != 0) {
            WebKitGTK.soup_session_feature_attach(n8, n7);
        }
        String string = System.getProperty(PROPERTY_PROXYHOST);
        String string2 = System.getProperty(PROPERTY_PROXYPORT);
        int n9 = -1;
        if (string2 != null) {
            try {
                n2 = Integer.valueOf(string2);
                if (0 <= n2 && n2 <= 65535) {
                    n9 = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string != null || n9 != -1) {
            if (!string.startsWith(PROTOCOL_HTTP)) {
                string = PROTOCOL_HTTP + string;
            }
            if ((n2 = WebKitGTK.soup_uri_new(byArray = Converter.wcsToMbcs(null, string = string + ":" + n9, true))) != 0) {
                OS.g_object_set(n7, WebKitGTK.SOUP_SESSION_PROXY_URI, n2, 0);
                WebKitGTK.soup_uri_free(n2);
            }
        }
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            public Object function(Object[] objectArray) {
                return WebKit.this.handleEventFromFunction(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        n2 = WebKitGTK.webkit_major_version();
        int n10 = WebKitGTK.webkit_minor_version();
        if (n2 == 1 && n10 >= 10) {
            Rectangle rectangle = this.browser.computeTrim(0, 0, 2, 2);
            Point point = this.browser.getSize();
            point.x += rectangle.width;
            point.y += rectangle.height;
            this.browser.setSize(point);
            point.x -= rectangle.width;
            point.y -= rectangle.height;
            this.browser.setSize(point);
        }
    }

    void addEventHandlers(int n, boolean bl) {
        if (!this.jsEnabled) {
            return;
        }
        if (bl && IsWebKit14orNewer) {
            int n2 = WebKitGTK.webkit_web_view_get_dom_document(n);
            if (n2 != 0) {
                WindowMappings.put(new LONG(n2), new LONG(n));
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.dragstart, JSDOMEventProc.getAddress(), 0, 29);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.keydown, JSDOMEventProc.getAddress(), 0, 1);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.keypress, JSDOMEventProc.getAddress(), 0, -1);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.keyup, JSDOMEventProc.getAddress(), 0, 2);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.mousedown, JSDOMEventProc.getAddress(), 0, 3);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.mousemove, JSDOMEventProc.getAddress(), 0, 5);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.mouseup, JSDOMEventProc.getAddress(), 0, 4);
                WebKitGTK.webkit_dom_event_target_add_event_listener(n2, WebKitGTK.mousewheel, JSDOMEventProc.getAddress(), 0, 37);
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
        stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
        this.execute(stringBuffer.toString());
        stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
        stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
        this.execute(stringBuffer.toString());
        if (bl) {
            stringBuffer = new StringBuffer("document.addEventListener('keydown', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            this.execute(stringBuffer.toString());
            return;
        }
        stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
        stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
        stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
        stringBuffer.append('}');
        this.execute(stringBuffer.toString());
    }

    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String string2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String string3 = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string3);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = confirm('");
            stringBuffer.append(string);
            stringBuffer.append("\\n\\n'+str+'\\n\\n");
            stringBuffer.append(string2);
            stringBuffer.append("');");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string3);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public boolean execute(String string) {
        int n = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int n2 = WebKitGTK.webkit_web_frame_get_global_context(n);
        byte[] byArray = null;
        try {
            byArray = (string + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        int n3 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        try {
            byArray = (this.getUrl() + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, this.getUrl(), true);
        }
        int n4 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        int n5 = WebKitGTK.JSEvaluateScript(n2, n3, 0, n4, 0, null);
        WebKitGTK.JSStringRelease(n4);
        WebKitGTK.JSStringRelease(n3);
        return n5 != 0;
    }

    public boolean forward() {
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int n = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        int n2 = WebKitGTK.webkit_web_frame_get_data_source(n);
        if (n2 == 0) {
            return "";
        }
        int n3 = WebKitGTK.webkit_web_data_source_get_data(n2);
        if (n3 == 0) {
            return "";
        }
        int n4 = WebKitGTK.webkit_web_data_source_get_encoding(n2);
        int n5 = OS.strlen(n4);
        byte[] byArray = new byte[n5];
        OS.memmove(byArray, n4, n5);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        n5 = OS.GString_len(n3);
        byArray = new byte[n5];
        int n6 = OS.GString_str(n3);
        C.memmove(byArray, n6, n5);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(Converter.mbcsToWcs(null, byArray));
        }
    }

    public String getUrl() {
        int n = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (n == 0) {
            return ABOUT_BLANK;
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        return string;
    }

    boolean handleDOMEvent(int n, int n2) {
        String string = null;
        boolean bl = false;
        switch (n2) {
            case 29: {
                string = DOMEVENT_DRAGSTART;
                bl = true;
                break;
            }
            case 3: {
                string = DOMEVENT_MOUSEDOWN;
                bl = true;
                break;
            }
            case 5: {
                string = DOMEVENT_MOUSEMOVE;
                bl = true;
                break;
            }
            case 4: {
                string = DOMEVENT_MOUSEUP;
                bl = true;
                break;
            }
            case 37: {
                string = DOMEVENT_MOUSEWHEEL;
                bl = true;
                break;
            }
            case 1: {
                string = DOMEVENT_KEYDOWN;
                break;
            }
            case 2: {
                string = DOMEVENT_KEYUP;
                break;
            }
            case -1: {
                string = DOMEVENT_KEYPRESS;
            }
        }
        if (bl) {
            int n3 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_x(n);
            int n4 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_y(n);
            int n5 = WebKitGTK.webkit_dom_mouse_event_get_button(n) + 1;
            boolean bl2 = WebKitGTK.webkit_dom_mouse_event_get_alt_key(n) != 0;
            boolean bl3 = WebKitGTK.webkit_dom_mouse_event_get_ctrl_key(n) != 0;
            boolean bl4 = WebKitGTK.webkit_dom_mouse_event_get_shift_key(n) != 0;
            boolean bl5 = WebKitGTK.webkit_dom_mouse_event_get_meta_key(n) != 0;
            int n6 = (int)WebKitGTK.webkit_dom_ui_event_get_detail(n);
            boolean bl6 = false;
            return this.handleMouseEvent(string, n3, n4, n6, n5, bl2, bl3, bl4, bl5, bl6);
        }
        int n7 = 0;
        int n8 = OS.gtk_get_current_event();
        if (n8 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n8, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: 
                case 9: {
                    n7 = gdkEventKey.state;
                }
            }
            OS.gdk_event_free(n8);
        }
        int n9 = (int)WebKitGTK.webkit_dom_ui_event_get_key_code(n);
        int n10 = (int)WebKitGTK.webkit_dom_ui_event_get_char_code(n);
        boolean bl7 = (n7 & 8) != 0;
        boolean bl8 = (n7 & 4) != 0;
        boolean bl9 = (n7 & 1) != 0;
        return this.handleKeyEvent(string, n9, n10, bl7, bl8, bl9, false);
    }

    boolean handleEventFromFunction(Object[] objectArray) {
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN) || string.equals(DOMEVENT_KEYPRESS) || string.equals(DOMEVENT_KEYUP)) {
            return this.handleKeyEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), (Boolean)objectArray[3], (Boolean)objectArray[4], (Boolean)objectArray[5], (Boolean)objectArray[6]);
        }
        return this.handleMouseEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), ((Double)objectArray[3]).intValue(), (objectArray[4] != null ? ((Double)objectArray[4]).intValue() : 0) + 1, (Boolean)objectArray[5], (Boolean)objectArray[6], (Boolean)objectArray[7], (Boolean)objectArray[8], (Boolean)objectArray[9]);
    }

    boolean handleKeyEvent(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string.equals(DOMEVENT_KEYDOWN)) {
            this.lastKeyCode = n = this.translateKey(n);
            switch (n) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n;
                    switch (n) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
                    event.stateMask &= ~n;
                    final int n3 = event.stateMask;
                    if (!this.sendKeyEvent(event) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || n != 9 || (n3 & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (WebKit.this.browser.isDisposed()) {
                                return;
                            }
                            if (WebKit.this.browser.getDisplay().getFocusControl() == null) {
                                int n = (n3 & 0x20000) != 0 ? 8 : 16;
                                WebKit.this.browser.traverse(n);
                            }
                        }
                    });
                    break;
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = n2;
            if (bl2 && 0 <= this.lastCharCode && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if ((n = this.translateKey(n)) == 0) {
            return true;
        }
        if (n != this.lastKeyCode) {
            this.lastKeyCode = n;
            this.lastCharCode = 0;
        }
        Event event = new Event();
        event.widget = this.browser;
        event.type = 2;
        event.keyCode = this.lastKeyCode;
        event.character = (char)this.lastCharCode;
        event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        switch (this.lastKeyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                event.stateMask |= this.lastKeyCode;
            }
        }
        this.browser.notifyListeners(event.type, event);
        this.lastCharCode = 0;
        this.lastKeyCode = 0;
        return event.doit && !this.browser.isDisposed();
    }

    boolean handleMouseEvent(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n5;
        Point point = new Point(n, n2);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n5 = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = n3;
            event.button = n4;
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (n3 == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n5;
                event.count = n3;
                event.button = n4;
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = n3;
            event.button = n4;
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = n3;
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = n4;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
            if (!IsWebKit14orNewer) {
                this.browser.notifyListeners(event.type, event);
                return false;
            }
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    int handleLoadCommitted(int n, boolean bl) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        if (bl && string.startsWith(ABOUT_BLANK) && this.htmlBytes != null) {
            return 0;
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.top = bl;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            this.locationListeners[i].changed(locationEvent);
        }
        return 0;
    }

    int handleLoadFinished(int n, boolean bl) {
        Object object;
        Object object2;
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        if (bl && this.htmlBytes != null && string.startsWith(ABOUT_BLANK)) {
            this.loadingText = true;
            object2 = Converter.wcsToMbcs(null, "text/html", true);
            byte[] byArray2 = Converter.wcsToMbcs(null, CHARSET_UTF8, true);
            object = this.untrustedText ? (Object)Converter.wcsToMbcs(null, ABOUT_BLANK, true) : (Object)Converter.wcsToMbcs(null, URI_FILEROOT, true);
            WebKitGTK.webkit_web_view_load_string(this.webView, this.htmlBytes, (byte[])object2, byArray2, (byte[])object);
            this.htmlBytes = null;
        }
        if (!this.loadingText) {
            int n3;
            int n4;
            if (bl && (n4 = WebKitGTK.webkit_web_frame_get_title(n3 = WebKitGTK.webkit_web_view_get_main_frame(this.webView))) == 0) {
                object = new TitleEvent(this.browser);
                ((TitleEvent)object).display = this.browser.getDisplay();
                ((TitleEvent)object).widget = this.browser;
                ((TitleEvent)object).title = string;
                for (int i = 0; i < this.titleListeners.length; ++i) {
                    this.titleListeners[i].changed((TitleEvent)object);
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            object2 = new ProgressEvent(this.browser);
            ((ProgressEvent)object2).display = this.browser.getDisplay();
            ((ProgressEvent)object2).widget = this.browser;
            ((ProgressEvent)object2).current = 100;
            ((ProgressEvent)object2).total = 100;
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].completed((ProgressEvent)object2);
            }
        }
        this.loadingText = false;
        return 0;
    }

    public boolean isBackEnabled() {
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event event) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            ((BrowserFunction)enumeration.nextElement()).dispose(false);
        }
        this.functions = null;
        if (this.eventFunction != null) {
            this.eventFunction.dispose(false);
            this.eventFunction = null;
        }
        C.free(this.webViewData);
        this.postData = null;
        this.headers = null;
        this.htmlBytes = null;
    }

    void onResize(Event event) {
        Rectangle rectangle = this.browser.getClientArea();
        OS.gtk_widget_set_size_request(this.scrolledWindow, rectangle.width, rectangle.height);
    }

    void openDownloadWindow(final int n) {
        final Shell shell = new Shell();
        String string = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        int n2 = WebKitGTK.webkit_download_get_suggested_filename(n);
        int n3 = OS.strlen(n2);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int n4 = WebKitGTK.webkit_download_get_uri(n);
        n3 = OS.strlen(n4);
        byArray = new byte[n3];
        OS.memmove(byArray, n4, n3);
        String string3 = new String(Converter.mbcsToWcs(null, byArray));
        string = Compatibility.getMessage("SWT_Download_Location", new Object[]{string2, string3});
        Label label = new Label(shell, 64);
        label.setText(string);
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n5 = monitor.getBounds().width / 2;
        int n6 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n6, n5);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WebKitGTK.webkit_download_cancel(n);
            }
        };
        button.addListener(13, listener);
        OS.g_object_ref(n);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            public void run() {
                int n2 = WebKitGTK.webkit_download_get_status(n);
                if (shell.isDisposed() || n2 == 3 || n2 == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(n);
                    return;
                }
                if (n2 == -1) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(n);
                    button.removeListener(13, listener);
                    button.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            shell.dispose();
                        }
                    });
                    return;
                }
                long l = WebKitGTK.webkit_download_get_current_size(n) / 1024L;
                long l2 = WebKitGTK.webkit_download_get_total_size(n) / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    public void refresh() {
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    public boolean setText(String string, boolean bl) {
        byte[] byArray = null;
        try {
            byArray = (string + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, string, true);
        }
        boolean bl2 = this.htmlBytes != null;
        this.htmlBytes = byArray;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        byte[] byArray2 = Converter.wcsToMbcs(null, ABOUT_BLANK, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray2);
        return true;
    }

    public boolean setUrl(String string, String string2, String[] stringArray) {
        this.postData = string2;
        this.headers = stringArray;
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = null;
            string3 = string.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + string : PROTOCOL_HTTP + string;
            try {
                new URL(string3);
                string = string3;
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        int n = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string4 = stringArray[i];
                if (string4 == null || (n2 = string4.indexOf(58)) == -1) continue;
                String string5 = string4.substring(0, n2).trim();
                String string6 = string4.substring(n2 + 1).trim();
                if (string5.length() <= 0 || string6.length() <= 0 || !string5.equalsIgnoreCase(USER_AGENT)) continue;
                byte[] byArray = Converter.wcsToMbcs(null, string6, true);
                OS.g_object_set(n, WebKitGTK.user_agent, byArray, 0);
            }
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        WebKitGTK.webkit_web_view_load_uri(this.webView, byArray);
        OS.g_object_set(n, WebKitGTK.user_agent, 0, 0);
        return true;
    }

    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    int webframe_notify_load_status(int n, int n2) {
        int n3 = WebKitGTK.webkit_web_frame_get_load_status(n);
        switch (n3) {
            case 1: {
                int n4 = WebKitGTK.webkit_web_frame_get_uri(n);
                return this.handleLoadCommitted(n4, false);
            }
            case 2: {
                int n5 = WebKitGTK.webkit_web_frame_get_parent(n);
                if (WebKitGTK.webkit_web_frame_get_load_status(n5) != 2) break;
                int n6 = WebKitGTK.webkit_web_frame_get_uri(n);
                return this.handleLoadFinished(n6, false);
            }
        }
        return 0;
    }

    int webkit_close_web_view(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        for (int i = 0; i < this.closeWindowListeners.length; ++i) {
            this.closeWindowListeners[i].close(windowEvent);
        }
        this.browser.dispose();
        return 0;
    }

    int webkit_console_message(int n, int n2, int n3, int n4) {
        return 1;
    }

    int webkit_create_web_view(int n, int n2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            for (int i = 0; i < this.openWindowListeners.length; ++i) {
                this.openWindowListeners[i].open(windowEvent);
            }
        }
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            return ((WebKit)((Browser)widget).webBrowser).webView;
        }
        return 0;
    }

    int webkit_download_requested(int n, int n2) {
        int n3 = WebKitGTK.webkit_download_get_suggested_filename(n2);
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        final String string = new String(Converter.mbcsToWcs(null, byArray));
        final int n5 = WebKitGTK.webkit_download_get_network_request(n2);
        OS.g_object_ref(n5);
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!WebKit.this.browser.isDisposed()) {
                    FileDialog fileDialog = new FileDialog(WebKit.this.browser.getShell(), 8192);
                    fileDialog.setFileName(string);
                    String string3 = Compatibility.getMessage("SWT_FileDownload");
                    fileDialog.setText(string3);
                    String string2 = fileDialog.open();
                    if (string2 != null) {
                        string2 = WebKit.URI_FILEROOT + string2;
                        int n = WebKitGTK.webkit_download_new(n5);
                        byte[] byArray = Converter.wcsToMbcs(null, string2, true);
                        WebKitGTK.webkit_download_set_destination_uri(n, byArray);
                        WebKit.this.openDownloadWindow(n);
                        WebKitGTK.webkit_download_start(n);
                        OS.g_object_unref(n);
                    }
                }
                OS.g_object_unref(n5);
            }
        });
        return 1;
    }

    int webkit_hovering_over_link(int n, int n2, int n3) {
        if (n3 != 0) {
            int n4 = OS.strlen(n3);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            for (int i = 0; i < this.statusTextListeners.length; ++i) {
                this.statusTextListeners[i].changed(statusTextEvent);
            }
        }
        return 0;
    }

    int webkit_mime_type_policy_decision_requested(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, n4) != 0;
        if (!bl) {
            WebKitGTK.webkit_web_policy_decision_download(n5);
            return 1;
        }
        return 0;
    }

    int webkit_navigation_policy_decision_requested(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (this.loadingText) {
            return 0;
        }
        int n7 = WebKitGTK.webkit_network_request_get_uri(n3);
        int n8 = OS.strlen(n7);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n7, n8);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n8 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n8) == '#') {
                string = ABOUT_BLANK + string.substring(n8);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            for (n6 = 0; n6 < this.locationListeners.length; ++n6) {
                this.locationListeners[n6].changing(locationEvent);
            }
        }
        if (locationEvent.doit && !this.browser.isDisposed()) {
            int n9;
            if (this.jsEnabled != this.jsEnabledOnNextPage) {
                this.jsEnabled = this.jsEnabledOnNextPage;
                DisabledJSCount += !this.jsEnabled ? 1 : -1;
                n6 = WebKitGTK.webkit_web_view_get_settings(this.webView);
                OS.g_object_set(n6, WebKitGTK.enable_scripts, this.jsEnabled ? 1 : 0, 0);
            }
            if (n2 != (n6 = WebKitGTK.webkit_web_view_get_main_frame(this.webView)) && (n9 = OS.g_signal_handler_find(n2, 24, 0, 0, 0, Proc3.getAddress(), 9)) == 0) {
                OS.g_signal_connect(n2, WebKitGTK.notify_load_status, Proc3.getAddress(), 9);
            }
        } else {
            WebKitGTK.webkit_web_policy_decision_ignore(n5);
        }
        return 0;
    }

    int webkit_notify_load_status(int n, int n2) {
        int n3 = WebKitGTK.webkit_web_view_get_load_status(this.webView);
        switch (n3) {
            case 1: {
                int n4 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(n4, true);
            }
            case 2: {
                int n5 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadFinished(n5, true);
            }
        }
        return 0;
    }

    int webkit_notify_progress(int n, int n2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.current = (int)(WebKitGTK.webkit_web_view_get_progress(this.webView) * 100.0);
        progressEvent.total = 100;
        for (int i = 0; i < this.progressListeners.length; ++i) {
            this.progressListeners[i].changed(progressEvent);
        }
        return 0;
    }

    int webkit_notify_title(int n, int n2) {
        String string;
        int n3 = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (n3 == 0) {
            string = "";
        } else {
            int n4 = OS.strlen(n3);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            string = new String(Converter.mbcsToWcs(null, byArray));
        }
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.title = string;
        for (int i = 0; i < this.titleListeners.length; ++i) {
            this.titleListeners[i].changed(titleEvent);
        }
        return 0;
    }

    int webkit_populate_popup(int n, int n2) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            int n3;
            int n4 = n3 = OS.gtk_container_get_children(n2);
            while (n4 != 0) {
                int n5 = OS.g_list_data(n4);
                OS.gtk_container_remove(n2, n5);
                n4 = OS.g_list_next(n4);
            }
            OS.g_list_free(n3);
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            int n6;
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            int n7 = n6 = OS.gtk_container_get_children(n2);
            while (n7 != 0) {
                int n8 = OS.g_list_data(n7);
                OS.gtk_container_remove(n2, n8);
                n7 = OS.g_list_next(n7);
            }
            OS.g_list_free(n6);
        }
        return 0;
    }

    int webkit_resource_request_starting(int n, int n2, int n3, int n4, int n5) {
        if (this.postData != null || this.headers != null) {
            int n6 = WebKitGTK.webkit_network_request_get_message(n4);
            if (n6 == 0) {
                this.headers = null;
                this.postData = null;
            } else {
                Object object;
                int n7;
                int n8;
                if (this.postData != null) {
                    WebKitGTK.SoupMessage_method(n6, PostString);
                    n8 = WebKitGTK.SoupMessage_request_body(n6);
                    byte[] byArray = Converter.wcsToMbcs(null, this.postData, false);
                    int n9 = C.malloc(byArray.length);
                    C.memmove(n9, byArray, byArray.length);
                    WebKitGTK.soup_message_body_append(n8, 1, n9, byArray.length);
                    WebKitGTK.soup_message_body_flatten(n8);
                    if (this.headers == null) {
                        this.headers = new String[0];
                    }
                    n7 = 0;
                    for (int i = 0; i < this.headers.length; ++i) {
                        int n10 = this.headers[i].indexOf(58);
                        if (n10 == -1 || !((String)(object = (Object)this.headers[i].substring(0, n10).trim().toLowerCase())).equals(HEADER_CONTENTTYPE)) continue;
                        n7 = 1;
                        break;
                    }
                    if (n7 == 0) {
                        String[] stringArray = new String[this.headers.length + 1];
                        System.arraycopy(this.headers, 0, stringArray, 0, this.headers.length);
                        stringArray[this.headers.length] = "content-type:application/x-www-form-urlencoded";
                        this.headers = stringArray;
                    }
                    this.postData = null;
                }
                n8 = WebKitGTK.SoupMessage_request_headers(n6);
                for (int i = 0; i < this.headers.length; ++i) {
                    String string = this.headers[i];
                    if (string == null || (n7 = string.indexOf(58)) == -1) continue;
                    String string2 = string.substring(0, n7).trim();
                    String string3 = string.substring(n7 + 1).trim();
                    if (string2.length() <= 0 || string3.length() <= 0) continue;
                    object = Converter.wcsToMbcs(null, string2, true);
                    byte[] byArray = Converter.wcsToMbcs(null, string3, true);
                    WebKitGTK.soup_message_headers_append(n8, (byte[])object, byArray);
                }
                this.headers = null;
            }
        }
        return 0;
    }

    int webkit_status_bar_text_changed(int n, int n2) {
        int n3 = OS.strlen(n2);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(Converter.mbcsToWcs(null, byArray));
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
        return 0;
    }

    int webkit_web_view_ready(int n) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n2 = WebKitGTK.webkit_web_view_get_window_features(this.webView);
        int[] nArray = new int[1];
        OS.g_object_get(n2, WebKitGTK.locationbar_visible, nArray, 0);
        windowEvent.addressBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.menubar_visible, nArray, 0);
        windowEvent.menuBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.statusbar_visible, nArray, 0);
        windowEvent.statusBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.toolbar_visible, nArray, 0);
        windowEvent.toolBar = nArray[0] != 0;
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.x, nArray, 0);
        int n3 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.y, nArray, 0);
        int n4 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.width, nArray, 0);
        int n5 = nArray[0];
        nArray[0] = 0;
        OS.g_object_get(n2, WebKitGTK.height, nArray, 0);
        int n6 = nArray[0];
        nArray[0] = 0;
        if (n3 != -1 && n4 != -1) {
            windowEvent.location = new Point(n3, n4);
        }
        if (n5 != -1 && n6 != -1) {
            windowEvent.size = new Point(n5, n6);
        }
        for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
            this.visibilityWindowListeners[i].show(windowEvent);
        }
        return 0;
    }

    int webkit_window_object_cleared(int n, int n2, int n3, int n4) {
        int n5 = WebKitGTK.JSContextGetGlobalObject(n3);
        int n6 = WebKitGTK.JSObjectMake(n3, ExternalClass, this.webViewData);
        byte[] byArray = null;
        try {
            byArray = "external\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = Converter.wcsToMbcs(null, OBJECTNAME_EXTERNAL, true);
        }
        int n7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
        WebKitGTK.JSObjectSetProperty(n3, n5, n7, n6, 0, null);
        WebKitGTK.JSStringRelease(n7);
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            BrowserFunction browserFunction = (BrowserFunction)enumeration.nextElement();
            this.execute(browserFunction.functionString);
        }
        int n8 = WebKitGTK.webkit_web_view_get_main_frame(this.webView);
        boolean bl = n8 == n2;
        this.addEventHandlers(n, bl);
        return 0;
    }

    int callJava(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = null;
        if (n4 == 3) {
            int[] nArray = new int[1];
            C.memmove(nArray, n5, C.PTR_SIZEOF);
            int n7 = WebKitGTK.JSValueGetType(n, nArray[0]);
            if (n7 == 3) {
                int n8 = ((Double)this.convertToJava(n, nArray[0])).intValue();
                nArray[0] = 0;
                Integer n9 = new Integer(n8);
                C.memmove(nArray, n5 + C.PTR_SIZEOF, C.PTR_SIZEOF);
                n7 = WebKitGTK.JSValueGetType(n, nArray[0]);
                if (n7 == 4) {
                    String string = (String)this.convertToJava(n, nArray[0]);
                    BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n9);
                    if (browserFunction != null && string.equals(browserFunction.token)) {
                        try {
                            C.memmove(nArray, n5 + 2 * C.PTR_SIZEOF, C.PTR_SIZEOF);
                            Object object2 = this.convertToJava(n, nArray[0]);
                            if (object2 instanceof Object[]) {
                                Object[] objectArray = (Object[])object2;
                                try {
                                    object = browserFunction.function(objectArray);
                                }
                                catch (Exception exception) {
                                    object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                }
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (browserFunction.isEvaluate) {
                                browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                            }
                            object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                        }
                    }
                }
            }
        }
        return this.convertToJS(n, object);
    }

    int convertToJS(int n, Object object) {
        if (object == null) {
            return WebKitGTK.JSValueMakeUndefined(n);
        }
        if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = ((String)object + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = Converter.wcsToMbcs(null, (String)object, true);
            }
            int n2 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
            int n3 = WebKitGTK.JSValueMakeString(n, n2);
            WebKitGTK.JSStringRelease(n2);
            return n3;
        }
        if (object instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(n, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(n, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length;
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                int n5;
                Object object2 = objectArray[i];
                nArray[i] = n5 = this.convertToJS(n, object2);
            }
            return WebKitGTK.JSObjectMakeArray(n, n4, nArray, null);
        }
        SWT.error(51);
        return 0;
    }

    Object convertToJava(int n, int n2) {
        int n3 = WebKitGTK.JSValueGetType(n, n2);
        switch (n3) {
            case 2: {
                int n4 = (int)WebKitGTK.JSValueToNumber(n, n2, null);
                return new Boolean(n4 != 0);
            }
            case 3: {
                double d = WebKitGTK.JSValueToNumber(n, n2, null);
                return new Double(d);
            }
            case 4: {
                int n5 = WebKitGTK.JSValueToStringCopy(n, n2, null);
                if (n5 == 0) {
                    return "";
                }
                int n6 = WebKitGTK.JSStringGetMaximumUTF8CStringSize(n5);
                byte[] byArray = new byte[n6];
                n6 = WebKitGTK.JSStringGetUTF8CString(n5, byArray, n6);
                WebKitGTK.JSStringRelease(n5);
                try {
                    return new String(byArray, 0, n6 - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(Converter.mbcsToWcs(null, byArray));
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = null;
                try {
                    byArray = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = Converter.wcsToMbcs(null, PROPERTY_LENGTH, true);
                }
                int n7 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
                int n8 = WebKitGTK.JSObjectGetProperty(n, n2, n7, null);
                WebKitGTK.JSStringRelease(n7);
                n3 = WebKitGTK.JSValueGetType(n, n8);
                if (n3 != 3) break;
                int n9 = (int)WebKitGTK.JSValueToNumber(n, n8, null);
                Object[] objectArray = new Object[n9];
                for (int i = 0; i < n9; ++i) {
                    int n10 = WebKitGTK.JSObjectGetPropertyAtIndex(n, n2, i, null);
                    if (n10 == 0) continue;
                    objectArray[i] = this.convertToJava(n, n10);
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        WindowMappings = new Hashtable();
        MIN_VERSION = new int[]{1, 2, 0};
        SEPARATOR_FILE = System.getProperty("file.separator").charAt(0);
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LibraryLoaded) {
            WebViewType = WebKitGTK.webkit_web_view_get_type();
            Proc2 = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "Proc", 2);
            if (Proc2.getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc3 = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "Proc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc4 = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "Proc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc5 = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "Proc", 5)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((Proc6 = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "Proc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((JSObjectHasPropertyProc = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "JSObjectHasPropertyProc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((JSObjectGetPropertyProc = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "JSObjectGetPropertyProc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((JSObjectCallAsFunctionProc = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((JSDOMEventProc = new Callback(class$org$eclipse$swt$browser$WebKit == null ? (class$org$eclipse$swt$browser$WebKit = WebKit.class$("org.eclipse.swt.browser.WebKit")) : class$org$eclipse$swt$browser$WebKit, "JSDOMEventProc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            NativeClearSessions = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        return;
                    }
                    int n4 = WebKitGTK.soup_cookie_jar_all_cookies(n3);
                    int n5 = OS.g_slist_length(n4);
                    int n6 = n4;
                    for (int i = 0; i < n5; ++i) {
                        int n7 = OS.g_slist_data(n6);
                        int n8 = WebKitGTK.SoupCookie_expires(n7);
                        if (n8 == 0) {
                            WebKitGTK.soup_cookie_jar_delete_cookie(n3, n7);
                        }
                        WebKitGTK.soup_cookie_free(n7);
                        n6 = OS.g_slist_next(n6);
                    }
                    OS.g_slist_free(n4);
                }
            };
            NativeGetCookie = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, WebBrowser.CookieUrl, true);
                    int n4 = WebKitGTK.soup_uri_new(byArray);
                    if (n4 == 0) {
                        return;
                    }
                    int n5 = WebKitGTK.soup_cookie_jar_get_cookies(n3, n4, 0);
                    WebKitGTK.soup_uri_free(n4);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = OS.strlen(n5);
                    byArray = new byte[n6];
                    C.memmove(byArray, n5, n6);
                    OS.g_free(n5);
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2;
                        String string3 = stringTokenizer.nextToken();
                        int n7 = string3.indexOf(61);
                        if (n7 == -1 || !(string2 = string3.substring(0, n7).trim()).equals(WebBrowser.CookieName)) continue;
                        WebBrowser.CookieValue = string3.substring(n7 + 1).trim();
                        return;
                    }
                }
            };
            NativeSetCookie = new Runnable(){

                public void run() {
                    int n;
                    if (!LibraryLoaded) {
                        return;
                    }
                    int n2 = WebKitGTK.webkit_get_default_session();
                    int n3 = WebKitGTK.soup_session_get_feature(n2, n = WebKitGTK.soup_cookie_jar_get_type());
                    if (n3 == 0) {
                        WebKitGTK.soup_session_add_feature_by_type(n2, n);
                        n3 = WebKitGTK.soup_session_get_feature(n2, n);
                    }
                    if (n3 == 0) {
                        return;
                    }
                    byte[] byArray = Converter.wcsToMbcs(null, WebBrowser.CookieUrl, true);
                    int n4 = WebKitGTK.soup_uri_new(byArray);
                    if (n4 == 0) {
                        return;
                    }
                    byArray = Converter.wcsToMbcs(null, WebBrowser.CookieValue, true);
                    int n5 = WebKitGTK.soup_cookie_parse(byArray, n4);
                    if (n5 != 0) {
                        WebKitGTK.soup_cookie_jar_add_cookie(n3, n5);
                        WebBrowser.CookieResult = true;
                    }
                    WebKitGTK.soup_uri_free(n4);
                }
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
                NativePendingCookies = null;
            }
        }
    }
}

