/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public Control topControl;

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        int n3;
        Control[] controlArray = composite.getChildren();
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < controlArray.length; ++n3) {
            Point point = controlArray[n3].computeSize(n, n2, bl);
            n4 = Math.max(point.x, n4);
            n5 = Math.max(point.y, n5);
        }
        n3 = n4 + 2 * this.marginWidth;
        int n6 = n5 + 2 * this.marginHeight;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        return new Point(n3, n6);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        Rectangle rectangle = composite.getClientArea();
        rectangle.x += this.marginWidth;
        rectangle.y += this.marginHeight;
        rectangle.width -= 2 * this.marginWidth;
        rectangle.height -= 2 * this.marginHeight;
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].setBounds(rectangle);
            controlArray[i].setVisible(controlArray[i] == this.topControl);
        }
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        String string = this.getName() + " {";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.topControl != null) {
            string = string + "topControl=" + this.topControl + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

