/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    String text;
    Image image;
    Image[] images = new Image[0];
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int accelGroup;
    int vboxHandle;

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n));
    }

    static int checkStyle(int n) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void _setImages(Image[] imageArray) {
        if (imageArray != null && imageArray.length > 1) {
            Image[] imageArray2 = new Image[imageArray.length];
            System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
            this.sort(imageArray2);
            imageArray = imageArray2;
        }
        int n = 0;
        if (imageArray != null) {
            for (int i = 0; i < imageArray.length; ++i) {
                Image image = imageArray[i];
                int n2 = ImageList.createPixbuf(image);
                n = OS.g_list_append(n, n2);
            }
        }
        OS.gtk_window_set_icon_list(this.topHandle(), n);
        int[] nArray = new int[1];
        int n3 = n;
        while (n3 != 0) {
            OS.memmove(nArray, n3, OS.PTR_SIZEOF);
            OS.g_object_unref(nArray[0]);
            n3 = OS.g_list_next(n3);
        }
        if (n != 0) {
            OS.g_list_free(n);
        }
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != null) continue;
            this.menus[i] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    int compare(ImageData imageData, ImageData imageData2) {
        if (imageData.width == imageData2.width && imageData.height == imageData2.height) {
            int n = imageData.getTransparencyType();
            int n2 = imageData2.getTransparencyType();
            if (n == 1) {
                return -1;
            }
            if (n2 == 1) {
                return 1;
            }
            if (n == 2) {
                return -1;
            }
            if (n2 == 2) {
                return 1;
            }
            if (n == 4) {
                return -1;
            }
            if (n2 == 4) {
                return 1;
            }
            return 0;
        }
        return imageData.width > imageData2.width || imageData.height > imageData2.height ? -1 : 1;
    }

    Widget computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    void createAccelGroup() {
        if (this.accelGroup != 0) {
            return;
        }
        this.accelGroup = OS.gtk_accel_group_new();
        if (this.accelGroup == 0) {
            this.error(2);
        }
        int n = this.topHandle();
        OS.gtk_window_add_accel_group(n, this.accelGroup);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    void destroyAccelGroup() {
        if (this.accelGroup == 0) {
            return;
        }
        int n = this.topHandle();
        OS.gtk_window_remove_accel_group(n, this.accelGroup);
        this.accelGroup = 0;
    }

    void fixAccelGroup() {
        if (this.menuBar == null) {
            return;
        }
        this.destroyAccelGroup();
        this.createAccelGroup();
        this.menuBar.addAccelerators(this.accelGroup);
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != menu) continue;
                control.setMenu(null);
                return;
            }
            menu.fixMenus(decorations);
        }
    }

    public Button getDefaultButton() {
        Button button;
        this.checkWidget();
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button != null && button.isDisposed()) {
            return null;
        }
        return button;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != menu) continue;
            this.menus[i] = null;
            return;
        }
    }

    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null || menu.isDisposed()) continue;
                menu.dispose();
            }
            this.menus = null;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.vboxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
    }

    void reskinChildren(int n) {
        if (this.menuBar != null) {
            this.menuBar.reskin(n);
        }
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null) continue;
                menu.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean bl = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return bl;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        int n = 0;
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            n = button.handle;
        }
        this.saveDefault = this.defaultButton = button;
        OS.gtk_window_set_default(this.topHandle(), n);
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        this.image = image;
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageArray[i] != null && !imageArray[i].isDisposed()) continue;
            this.error(5);
        }
        this.images = imageArray;
        this._setImages(imageArray);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        this.maximized = bl;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        this.minimized = bl;
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!bl && this.menuBar != null) {
            this.menuBar._setOrientation(this.style & 0x6000000);
        }
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    void sort(Image[] imageArray) {
        int n;
        int n2 = imageArray.length;
        if (n2 <= 1) {
            return;
        }
        ImageData[] imageDataArray = new ImageData[n2];
        for (n = 0; n < n2; ++n) {
            imageDataArray[n] = imageArray[n].getImageData();
        }
        for (n = n2 / 2; n > 0; n /= 2) {
            for (int i = n; i < n2; ++i) {
                for (int j = i - n; j >= 0; j -= n) {
                    if (this.compare(imageDataArray[j], imageDataArray[j + n]) < 0) continue;
                    Image image = imageArray[j];
                    imageArray[j] = imageArray[j + n];
                    imageArray[j + n] = image;
                    ImageData imageData = imageDataArray[j];
                    imageDataArray[j] = imageDataArray[j + n];
                    imageDataArray[j + n] = imageData;
                }
            }
        }
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        Button button;
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button == null || button.isDisposed()) {
            return false;
        }
        if (!button.isVisible() || !button.isEnabled()) {
            return true;
        }
        int n = this._getShell().topHandle();
        return OS.gtk_window_activate_default(n);
    }
}

