/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.gitlab.core.Duration;
import org.eclipse.mylyn.gitlab.core.GitlabConfiguration;
import org.eclipse.mylyn.gitlab.core.GitlabCoreActivator;
import org.eclipse.mylyn.internal.commons.core.operations.NullOperationMonitor;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRestClient;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskDataHandler;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryInfo;
import org.eclipse.mylyn.tasks.core.RepositoryVersion;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class GitlabRepositoryConnector
extends AbstractRepositoryConnector {
    private static final ThreadLocal<IOperationMonitor> context = new ThreadLocal();
    private final LoadingCache<RepositoryKey, Optional<GitlabConfiguration>> configurationCache;
    private SimpleDateFormat simpleFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static Duration CONFIGURATION_CACHE_EXPIRE_DURATION = new Duration(7L, TimeUnit.DAYS);
    public static Duration CONFIGURATION_CACHE_REFRESH_AFTER_WRITE_DURATION = new Duration(1L, TimeUnit.DAYS);
    public static Duration CLIENT_CACHE_DURATION = new Duration(24L, TimeUnit.HOURS);
    private PropertyChangeListener repositoryChangeListener4ConfigurationCache;
    private PropertyChangeListener repositoryChangeListener4ClientCache;
    private final LoadingCache<RepositoryKey, GitlabRestClient> clientCache = Caffeine.newBuilder().expireAfterAccess(CLIENT_CACHE_DURATION.getValue(), CLIENT_CACHE_DURATION.getUnit()).build(key -> {
        TaskRepository repository = key.getRepository();
        repository.addChangeListener(this.repositoryChangeListener4ClientCache);
        return this.createClient(repository);
    });
    private final LoadingCache<String, byte[]> avatarCache = Caffeine.newBuilder().expireAfterAccess(CLIENT_CACHE_DURATION.getValue(), CLIENT_CACHE_DURATION.getUnit()).build(key -> {
        byte[] avatarBytes = null;
        HttpURLConnection connection = (HttpURLConnection)new URL((String)key).openConnection();
        connection.setConnectTimeout(30000);
        connection.setUseCaches(false);
        connection.connect();
        if (connection.getResponseCode() != 200) return avatarBytes;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                try (InputStream input = connection.getInputStream();){
                    byte[] buffer = new byte[8192];
                    int read = -1;
                    while ((read = input.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    avatarBytes = output.toByteArray();
                }
                if (output == null) return avatarBytes;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            output.close();
            return avatarBytes;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    });

    private boolean ignoredProperty(String propertyName) {
        return propertyName.equals("label") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.offline") || propertyName.equals("encoding") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.hostname") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.port") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.savePassword") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.usedefault") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.savePassword") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.username") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.password") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.enabled");
    }

    protected Caffeine<Object, Object> createCacheBuilder(Duration expireAfterWriteDuration, Duration refreshAfterWriteDuration) {
        return Caffeine.newBuilder().expireAfterWrite(expireAfterWriteDuration.getValue(), expireAfterWriteDuration.getUnit()).refreshAfterWrite(refreshAfterWriteDuration.getValue(), refreshAfterWriteDuration.getUnit());
    }

    public GitlabRepositoryConnector() {
        this(CONFIGURATION_CACHE_REFRESH_AFTER_WRITE_DURATION);
    }

    public GitlabRepositoryConnector(Duration refreshAfterWriteDuration) {
        this.configurationCache = this.createCacheBuilder(CONFIGURATION_CACHE_EXPIRE_DURATION, refreshAfterWriteDuration).build(key -> {
            GitlabRestClient client = (GitlabRestClient)this.clientCache.get(key);
            TaskRepository repository = key.getRepository();
            repository.addChangeListener(this.repositoryChangeListener4ConfigurationCache);
            return Optional.ofNullable(client.getConfiguration(key.getRepository(), context.get()));
        });
        this.repositoryChangeListener4ClientCache = evt -> {
            TaskRepository taskRepository = (TaskRepository)evt.getSource();
            this.clientCache.invalidate((Object)new RepositoryKey(taskRepository));
        };
        this.repositoryChangeListener4ConfigurationCache = evt -> {
            if (this.ignoredProperty(evt.getPropertyName()) || evt.getPropertyName().equals("org.eclipse.mylyn.tasklist.repositories.password")) {
                return;
            }
            TaskRepository taskRepository = (TaskRepository)evt.getSource();
            this.configurationCache.invalidate((Object)new RepositoryKey(taskRepository));
        };
    }

    public GitlabConfiguration getRepositoryConfiguration(TaskRepository repository) throws CoreException {
        long startTime = 0L;
        long endTime = 0L;
        Object traceExitResult = "";
        if (GitlabCoreActivator.DEBUG_REPOSITORY_CONNECTOR) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry(null, (Object)repository.getUrl());
        }
        if (this.clientCache.getIfPresent((Object)new RepositoryKey(repository)) == null) {
            this.getClient(repository);
        }
        try {
            Optional configurationOptional;
            GitlabConfiguration result;
            if (GitlabCoreActivator.DEBUG_REPOSITORY_CONNECTOR) {
                startTime = System.currentTimeMillis();
            }
            GitlabConfiguration gitlabConfiguration = result = (configurationOptional = (Optional)this.configurationCache.get((Object)new RepositoryKey(repository))).isPresent() ? (GitlabConfiguration)configurationOptional.get() : null;
            if (GitlabCoreActivator.DEBUG_REPOSITORY_CONNECTOR) {
                endTime = System.currentTimeMillis();
                traceExitResult = result.toString() + " " + (endTime - startTime) + " ms";
            }
            GitlabConfiguration gitlabConfiguration2 = result;
            return gitlabConfiguration2;
        }
        finally {
            if (GitlabCoreActivator.DEBUG_REPOSITORY_CONNECTOR) {
                GitlabCoreActivator.DEBUG_TRACE.traceExit(null, traceExitResult);
            }
        }
    }

    public boolean canCreateNewTask(@NonNull TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(@NonNull TaskRepository repository) {
        return false;
    }

    public @Nullable String getRepositoryUrlFromTaskUrl(@NonNull String taskUrl) {
        throw new UnsupportedOperationException();
    }

    public @Nullable String getTaskIdFromTaskUrl(@NonNull String taskUrl) {
        throw new UnsupportedOperationException();
    }

    public @Nullable String getTaskUrl(@NonNull String repositoryUrl, @NonNull String taskIdOrKey) {
        throw new UnsupportedOperationException();
    }

    public boolean hasTaskChanged(@NonNull TaskRepository taskRepository, @NonNull ITask task, @NonNull TaskData taskData) {
        String lastKnownLocalModValue = task.getModificationDate() != null ? this.simpleFormatter.format(task.getModificationDate()) : "";
        TaskAttribute latestRemoteModAttribute = taskData.getRoot().getMappedAttribute("task.common.date.modified");
        String latestRemoteModValue = latestRemoteModAttribute != null ? latestRemoteModAttribute.getValue() : null;
        return !Objects.equals(latestRemoteModValue, lastKnownLocalModValue);
    }

    public void updateRepositoryConfiguration(@NonNull TaskRepository taskRepository, @NonNull IProgressMonitor monitor) throws CoreException {
        context.set((IOperationMonitor)(monitor != null ? OperationUtil.convert((IProgressMonitor)monitor) : new NullOperationMonitor()));
        this.configurationCache.invalidate((Object)new RepositoryKey(taskRepository));
        this.getRepositoryConfiguration(taskRepository);
        context.remove();
    }

    public String getConnectorKind() {
        return "org.eclipse.mylyn.gitlab";
    }

    public String getLabel() {
        return "Gitlab";
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add(taskId);
        SingleTaskDataCollector singleTaskDataCollector = new SingleTaskDataCollector();
        this.getTaskDataHandler().getMultiTaskData(repository, taskIds, (TaskDataCollector)singleTaskDataCollector, monitor);
        if (singleTaskDataCollector.getTaskData() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "Task data could not be retrieved. Please re-synchronize task"));
        }
        return singleTaskDataCollector.getTaskData();
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        monitor.beginTask("performQuery", -1);
        try {
            GitlabRestClient client = this.getClient(repository);
            IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"performQuery", (int)3);
            client.getIssues(query, collector, (IOperationMonitor)new NullOperationMonitor());
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.mylyn.gitlab.core", 1, "CoreException from performQuery", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper scheme = this.getTaskMapping(taskData);
        scheme.applyTo(task);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return new GitlabTaskDataHandler(this);
    }

    public RepositoryInfo validateRepository(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            GitlabRestClient client = this.createClient(repository);
            if (!client.validate(OperationUtil.convert((IProgressMonitor)monitor))) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "repository is invalide"));
            }
            return new RepositoryInfo(new RepositoryVersion(client.getVersion(OperationUtil.convert((IProgressMonitor)monitor))));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", e.getMessage(), (Throwable)e));
        }
    }

    public GitlabRestClient getClient(TaskRepository repository) throws CoreException {
        return (GitlabRestClient)this.clientCache.get((Object)new RepositoryKey(repository));
    }

    public GitlabRestClient createClient(TaskRepository repository) {
        RepositoryLocation location = new RepositoryLocation(this.convertProperties(repository));
        org.eclipse.mylyn.commons.net.AuthenticationCredentials credentials1 = repository.getCredentials(AuthenticationType.REPOSITORY);
        UserCredentials credentials = new UserCredentials(credentials1.getUserName(), credentials1.getPassword(), null, true);
        location.setCredentials(org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType.REPOSITORY, (AuthenticationCredentials)credentials);
        GitlabRestClient client = new GitlabRestClient(location, this, repository);
        return client;
    }

    private Map<String, String> convertProperties(TaskRepository repository) {
        return repository.getProperties().entrySet().stream().collect(Collectors.toMap(e -> this.convertProperty((String)e.getKey()), Map.Entry::getValue));
    }

    private String convertProperty(String key) {
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.usedefault".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.usedefault";
        }
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.hostname".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.host";
        }
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.port".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.port";
        }
        return key;
    }

    public TaskMapper getTaskMapping(final TaskData taskData) {
        return new TaskMapper(taskData){

            public String getTaskKey() {
                TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(GitlabTaskSchema.getDefault().TASK_KEY.getKey());
                if (attribute != null) {
                    return attribute.getValue();
                }
                return super.getTaskKey();
            }

            public String getTaskKind() {
                return taskData.getConnectorKind();
            }
        };
    }

    public byte[] getAvatarData(String url) {
        return (byte[])this.avatarCache.get((Object)url);
    }

    public class RepositoryKey {
        private final TaskRepository repository;

        public RepositoryKey(TaskRepository repository) {
            this.repository = repository;
        }

        public TaskRepository getRepository() {
            return this.repository;
        }

        public int hashCode() {
            return this.repository.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.repository.equals((Object)((RepositoryKey)obj).getRepository());
        }
    }

    public class SingleTaskDataCollector
    extends TaskDataCollector {
        final TaskData[] retrievedData = new TaskData[1];

        public void accept(TaskData taskData) {
            this.retrievedData[0] = taskData;
        }

        public TaskData getTaskData() {
            return this.retrievedData[0];
        }
    }
}

