/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.util.LabelComparator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.github.core.QueryUtils;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.ui.GitHubImages;
import org.eclipse.mylyn.internal.github.ui.GitHubRepositoryQueryPage;
import org.eclipse.mylyn.internal.github.ui.issue.IssueConnectorUi;
import org.eclipse.mylyn.internal.github.ui.issue.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class IssueRepositoryQueryPage
extends GitHubRepositoryQueryPage {
    private Button openButton;
    private Button closedButton;
    private Text titleText;
    private Text assigneeText;
    private Text mentionText;
    private Combo milestoneCombo;
    private CheckboxTableViewer labelsViewer;
    private List<Milestone> milestones;
    private SelectionListener completeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IssueRepositoryQueryPage.this.setPageComplete(IssueRepositoryQueryPage.this.isPageComplete());
        }
    };

    public IssueRepositoryQueryPage(String pageName, TaskRepository taskRepository, IRepositoryQuery query) {
        super(pageName, taskRepository, query);
        this.setDescription(Messages.IssueRepositoryQueryPage_Description);
        this.setPageComplete(false);
    }

    public IssueRepositoryQueryPage(TaskRepository taskRepository, IRepositoryQuery query) {
        this("issueQueryPage", taskRepository, query);
    }

    private void createLabelsArea(Composite parent) {
        Group labelsArea = new Group(parent, 0);
        labelsArea.setText(Messages.IssueRepositoryQueryPage_LabelsLabel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)labelsArea);
        GridLayoutFactory.swtDefaults().applyTo((Composite)labelsArea);
        this.labelsViewer = CheckboxTableViewer.newCheckList((Composite)labelsArea, (int)2816);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 80).applyTo(this.labelsViewer.getControl());
        this.labelsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.labelsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return GitHubImages.get("org.eclipse.mylyn.github.uiOBJ_GITHUB_ISSUE_LABEL");
            }
        });
        this.labelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IssueRepositoryQueryPage.this.setPageComplete(IssueRepositoryQueryPage.this.isPageComplete());
            }
        });
    }

    private void createOptionsArea(Composite parent) {
        Composite optionsArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)optionsArea);
        Composite statusArea = new Composite(optionsArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).applyTo(statusArea);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)statusArea);
        new org.eclipse.swt.widgets.Label(statusArea, 0).setText(Messages.IssueRepositoryQueryPage_StatusLabel);
        this.openButton = new Button(statusArea, 32);
        this.openButton.setSelection(true);
        this.openButton.setText(Messages.IssueRepositoryQueryPage_StatusOpen);
        this.openButton.addSelectionListener(this.completeListener);
        this.closedButton = new Button(statusArea, 32);
        this.closedButton.setSelection(true);
        this.closedButton.setText(Messages.IssueRepositoryQueryPage_StatusClosed);
        this.closedButton.addSelectionListener(this.completeListener);
        ToolBar toolbar = new ToolBar(statusArea, 0x800000);
        ToolItem updateItem = new ToolItem(toolbar, 8);
        final Image updateImage = TasksUiImages.REPOSITORY_UPDATE_CONFIGURATION.createImage();
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                updateImage.dispose();
            }
        });
        updateItem.setImage(updateImage);
        updateItem.setToolTipText(Messages.IssueRepositoryQueryPage_TooltipUpdateRepository);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)toolbar);
        updateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueRepositoryQueryPage.this.refreshRepository();
            }
        });
        org.eclipse.swt.widgets.Label milestonesLabel = new org.eclipse.swt.widgets.Label(optionsArea, 0);
        milestonesLabel.setText(Messages.IssueRepositoryQueryPage_MilestoneLabel);
        this.milestoneCombo = new Combo(optionsArea, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.milestoneCombo);
        org.eclipse.swt.widgets.Label assigneeLabel = new org.eclipse.swt.widgets.Label(optionsArea, 0);
        assigneeLabel.setText(Messages.IssueRepositoryQueryPage_AssigneeLabel);
        this.assigneeText = new Text(optionsArea, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.assigneeText);
        org.eclipse.swt.widgets.Label mentionLabel = new org.eclipse.swt.widgets.Label(optionsArea, 0);
        mentionLabel.setText(Messages.IssueRepositoryQueryPage_MentionsLabel);
        this.mentionText = new Text(optionsArea, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mentionText);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        if (!this.inSearchContainer()) {
            Composite titleArea = new Composite(displayArea, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(titleArea);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)titleArea);
            new org.eclipse.swt.widgets.Label(titleArea, 0).setText(Messages.IssueRepositoryQueryPage_TitleLabel);
            this.titleText = new Text(titleArea, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.titleText);
            this.titleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IssueRepositoryQueryPage.this.setPageComplete(IssueRepositoryQueryPage.this.isPageComplete());
                }
            });
        }
        this.createOptionsArea(displayArea);
        this.createLabelsArea(displayArea);
        this.loadRepository();
        this.initialize();
        this.setControl((Control)displayArea);
    }

    private void initialize() {
        String mentioning;
        IRepositoryQuery query = this.getQuery();
        if (query == null) {
            return;
        }
        String milestoneNumber = query.getAttribute("milestone");
        if (milestoneNumber != null && this.milestones != null) {
            int index = 0;
            for (Milestone milestone : this.milestones) {
                ++index;
                if (!milestoneNumber.equals(Integer.toString(milestone.getNumber()))) continue;
                this.milestoneCombo.select(index);
                break;
            }
        }
        this.titleText.setText(query.getSummary());
        this.labelsViewer.setCheckedElements(QueryUtils.getAttributes((String)"labels", (IRepositoryQuery)query).toArray());
        List status = QueryUtils.getAttributes((String)"state", (IRepositoryQuery)query);
        this.closedButton.setSelection(status.contains("closed"));
        this.openButton.setSelection(status.contains("open"));
        String assignee = query.getAttribute("assignee");
        if (assignee != null) {
            this.assigneeText.setText(assignee);
        }
        if ((mentioning = query.getAttribute("mentioned")) != null) {
            this.mentionText.setText(mentioning);
        }
    }

    private boolean updateLabels() {
        TaskRepository repository;
        if (this.labelsViewer.getControl().isDisposed()) {
            return false;
        }
        IssueConnector connector = IssueConnectorUi.getCoreConnector();
        boolean hasLabels = connector.hasCachedLabels(repository = this.getTaskRepository());
        if (hasLabels) {
            List labels = connector.getLabels(repository);
            Collections.sort(labels, new LabelComparator());
            ArrayList<String> labelNames = new ArrayList<String>(labels.size());
            for (Label label : labels) {
                labelNames.add(label.getName());
            }
            this.labelsViewer.setInput(labelNames);
        }
        return hasLabels;
    }

    private boolean updateMilestones() {
        TaskRepository repository;
        if (this.milestoneCombo.isDisposed()) {
            return false;
        }
        IssueConnector connector = IssueConnectorUi.getCoreConnector();
        boolean hasMilestones = connector.hasCachedMilestones(repository = this.getTaskRepository());
        if (hasMilestones) {
            this.milestones = connector.getMilestones(repository);
            this.milestoneCombo.removeAll();
            this.milestoneCombo.add(Messages.IssueRepositoryQueryPage_MilestoneNone);
            Collections.sort(this.milestones, Comparator.comparing(Milestone::getTitle, String.CASE_INSENSITIVE_ORDER));
            for (Milestone milestone : this.milestones) {
                this.milestoneCombo.add(milestone.getTitle());
            }
            this.milestoneCombo.select(0);
        }
        return hasMilestones;
    }

    private void refreshRepository() {
        try {
            ICoreRunnable runnable = new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Policy.monitorFor((IProgressMonitor)monitor);
                    monitor.beginTask("", 2);
                    IssueConnector connector = IssueConnectorUi.getCoreConnector();
                    TaskRepository repository = IssueRepositoryQueryPage.this.getTaskRepository();
                    monitor.setTaskName(Messages.IssueRepositoryQueryPage_TaskLoadingLabels);
                    connector.refreshLabels(repository);
                    monitor.worked(1);
                    monitor.setTaskName(Messages.IssueRepositoryQueryPage_TaskLoadingMilestones);
                    connector.refreshMilestones(repository);
                    monitor.done();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IssueRepositoryQueryPage.this.updateLabels();
                            IssueRepositoryQueryPage.this.updateMilestones();
                            IssueRepositoryQueryPage.this.initialize();
                        }
                    });
                }
            };
            Object context = this.getContainer();
            if (context == null) {
                context = this.inSearchContainer() ? this.getSearchContainer().getRunnableContext() : PlatformUI.getWorkbench().getProgressService();
            }
            CommonUiUtil.run((IRunnableContext)context, (ICoreRunnable)runnable);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.IssueRepositoryQueryPage_ErrorLoading, (String)e.getLocalizedMessage(), (IStatus)status);
        }
    }

    private void loadRepository() {
        boolean labelsLoaded = this.updateLabels();
        boolean milestonesLoaded = this.updateMilestones();
        if (!labelsLoaded || !milestonesLoaded) {
            this.refreshRepository();
        }
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = this.inSearchContainer() ? true : super.isPageComplete();
        if (complete) {
            String message = null;
            if (!this.openButton.getSelection() && !this.closedButton.getSelection()) {
                message = Messages.IssueRepositoryQueryPage_ErrorStatus;
            }
            this.setErrorMessage(message);
            complete = message == null;
        }
        return complete;
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        LinkedList<String> statuses = new LinkedList<String>();
        if (this.openButton.getSelection()) {
            statuses.add("open");
        }
        if (this.closedButton.getSelection()) {
            statuses.add("closed");
        }
        QueryUtils.setAttribute((String)"state", statuses, (IRepositoryQuery)query);
        String assignee = this.assigneeText.getText().trim();
        if (assignee.length() > 0) {
            query.setAttribute("assignee", assignee);
        } else {
            query.setAttribute("assignee", null);
        }
        String mentions = this.mentionText.getText().trim();
        if (mentions.length() > 0) {
            query.setAttribute("mentioned", mentions);
        } else {
            query.setAttribute("mentioned", null);
        }
        int milestoneSelected = this.milestoneCombo.getSelectionIndex() - 1;
        if (milestoneSelected >= 0) {
            query.setAttribute("milestone", Integer.toString(this.milestones.get(milestoneSelected).getNumber()));
        } else {
            query.setAttribute("milestone", null);
        }
        LinkedList<String> labels = new LinkedList<String>();
        Object[] objectArray = this.labelsViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object label = objectArray[n2];
            labels.add(label.toString());
            ++n2;
        }
        QueryUtils.setAttribute((String)"labels", labels, (IRepositoryQuery)query);
    }
}

