/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting.preferences;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.ide.formatting.preferences.TabFactory;
import org.eclipse.xtend.ide.internal.XtendActivator;

public class FormatterModifyDialog
extends ModifyDialog {
    @Inject
    private TabFactory tabFactory;
    private static final String DS_KEY_LAST_FOCUS = "modify_dialog.last_focus";
    private final List<IModifyDialogTabPage> fTabPages = new ArrayList<IModifyDialogTabPage>();
    private final ProfileManager.Profile fProfile;
    private final String fKeyLastFocus;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;

    public FormatterModifyDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile, String dialogPreferencesKey, String lastSavePathKey) {
        super(parentShell, profile, profileManager, profileStore, newProfile, dialogPreferencesKey, lastSavePathKey);
        this.fProfile = profile;
        this.fKeyLastFocus = "org.eclipse.jdt.ui" + dialogPreferencesKey + DS_KEY_LAST_FOCUS;
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    protected void addPages(Map values) {
        this.addTabPageNewAPI("Braces", this.tabFactory.createBracesTab((IModifyDialogTabPage.IModificationListener)this, values));
        this.addTabPageNewAPI("White Space", this.tabFactory.createWhiteSpaceTab((IModifyDialogTabPage.IModificationListener)this, values));
        this.addTabPageNewAPI("Blank Lines", this.tabFactory.createBlankLinesTab((IModifyDialogTabPage.IModificationListener)this, values));
        this.addTabPageNewAPI("New Lines", this.tabFactory.createNewLineTab((IModifyDialogTabPage.IModificationListener)this, values));
        this.addTabPageNewAPI("Line Wrapping", this.tabFactory.createLineWrapTab((IModifyDialogTabPage.IModificationListener)this, values));
    }

    private final void addTabPageNewAPI(String title, IModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        FormatterModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(this.fKeyLastFocus);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException x) {
            lastFocusNr = 0;
        }
        try {
            Field fNewProfile = ModifyDialog.class.getDeclaredField("fNewProfile");
            fNewProfile.setAccessible(true);
            if (!fNewProfile.getBoolean((Object)this)) {
                this.fTabFolder.setSelection(lastFocusNr);
                ((IModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            XtendActivator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.xtend.ide", e.getMessage(), (Throwable)e));
        }
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            FormatterModifyDialog.applyDialogFont((Control)composite);
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            nameComposite.setLayout((Layout)new GridLayout(3, false));
            Field fProfileNameField = ModifyDialog.class.getDeclaredField("fProfileNameField");
            fProfileNameField.setAccessible(true);
            StringDialogField f = new StringDialogField();
            fProfileNameField.set((Object)this, f);
            f.setLabelText("&Profile name:");
            f.setText(this.fProfile.getName());
            f.getLabelControl(nameComposite).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            f.getTextControl(nameComposite).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            f.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    try {
                        Method doValidate = ModifyDialog.class.getDeclaredMethod("doValidate", new Class[0]);
                        doValidate.setAccessible(true);
                        doValidate.invoke((Object)FormatterModifyDialog.this, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        XtendActivator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.xtend.ide", e.getMessage(), (Throwable)e));
                    }
                }
            });
            Field fSaveButton = ModifyDialog.class.getDeclaredField("fSaveButton");
            fSaveButton.setAccessible(true);
            fSaveButton.set((Object)this, this.createButton(nameComposite, 1025, "E&xport...", false));
            this.fTabFolder = new TabFolder(composite, 0);
            this.fTabFolder.setFont(composite.getFont());
            this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            Field fWorkingValues = ModifyDialog.class.getDeclaredField("fWorkingValues");
            fWorkingValues.setAccessible(true);
            this.addPages((Map)fWorkingValues.get((Object)this));
            FormatterModifyDialog.applyDialogFont((Control)composite);
            this.fTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    TabItem tabItem = (TabItem)e.item;
                    IModifyDialogTabPage page = (IModifyDialogTabPage)tabItem.getData();
                    FormatterModifyDialog.this.fDialogSettings.put(FormatterModifyDialog.this.fKeyLastFocus, FormatterModifyDialog.this.fTabPages.indexOf(page));
                    page.makeVisible();
                }
            });
            Method doValidate = ModifyDialog.class.getDeclaredMethod("doValidate", new Class[0]);
            doValidate.setAccessible(true);
            doValidate.invoke((Object)this, new Object[0]);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpContextId());
            return composite;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            XtendActivator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.xtend.ide", e.getMessage(), (Throwable)e));
            return null;
        }
    }

    protected String getHelpContextId() {
        return null;
    }

    public static class Factory {
        @Inject
        MembersInjector<FormatterModifyDialog> injector;

        public FormatterModifyDialog create(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile, String dialogPreferencesKey, String lastSavePathKey) {
            FormatterModifyDialog modifyDialog = new FormatterModifyDialog(parentShell, profile, profileManager, profileStore, newProfile, dialogPreferencesKey, lastSavePathKey);
            this.injector.injectMembers((Object)modifyDialog);
            return modifyDialog;
        }
    }
}

