/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.document;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceSerializer;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.ui.contentassist.WhitespaceHelper;

public class DocumentSourceAppender
implements ISourceAppender {
    private int baseIndentLevel = 0;
    private String indentString = "  ";
    private String lineSeparator = "\n";
    private LightweightTypeReferenceSerializer lightweightTypeReferenceSerializer;
    private boolean isJava;
    private StringBuilder builder = new StringBuilder(8192);
    private int currentIndentLevel = 0;
    private final IXtextDocument document;
    private final WhitespaceHelper whitespaceHelper;
    private final RewritableImportSection importSection;

    public DocumentSourceAppender(IXtextDocument document, RewritableImportSection importSection, WhitespaceHelper whitespaceHelper, String indentString, String lineSeparator, int baseIndentationLevel, boolean isJava) {
        this.baseIndentLevel = baseIndentationLevel;
        this.indentString = indentString;
        this.currentIndentLevel = baseIndentationLevel;
        this.lineSeparator = lineSeparator;
        this.lightweightTypeReferenceSerializer = this.createLightweightTypeReferenceSerializer();
        this.isJava = isJava;
        this.document = document;
        this.importSection = importSection;
        this.whitespaceHelper = whitespaceHelper;
    }

    protected LightweightTypeReferenceSerializer createLightweightTypeReferenceSerializer() {
        return new LightweightTypeReferenceSerializer((ISourceAppender)this);
    }

    public int getBaseIndentLevel() {
        return this.baseIndentLevel;
    }

    protected int getCurrentIndentLevel() {
        return this.currentIndentLevel;
    }

    protected CharSequence getIndentationString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append(this.lineSeparator);
        int i = 0;
        while (i < this.currentIndentLevel) {
            sb.append(this.indentString);
            ++i;
        }
        return sb.toString();
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }

    public boolean isJava() {
        return this.isJava;
    }

    public IXtextDocument getDocument() {
        return this.document;
    }

    public RewritableImportSection getImportSection() {
        return this.importSection;
    }

    public ISourceAppender append(JvmType type) {
        this.appendType(type, this.builder);
        return this;
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.getInnerTypeSeparator()));
        } else if (type instanceof JvmArrayType) {
            this.appendType((JvmType)((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String qualifiedName = type.getQualifiedName(this.getInnerTypeSeparator());
            String simpleName = type.getSimpleName();
            JvmDeclaredType importedType = this.getImportedType(type);
            if (importedType == type) {
                builder.append(simpleName);
            } else if (importedType == null) {
                this.importSection.addImport((JvmDeclaredType)type);
                builder.append(simpleName);
            } else {
                builder.append(qualifiedName);
            }
        }
    }

    protected JvmDeclaredType getImportedType(JvmType type) {
        List importedTypes = this.importSection.getImportedTypes(type.getSimpleName());
        if (importedTypes == null) {
            return null;
        }
        for (JvmDeclaredType importedType : importedTypes) {
            if (importedType != type) continue;
            return importedType;
        }
        return (JvmDeclaredType)IterableExtensions.lastOrNull((Iterable)importedTypes);
    }

    protected char getInnerTypeSeparator() {
        return '.';
    }

    public ISourceAppender append(LightweightTypeReference typeRef) {
        typeRef.accept((TypeReferenceVisitor)this.lightweightTypeReferenceSerializer);
        return this;
    }

    public void append(CharSequence content, int indentationDelta) {
        if (indentationDelta < 0) {
            this.append(content.toString().replaceAll(Pattern.quote(this.getLineSeparator() + this.indentString(-indentationDelta)), this.getLineSeparator()));
        } else if (indentationDelta > 0) {
            this.append(content.toString().replaceAll(Pattern.quote(this.getLineSeparator()), this.getLineSeparator() + this.indentString(indentationDelta)));
        } else {
            this.append(content);
        }
    }

    protected String indentString(int indentLevel) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indentLevel) {
            sb.append(this.indentString);
            ++i;
        }
        return sb.toString();
    }

    public ISourceAppender append(CharSequence string) {
        String replaced = string.toString().replace(this.lineSeparator, this.getIndentationString());
        this.builder.append(replaced);
        return this;
    }

    public ISourceAppender newLine() {
        this.builder.append(this.getIndentationString());
        return this;
    }

    public ISourceAppender increaseIndentation() {
        ++this.currentIndentLevel;
        return this;
    }

    public ISourceAppender decreaseIndentation() {
        if (this.currentIndentLevel == 0) {
            throw new IllegalStateException("Can't reduce indentation level. It's already zero.");
        }
        --this.currentIndentLevel;
        return this;
    }

    public int length() {
        return this.builder.length();
    }

    public String toString() {
        return this.builder.toString();
    }

    public String getCode() {
        StringBuilder builder = new StringBuilder();
        if (this.whitespaceHelper.getPrefix() != null) {
            builder.append(this.whitespaceHelper.getPrefix().replace(this.getLineSeparator(), this.getIndentationString()));
        }
        builder.append(this.toString());
        if (this.whitespaceHelper.getSuffix() != null) {
            builder.append(this.whitespaceHelper.getSuffix().replace(this.getLineSeparator(), this.getIndentationString()));
        }
        return builder.toString();
    }

    public ReplaceRegion getChange() {
        return new ReplaceRegion(this.whitespaceHelper.getTotalOffset(), this.whitespaceHelper.getTotalLength(), this.getCode());
    }

    public ReplaceRegion getChange(int offset, int length) {
        int actualOffset = Math.min(this.whitespaceHelper.getTotalOffset(), offset);
        int endOffset = Math.max(this.whitespaceHelper.getTotalOffset() + this.whitespaceHelper.getTotalLength(), offset + length);
        return new ReplaceRegion(actualOffset, endOffset - actualOffset, this.getCode());
    }

    public int getTotalOffset() {
        return this.whitespaceHelper.getTotalOffset();
    }

    public int getTotalLength() {
        return this.whitespaceHelper.getTotalLength();
    }

    public static abstract class Factory<T extends DocumentSourceAppender> {
        private static final Logger LOG = Logger.getLogger(Factory.class);
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;
        @Inject
        private Provider<WhitespaceHelper> whitespaceHelperProvider;
        @Inject
        private RewritableImportSection.Factory rewritableImportSectionFactory;

        protected abstract T newInstance(IXtextDocument var1, RewritableImportSection var2, WhitespaceHelper var3, String var4, String var5, int var6, boolean var7);

        public T create(IXtextDocument document, XtextResource resource, int offset, int length) {
            return this.create(document, resource, offset, length, new OptionalParameters());
        }

        public T create(IXtextDocument document, XtextResource resource, int offset, int length, OptionalParameters params) {
            int baseIndentationLevel = params.baseIndentationLevel != -1 ? params.baseIndentationLevel : this.getIndentationLevelAtOffset(offset, (IDocument)document, resource);
            RewritableImportSection importSection = params.importSection != null ? params.importSection : this.rewritableImportSectionFactory.parse(resource);
            String indentString = this.getIndentString(resource);
            String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
            WhitespaceHelper whitespaceHelper = (WhitespaceHelper)this.whitespaceHelperProvider.get();
            whitespaceHelper.initialize((IDocument)document, offset, length, params.ensureEmptyLinesAround);
            T appendable = this.newInstance(document, importSection, whitespaceHelper, indentString, lineSeparator, baseIndentationLevel, params.isJava);
            return appendable;
        }

        protected String getIndentString(XtextResource resource) {
            return this.whitespaceInformationProvider.getIndentationInformation(resource.getURI()).getIndentString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getIndentationLevelAtOffset(int offset, IDocument document, XtextResource resource) {
            try {
                if (offset <= 0) {
                    return 0;
                }
                int currentOffset = offset - 1;
                char currentChr = document.getChar(currentOffset);
                int indentationOffset = 0;
                if (currentChr == '\n' || currentChr == '\r') {
                    if (--currentOffset < 0) {
                        return 0;
                    }
                    currentChr = document.getChar(currentOffset);
                }
                while (true) {
                    if (currentChr == '\n' || currentChr == '\r' || currentOffset <= 0) {
                        return indentationOffset / this.getIndentString(resource).length();
                    }
                    indentationOffset = Character.isWhitespace(currentChr) ? ++indentationOffset : 0;
                    currentChr = document.getChar(--currentOffset);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error calculating indentation at offset", (Throwable)e);
                return 0;
            }
        }

        public static class OptionalParameters {
            public boolean isJava;
            public boolean ensureEmptyLinesAround;
            public int baseIndentationLevel = -1;
            public RewritableImportSection importSection;
        }
    }
}

