/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleHandle {
    private final String className;
    private final String simpleName;
    private final List<String> usedPackages;

    ModuleHandle(String className, String moduleName, List<String> usedPackages) {
        if (className == null || usedPackages == null || moduleName == null) {
            throw new IllegalArgumentException();
        }
        this.className = className;
        this.simpleName = moduleName;
        this.usedPackages = Collections.unmodifiableList(new ArrayList<String>(usedPackages));
    }

    public String getModuleName() {
        return this.simpleName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public List<String> getUsedPackages() {
        return this.usedPackages;
    }

    public Class<?> getModuleJavaClass() throws ClassNotFoundException {
        return Class.forName(this.className);
    }

    public String toString() {
        return String.valueOf(this.simpleName) + ", javaClass: " + this.className;
    }
}

