/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.internal.qvt.oml.common.project.DeployedTransformation;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.CommonPluginImages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.AbstractDeferredAdapter;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.QvtDeployedTransformationLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class UniSelectTransformationControl
extends Composite {
    public static final IResourceFilter QVTO_FILE_FILTER = new IResourceFilter(){

        public boolean accept(IResource resource) {
            return resource instanceof IFile && "qvto".equalsIgnoreCase(resource.getFileExtension());
        }
    };
    private final ViewerFilter VIEWER_FILTER = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return this.hasMatchingChildrenRecursive((IContainer)element, UniSelectTransformationControl.this.myResourceFilter);
            }
            if (element instanceof IResource) {
                return this.resourceMatches(UniSelectTransformationControl.this.myResourceFilter, (IResource)element);
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasMatchingChildrenRecursive(IContainer container, IResourceFilter filter) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (true) {
                    boolean has;
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (this.resourceMatches(filter, member)) {
                        return true;
                    }
                    if (member instanceof IContainer && (has = this.hasMatchingChildrenRecursive((IContainer)member, filter))) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private boolean resourceMatches(IResourceFilter filter, IResource member) {
            return filter == null || filter.accept(member);
        }
    };
    private static final ViewerSorter VIEWER_SORTER = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean folderLeft = e1 instanceof IContainer;
            boolean folderRight = e2 instanceof IContainer;
            if (folderLeft == folderRight) {
                return super.compare(viewer, e1, e2);
            }
            return folderLeft ? -1 : 1;
        }
    };
    private final ISelectionChangedListener VIEWER_LISTENER = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            UniSelectTransformationControl.this.myFileNameText.setText("");
            UniSelectTransformationControl.this.myUri = null;
            if (selection != null && selection.getFirstElement() instanceof IFile) {
                IFile ifile = (IFile)selection.getFirstElement();
                UniSelectTransformationControl.this.myUri = URI.createPlatformResourceURI((String)ifile.getFullPath().toOSString(), (boolean)false);
                UniSelectTransformationControl.this.myFileNameText.setText(UniSelectTransformationControl.this.myUri.toString());
            } else if (selection != null && selection.getFirstElement() instanceof DeployedTransformation) {
                DeployedTransformation transf = (DeployedTransformation)selection.getFirstElement();
                UniSelectTransformationControl.this.myUri = transf.getUri();
                UniSelectTransformationControl.this.myFileNameText.setText(UniSelectTransformationControl.this.myUri.toString());
            }
            UniSelectTransformationControl.this.fileSelectionChanged(UniSelectTransformationControl.this.myUri);
        }
    };
    private final TreeViewer myViewer;
    private Text myFileNameText;
    private final IResourceFilter myResourceFilter;
    private final ISelectionListener mySelectionListener;
    private URI myUri;
    private final List<DeployedTransformation> myDeployedTransformations;
    private final DeferredTreeContentManager myContentManager;
    private static final int DEFAUL_AUTO_EXPAND_LEVEL = 2;

    public UniSelectTransformationControl(Composite parentComposite, IResourceFilter resourceFilter, TransformationRegistry transfRegistry, TransformationRegistry.Filter transfFilter, ISelectionListener listener) {
        super(parentComposite, 0);
        this.myResourceFilter = resourceFilter;
        this.mySelectionListener = listener;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        ArrayList<ITreeContentProviderEx> contentProviders = new ArrayList<ITreeContentProviderEx>(2);
        contentProviders.add(new WorkspaceContentProvider());
        contentProviders.add(new DeployedTransformationContentProvider());
        ArrayList<ILabelProviderEx> labelProviders = new ArrayList<ILabelProviderEx>(3);
        labelProviders.add(new LabelProviderDelegate((ILabelProvider)new WorkbenchLabelProvider()){

            public boolean canHandle(Object element) {
                return element instanceof IResource;
            }
        });
        labelProviders.add(new LabelProviderDelegate((ILabelProvider)new QvtDeployedTransformationLabelProvider()){

            public boolean canHandle(Object element) {
                return element instanceof DeployedTransformation || element instanceof DeployedTransformationRoot;
            }

            public String getText(Object element) {
                if (element instanceof DeployedTransformationRoot) {
                    return Messages.UniSelectTransformationControl_DeployedTransformations;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof DeployedTransformationRoot) {
                    return CommonPluginImages.getInstance().getImage("registry");
                }
                return super.getImage(element);
            }
        });
        labelProviders.add(new ILabelProviderEx(){

            public boolean canHandle(Object element) {
                return element instanceof PendingUpdateAdapter;
            }

            public Image getImage(Object element) {
                return CommonPluginImages.getInstance().getImage("activity");
            }

            public String getText(Object element) {
                return Messages.UniSelectTransformationControl_fetchingTransformations;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.myViewer = new TreeViewer((Composite)this, 2820);
        this.myViewer.setContentProvider((IContentProvider)new CompositeContentProvider(contentProviders));
        this.myViewer.setLabelProvider((IBaseLabelProvider)new CompositeLabelProvider(labelProviders));
        this.myViewer.setAutoExpandLevel(2);
        this.myViewer.addFilter(this.VIEWER_FILTER);
        this.myViewer.setSorter(VIEWER_SORTER);
        this.myViewer.addSelectionChangedListener(this.VIEWER_LISTENER);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 250;
        data.widthHint = 350;
        this.myViewer.getControl().setLayoutData((Object)data);
        this.myContentManager = new DeferredTreeContentManager((AbstractTreeViewer)this.myViewer){

            protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
                WorkbenchJob updateJob = new WorkbenchJob(Messages.UniSelectTransformationControl_addingTransformations){

                    public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                        if (UniSelectTransformationControl.this.myViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        UniSelectTransformationControl.this.myViewer.add(parent, children);
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
                try {
                    updateJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        ArrayList<Object> inputs = new ArrayList<Object>(2);
        inputs.add(ResourcesPlugin.getWorkspace().getRoot());
        this.myDeployedTransformations = transfRegistry.getTransformations(transfFilter);
        inputs.add(new DeployedTransformationRoot(this.myDeployedTransformations));
        this.myViewer.setInput(inputs);
        TransformationControls.createLabel(this, Messages.UniSelectTransformationControl_CurrentSelection, 2);
        this.myFileNameText = new Text((Composite)this, 2048);
        this.myFileNameText.setEnabled(false);
        this.myFileNameText.setLayoutData((Object)new GridData(768));
    }

    public URI getSelectedUri() {
        return this.myUri;
    }

    public void selectTransformationByUri(String uriString) {
        URI uri = EmfUtil.makeUri((String)uriString);
        if (uri == null) {
            return;
        }
        if (uri.isPlatformPlugin()) {
            for (DeployedTransformation deployedTransf : this.myDeployedTransformations) {
                if (!deployedTransf.getUri().equals(uri)) continue;
                StructuredSelection sel = new StructuredSelection(new Object[]{deployedTransf});
                this.myViewer.setSelection((ISelection)sel);
                return;
            }
            String transfId = uri.toPlatformString(false).replace("/", "");
            for (DeployedTransformation deployedTransf : this.myDeployedTransformations) {
                if (!deployedTransf.getId().equals(transfId)) continue;
                StructuredSelection sel = new StructuredSelection(new Object[]{deployedTransf});
                this.myViewer.setSelection((ISelection)sel);
                return;
            }
        } else {
            IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uri);
            if (ifile != null) {
                StructuredSelection sel = new StructuredSelection(new Object[]{ifile});
                this.myViewer.setSelection((ISelection)sel);
            }
        }
    }

    private void fileSelectionChanged(URI selectedUri) {
        if (this.mySelectionListener != null) {
            try {
                this.mySelectionListener.selectionChanged(selectedUri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeContentProvider
    implements ITreeContentProvider {
        private final List<ITreeContentProviderEx> myProviders;

        CompositeContentProvider(List<ITreeContentProviderEx> providers) {
            this.myProviders = providers;
        }

        public Object[] getChildren(Object parentElement) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(parentElement)) continue;
                return provider.getChildren(parentElement);
            }
            return null;
        }

        public Object getParent(Object element) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.hasChildren(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(inputElement)) continue;
                return provider.getChildren(inputElement);
            }
            return null;
        }

        public void dispose() {
            for (ITreeContentProviderEx provider : this.myProviders) {
                provider.dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                provider.inputChanged(viewer, oldInput, newInput);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeLabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderEx> myProviders;

        CompositeLabelProvider(List<ILabelProviderEx> providers) {
            this.myProviders = providers;
        }

        public Image getImage(Object element) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getText(element);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.addListener(listener);
            }
        }

        public void dispose() {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.isLabelProperty(element, property);
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.removeListener(listener);
            }
        }
    }

    private class DeployedTransformationContentProvider
    implements ITreeContentProviderEx {
        private AbstractDeferredAdapter deployedTransformationAdapter;
        private IAdapterFactory deployedTransformationProviderFactory;

        private DeployedTransformationContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return UniSelectTransformationControl.this.myContentManager.mayHaveChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return UniSelectTransformationControl.this.myContentManager.getChildren(inputElement);
        }

        public void dispose() {
            this.deployedTransformationAdapter.cancel();
            IAdapterManager adapterManager = Platform.getAdapterManager();
            adapterManager.unregisterAdapters(this.deployedTransformationProviderFactory);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.deployedTransformationAdapter == null) {
                this.deployedTransformationAdapter = new AbstractDeferredAdapter(UniSelectTransformationControl.this.myViewer){

                    public String getLabel(Object o) {
                        return Messages.UniSelectTransformationControl_platformTransformations;
                    }

                    public Object[] getChildren(Object o) {
                        return ((DeployedTransformationRoot)o).getChildren();
                    }

                    public boolean isAccepted(Object object, IProgressMonitor monitor) {
                        if (UniSelectTransformationControl.this.mySelectionListener == null) {
                            return true;
                        }
                        return UniSelectTransformationControl.this.mySelectionListener.accept(((DeployedTransformation)object).getUri());
                    }

                    public ISelectionListener.TreeAction getTreeAction(Object object, IProgressMonitor monitor) {
                        if (UniSelectTransformationControl.this.mySelectionListener == null) {
                            return ISelectionListener.TreeAction.NONE;
                        }
                        return UniSelectTransformationControl.this.mySelectionListener.getTreeAction(((DeployedTransformation)object).getUri());
                    }
                };
                this.deployedTransformationProviderFactory = new IAdapterFactory(){

                    public Object getAdapter(Object adaptableObject, Class adapterType) {
                        return DeployedTransformationContentProvider.this.deployedTransformationAdapter;
                    }

                    public Class<?>[] getAdapterList() {
                        return new Class[]{IWorkbenchAdapter.class, IDeferredWorkbenchAdapter.class};
                    }
                };
                IAdapterManager adapterManager = Platform.getAdapterManager();
                adapterManager.registerAdapters(this.deployedTransformationProviderFactory, DeployedTransformationRoot.class);
            }
        }

        public boolean canHandle(Object element) {
            return element instanceof DeployedTransformation || element instanceof DeployedTransformationRoot;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeployedTransformationRoot {
        private final List<DeployedTransformation> myTrasformations;

        DeployedTransformationRoot(List<DeployedTransformation> trasformations) {
            this.myTrasformations = trasformations;
        }

        Object[] getChildren() {
            return this.myTrasformations.toArray();
        }
    }

    private static interface ILabelProviderEx
    extends ILabelProvider {
        public boolean canHandle(Object var1);
    }

    public static interface IResourceFilter {
        public boolean accept(IResource var1);
    }

    public static interface ISelectionListener {
        public boolean accept(URI var1);

        public TreeAction getTreeAction(URI var1);

        public IStatus selectionChanged(URI var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TreeAction {
            NONE,
            EXPAND,
            SELECT;

        }
    }

    private static interface ITreeContentProviderEx
    extends ITreeContentProvider {
        public boolean canHandle(Object var1);
    }

    private static abstract class LabelProviderDelegate
    implements ILabelProviderEx {
        private final ILabelProvider myDelegate;

        LabelProviderDelegate(ILabelProvider provider) {
            this.myDelegate = provider;
        }

        public Image getImage(Object element) {
            return this.myDelegate.getImage(element);
        }

        public String getText(Object element) {
            return this.myDelegate.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myDelegate.addListener(listener);
        }

        public void dispose() {
            this.myDelegate.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myDelegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myDelegate.removeListener(listener);
        }
    }

    public static abstract class SelectionListenerAdapter
    implements ISelectionListener {
        private final ISelectionListener delegate;

        public SelectionListenerAdapter(ISelectionListener delegate) {
            this.delegate = delegate;
        }

        public SelectionListenerAdapter() {
            this.delegate = null;
        }

        public boolean accept(URI uri) {
            if (this.delegate != null) {
                return this.delegate.accept(uri);
            }
            return true;
        }

        public ISelectionListener.TreeAction getTreeAction(URI uri) {
            if (this.delegate != null) {
                return this.delegate.getTreeAction(uri);
            }
            return ISelectionListener.TreeAction.NONE;
        }
    }

    private class WorkspaceContentProvider
    implements ITreeContentProviderEx {
        private AbstractDeferredAdapter workspaceContentAdapter;
        private IAdapterFactory workspaceContentProviderFactory;
        private final ITreeContentProvider myProvider = new WorkbenchContentProvider();

        private WorkspaceContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return this.myProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return false;
            }
            return UniSelectTransformationControl.this.myContentManager.mayHaveChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return UniSelectTransformationControl.this.myContentManager.getChildren(inputElement);
        }

        public void dispose() {
            this.myProvider.dispose();
            this.workspaceContentAdapter.cancel();
            IAdapterManager adapterManager = Platform.getAdapterManager();
            adapterManager.unregisterAdapters(this.workspaceContentProviderFactory);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.workspaceContentAdapter == null) {
                this.workspaceContentAdapter = new AbstractDeferredAdapter((TreeViewer)viewer){

                    public String getLabel(Object o) {
                        return Messages.UniSelectTransformationControl_workspaceTransformations;
                    }

                    public Object[] getChildren(Object o) {
                        return WorkspaceContentProvider.this.myProvider.getElements(o);
                    }

                    public boolean isAccepted(Object object, IProgressMonitor monitor) {
                        if (UniSelectTransformationControl.this.myResourceFilter == null || !UniSelectTransformationControl.this.myResourceFilter.accept((IResource)object)) {
                            return true;
                        }
                        if (UniSelectTransformationControl.this.mySelectionListener == null) {
                            return true;
                        }
                        URI uri = URIUtils.getResourceURI((IResource)((IResource)object));
                        return UniSelectTransformationControl.this.mySelectionListener.accept(uri);
                    }

                    public ISelectionListener.TreeAction getTreeAction(Object object, IProgressMonitor monitor) {
                        if (UniSelectTransformationControl.this.mySelectionListener == null) {
                            return ISelectionListener.TreeAction.NONE;
                        }
                        URI uri = URIUtils.getResourceURI((IResource)((IResource)object));
                        return UniSelectTransformationControl.this.mySelectionListener.getTreeAction(uri);
                    }
                };
                this.workspaceContentProviderFactory = new IAdapterFactory(){

                    public Object getAdapter(Object adaptableObject, Class adapterType) {
                        return WorkspaceContentProvider.this.workspaceContentAdapter;
                    }

                    public Class<?>[] getAdapterList() {
                        return new Class[]{IWorkbenchAdapter.class, IDeferredWorkbenchAdapter.class};
                    }
                };
                IAdapterManager adapterManager = Platform.getAdapterManager();
                adapterManager.registerAdapters(this.workspaceContentProviderFactory, IResource.class);
            }
            this.myProvider.inputChanged(viewer, oldInput, newInput);
        }

        public boolean canHandle(Object element) {
            return element instanceof IResource;
        }
    }
}

