/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ExecutionDiagnosticImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.Transformation;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;

public class CstTransformation
implements Transformation {
    private URI fURI;
    private EPackage.Registry fPackageRegistry;
    private CompiledUnit fCompiledUnit;
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fTransformation;
    private QVTOCompiler fCompiler;

    public CstTransformation(URI uri) {
        this(uri, null);
    }

    public CstTransformation(URI uri, EPackage.Registry packageRegistry) {
        if (uri == null) {
            throw new IllegalArgumentException("null transformation URI");
        }
        this.fURI = uri;
        this.fPackageRegistry = packageRegistry;
    }

    protected CompiledUnit getCompiledUnit(IProgressMonitor monitor) throws MdaException {
        if ("qvtox".equals(this.fURI.fileExtension())) {
            return new CompiledUnit(this.fURI, this.getResourceSet());
        }
        UnitProxy proxy = UnitResolverFactory.Registry.INSTANCE.getUnit(this.fURI);
        if (proxy == null) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.UnitNotFoundError, this.fURI));
            return null;
        }
        QVTOCompiler compiler = this.getCompiler();
        return compiler.compile(proxy, null, BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    private QVTOCompiler getCompiler() {
        if (this.fCompiler == null) {
            this.fCompiler = this.createCompiler();
        }
        return this.fCompiler;
    }

    protected QVTOCompiler createCompiler() {
        if (this.fPackageRegistry == null) {
            return CompilerUtils.createCompiler();
        }
        return QVTOCompiler.createCompiler(this.fPackageRegistry);
    }

    private void doLoad(IProgressMonitor monitor) {
        this.fLoadDiagnostic = ExecutionDiagnostic.OK_INSTANCE;
        try {
            this.fCompiledUnit = this.getCompiledUnit(monitor);
        }
        catch (MdaException e) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.FailedToCompileUnitError, this.fURI));
            this.fLoadDiagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        if (this.fCompiledUnit != null && EmfUtilPlugin.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
            this.fLoadDiagnostic = CstTransformation.createCompilationDiagnostic(this.fCompiledUnit);
            this.fTransformation = this.doGetTransformation();
            if (this.fTransformation == null) {
                this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.NotTransformationInUnitError, this.fURI));
                return;
            }
            ExecutionDiagnostic validForExecution = CstTransformation.checkIsExecutable(this.fTransformation);
            if (!EmfUtilPlugin.isSuccess((Diagnostic)validForExecution)) {
                this.fLoadDiagnostic = validForExecution;
            }
        }
    }

    private OperationalTransformation doGetTransformation() {
        if (this.fCompiledUnit == null) {
            return null;
        }
        List<Module> allModules = this.fCompiledUnit.getModules();
        for (Module module : allModules) {
            if (!(module instanceof OperationalTransformation)) continue;
            return (OperationalTransformation)module;
        }
        return null;
    }

    private static ExecutionDiagnostic createCompilationDiagnostic(CompiledUnit compiledUnit) {
        List<QvtMessage> errors = compiledUnit.getErrors();
        if (errors.isEmpty()) {
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        URI uri = compiledUnit.getURI();
        ExecutionDiagnosticImpl mainDiagnostic = new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.CompilationErrorsFoundInUnit, uri.toString()));
        for (QvtMessage message : errors) {
            mainDiagnostic.add(CompilerUtils.createProblemDiagnostic(uri, message));
        }
        return mainDiagnostic;
    }

    public OperationalTransformation getTransformation(IProgressMonitor monitor) {
        this.loadTransformation(monitor);
        return this.fTransformation;
    }

    private static ExecutionDiagnostic checkIsExecutable(OperationalTransformation transformation) {
        if (transformation.isIsBlackbox()) {
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        EList operations = transformation.getEOperations();
        for (EOperation oper : operations) {
            if (!(oper instanceof ImperativeOperation) || !"main".equals(oper.getName())) continue;
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        return new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.NoTransformationEntryPointError, transformation.getName()));
    }

    private Diagnostic loadTransformation(IProgressMonitor monitor) {
        try {
            if (this.fLoadDiagnostic == null) {
                this.doLoad(monitor);
            }
            ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
            return executionDiagnostic;
        }
        finally {
            monitor.done();
        }
    }

    public ExecutionDiagnostic getDiagnostic() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fLoadDiagnostic;
    }

    public URI getURI() {
        return this.fURI;
    }

    public ResourceSet getResourceSet() {
        return this.getCompiler().getResourceSet();
    }

    public CompiledUnit getUnit() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fCompiledUnit;
    }

    public void cleanup() {
        if (this.getResourceSet() != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.getResourceSet());
        }
    }
}

