/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.EmfUtilUiPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.ChooserNode;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.EPackageNode;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.metamodel.IEPackageNodeFactory;

public class MetamodelsNode
extends ChooserNode {
    private MetamodelRegistry registry;
    private EPackageNode[] myChildren;
    private final IEPackageNodeFactory myFactory;

    public MetamodelsNode(IEPackageNodeFactory factory, MetamodelRegistry metamodelRegistry) {
        super(null);
        this.myFactory = factory;
        this.registry = metamodelRegistry;
    }

    public boolean hasChildren() {
        return true;
    }

    public ChooserNode[] getChildren() {
        if (this.myChildren == null) {
            this.myChildren = this.getRootPackageNodes();
        }
        return this.myChildren;
    }

    private EPackageNode[] getRootPackageNodes() {
        EPackage[] roots = this.getRootPackages();
        EPackageNode[] nodes = new EPackageNode[roots.length];
        int i = 0;
        while (i < roots.length) {
            nodes[i] = this.myFactory.createNode(roots[i], this);
            ++i;
        }
        return nodes;
    }

    private EPackage[] getRootPackages() {
        ArrayList<EPackage> nodes = new ArrayList<EPackage>();
        String[] metamodelIds = this.registry.getMetamodelIds();
        int i = 0;
        while (i < metamodelIds.length) {
            String metamodelId = metamodelIds[i];
            try {
                IMetamodelDesc desc = this.registry.getMetamodelDesc(metamodelId);
                EPackage descPackage = desc.getModel();
                if (descPackage.getESuperPackage() == null) {
                    nodes.add(descPackage);
                }
            }
            catch (EmfException ignore) {
                Status status = new Status(4, "org.eclipse.m2m.qvt.oml.emf.util.ui", "Failed to get root EPackage:" + metamodelId, (Throwable)ignore);
                EmfUtilUiPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
        return nodes.toArray(new EPackage[nodes.size()]);
    }
}

