/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.ParsedModuleCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledModule {
    private final Module myModule;
    private final CFile mySource;
    private final List<QvtMessage> myWarnings;
    private final List<QvtMessage> myErrors;
    private final List<CompiledModule> myCompiledImports;
    private final ParsedModuleCS mySyntaxElement;

    public CompiledModule(Module module, ParsedModuleCS moduleCS, CFile source, List<QvtMessage> messages) {
        this.myModule = module;
        this.mySource = source;
        this.myWarnings = new ArrayList<QvtMessage>(2);
        this.myErrors = new ArrayList<QvtMessage>(2);
        for (QvtMessage m : messages) {
            this.addMessage(m);
        }
        this.myCompiledImports = new ArrayList<CompiledModule>(2);
        this.mySyntaxElement = moduleCS;
    }

    public Module getModule() {
        return this.myModule;
    }

    public CFile getSource() {
        return this.mySource;
    }

    public List<CompiledModule> getCompiledImports() {
        return this.myCompiledImports;
    }

    public ParsedModuleCS getSyntaxElement() {
        return this.mySyntaxElement;
    }

    public QvtMessage[] getErrors() {
        return this.myErrors.toArray(new QvtMessage[this.myErrors.size()]);
    }

    public QvtMessage[] getWarnings() {
        return this.myWarnings.toArray(new QvtMessage[this.myWarnings.size()]);
    }

    public QvtMessage[] getMessages() {
        ArrayList<QvtMessage> allMessages = new ArrayList<QvtMessage>(this.myWarnings);
        allMessages.addAll(this.myErrors);
        return allMessages.toArray(new QvtMessage[allMessages.size()]);
    }

    public void addMessage(QvtMessage m) {
        if (m.getSeverity() == 1) {
            this.myWarnings.add(m);
        } else {
            this.myErrors.add(m);
        }
    }
}

