/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.launch;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.IModelParameterInfo;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.BaseUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.UriChooserListener;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IChooser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UriGroupIn
extends BaseUriGroup {
    private final Text myUriText;
    private final Button myBrowseButton;
    private SelectionListener myActiveListener;

    public UriGroupIn(Composite parent, String name) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(name, 1);
        this.myUriText = TransformationControls.createText(this, 1);
        this.myUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UriGroupIn.this.fireModified();
            }
        });
        this.myBrowseButton = TransformationControls.createButton(this, Messages.BrowseButtonLabel);
        this.myBrowseButton.setEnabled(false);
        this.myBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UriGroupIn.this.myActiveListener != null) {
                    UriGroupIn.this.myActiveListener.widgetSelected(e);
                }
            }
        });
    }

    public void initializeFrom(TargetUriData uriData) {
        this.myUriText.setText(uriData.getUriString());
    }

    public TargetUriData getUriData() {
        return new TargetUriData(this.getText());
    }

    public String getText() {
        return this.myUriText.getText();
    }

    public void update(String uri, Shell shell) {
        if (uri == null) {
            this.myUriText.setEnabled(false);
            this.myBrowseButton.setEnabled(false);
            this.myActiveListener = null;
        } else {
            IMetamodelHandler handler = MetamodelHandlerManager.getInstance().getHandler(uri);
            if (handler == null) {
                throw new RuntimeException("No handler for URI " + uri);
            }
            this.myActiveListener = new UriChooserListener(this.myUriText, this.getChooser(handler), shell);
            this.myUriText.setEnabled(true);
            this.myBrowseButton.setEnabled(true);
        }
    }

    protected IChooser getChooser(IMetamodelHandler handler) {
        return handler.getSourceAdaptableChooser();
    }

    public void update(String moduleName, IModelParameterInfo paramInfo, Shell shell) {
        EClassifier classifier = paramInfo.getEntryParamType();
        if (classifier == null) {
            classifier = paramInfo.getMetamodel().eClass();
        }
        this.update(EmfUtil.getRootPackageUri((EClassifier)classifier), shell);
    }
}

