/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedQvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationUtil {
    public static final String DEFAULT_RESULT_EXTENSION = "psm";

    private TransformationUtil() {
    }

    public static void getErrors(CompiledModule module, List<QvtMessage> errors) {
        errors.addAll((Collection<QvtMessage>)Arrays.asList(module.getErrors()));
        for (CompiledModule imp : module.getCompiledImports()) {
            TransformationUtil.getErrors(imp, errors);
        }
    }

    public static void getWarnings(CompiledModule module, List<QvtMessage> warnings) {
        warnings.addAll((Collection<QvtMessage>)Arrays.asList(module.getWarnings()));
        for (CompiledModule imp : module.getCompiledImports()) {
            TransformationUtil.getWarnings(imp, warnings);
        }
    }

    public static QvtModule getQvtModule(URI uriTransf) throws MdaException {
        if (uriTransf == null) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_InvalidUri, (Object)uriTransf));
        }
        if (uriTransf.isPlatformPlugin()) {
            return new DeployedQvtModule(uriTransf.toPlatformString(false));
        }
        IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uriTransf);
        if (ifile == null || !ifile.exists()) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_InvalidUri, (Object)uriTransf));
        }
        return new WorkspaceQvtModule(ifile);
    }
}

