/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.EvaluationMonitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;

public class QVTiPivotEvaluator
implements EvaluationMonitor {
    @NonNull
    protected final QVTiEnvironmentFactory environmentFactory;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final QVTiModelManager modelManager;
    private EvaluationMonitor monitor = null;
    private boolean canceled = false;

    public QVTiPivotEvaluator(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        this.environmentFactory = environmentFactory;
        this.transformation = transformation;
        QVTiTransformationAnalysis transformationAnalysis = environmentFactory.createTransformationAnalysis();
        transformationAnalysis.analyzeTransformation(transformation);
        this.modelManager = environmentFactory.createModelManager(transformationAnalysis);
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource resource) {
        this.modelManager.addModel(typedModel, resource);
    }

    @Override
    public void cancel() {
        if (this.monitor != null) {
            this.monitor.cancel();
        } else {
            this.canceled = true;
        }
    }

    @Deprecated
    public void createModel(@NonNull String name, @NonNull URI modelURI) {
        this.createModel(name, modelURI, null);
    }

    public void createModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.environmentFactory.getResourceSet().createResource(modelURI, contentType);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void dispose() {
        this.modelManager.dispose();
    }

    public Boolean execute() {
        EvaluationEnvironment evalEnv = this.environmentFactory.createEvaluationEnvironment((NamedElement)this.transformation, this.modelManager);
        EvaluationVisitor visitor = this.environmentFactory.createEvaluationVisitor(evalEnv);
        StandardLibraryInternal standardLibrary = this.environmentFactory.getStandardLibrary();
        Variable ownedContext = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (Transformation)this.transformation);
        evalEnv.add((TypedElement)ownedContext, this.modelManager.getTransformationInstance(this.transformation));
        for (TypedModel typedModel : this.transformation.getModelParameter()) {
            if (typedModel == null) continue;
            ownedContext = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (TypedModel)typedModel);
            evalEnv.add((TypedElement)ownedContext, this.modelManager.getTypedModelInstance(typedModel));
        }
        return (Boolean)this.transformation.accept((Visitor)visitor);
    }

    @NonNull
    public EvaluationMonitor getEvaluationMonitor() {
        return this.monitor != null ? this.monitor : this;
    }

    @NonNull
    public final QVTiEnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @NonNull
    public final MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    @NonNull
    public final QVTiModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public final Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled || this.monitor != null && this.monitor.isCanceled();
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.environmentFactory.getResourceSet().getResource(modelURI, true);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        Resource resource;
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        if (contentType == null) {
            resource = this.environmentFactory.getResourceSet().getResource(modelURI, true);
        } else {
            resource = this.environmentFactory.getResourceSet().createResource(modelURI, contentType);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void saveModels() {
        this.modelManager.saveModels();
    }

    public void saveModels(@Nullable Map<?, ?> savingOptions) {
        this.modelManager.saveModels(savingOptions);
    }

    public void saveModels(@NonNull URI traceURI) {
        this.saveModels(traceURI, null);
    }

    public void saveModels(@NonNull URI traceURI, @Nullable Map<?, ?> savingOptions) {
        this.saveModels(savingOptions);
        this.modelManager.saveMiddleModel(traceURI, savingOptions);
    }

    public void saveTransformation(Map<?, ?> options) throws IOException {
        XMLResource resource = (XMLResource)this.transformation.eResource();
        resource.save(options);
    }

    public void setEvaluationMonitor(@Nullable EvaluationMonitor monitor) {
        this.monitor = monitor;
    }
}

