/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.usage.DirectedDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.RelationImplementation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.util.QVTrelationVisitor;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class QVTrelationDomainUsageAnalysis
extends RootDomainUsageAnalysis
implements QVTrelationVisitor<DomainUsage> {
    public QVTrelationDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        super(environmentFactory, transformation);
    }

    @Override
    public void analyzeTracePackage(@NonNull TypedModel typedModel, @NonNull Package tracePackage) {
        assert (typedModel == this.getTraceTypedModel());
        this.setUsage((Element)typedModel, this.getMiddleUsage());
        @NonNull DomainUsage typedModelUsage = this.getMiddleUsage();
        for (Class traceClass : QVTrelationUtil.getOwnedClasses((Package)tracePackage)) {
            this.setUsage((Element)traceClass, typedModelUsage);
        }
    }

    @Override
    public @NonNull DirectedDomainUsageAnalysis createDirectedDomainUsageAnalysis() {
        return new QVTrelationDirectedDomainUsageAnalysis(this);
    }

    public @NonNull DomainUsage visitCollectionTemplateExp(@NonNull CollectionTemplateExp object) {
        for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)object)) {
            this.visit((Element)member);
        }
        Variable rest = object.getRest();
        if (rest != null) {
            this.visit((Element)rest);
        }
        return this.visitTemplateExp((TemplateExp)object);
    }

    public @NonNull DomainUsage visitDomainPattern(@NonNull DomainPattern object) {
        Domain relationDomain = QVTrelationUtil.getContainingDomain((EObject)object);
        TypedModel typedModel = relationDomain.getTypedModel();
        if (typedModel == null) {
            return this.getPrimitiveUsage();
        }
        DomainUsage usage = this.getUsage((Element)typedModel);
        this.setUsage((Element)object, usage);
        this.visit((Element)QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)object));
        return usage;
    }

    public @NonNull DomainUsage visitKey(@NonNull Key object) {
        return this.getUsage((Element)QVTrelationUtil.getIdentifies((Key)object));
    }

    public @NonNull DomainUsage visitObjectTemplateExp(@NonNull ObjectTemplateExp object) {
        DomainUsage usage = this.visitTemplateExp((TemplateExp)object);
        for (PropertyTemplateItem part : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)object)) {
            this.visit((Element)part);
        }
        return usage;
    }

    @Override
    public @NonNull DomainUsage visitPattern(@NonNull Pattern object) {
        DomainUsage domainUsage = this.getDomainUsage((EObject)object);
        for (Predicate predicate : QVTrelationUtil.getOwnedPredicates((Pattern)object)) {
            this.visit((Element)predicate);
        }
        return domainUsage;
    }

    public @NonNull DomainUsage visitPropertyTemplateItem(@NonNull PropertyTemplateItem object) {
        DomainUsage usage = this.visit((Element)QVTrelationUtil.getReferredProperty((PropertyTemplateItem)object));
        this.visit((Element)QVTrelationUtil.getOwnedValue((PropertyTemplateItem)object));
        return usage;
    }

    public @NonNull DomainUsage visitRelation(@NonNull Relation object) {
        Pattern where;
        DomainUsage usage = this.getRootAnalysis().getNoneUsage();
        this.setUsage((Element)object, usage);
        Variable traceClassVariable = (Variable)NameUtil.getNameable((Iterable)object.getVariable(), (String)"trace");
        if (traceClassVariable != null) {
            this.setUsage((Element)traceClassVariable, this.getMiddleUsage());
        }
        for (Domain domain : QVTrelationUtil.getOwnedDomains((Relation)object)) {
            this.visit((Element)domain);
        }
        Pattern when = object.getWhen();
        if (when != null) {
            this.visit((Element)when);
        }
        if ((where = object.getWhere()) != null) {
            this.visit((Element)where);
        }
        return usage;
    }

    public @NonNull DomainUsage visitRelationCallExp(@NonNull RelationCallExp object) {
        int i = 0;
        for (OCLExpression argument : QVTrelationUtil.getOwnedArguments((RelationCallExp)object)) {
            if (argument instanceof VariableExp) {
                RelationDomain relationDomain = QVTrelationUtil.getRelationCallExpArgumentDomain((RelationCallExp)object, (int)i);
                TypedModel typedModel = relationDomain.getTypedModel();
                RootDomainUsageAnalysis.DomainUsageConstant usage = typedModel != null ? this.getUsage((Element)typedModel) : this.getPrimitiveUsage();
                this.setUsage((Element)QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)argument)), (DomainUsage)usage);
            }
            this.visit((Element)argument);
            ++i;
        }
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    public @NonNull DomainUsage visitRelationDomain(@NonNull RelationDomain object) {
        TypedModel typedModel = object.getTypedModel();
        if (typedModel == null) {
            return this.getPrimitiveUsage();
        }
        DomainUsage usage = this.visit((Element)typedModel);
        this.setUsage((Element)object, usage);
        for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)object)) {
            this.visit((Element)domainPattern);
        }
        return usage;
    }

    public @NonNull DomainUsage visitRelationDomainAssignment(@NonNull RelationDomainAssignment object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitRelationImplementation(@NonNull RelationImplementation object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitRelationModel(@NonNull RelationModel object) {
        return this.visitBaseModel((BaseModel)object);
    }

    public @NonNull DomainUsage visitRelationalTransformation(@NonNull RelationalTransformation object) {
        DomainUsage usage = this.getRootAnalysis().getNoneUsage();
        this.setUsage((Element)object, usage);
        for (Operation operation : object.getOwnedOperations()) {
            if (operation == null) continue;
            DomainUsageAnalysis operationAnalysis = this.getRootAnalysis().analyzeOperation(operation);
            this.setUsage((Element)operation, operationAnalysis.getUsage((Element)operation));
        }
        for (Key key : QVTrelationUtil.getOwnedKey((RelationalTransformation)object)) {
            this.visit((Element)key);
        }
        for (Relation relation : QVTrelationUtil.getOwnedRelations((RelationalTransformation)object)) {
            this.visit((Element)relation);
        }
        this.visitTransformation((Transformation)object);
        return usage;
    }

    public @NonNull DomainUsage visitSharedVariable(@NonNull SharedVariable object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null) {
            this.visit((Element)ownedInit);
        }
        return (DomainUsage)this.visitVariable((Variable)object);
    }

    public @NonNull DomainUsage visitTemplateExp(@NonNull TemplateExp object) {
        DomainUsage usage = this.getUsage((Element)QVTrelationUtil.getTypedModel((Domain)QVTrelationUtil.getContainingDomain((EObject)object)));
        this.setUsage((Element)object, usage);
        Variable bindsTo = QVTrelationUtil.getBindsTo((TemplateExp)object);
        DomainUsage oldUsage = this.basicGetUsage((Element)bindsTo);
        if (oldUsage != null) {
            usage = this.union(usage, oldUsage);
        }
        this.setUsage((Element)QVTrelationUtil.getBindsTo((TemplateExp)object), usage);
        OCLExpression where = object.getWhere();
        if (where != null) {
            this.visit((Element)where);
        }
        return usage;
    }

    public @NonNull DomainUsage visitTemplateVariable(@NonNull TemplateVariable object) {
        return (DomainUsage)this.visitVariable((Variable)object);
    }

    protected static class QVTrelationDirectedDomainUsageAnalysis
    extends DirectedDomainUsageAnalysis {
        public QVTrelationDirectedDomainUsageAnalysis(@NonNull QVTrelationDomainUsageAnalysis domainUsageAnalysis) {
            super(domainUsageAnalysis);
        }
    }
}

