/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CycleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class TransformationPartitioner {
    public static final @NonNull TracingOption CYCLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/cycles");
    public static final @NonNull TracingOption DISCRIMINATION = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/discrimination");
    public static final @NonNull TracingOption PREDECESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/predecessors");
    public static final @NonNull TracingOption SUCCESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/successors");
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull Iterable<@NonNull ? extends Region> activeRegions;
    private final @NonNull Map<@NonNull MappingRegion, @NonNull MappingPartitioner> region2mappingPartitioner = new HashMap<MappingRegion, MappingPartitioner>();
    private final @NonNull List<@NonNull MappingPartitioner> mappingPartitioners = new ArrayList<MappingPartitioner>();
    private final @NonNull Map<@NonNull CompleteClass, @NonNull TraceClassAnalysis> completeClass2traceClassAnalysis = new HashMap<CompleteClass, TraceClassAnalysis>();
    private final @NonNull Map<@NonNull Property, @NonNull List<@NonNull MappingRegion>> corrolaryProperty2regions = new HashMap<Property, List<MappingRegion>>();
    private @Nullable Map<@NonNull MappingPartitioner, @NonNull CycleAnalysis> mappingPartitioner2cycleAnalysis = null;
    private @Nullable Map<@NonNull TraceClassAnalysis, @NonNull CycleAnalysis> traceClassAnalysis2cycleAnalysis = null;

    public static @NonNull Iterable<@NonNull MappingRegion> partition(@NonNull ScheduleManager scheduleManager, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) throws CompilerChainException {
        TransformationPartitioner transformationPartitioner = new TransformationPartitioner(scheduleManager, problemHandler, activeRegions);
        return transformationPartitioner.partition();
    }

    public TransformationPartitioner(@NonNull ScheduleManager scheduleManager, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) {
        this.scheduleManager = scheduleManager;
        this.problemHandler = problemHandler;
        this.activeRegions = activeRegions;
    }

    public @NonNull TraceClassAnalysis addConsumer(@NonNull CompleteClass completeClass, @NonNull MappingPartitioner consumer) {
        TraceClassAnalysis middleAnalysis = this.completeClass2traceClassAnalysis.get(completeClass);
        if (middleAnalysis == null) {
            middleAnalysis = new TraceClassAnalysis(this, completeClass);
            this.completeClass2traceClassAnalysis.put(completeClass, middleAnalysis);
        }
        middleAnalysis.addConsumer(consumer);
        return middleAnalysis;
    }

    public void addCorrolary(@NonNull Property property, @NonNull MappingRegion region) {
        List<@NonNull MappingRegion> regions = this.corrolaryProperty2regions.get(property);
        if (regions == null) {
            regions = new ArrayList<MappingRegion>();
            this.corrolaryProperty2regions.put(property, regions);
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    public @NonNull TraceClassAnalysis addProducer(@NonNull CompleteClass completeClass, @NonNull MappingPartitioner producer) {
        TraceClassAnalysis middleAnalysis = this.completeClass2traceClassAnalysis.get(completeClass);
        if (middleAnalysis == null) {
            middleAnalysis = new TraceClassAnalysis(this, completeClass);
            this.completeClass2traceClassAnalysis.put(completeClass, middleAnalysis);
        }
        middleAnalysis.addProducer(producer);
        return middleAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void computeCycles() {
        Map<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> partitioner2predecessors = this.computeTransitivePredecessors();
        Map<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> partitioner2successors = this.computeTransitiveSuccessors();
        HashSet<@NonNull HashSet<@NonNull E>> allCycleElements = new HashSet();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            HashSet<@NonNull E> newCycleElements = new HashSet(partitioner2predecessors.get(mappingPartitioner));
            newCycleElements.retainAll((Collection)partitioner2successors.get(mappingPartitioner));
            if (newCycleElements.isEmpty()) continue;
            allCycleElements.add(newCycleElements);
        }
        ArrayList<@NonNull @NonNull E> prunedCycleElements = new ArrayList(allCycleElements);
        int i = prunedCycleElements.size();
        while (--i >= 0) {
            @NonNull Set iCycleElements = (Set)prunedCycleElements.get(i);
            boolean pruneIt = false;
            int j = i;
            while (--j >= 0) {
                @NonNull Set jCycleElements = (Set)prunedCycleElements.get(j);
                if (!QVTbaseUtil.containsAny((Iterable)jCycleElements, (Iterable)iCycleElements) || !jCycleElements.addAll(iCycleElements)) continue;
                pruneIt = true;
            }
            if (!pruneIt) continue;
            prunedCycleElements.remove(i);
        }
        ArrayList<@NonNull CycleAnalysis> cycleAnalyses = new ArrayList<CycleAnalysis>();
        for (Set cycleElements : prunedCycleElements) {
            cycleAnalyses.add(this.createCycleAnalysis(cycleElements));
        }
        if (CYCLES.isActive()) {
            if (cycleAnalyses.isEmpty()) {
                CYCLES.println("No cycles");
            } else {
                for (CycleAnalysis cycleAnalysis : cycleAnalyses) {
                    StringBuilder s = new StringBuilder();
                    s.append("\n  MappingPartitioners:");
                    for (MappingPartitioner mappingPartitioner : cycleAnalysis.getMappingPartitioners()) {
                        s.append("\n\t" + mappingPartitioner);
                    }
                    s.append("\n  TraceClassAnalyses:");
                    for (TraceClassAnalysis traceClassAnalysis : cycleAnalysis.getTraceClassAnalyses()) {
                        s.append("\n\t" + traceClassAnalysis);
                    }
                    CYCLES.println(s.toString());
                }
            }
        }
    }

    private void computeCyclicTraceClasses() {
        HashSet<@NonNull MappingPartitioner> acyclicProducers = new HashSet<MappingPartitioner>();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            Iterable<@NonNull TraceClassAnalysis> consumedTraceClassAnalyses = mappingPartitioner.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses != null) continue;
            acyclicProducers.add(mappingPartitioner);
        }
        this.computeCycles();
        HashSet<@NonNull TraceClassAnalysis> acylicAnalysis = new HashSet<TraceClassAnalysis>();
        for (MappingPartitioner acyclicProducer : acyclicProducers) {
            for (Node traceNode : acyclicProducer.getTraceNodes()) {
                CompleteClass traceClass = traceNode.getCompleteClass();
                TraceClassAnalysis middleAnalysis = this.completeClass2traceClassAnalysis.get(traceClass);
                assert (middleAnalysis != null);
                if (!QVTbaseUtil.containsAll(acyclicProducers, middleAnalysis.getProducers())) continue;
                acylicAnalysis.add(middleAnalysis);
            }
        }
    }

    private void computeTraceClassDiscrimination() throws CompilerChainException {
        for (TraceClassAnalysis traceClassAnalysis : this.completeClass2traceClassAnalysis.values()) {
            traceClassAnalysis.discriminate();
        }
    }

    private void computeTraceClassInheritance() {
        for (TraceClassAnalysis subTraceClassAnalysis : this.completeClass2traceClassAnalysis.values()) {
            CompleteClass traceClass = subTraceClassAnalysis.getTraceClass();
            for (CompleteClass superCompleteClass : traceClass.getProperSuperCompleteClasses()) {
                TraceClassAnalysis superTraceClassAnalysis = this.completeClass2traceClassAnalysis.get(superCompleteClass);
                if (superTraceClassAnalysis == null) continue;
                superTraceClassAnalysis.addSubTraceClassAnalysis(subTraceClassAnalysis);
                subTraceClassAnalysis.addSuperTraceClassAnalysis(superTraceClassAnalysis);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> computeTransitivePredecessors() {
        HashMap<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> partitioner2predecessors = new HashMap<MappingPartitioner, Set<MappingPartitioner>>();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            partitioner2predecessors.put(mappingPartitioner, new HashSet());
        }
        ArrayDeque<@NonNull MappingPartitioner> worklist = new ArrayDeque<MappingPartitioner>(this.mappingPartitioners);
        while (!worklist.isEmpty()) {
            MappingPartitioner producer = (MappingPartitioner)worklist.remove();
            @NonNull Set producerPredecessors = (Set)partitioner2predecessors.get(producer);
            assert (producerPredecessors != null);
            Iterable<@NonNull TraceClassAnalysis> producedTraceClassAnalyses = producer.getProducedTraceClassAnalyses();
            if (producedTraceClassAnalyses == null) continue;
            for (TraceClassAnalysis producedTraceClass : producedTraceClassAnalyses) {
                for (TraceClassAnalysis superProducedTraceClass : producedTraceClass.getSuperTraceClassAnalyses()) {
                    for (MappingPartitioner consumer : superProducedTraceClass.getConsumers()) {
                        @NonNull Set consumerPredecessors = (Set)partitioner2predecessors.get(consumer);
                        assert (consumerPredecessors != null);
                        boolean propagate = consumerPredecessors.add(producer);
                        if (consumerPredecessors.addAll(producerPredecessors)) {
                            propagate = true;
                        }
                        if (!propagate || worklist.contains(consumer)) continue;
                        worklist.add(consumer);
                    }
                }
            }
        }
        if (PREDECESSORS.isActive()) {
            for (MappingPartitioner successor : this.mappingPartitioners) {
                StringBuilder s = new StringBuilder();
                s.append(successor + ":");
                @NonNull Set predecessors = (Set)partitioner2predecessors.get(successor);
                assert (predecessors != null);
                for (MappingPartitioner predecessor : predecessors) {
                    s.append("\n\t" + predecessor);
                }
                PREDECESSORS.println(s.toString());
            }
        }
        return partitioner2predecessors;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> computeTransitiveSuccessors() {
        HashMap<@NonNull MappingPartitioner, @NonNull Set<@NonNull MappingPartitioner>> partitioner2successors = new HashMap<MappingPartitioner, Set<MappingPartitioner>>();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            partitioner2successors.put(mappingPartitioner, new HashSet());
        }
        ArrayDeque<@NonNull MappingPartitioner> worklist = new ArrayDeque<MappingPartitioner>(this.mappingPartitioners);
        while (!worklist.isEmpty()) {
            MappingPartitioner consumer = (MappingPartitioner)worklist.remove();
            @NonNull Set consumerSuccessors = (Set)partitioner2successors.get(consumer);
            assert (consumerSuccessors != null);
            Iterable<@NonNull TraceClassAnalysis> consumedTraceClassAnalyses = consumer.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses == null) continue;
            for (TraceClassAnalysis consumedTraceClassAnalysis : consumedTraceClassAnalyses) {
                for (TraceClassAnalysis subConsumedTraceClass : consumedTraceClassAnalysis.getSubTraceClassAnalyses()) {
                    for (MappingPartitioner producer : subConsumedTraceClass.getProducers()) {
                        @NonNull Set producerSuccessors = (Set)partitioner2successors.get(producer);
                        assert (producerSuccessors != null);
                        boolean propagate = producerSuccessors.add(consumer);
                        if (producerSuccessors.addAll(consumerSuccessors)) {
                            propagate = true;
                        }
                        if (!propagate || worklist.contains(producer)) continue;
                        worklist.add(producer);
                    }
                }
            }
        }
        if (SUCCESSORS.isActive()) {
            for (MappingPartitioner predecessor : this.mappingPartitioners) {
                StringBuilder s = new StringBuilder();
                s.append(predecessor + ":");
                @NonNull Set successors = (Set)partitioner2successors.get(predecessor);
                assert (successors != null);
                for (MappingPartitioner successor : successors) {
                    s.append("\n\t" + successor);
                }
                SUCCESSORS.println(s.toString());
            }
        }
        return partitioner2successors;
    }

    private @NonNull CycleAnalysis createCycleAnalysis(@NonNull Set<@NonNull MappingPartitioner> cyclicMappingPartitioners) {
        CycleAnalysis oldCycleAnalysis;
        Map<TraceClassAnalysis, CycleAnalysis> traceClassAnalysis2cycleAnalysis2;
        Map<@NonNull MappingPartitioner, @NonNull CycleAnalysis> mappingPartitioner2cycleAnalysis2 = this.mappingPartitioner2cycleAnalysis;
        if (mappingPartitioner2cycleAnalysis2 == null) {
            this.mappingPartitioner2cycleAnalysis = mappingPartitioner2cycleAnalysis2 = new HashMap<MappingPartitioner, CycleAnalysis>();
        }
        if ((traceClassAnalysis2cycleAnalysis2 = this.traceClassAnalysis2cycleAnalysis) == null) {
            this.traceClassAnalysis2cycleAnalysis = traceClassAnalysis2cycleAnalysis2 = new HashMap<TraceClassAnalysis, CycleAnalysis>();
        }
        HashSet<@NonNull E> consumedTraceClassAnalyses = new HashSet();
        HashSet<@NonNull E> superProducedTraceClassAnalyses = new HashSet();
        for (MappingPartitioner cyclicMappingPartitioner : cyclicMappingPartitioners) {
            Iterables.addAll(consumedTraceClassAnalyses, cyclicMappingPartitioner.getConsumedTraceClassAnalyses());
            Iterables.addAll(superProducedTraceClassAnalyses, cyclicMappingPartitioner.getSuperProducedTraceClassAnalyses());
        }
        HashSet<@NonNull TraceClassAnalysis> cyclicTraceClassAnalyses = new HashSet<TraceClassAnalysis>(consumedTraceClassAnalyses);
        cyclicTraceClassAnalyses.retainAll(superProducedTraceClassAnalyses);
        CycleAnalysis cycleAnalysis = new CycleAnalysis(this, cyclicMappingPartitioners, cyclicTraceClassAnalyses);
        for (MappingPartitioner cyclicMappingPartitioner : cyclicMappingPartitioners) {
            oldCycleAnalysis = mappingPartitioner2cycleAnalysis2.put(cyclicMappingPartitioner, cycleAnalysis);
            assert (oldCycleAnalysis == null);
        }
        for (TraceClassAnalysis cyclicTraceClassAnalysis : cyclicTraceClassAnalyses) {
            oldCycleAnalysis = traceClassAnalysis2cycleAnalysis2.put(cyclicTraceClassAnalysis, cycleAnalysis);
            assert (oldCycleAnalysis == null);
        }
        return cycleAnalysis;
    }

    public @Nullable List<@NonNull MappingRegion> getCorrolaryOf(@NonNull Edge edge) {
        if (!edge.isNavigation()) {
            return null;
        }
        return this.corrolaryProperty2regions.get(((NavigableEdge)edge).getProperty());
    }

    public @Nullable CycleAnalysis getCycleAnalysis(@NonNull CompleteClass completeClass) {
        TraceClassAnalysis traceClassAnalysis = this.completeClass2traceClassAnalysis.get(completeClass);
        if (traceClassAnalysis == null) {
            return null;
        }
        return this.getCycleAnalysis(traceClassAnalysis);
    }

    public @Nullable CycleAnalysis getCycleAnalysis(@NonNull MappingPartitioner mappingPartitioner) {
        Map<@NonNull MappingPartitioner, @NonNull CycleAnalysis> mappingPartitioner2cycleAnalysis2 = this.mappingPartitioner2cycleAnalysis;
        if (mappingPartitioner2cycleAnalysis2 == null) {
            return null;
        }
        return mappingPartitioner2cycleAnalysis2.get(mappingPartitioner);
    }

    public @Nullable CycleAnalysis getCycleAnalysis(@NonNull TraceClassAnalysis traceClassAnalysis) {
        Map<@NonNull TraceClassAnalysis, @NonNull CycleAnalysis> traceClassAnalysis2cycleAnalysis2 = this.traceClassAnalysis2cycleAnalysis;
        if (traceClassAnalysis2cycleAnalysis2 == null) {
            return null;
        }
        return traceClassAnalysis2cycleAnalysis2.get(traceClassAnalysis);
    }

    public @NonNull MappingPartitioner getMappingPartitioner(@NonNull MappingRegion region) {
        return (MappingPartitioner)ClassUtil.nonNullState((Object)this.region2mappingPartitioner.get(region));
    }

    protected @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        return this.scheduleManager.getSuccessPropertyDatum(successProperty);
    }

    public @NonNull TraceClassAnalysis getTraceClassAnalysis(@NonNull CompleteClass completeClass) {
        return (TraceClassAnalysis)ClassUtil.nonNullState((Object)this.completeClass2traceClassAnalysis.get(completeClass));
    }

    public boolean isCyclic(@NonNull CompleteClass traceClass) {
        TraceClassAnalysis traceClassAnalysis = this.completeClass2traceClassAnalysis.get(traceClass);
        if (traceClassAnalysis == null) {
            return false;
        }
        return traceClassAnalysis.isCyclic();
    }

    public @NonNull Iterable<@NonNull MappingRegion> partition() throws CompilerChainException {
        for (Region region : this.activeRegions) {
            if (!(region instanceof MappingRegion)) continue;
            MappingRegion mappingRegion = (MappingRegion)region;
            MappingPartitioner mappingPartitioner = new MappingPartitioner(this, mappingRegion);
            this.region2mappingPartitioner.put(mappingRegion, mappingPartitioner);
            this.mappingPartitioners.add(mappingPartitioner);
        }
        this.computeTraceClassDiscrimination();
        this.computeTraceClassInheritance();
        this.computeCyclicTraceClasses();
        ArrayList<@NonNull MappingRegion> arrayList = new ArrayList<MappingRegion>();
        HashSet<@NonNull CycleAnalysis> partitionedCycles = new HashSet<CycleAnalysis>();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            CycleAnalysis cycleAnalysis = this.getCycleAnalysis(mappingPartitioner);
            if (Iterables.isEmpty(mappingPartitioner.getTraceNodes())) {
                arrayList.add(mappingPartitioner.getRegion());
                continue;
            }
            if (cycleAnalysis == null) {
                Iterables.addAll(arrayList, mappingPartitioner.partition());
                continue;
            }
            if (!partitionedCycles.add(cycleAnalysis)) continue;
            Iterables.addAll(arrayList, cycleAnalysis.partition(this.mappingPartitioners));
        }
        return arrayList;
    }
}

