/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public abstract class AbstractScheduledRegion2Mapping
extends AbstractRegion2Mapping {
    protected AbstractScheduledRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        super(visitor, region);
        this.connection2variable = new HashMap();
    }

    protected @NonNull MappingStatement createCall(@NonNull Region calledRegion, @Nullable Map<@NonNull VariableDeclaration, @NonNull OCLExpression> guardVariable2expression) {
        AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
        HashMap<@NonNull LoopVariable, @NonNull OCLExpression> loopVariables = new HashMap<LoopVariable, OCLExpression>();
        ArrayList<@NonNull MappingParameterBinding> mappingParameterBindings = new ArrayList<MappingParameterBinding>();
        for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
            MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(calledGuardNode);
            NodeConnection callingConnection = calledGuardNode.getIncomingPassedConnection();
            if (callingConnection != null) {
                OCLExpression connectionExpression = null;
                if (guardVariable2expression != null) {
                    connectionExpression = guardVariable2expression.get(guardVariable);
                }
                if (connectionExpression == null) {
                    ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(callingConnection);
                    if (connectionVariable != null) {
                        connectionExpression = PivotUtil.createVariableExp((VariableDeclaration)connectionVariable);
                    } else {
                        Node callingNode = callingConnection.getSource(this.region);
                        connectionExpression = this.createSelectByKind(callingNode);
                    }
                }
                Type type = connectionExpression.getType();
                assert (type instanceof CollectionType);
                Type elementType = ((CollectionType)type).getElementType();
                assert (elementType != null);
                LoopVariable loopVariable = this.helper.createLoopVariable("loop" + loopVariables.size(), elementType);
                loopVariables.put(loopVariable, connectionExpression);
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createLoopParameterBinding((GuardParameter)guardVariable, loopVariable));
            }
            for (Node callingNode : calledGuardNode.getUsedBindingSources()) {
                if (callingNode.getOwningRegion() != this.region) continue;
                OCLExpression sourceExpression = this.createSelectByKind(callingNode);
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createSimpleParameterBinding((SimpleParameter)guardVariable, sourceExpression));
            }
        }
        for (NodeConnection intermediateConnection : calledRegion.getIntermediateConnections()) {
            ConnectionVariable calledConnectionVariable = calledRegion2Mapping.getConnectionVariable(intermediateConnection);
            ConnectionVariable callingConnectionVariable = (ConnectionVariable)this.connection2variable.get(intermediateConnection);
            assert (callingConnectionVariable != null);
            mappingParameterBindings.add((MappingParameterBinding)this.helper.createAppendParameterBinding((AppendParameter)calledConnectionVariable, callingConnectionVariable));
        }
        Collections.sort(mappingParameterBindings, QVTimperativeUtil.MappingParameterBindingComparator.INSTANCE);
        MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingParameterBindings);
        for (Map.Entry loopEntry : loopVariables.entrySet()) {
            @NonNull LoopVariable loopVariable = (LoopVariable)loopEntry.getKey();
            @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
            mappingCallStatement = this.helper.createMappingLoop(loopSource, loopVariable, (MappingStatement)mappingCallStatement);
        }
        return mappingCallStatement;
    }

    protected @NonNull MappingStatement createInstall(@NonNull Region calledRegion) {
        AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
        ArrayList<@NonNull MappingParameterBinding> mappingParameterBindings = new ArrayList<MappingParameterBinding>();
        for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
            if (calledGuardNode.isDependency()) continue;
            MappingParameter guardVariable = calledRegion2Mapping.getGuardVariable(calledGuardNode);
            NodeConnection callingConnection = calledGuardNode.getIncomingPassedConnection();
            assert (callingConnection != null);
            ConnectionVariable connectionVariable = (ConnectionVariable)this.connection2variable.get(callingConnection);
            assert (connectionVariable != null);
            if (guardVariable instanceof AppendParameter) {
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createAppendParameterBinding((AppendParameter)guardVariable, connectionVariable));
                continue;
            }
            if (guardVariable instanceof GuardParameter) {
                mappingParameterBindings.add((MappingParameterBinding)this.helper.createGuardParameterBinding((GuardParameter)guardVariable, connectionVariable));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        for (NodeConnection intermediateConnection : calledRegion.getIntermediateConnections()) {
            ConnectionVariable calledConnectionVariable = calledRegion2Mapping.getConnectionVariable(intermediateConnection);
            ConnectionVariable callingConnectionVariable = (ConnectionVariable)this.connection2variable.get(intermediateConnection);
            assert (callingConnectionVariable != null);
            mappingParameterBindings.add((MappingParameterBinding)this.helper.createAppendParameterBinding((AppendParameter)calledConnectionVariable, callingConnectionVariable));
        }
        Collections.sort(mappingParameterBindings, QVTimperativeUtil.MappingParameterBindingComparator.INSTANCE);
        MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingParameterBindings);
        mappingCallStatement.setIsInstall(true);
        return mappingCallStatement;
    }

    protected abstract @NonNull OCLExpression createSelectByKind(@NonNull Node var1);
}

