/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

class SplitterAnalysis {
    protected final @NonNull Region region;
    private final @NonNull Map<@NonNull Node, List<@NonNull SimpleGroup>> reachableNode2simpleGroups = new HashMap<Node, List<SimpleGroup>>();

    public SplitterAnalysis(@NonNull Region region) {
        this.region = region;
    }

    protected @Nullable Iterable<@NonNull SimpleGroup> analyze() {
        ArrayList<@NonNull Node> headNodes = new ArrayList<Node>();
        for (Node headNode : RegionUtil.getHeadNodes((Region)this.region)) {
            if (!headNode.isMatched()) continue;
            headNodes.add(headNode);
        }
        if (headNodes.size() <= 1) {
            return null;
        }
        HashSet<@NonNull SimpleGroup> simpleGroups = new HashSet<SimpleGroup>(headNodes.size());
        for (Node headNode : headNodes) {
            SimpleGroup simpleGroup = new SimpleGroup(this, headNode);
            simpleGroups.add(simpleGroup);
        }
        this.computeReachableNode2SimpleGroups(simpleGroups);
        return simpleGroups;
    }

    protected void computeReachableNode2SimpleGroups(@NonNull Iterable<@NonNull SimpleGroup> simpleGroups) {
        for (SimpleGroup simpleGroup : simpleGroups) {
            for (Node reachableNode : simpleGroup.getReachableNodes()) {
                List<@NonNull SimpleGroup> reachableGroups = this.reachableNode2simpleGroups.get(reachableNode);
                if (reachableGroups == null) {
                    reachableGroups = new ArrayList<SimpleGroup>();
                    this.reachableNode2simpleGroups.put(reachableNode, reachableGroups);
                }
                assert (!reachableGroups.contains(simpleGroup));
                reachableGroups.add(simpleGroup);
            }
        }
    }

    public @Nullable Iterable<@NonNull SimpleGroup> basicGetReachableSimpleGroups(@NonNull Node node) {
        return this.reachableNode2simpleGroups.get(node);
    }

    public @NonNull Iterable<@NonNull SimpleGroup> getReachableSimpleGroups(@NonNull Node node) {
        return (Iterable)ClassUtil.nonNullState(this.reachableNode2simpleGroups.get(node));
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    public @NonNull String toString() {
        return String.valueOf(this.region.getName());
    }
}

