/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.BodyStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.HeadStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.HeadedStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.LoopStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Stage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class Split {
    protected final @NonNull SplitterAnalysis splitter;
    private final @NonNull List<@NonNull Stage> stages = new ArrayList<Stage>();
    private final @NonNull Map<@NonNull SimpleGroup, @NonNull HeadedStage> simpleGroup2stage = new HashMap<SimpleGroup, HeadedStage>();

    public Split(@NonNull SplitterAnalysis splitter) {
        this.splitter = splitter;
    }

    public void addBodyStage() {
        BodyStage bodyStage = new BodyStage(this.splitter, this.stages);
        this.stages.add(bodyStage);
    }

    public @NonNull Stage addStage(@Nullable SimpleGroup sourceSimpleGroup, @Nullable Edge edge, @NonNull SimpleGroup targetSimpleGroup) {
        HeadedStage targetStage;
        HeadedStage sourceStage;
        assert (!this.simpleGroup2stage.containsKey(targetSimpleGroup));
        if (edge == null) {
            assert (sourceSimpleGroup == null);
            sourceStage = null;
            targetStage = new HeadStage(this.splitter, targetSimpleGroup);
        } else {
            assert (sourceSimpleGroup != null);
            sourceStage = this.simpleGroup2stage.get(sourceSimpleGroup);
            targetStage = new LoopStage(this.splitter, sourceStage, edge, targetSimpleGroup);
        }
        this.stages.add(targetStage);
        this.simpleGroup2stage.put(targetSimpleGroup, targetStage);
        if (sourceStage != null) {
            sourceStage.addSuccessor(targetStage);
        }
        return targetStage;
    }

    public void check() {
        for (Stage stage : this.stages) {
            stage.debug();
            stage.check();
        }
    }

    public void debug() {
        for (Stage stage : this.stages) {
            stage.debug();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void install() {
        Region region = this.splitter.getRegion();
        Iterable<@NonNull Node> newHeadNodes = this.stages.get(0).getHeadNodes();
        @NonNull ArrayList oldHeadNodes = Lists.newArrayList((Iterable)RegionUtil.getHeadNodes((Region)region));
        for (Node headNode : oldHeadNodes) {
            if (Iterables.contains(newHeadNodes, (Object)headNode)) continue;
            region.resetHead(headNode);
        }
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull StringBuilder s, int depth) {
        CompilerUtil.indent(s, depth);
        for (Stage stage : this.stages) {
            s.append("\n");
            stage.toString(s, depth + 1);
        }
    }
}

