/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.impl.MappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionHelper {
    protected final @NonNull MappingRegion mappingRegion;
    private @Nullable List<@NonNull Node> stronglyMatchedNodes = null;
    private @Nullable List<@NonNull Node> unconditionalNodes = null;
    private @Nullable List<@NonNull Node> conditionalNodes = null;
    private @Nullable List<@NonNull Node> deadNodes = null;
    private @Nullable Map<@NonNull Node, @NonNull Integer> node2implicity = null;

    public static void initHeadNodes(@NonNull MappingRegion mappingRegion) {
        RegionHelper regionHelper = new RegionHelper(mappingRegion);
        regionHelper.initHeadNodes();
    }

    public RegionHelper(@NonNull MappingRegion mappingRegion) {
        this.mappingRegion = mappingRegion;
    }

    private boolean canBeStronglyMatched(@NonNull Node node) {
        if (node.isExplicitNull()) {
            return true;
        }
        return node.isPattern();
    }

    private boolean canBeUnconditional(@NonNull Node node) {
        if (node.isExplicitNull()) {
            return true;
        }
        if (node.isIterator()) {
            return false;
        }
        if (node.isOperation()) {
            return true;
        }
        return node.isPattern();
    }

    private @NonNull Set<@NonNull Node> computeConditionalNodes(@NonNull Set<@NonNull Node> unconditionalNodes) {
        HashSet<@NonNull Node> conditionalNodes = new HashSet<Node>();
        Set<@NonNull Node> moreNodes = unconditionalNodes;
        while (moreNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (unconditionalNodes.contains(sourceNode) || !conditionalNodes.add(sourceNode)) continue;
                    moreMoreNodes.add(sourceNode);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (unconditionalNodes.contains(targetNode) || !conditionalNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreNodes = moreMoreNodes;
        }
        this.conditionalNodes = new ArrayList<Node>(conditionalNodes);
        Collections.sort(this.conditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return conditionalNodes;
    }

    protected @NonNull List<@NonNull Node> computeHeadNodes() {
        ArrayList<@NonNull Node> navigableNodes = new ArrayList<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!node.isPattern() || !node.isMatched() || !node.isClass() || node.isExplicitNull() || node.isOperation() || !node.isLoaded() && !node.isPredicated() && !node.isSpeculated()) continue;
            navigableNodes.add(node);
        }
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure = new HashMap<Node, Set<Node>>();
        for (Node targetNode : navigableNodes) {
            targetFromSourceClosure.put(targetNode, Sets.newHashSet((Object[])new Node[]{targetNode}));
        }
        for (Node sourceNode : navigableNodes) {
            for (Edge navigationEdge : sourceNode.getNavigationEdges()) {
                Set sourceClosure;
                Node targetNode;
                if (navigationEdge.isRealized() || !(targetNode = navigationEdge.getEdgeTarget()).isMatched() || !targetNode.isClass() || targetNode.isExplicitNull() || (sourceClosure = (Set)targetFromSourceClosure.get(targetNode)) == null) continue;
                sourceClosure.add(sourceNode);
            }
        }
        List<@NonNull Node> headNodes = this.computeHeadNodes(targetFromSourceClosure);
        HashSet<@NonNull Node> debugHeadNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (node.isTrue() || node.isDependency()) {
                debugHeadNodes.add(node);
                node.setHead();
                assert (!headNodes.contains(node));
                headNodes.add(node);
                continue;
            }
            if (!node.isHead()) continue;
            debugHeadNodes.add(node);
        }
        assert (debugHeadNodes.equals(new HashSet<Node>(headNodes)));
        return headNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull Node> computeHeadNodes(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure) {
        Set<@NonNull Node> navigableNodes = targetFromSourceClosure.keySet();
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Node targetNode : navigableNodes) {
                Set<Node> sourceClosure = targetFromSourceClosure.get(targetNode);
                assert (sourceClosure != null);
                for (Node sourceNode : new ArrayList(sourceClosure)) {
                    Set<Node> sourceSourceClosure = targetFromSourceClosure.get(sourceNode);
                    assert (sourceSourceClosure != null);
                    if (!sourceClosure.addAll(sourceSourceClosure)) continue;
                    isChanged = true;
                }
            }
        }
        HashMap<@NonNull Node, @NonNull @NonNull HashSet> source2targetClosure = new HashMap<Node, HashSet>();
        for (Node sourceNode : navigableNodes) {
            source2targetClosure.put(sourceNode, Sets.newHashSet((Object[])new Node[]{sourceNode}));
        }
        for (Node targetNode : targetFromSourceClosure.keySet()) {
            Set<@NonNull Node> sourceClosure = targetFromSourceClosure.get(targetNode);
            assert (sourceClosure != null);
            for (Node sourceNode : sourceClosure) {
                @NonNull Set targetClosure = (Set)source2targetClosure.get(sourceNode);
                assert (targetClosure != null);
                targetClosure.add(targetNode);
            }
        }
        ArrayList<@NonNull E> headLessNodes = new ArrayList();
        Iterables.addAll(headLessNodes, targetFromSourceClosure.keySet());
        Collections.sort(headLessNodes, new HeadComparator(targetFromSourceClosure));
        ArrayList<@NonNull Node> headNodes = new ArrayList<Node>();
        while (!headLessNodes.isEmpty()) {
            Node headNode = (Node)headLessNodes.remove(0);
            assert (headNode != null);
            Set<@NonNull Node> debugSourceClosure = targetFromSourceClosure.get(headNode);
            @NonNull Set targetClosure = (Set)source2targetClosure.get(headNode);
            assert (targetClosure != null);
            for (Node node : targetClosure) {
                if (node != headNode) {
                    node.resetHead();
                } else {
                    headNode.setHead();
                }
                headLessNodes.remove(node);
            }
            targetClosure.remove(headNode);
            assert (!headNodes.contains(headNode));
            headNodes.add(headNode);
        }
        return headNodes;
    }

    private @NonNull Set<@NonNull Node> computeStronglyMatchedNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> stronglyMatchedNodes = new HashSet<Node>();
        for (Node headNode : headNodes) {
            if (headNode.isDependency() || headNode.isTrue()) continue;
            stronglyMatchedNodes.add(headNode);
        }
        HashSet<@NonNull E> moreStronglyMatchedNodes = new HashSet(stronglyMatchedNodes);
        while (moreStronglyMatchedNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node sourceNode : moreStronglyMatchedNodes) {
                for (NavigableEdge edge : sourceNode.getNavigationEdges()) {
                    Node targetNode = edge.getEdgeTarget();
                    if (!this.canBeStronglyMatched(targetNode) || !targetNode.isExplicitNull() && !edge.getProperty().isIsRequired() || !stronglyMatchedNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreStronglyMatchedNodes = moreMoreNodes;
        }
        this.stronglyMatchedNodes = new ArrayList<Node>(stronglyMatchedNodes);
        Collections.sort(this.stronglyMatchedNodes, NameUtil.NAMEABLE_COMPARATOR);
        return stronglyMatchedNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull Node> computeUnconditionalNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        @NonNull @NonNull HashSet unconditionalNodes = Sets.newHashSet(headNodes);
        Iterables.addAll((Collection)unconditionalNodes, (Iterable)this.mappingRegion.getNewNodes());
        for (NavigableEdge edge : this.mappingRegion.getRealizedNavigationEdges()) {
            if (edge.isSecondary()) continue;
            Node sourceNode = edge.getEdgeSource();
            assert (this.canBeUnconditional(sourceNode));
            unconditionalNodes.add(sourceNode);
            Node targetNode = edge.getEdgeTarget();
            assert (this.canBeUnconditional(targetNode));
            unconditionalNodes.add(targetNode);
        }
        HashSet<@NonNull E> moreUnconditionalNodes = new HashSet(unconditionalNodes);
        while (moreUnconditionalNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreUnconditionalNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (!this.canBeUnconditional(sourceNode)) continue;
                    if (incomingEdge.isComputation()) {
                        if (this.isConditionalEdge(incomingEdge) || !unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    if (incomingEdge.isNavigation()) {
                        if (!unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    System.err.println("Unsupported incoming edge in " + this + " : " + incomingEdge);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (!this.canBeUnconditional(targetNode) || outgoingEdge.isComputation()) continue;
                    if (outgoingEdge.isNavigation()) {
                        if (targetNode.isExplicitNull()) {
                            if (!unconditionalNodes.add(targetNode)) continue;
                            moreMoreNodes.add(targetNode);
                            continue;
                        }
                        if (!node.isRequired() || !((NavigableEdge)outgoingEdge).getProperty().isIsRequired() || !unconditionalNodes.add(targetNode)) continue;
                        moreMoreNodes.add(targetNode);
                        continue;
                    }
                    System.err.println("Unsupported outgoing edge in " + this + " : " + outgoingEdge);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreUnconditionalNodes = moreMoreNodes;
        }
        this.unconditionalNodes = new ArrayList<Node>(unconditionalNodes);
        Collections.sort(this.unconditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return unconditionalNodes;
    }

    public void computeUtilities(@NonNull Iterable<@NonNull Node> headNodes) {
        Set<@NonNull Node> stronglyMatchedNodes = this.computeStronglyMatchedNodes(headNodes);
        Set<@NonNull Node> unconditionalNodes = this.computeUnconditionalNodes(headNodes);
        Set<@NonNull Node> conditionalNodes = this.computeConditionalNodes(unconditionalNodes);
        HashSet<Node> deadNodes = null;
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (stronglyMatchedNodes.contains(node)) {
                node.setUtility(Node.Utility.STRONGLY_MATCHED);
                assert (unconditionalNodes.contains(node));
                continue;
            }
            if (unconditionalNodes.contains(node) && !node.isDependency()) {
                node.setUtility(Node.Utility.WEAKLY_MATCHED);
                continue;
            }
            if (conditionalNodes.contains(node)) {
                node.setUtility(Node.Utility.CONDITIONAL);
                continue;
            }
            if (node.isDependency()) {
                node.setUtility(Node.Utility.DEPENDENCY);
                continue;
            }
            System.err.println("Dead node in " + this + " : " + node);
            if (deadNodes == null) {
                deadNodes = new HashSet<Node>();
            }
            deadNodes.add(node);
            node.setUtility(Node.Utility.DEAD);
            this.toString();
        }
        if (deadNodes != null) {
            this.deadNodes = new ArrayList<Node>(deadNodes);
            Collections.sort(this.deadNodes, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    private int getImplicity(@NonNull Node node) {
        Integer implicity;
        Map<@NonNull Node, @NonNull Integer> node2implicity2 = this.node2implicity;
        if (node2implicity2 == null) {
            this.node2implicity = node2implicity2 = new HashMap<Node, Integer>();
        }
        if ((implicity = node2implicity2.get(node)) == null) {
            implicity = 0;
            for (NavigableEdge e : node.getNavigationEdges()) {
                if (!e.getProperty().isIsImplicit()) continue;
                implicity = implicity + 1;
            }
            node2implicity2.put(node, implicity);
        }
        return implicity;
    }

    public @NonNull List<@NonNull Node> initHeadNodes() {
        List<@NonNull Node> headNodes = this.computeHeadNodes();
        ((MappingRegionImpl)this.mappingRegion).getHeadNodes2().addAll(headNodes);
        return headNodes;
    }

    private boolean isConditionalEdge(@NonNull Edge edge) {
        String edgeName = edge.getName();
        return "\u00abthen\u00bb".equals(edgeName) || "\u00abelse\u00bb".equals(edgeName) || "\u00abbody\u00bb".equals(edgeName);
    }

    public String toString() {
        return this.mappingRegion.toString();
    }

    protected class HeadComparator
    implements Comparator<Node> {
        private final @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure;

        public HeadComparator(Map<Node, Set<Node>> targetFromSourceClosure) {
            this.targetFromSourceClosure = targetFromSourceClosure;
        }

        @Override
        public int compare(@NonNull Node o1, @NonNull Node o2) {
            int i2;
            boolean c2;
            int l2;
            if (o1.isSpeculated() != o2.isSpeculated()) {
                return o1.isSpeculated() ? -1 : 1;
            }
            if (o1.isConstant() != o2.isConstant()) {
                return o1.isConstant() ? -1 : 1;
            }
            Set<@NonNull Node> set1 = this.targetFromSourceClosure.get(o1);
            Set<@NonNull Node> set2 = this.targetFromSourceClosure.get(o2);
            assert (set1 != null && set2 != null);
            int l1 = set1.size();
            int diff = l1 - (l2 = set2.size());
            if (diff != 0) {
                return diff;
            }
            if (o1.isLoaded() != o2.isLoaded()) {
                return o1.isLoaded() ? -1 : 1;
            }
            if (o1.isPredicated() != o2.isPredicated()) {
                return o1.isPredicated() ? -1 : 1;
            }
            boolean c1 = RegionUtil.getCastTarget((Node)o1) != o1;
            boolean bl = c2 = RegionUtil.getCastTarget((Node)o2) != o2;
            if (c1 != c2) {
                return !c1 ? -1 : 1;
            }
            int i1 = RegionHelper.this.getImplicity(o1);
            diff = i1 - (i2 = RegionHelper.this.getImplicity(o2));
            if (diff != 0) {
                return diff;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }
    }
}

