/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.AssignmentSorter;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ExpressionAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.IsConstantExpressionVisitor;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.BottomVariable;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.impl.BasicMappingRegionImpl;

public class MappingAnalysis
implements Nameable {
    private final @NonNull BasicMappingRegionImpl mappingRegion;
    private final @NonNull Set<@NonNull Predicate> complexPredicates = new HashSet<Predicate>();
    private final @NonNull ExpressionAnalyzer expressionAnalyzer;
    private final @NonNull List<@NonNull GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
    private final @NonNull List<@NonNull BottomPattern> bottomPatterns = new ArrayList<BottomPattern>();
    private final @NonNull List<@NonNull NavigationAssignment> navigationAssignments = new ArrayList<NavigationAssignment>();
    private @NonNull Map<@NonNull VariableDeclaration, @NonNull List<@NonNull OCLExpression>> variable2expressions = new HashMap<VariableDeclaration, List<OCLExpression>>();
    private List<@NonNull Node> dependencyHeadNodes = null;

    public static @NonNull MappingAnalysis createMappingRegion(@NonNull ScheduleManager scheduleManager, @NonNull Mapping mapping) {
        MappingAnalysis mappingAnalysis = new MappingAnalysis(scheduleManager.getScheduleModel(), mapping);
        String name = mappingAnalysis.getMappingRegion().getName();
        mappingAnalysis.initialize();
        return mappingAnalysis;
    }

    private MappingAnalysis(@NonNull ScheduleModel scheduleModel, @NonNull Mapping mapping) {
        this.mappingRegion = (BasicMappingRegionImpl)QVTscheduleFactory.eINSTANCE.createBasicMappingRegion();
        this.mappingRegion.setFixmeScheduleModel(scheduleModel);
        scheduleModel.getOwnedOtherMappingRegions().add((Object)this.mappingRegion);
        this.mappingRegion.setReferredMapping(mapping);
        this.expressionAnalyzer = new ExpressionAnalyzer(this);
        GuardPattern guardPattern = QVTcoreUtil.getGuardPattern((Area)mapping);
        BottomPattern bottomPattern = QVTcoreUtil.getBottomPattern((Area)mapping);
        this.guardPatterns.add(guardPattern);
        this.bottomPatterns.add(bottomPattern);
        for (Assignment assignment : QVTcoreUtil.getOwnedAssignments((BottomPattern)bottomPattern)) {
            if (assignment instanceof NavigationAssignment) {
                this.navigationAssignments.add((NavigationAssignment)assignment);
                continue;
            }
            if (!(assignment instanceof VariableAssignment)) continue;
            VariableAssignment variableAssignment = (VariableAssignment)assignment;
            this.addExpression((VariableDeclaration)QVTcoreUtil.getTargetVariable((VariableAssignment)variableAssignment), QVTcoreUtil.getValue((Assignment)variableAssignment));
        }
        for (CoreDomain coreDomain : QVTcoreUtil.getOwnedDomains((Mapping)mapping)) {
            guardPattern = QVTcoreUtil.getGuardPattern((Area)coreDomain);
            bottomPattern = QVTcoreUtil.getBottomPattern((Area)coreDomain);
            this.guardPatterns.add(guardPattern);
            this.bottomPatterns.add(bottomPattern);
            for (Assignment assignment : QVTcoreUtil.getOwnedAssignments((BottomPattern)bottomPattern)) {
                if (assignment instanceof NavigationAssignment) {
                    this.navigationAssignments.add((NavigationAssignment)assignment);
                    continue;
                }
                if (!(assignment instanceof VariableAssignment)) continue;
                VariableAssignment variableAssignment = (VariableAssignment)assignment;
                this.addExpression((VariableDeclaration)QVTcoreUtil.getTargetVariable((VariableAssignment)variableAssignment), QVTcoreUtil.getValue((Assignment)variableAssignment));
            }
        }
    }

    protected void addExpression(@NonNull VariableDeclaration variable, @NonNull OCLExpression expression) {
        List<@NonNull OCLExpression> initializers = this.variable2expressions.get(variable);
        if (initializers == null) {
            initializers = new ArrayList<OCLExpression>();
            this.variable2expressions.put(variable, initializers);
        }
        if (!initializers.contains(expression)) {
            initializers.add(expression);
        }
    }

    protected void analyzeAssignmentValues() {
        AssignmentSorter assignmentSorter = new AssignmentSorter();
        for (BottomPattern bottomPattern : this.bottomPatterns) {
            assignmentSorter.addAll((Iterable<Assignment>)ClassUtil.nullFree((EList)bottomPattern.getAssignment()));
        }
        for (Assignment assignment : assignmentSorter.getSortedAssignments()) {
            assignment.accept((Visitor)this.expressionAnalyzer);
        }
    }

    protected void analyzeComplexPredicates() {
        for (Predicate predicate : this.complexPredicates) {
            OCLExpression conditionExpression = predicate.getConditionExpression();
            Node resultNode = (Node)conditionExpression.accept((Visitor)this.expressionAnalyzer);
            if (resultNode == null || resultNode.isTrue()) continue;
            Node trueNode = RegionUtil.createTrueNode((Region)this.mappingRegion);
            RegionUtil.createPredicateEdge(resultNode, null, trueNode);
        }
    }

    protected void analyzeContainments() {
        for (Node node : this.mappingRegion.getNewNodes()) {
            boolean isContained = false;
            for (NavigableEdge edge : node.getNavigationEdges()) {
                Property property = edge.getProperty();
                Property opposite = property.getOpposite();
                if (opposite == null || !opposite.isIsComposite() || edge.getEdgeTarget().isExplicitNull()) continue;
                isContained = true;
                break;
            }
            if (!isContained) continue;
            node.setContained(true);
        }
    }

    protected void analyzeGuardVariables() {
        for (GuardPattern guardPattern : this.guardPatterns) {
            for (Variable guardVariable : ClassUtil.nullFree((EList)guardPattern.getVariable())) {
                Node guardNode = this.mappingRegion.getNode((TypedElement)guardVariable);
                assert (guardNode == null);
                guardNode = RegionUtil.createOldNode((Region)this.mappingRegion, (VariableDeclaration)guardVariable);
                assert (guardNode == this.mappingRegion.getNode((TypedElement)guardVariable));
            }
        }
    }

    protected void analyzePredicates(@NonNull List<@NonNull ? extends CorePattern> corePatterns) {
        for (CorePattern corePattern : corePatterns) {
            for (Predicate predicate : ClassUtil.nullFree((EList)corePattern.getPredicate())) {
                OCLExpression referenceExpression;
                OCLExpression conditionExpression = predicate.getConditionExpression();
                if (conditionExpression == null) continue;
                OCLExpression boundExpression = this.getPredicateComparisonBoundExpression(conditionExpression);
                if (boundExpression instanceof VariableExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    Variable referredVariable = QVTcoreUtil.getReferredVariable((VariableExp)((VariableExp)boundExpression));
                    if (referredVariable instanceof BottomVariable) {
                        this.addExpression((VariableDeclaration)referredVariable, referenceExpression);
                        continue;
                    }
                    this.analyzeSimplePredicate((VariableDeclaration)referredVariable, referenceExpression);
                    continue;
                }
                if (boundExpression instanceof NullLiteralExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    this.analyzeSimplePredicate(null, referenceExpression);
                    continue;
                }
                this.complexPredicates.add(predicate);
            }
        }
    }

    protected void analyzeRealizedVariables() {
        for (BottomPattern bottomPattern : this.bottomPatterns) {
            for (RealizedVariable realizedVariable : ClassUtil.nullFree((EList)bottomPattern.getRealizedVariable())) {
                Node realizedNode = this.mappingRegion.getNode((TypedElement)realizedVariable);
                assert (realizedNode == null);
                realizedNode = RegionUtil.createRealizedStepNode((Region)this.mappingRegion, (Variable)realizedVariable);
                assert (realizedNode == this.mappingRegion.getNode((TypedElement)realizedVariable));
            }
        }
    }

    private void analyzeSimplePredicate(@Nullable VariableDeclaration boundVariable, @NonNull OCLExpression referenceExpression) {
        @NonNull OCLExpression expression = referenceExpression;
        while (expression instanceof NavigationCallExp) {
            Node targetNode;
            NavigationCallExp navigationCallExp = (NavigationCallExp)expression;
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            assert (referredProperty != null);
            expression = (OCLExpression)ClassUtil.nonNullState((Object)navigationCallExp.getOwnedSource());
            if (!(expression instanceof VariableExp)) continue;
            VariableDeclaration sourceVariable = ((VariableExp)expression).getReferredVariable();
            assert (sourceVariable != null);
            Node sourceNode = this.getReferenceNode(sourceVariable);
            Node node = targetNode = boundVariable != null ? this.getReferenceNode(boundVariable) : RegionUtil.createNullNode((Region)this.mappingRegion, true, null);
            assert (sourceNode.isClass());
            if (referredProperty.isIsMany()) continue;
            Edge predicateEdge = sourceNode.getPredicateEdge(referredProperty);
            if (predicateEdge == null) {
                RegionUtil.createNavigationEdge(sourceNode, referredProperty, targetNode, false);
                continue;
            }
            assert (predicateEdge.getEdgeTarget() == targetNode);
        }
    }

    private @Nullable Node analyzeVariable(@NonNull Variable variable, @NonNull List<@NonNull OCLExpression> expressions) {
        ScheduleManager scheduleManager;
        ClassDatum variableClassDatum;
        CompleteClass variableCompleteClass;
        OCLExpression bestInitExpression = null;
        for (OCLExpression initExpression : expressions) {
            OperationCallExp operationCallExp;
            OperationId operationId;
            if (!(initExpression instanceof OperationCallExp) || PivotUtil.isSameOperation((OperationId)(operationId = (operationCallExp = (OperationCallExp)initExpression).getReferredOperation().getOperationId()), (OperationId)OperationId.OCLANY_EQUALS) || PivotUtil.isSameOperation((OperationId)operationId, (OperationId)OperationId.OCLANY_NOT_EQUALS)) continue;
            bestInitExpression = initExpression;
            break;
        }
        if (bestInitExpression == null) {
            OCLExpression oCLExpression = bestInitExpression = expressions.size() > 0 ? expressions.get(0) : null;
        }
        if (bestInitExpression == null) {
            return null;
        }
        Node bestInitNode = (Node)bestInitExpression.accept((Visitor)this.expressionAnalyzer);
        assert (bestInitNode != null);
        CompleteClass initCompleteClass = bestInitNode.getCompleteClass();
        if (!initCompleteClass.conformsTo(variableCompleteClass = RegionUtil.getCompleteClass((ClassDatum)(variableClassDatum = (scheduleManager = this.getScheduleManager()).getClassDatum((TypedElement)variable))))) {
            VariableNode castNode = RegionUtil.createOldNode((Region)this.mappingRegion, (VariableDeclaration)variable);
            Property castProperty = scheduleManager.getCastProperty(PivotUtil.getType((TypedElement)variable));
            this.expressionAnalyzer.createCastEdge(bestInitNode, castProperty, (Node)castNode);
            bestInitNode = castNode;
        }
        bestInitNode.addTypedElement((TypedElement)variable);
        this.mappingRegion.addVariableNode((VariableDeclaration)variable, bestInitNode);
        for (OCLExpression initExpression : expressions) {
            if (initExpression == bestInitExpression) continue;
            Node initNode = (Node)bestInitExpression.accept((Visitor)this.expressionAnalyzer);
            assert (initNode != null);
            RegionUtil.createEqualsEdge(bestInitNode, initNode);
        }
        return bestInitNode;
    }

    public @NonNull Node createDependencyHead(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        if (this.dependencyHeadNodes == null) {
            this.dependencyHeadNodes = new ArrayList<Node>();
        }
        Node dependencyHeadNode = RegionUtil.createDependencyNode((Region)this.mappingRegion, "\u00abextra-" + (this.dependencyHeadNodes.size() + 1) + "\u00bb", classDatumAnalysis);
        dependencyHeadNode.setHead();
        this.dependencyHeadNodes.add(dependencyHeadNode);
        return dependencyHeadNode;
    }

    public @Nullable Node getDependencyHead(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        if (this.dependencyHeadNodes != null) {
            for (Node dependencyHeadNode : this.dependencyHeadNodes) {
                if (RegionUtil.getClassDatumAnalysis(dependencyHeadNode) != classDatumAnalysis) continue;
                return dependencyHeadNode;
            }
        }
        return null;
    }

    public @NonNull MappingRegion getMappingRegion() {
        return this.mappingRegion;
    }

    public @NonNull String getName() {
        return RegionUtil.getName((Nameable)this.mappingRegion);
    }

    private @Nullable OCLExpression getPredicateComparisonBoundExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)RegionUtil.getScheduleManager((Region)this.mappingRegion).getStandardLibraryHelper().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            if (leftExp instanceof VariableExp) {
                return leftExp;
            }
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (rightExp instanceof VariableExp) {
                return rightExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return leftExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return rightExp;
            }
        }
        return null;
    }

    private @Nullable OCLExpression getPredicateComparisonReferenceExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)RegionUtil.getScheduleManager((Region)this.mappingRegion).getStandardLibraryHelper().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (leftExp instanceof VariableExp) {
                return rightExp;
            }
            if (rightExp instanceof VariableExp) {
                return leftExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return rightExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return leftExp;
            }
        }
        return null;
    }

    public @NonNull Node getReferenceNode(@NonNull VariableDeclaration variableDeclaration) {
        Node node = this.mappingRegion.getNode((TypedElement)variableDeclaration);
        if (node == null && variableDeclaration instanceof Variable) {
            List<OCLExpression> expressions;
            Variable variable = (Variable)variableDeclaration;
            OCLExpression ownedInit = variable.getOwnedInit();
            if (ownedInit != null) {
                this.addExpression((VariableDeclaration)variable, ownedInit);
            }
            if ((expressions = this.variable2expressions.get(variable)) != null) {
                node = this.analyzeVariable(variable, expressions);
            } else if (variable.eContainer() instanceof BottomPattern) {
                DomainUsage domainUsage = RegionUtil.getScheduleManager((Region)this.mappingRegion).getDomainUsage((Element)variable);
                boolean isEnforceable = domainUsage.isOutput() || domainUsage.isMiddle();
                node = isEnforceable ? RegionUtil.createRealizedStepNode((Region)this.mappingRegion, variable) : RegionUtil.createLoadedStepNode((Region)this.mappingRegion, (VariableDeclaration)variable);
            }
        }
        assert (node != null) : "No variable2simpleNode entry for " + variableDeclaration;
        return node;
    }

    protected @NonNull ScheduleManager getScheduleManager() {
        return this.expressionAnalyzer.scheduleManager;
    }

    public @NonNull Node getUnknownNode(@NonNull TypedElement typedElement) {
        assert (!(typedElement instanceof Property));
        Node node = this.mappingRegion.getNode(typedElement);
        if (node == null) {
            node = RegionUtil.createUnknownNode((Region)this.mappingRegion, (String)ClassUtil.nonNullState((Object)typedElement.getType().toString()), typedElement);
        }
        return node;
    }

    public void initialize() {
        this.analyzeGuardVariables();
        this.analyzeRealizedVariables();
        this.analyzePredicates(this.guardPatterns);
        this.analyzePredicates(this.bottomPatterns);
        this.analyzeAssignmentValues();
        this.analyzeComplexPredicates();
        this.analyzeContainments();
        RegionHelper regionHelper = new RegionHelper((MappingRegion)this.mappingRegion);
        List<@NonNull Node> headNodes = regionHelper.initHeadNodes();
        regionHelper.computeUtilities(headNodes);
    }

    public boolean isPropertyAssignment(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        if (sourceNode.isRealized()) {
            for (NavigationAssignment navigationAssignment : this.navigationAssignments) {
                Node slotNode;
                Property navigationProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                if (source2targetProperty != navigationProperty || (slotNode = this.expressionAnalyzer.analyze((Visitable)navigationAssignment.getSlotExpression())) != sourceNode) continue;
                return true;
            }
        }
        return false;
    }

    public void registerConsumptionsAndProductions(@NonNull QVTm2QVTs qvtm2qts) {
        ClassDatumAnalysis classDatumAnalysis;
        for (Node newNode : this.mappingRegion.getNewNodes()) {
            classDatumAnalysis = RegionUtil.getClassDatumAnalysis(newNode);
            classDatumAnalysis.addProduction((MappingRegion)this.mappingRegion, newNode);
            for (Mapping consumingMapping : classDatumAnalysis.getRequiredBy()) {
                MappingRegion consumingRegion = qvtm2qts.getMappingRegion(consumingMapping);
                for (Node consumingNode : consumingRegion.getOldNodes()) {
                    if (consumingNode.getCompleteClass() != classDatumAnalysis.getClassDatum().getCompleteClass()) continue;
                    classDatumAnalysis.addConsumption(consumingRegion, consumingNode);
                }
            }
        }
        for (Node predicatedNode : this.mappingRegion.getOldNodes()) {
            classDatumAnalysis = RegionUtil.getClassDatumAnalysis(predicatedNode);
            classDatumAnalysis.addConsumption((MappingRegion)this.mappingRegion, predicatedNode);
            for (Mapping producingMapping : classDatumAnalysis.getProducedBy()) {
                MappingRegion producingRegion = qvtm2qts.getMappingRegion(producingMapping);
                assert (producingRegion != null);
                for (Node newNode : producingRegion.getNewNodes()) {
                    if (newNode.getCompleteClass() != classDatumAnalysis.getClassDatum().getCompleteClass()) continue;
                    classDatumAnalysis.addProduction(producingRegion, newNode);
                }
            }
        }
    }
}

