/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    private static final Set<String> RELATIONAL_OPERATORS = new HashSet<String>();

    static {
        RELATIONAL_OPERATORS.add("<");
        RELATIONAL_OPERATORS.add("<=");
        RELATIONAL_OPERATORS.add(">");
        RELATIONAL_OPERATORS.add(">=");
    }

    private TypeUtil() {
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean isOclAnyOperation(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        return env.getUMLReflection().getOwningClassifier(operation) instanceof AnyType;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> O findOperationMatching(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> lib;
        if (args == null) {
            args = Collections.emptyList();
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        List<O> operations = TypeUtil.getOperations(env, owner);
        ArrayList<O> matches = null;
        for (O oper : operations) {
            if (!name.equals(uml.getName(oper)) || !TypeUtil.matchArgs(env, owner, uml.getParameters(oper), args)) continue;
            if (uml.getOwningClassifier(oper) == owner) {
                return oper;
            }
            if (matches == null) {
                matches = new ArrayList<O>(3);
            }
            matches.add(oper);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (O)matches.get(0);
            }
            if (!matches.isEmpty()) {
                return (O)TypeUtil.mostSpecificRedefinition(matches, uml);
            }
        }
        if (owner == (lib = env.getOCLStandardLibrary()).getOclVoid() || owner == lib.getInvalid()) {
            return TypeUtil.findOperationForVoidOrInvalid(env, owner, name, args);
        }
        return null;
    }

    private static <C, F> F mostSpecificRedefinition(List<? extends F> features, UMLReflection<?, C, ?, ?, ?, ?, ?, ?, ?, ?> uml) {
        HashMap<C, F> redefinitions = new HashMap<C, F>();
        for (F next : features) {
            redefinitions.put(uml.getOwningClassifier(next), next);
        }
        ArrayList classifiers = new ArrayList(redefinitions.keySet());
        while (true) {
            for (Object next : classifiers) {
                if (classifiers.removeAll(uml.getAllSupertypes(next))) continue;
            }
            break;
        }
        return (F)redefinitions.get(classifiers.get(0));
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> O findOperationForVoidOrInvalid(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name, List<? extends TypedElement<C>> args) {
        C argType;
        O result = null;
        if (args.size() == 1 && (argType = args.get(0).getType()) != owner) {
            result = TypeUtil.findOperationMatching(env, argType, name, args);
        }
        return result;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C findSignalMatching(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C receiver, List<C> signals, String name, List<? extends TypedElement<C>> args) {
        if (args == null) {
            args = Collections.emptyList();
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        for (C signal : signals) {
            if (!uml.getName(signal).equals(name) || !TypeUtil.matchArgs(env, receiver, uml.getAttributes(signal), args)) continue;
            return signal;
        }
        return null;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> List<O> getOperations(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner) {
        List<O> result;
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        if (owner instanceof TypeType) {
            TypeType source = (TypeType)owner;
            result = new ArrayList((Collection)source.oclOperations());
            for (O o : TypeUtil.getOperations(env, source.getReferredType())) {
                if (!uml.isStatic(o)) continue;
                result.add(o);
            }
            result = Collections.unmodifiableList(result);
        } else {
            List<O> additionalOperations;
            if (owner instanceof PredefinedType) {
                PredefinedType source = (PredefinedType)owner;
                result = new ArrayList((Collection)source.oclOperations());
                if (source instanceof AnyType && !ParsingOptions.getValue(env, ParsingOptions.USE_COMPARE_TO_OPERATION).booleanValue()) {
                    Iterator iter = result.iterator();
                    while (iter.hasNext()) {
                        if (!RELATIONAL_OPERATORS.contains(uml.getName(iter.next()))) continue;
                        iter.remove();
                    }
                }
            } else if ((owner = uml.asOCLType(owner)) instanceof PredefinedType) {
                PredefinedType pt = (PredefinedType)owner;
                result = new ArrayList((Collection)pt.oclOperations());
            } else {
                result = new ArrayList();
                C oclAny = env.getOCLStandardLibrary().getOclAny();
                result.addAll((Collection)uml.getOperations(owner));
                C implictBaseClassifier = TypeUtil.getImplicitRootClass(env);
                if (implictBaseClassifier != null && implictBaseClassifier != owner) {
                    result.addAll((Collection)uml.getOperations(implictBaseClassifier));
                }
                result.addAll(TypeUtil.getOperations(env, oclAny));
            }
            if ((additionalOperations = env.getAdditionalOperations(owner)) != null && !additionalOperations.isEmpty()) {
                result.addAll(additionalOperations);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    private static <C> C getImplicitRootClass(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env) {
        C result = ParsingOptions.getValue(env, ParsingOptions.implicitRootClass(env));
        if (result != null && !env.getUMLReflection().isClass(result)) {
            result = null;
        }
        return result;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> P findAttribute(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, String name) {
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        List<P> attributes = TypeUtil.getAttributes(env, owner);
        ArrayList<P> matches = null;
        for (P attr : attributes) {
            if (!name.equals(uml.getName(attr))) continue;
            if (uml.getOwningClassifier(attr) == owner) {
                return attr;
            }
            if (matches == null) {
                matches = new ArrayList<P>(3);
            }
            matches.add(attr);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (P)matches.get(0);
            }
            if (!matches.isEmpty()) {
                return (P)TypeUtil.mostSpecificRedefinition(matches, uml);
            }
        }
        return null;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> List<P> getAttributes(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner) {
        List<P> result;
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        if (owner instanceof TypeType) {
            TypeType source = (TypeType)owner;
            result = new ArrayList();
            for (P p : TypeUtil.getAttributes(env, source.getReferredType())) {
                if (!uml.isStatic(p)) continue;
                result.add(p);
            }
            result = Collections.unmodifiableList(result);
        } else {
            if (owner instanceof PredefinedType) {
                result = new ArrayList(uml.getAttributes(owner));
            } else if ((owner = uml.asOCLType(owner)) instanceof PredefinedType) {
                result = new ArrayList(uml.getAttributes(owner));
            } else {
                result = new ArrayList();
                C oclAny = env.getOCLStandardLibrary().getOclAny();
                result.addAll((Collection)uml.getAttributes(owner));
                C implictBaseClassifier = TypeUtil.getImplicitRootClass(env);
                if (implictBaseClassifier != null && implictBaseClassifier != owner) {
                    result.addAll((Collection)uml.getAttributes(implictBaseClassifier));
                }
                result.addAll(TypeUtil.getAttributes(env, oclAny));
            }
            List<P> additionalProperties = env.getAdditionalAttributes(owner);
            if (additionalProperties != null && !additionalProperties.isEmpty()) {
                result.addAll(additionalProperties);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean matchArgs(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, List<?> paramsOrProperties, List<? extends TypedElement<C>> args) {
        int argsize = args == null ? 0 : args.size();
        if (paramsOrProperties.size() != argsize) {
            return false;
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        int i = 0;
        for (Object paramOrProperty : paramsOrProperties) {
            TypedElement<C> arg = args.get(i++);
            C argType = arg.getType();
            C popType = TypeUtil.resolveType(env, uml.getOCLType(paramOrProperty));
            if (popType instanceof TypeType) {
                if (arg instanceof TypeExp) continue;
                return false;
            }
            if ((popType = TypeUtil.resolveGenericType(env, owner, popType, argType)) == env.getOCLStandardLibrary().getT() || (TypeUtil.getRelationship(env, argType, popType) & 3) != 0) continue;
            return false;
        }
        return true;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveGenericType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, C paramType, C argType) {
        C result = paramType;
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        if (result == stdlib.getT()) {
            result = owner;
            if (result instanceof CollectionType && (result = ((CollectionType)result).getElementType()) == stdlib.getOclVoid()) {
                result = stdlib.getT();
            }
        } else if (result instanceof CollectionType) {
            CollectionType collType = (CollectionType)result;
            Object elemType = collType.getElementType();
            if (elemType == stdlib.getT()) {
                C ownerMatch = owner;
                if (ownerMatch instanceof CollectionType && (ownerMatch = ((CollectionType)ownerMatch).getElementType()) == stdlib.getOclVoid()) {
                    ownerMatch = stdlib.getT();
                }
                result = TypeUtil.resolveCollectionType(env, collType.getKind(), ownerMatch);
            } else if (elemType == env.getOCLStandardLibrary().getT2()) {
                C argMatch = argType;
                if (argMatch instanceof CollectionType && (argMatch = ((CollectionType)argMatch).getElementType()) == stdlib.getOclVoid()) {
                    argMatch = stdlib.getT();
                }
                result = TypeUtil.resolveCollectionType(env, collType.getKind(), argMatch);
            }
        }
        return result;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> O resolveGenericSignature(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        String name = uml.getName(oper);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<C> paramTypes = new ArrayList<C>();
        for (PM param : uml.getParameters(oper)) {
            paramNames.add(uml.getName(param));
            paramTypes.add(TypeUtil.resolveGenericType(env, owner, TypeUtil.resolveType(env, uml.getOCLType(param)), env.getOCLStandardLibrary().getT()));
        }
        C resultType = TypeUtil.getResultType(oper, env, owner, oper);
        return uml.createOperation(name, resultType, paramNames, paramTypes);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getPropertyType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, P property) {
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        C result = TypeUtil.resolveType(env, uml.getOCLType(property));
        if (uml.isAssociationClass(owner) && uml.getMemberEnds(owner).contains(property) && result instanceof CollectionType) {
            result = ((CollectionType)result).getElementType();
        }
        return result;
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getResultType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        return TypeUtil.getResultType(null, env, owner, oper);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C getResultType(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C owner, O oper) {
        UMLReflection uml = env.getUMLReflection();
        if (owner instanceof PredefinedType) {
            int opcode = OCLStandardLibraryUtil.getOperationCode(uml.getName(oper));
            List<PM> parameters = uml.getParameters(oper);
            ArrayList<TypeExp<C>> args = new ArrayList<TypeExp<C>>(parameters.size());
            for (PM param : parameters) {
                CollectionType ct;
                OCLExpression<C> exp;
                C paramType = TypeUtil.resolveType(env, uml.getOCLType(param));
                if (paramType instanceof TypeType) {
                    exp = env.getOCLFactory().createTypeExp();
                    exp.setReferredType(env.getOCLStandardLibrary().getT());
                    uml.setType(exp, paramType);
                    args.add((TypeExp<C>)exp);
                    continue;
                }
                if (paramType instanceof CollectionType && (ct = (CollectionType)paramType).getElementType() == env.getOCLStandardLibrary().getT2()) {
                    paramType = TypeUtil.resolveCollectionType(env, ct.getKind(), env.getOCLStandardLibrary().getT());
                }
                exp = env.getOCLFactory().createUnspecifiedValueExp();
                uml.setType(exp, paramType);
                args.add((TypeExp<C>)exp);
            }
            try {
                Iterator<Object> iterator = OCLStandardLibraryUtil.getResultTypeOf(problemObject, env, owner, opcode, args);
                return (C)iterator;
            }
            catch (Exception exception) {
            }
            finally {
                ObjectUtil.dispose(args);
            }
        }
        return TypeUtil.resolveType(env, uml.getOCLType(oper));
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean type1AsType2(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) throws SemanticException {
        if (TypeUtil.typeCompare(env, type1, type2) != -1) {
            return true;
        }
        String message = OCLMessages.bind(OCLMessages.CastTypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
        throw new SemanticException(message);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean exactTypeMatch(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        switch (TypeUtil.getRelationship(env, type1, type2)) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean compatibleTypeMatch(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        switch (TypeUtil.getRelationship(env, type1, type2)) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> int typeCompare(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        switch (TypeUtil.getRelationship(env, type1, type2)) {
            case 1: {
                return 0;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 1;
            }
        }
        String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(TypeUtil.class, "typeCompare", error);
        throw error;
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void checkMutuallyComparable(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2, int opcode) throws SemanticException {
        if (!(type1 instanceof PrimitiveType && type2 instanceof PrimitiveType || TypeUtil.commonSuperType(env, type1, type2) != null)) {
            String message = OCLMessages.bind(OCLMessages.Noncomforming_ERROR_, TypeUtil.getName(env, type1), OCLStandardLibraryUtil.getOperationName(opcode));
            throw new SemanticException(message);
        }
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> boolean checkMutuallyComparable(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2, int opcode) {
        if (!(type1 instanceof PrimitiveType && type2 instanceof PrimitiveType || TypeUtil.commonSuperType(problemObject, env, type1, type2) != null)) {
            String message = OCLMessages.bind(OCLMessages.Noncomforming_ERROR_, TypeUtil.getName(env, type1), OCLStandardLibraryUtil.getOperationName(opcode));
            TypeUtil.error(env, message, "checkMutuallyComparable", problemObject);
            return false;
        }
        return true;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> int getRelationship(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        C implictBaseClassifier;
        if (type1 != null) {
            type1 = env.getUMLReflection().getOCLType(type1);
        }
        if (type2 != null) {
            type2 = env.getUMLReflection().getOCLType(type2);
        }
        if (type1 == type2) {
            return 1;
        }
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        if (type1 == stdlib.getOclVoid() && type2 != stdlib.getInvalid()) {
            return 2;
        }
        if (type2 == stdlib.getOclVoid() && type1 != stdlib.getInvalid()) {
            return 4;
        }
        if (type1 == stdlib.getInvalid()) {
            return 2;
        }
        if (type2 == stdlib.getInvalid()) {
            return 4;
        }
        if (type1 == stdlib.getOclAny()) {
            return type2 instanceof CollectionType ? 8 : 4;
        }
        if (type2 == stdlib.getOclAny()) {
            return type1 instanceof CollectionType ? 8 : 2;
        }
        if (type1 instanceof PrimitiveType) {
            if (type1 == stdlib.getInteger() || type1 == stdlib.getUnlimitedNatural()) {
                if (type2 == stdlib.getReal()) {
                    return 2;
                }
            } else if (type1 == stdlib.getReal() && (type2 == stdlib.getInteger() || type2 == stdlib.getUnlimitedNatural())) {
                return 4;
            }
            return 8;
        }
        if (type2 instanceof PrimitiveType) {
            return 8;
        }
        if (type1 instanceof CollectionType) {
            if (!(type2 instanceof CollectionType)) {
                return 8;
            }
            CollectionType first = (CollectionType)type1;
            CollectionType other = (CollectionType)type2;
            int kindRelationship = TypeUtil.getRelationship(first.getKind(), other.getKind());
            if (kindRelationship == 8) {
                return kindRelationship;
            }
            int elementRelationship = TypeUtil.getRelationship(env, first.getElementType(), other.getElementType());
            switch (kindRelationship) {
                case 1: {
                    return elementRelationship;
                }
                case 2: {
                    switch (elementRelationship) {
                        case 1: 
                        case 2: {
                            return 2;
                        }
                    }
                    return 8;
                }
                case 4: {
                    switch (elementRelationship) {
                        case 1: 
                        case 4: {
                            return 4;
                        }
                    }
                    return 8;
                }
            }
            return 8;
        }
        if (type1 instanceof MessageType && type2 == stdlib.getOclMessage()) {
            return 2;
        }
        if (type2 instanceof MessageType && type1 == stdlib.getOclMessage()) {
            return 4;
        }
        if (type1 instanceof TypeType && type2 == stdlib.getOclType()) {
            return 2;
        }
        if (type2 instanceof TypeType && type1 == stdlib.getOclType()) {
            return 4;
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        if (type1 instanceof TupleType || type2 instanceof TupleType) {
            if (!(type1 instanceof TupleType) || !(type2 instanceof TupleType)) {
                return 8;
            }
            List<P> props1 = uml.getAttributes(type1);
            List<P> props2 = uml.getAttributes(type2);
            if (props1.size() != props2.size()) {
                return 8;
            }
            int result = 1;
            for (P prop1 : props1) {
                boolean found = false;
                for (P prop2 : props2) {
                    if (!uml.getName(prop1).equals(uml.getName(prop2))) continue;
                    int propResult = TypeUtil.getRelationship(env, TypeUtil.resolveType(env, uml.getOCLType(prop1)), TypeUtil.resolveType(env, uml.getOCLType(prop2)));
                    if (result == 1) {
                        result = propResult;
                    } else if (result != propResult) {
                        return 8;
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                return 8;
            }
            return result;
        }
        if (type1 instanceof PredefinedType || type2 instanceof PredefinedType) {
            return 8;
        }
        int result = uml.getRelationship(type1, type2);
        if (result == 8 && (implictBaseClassifier = TypeUtil.getImplicitRootClass(env)) != null && uml.isClass(type1) && uml.isClass(type2)) {
            if (type1 == implictBaseClassifier) {
                result = 4;
            } else if (type2 == implictBaseClassifier) {
                result = 2;
            }
        }
        return result;
    }

    static int getRelationship(CollectionKind kind1, CollectionKind kind2) {
        switch (kind1) {
            case BAG_LITERAL: {
                switch (kind2) {
                    case BAG_LITERAL: {
                        return 1;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: {
                        return 1;
                    }
                    case ORDERED_SET_LITERAL: {
                        return 4;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case ORDERED_SET_LITERAL: {
                switch (kind2) {
                    case ORDERED_SET_LITERAL: {
                        return 1;
                    }
                    case SET_LITERAL: 
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case SEQUENCE_LITERAL: {
                switch (kind2) {
                    case SEQUENCE_LITERAL: {
                        return 1;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
        }
        switch (kind2) {
            case COLLECTION_LITERAL: {
                return 1;
            }
        }
        return 4;
    }

    @Deprecated
    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C commonSuperType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) throws SemanticException {
        return TypeUtil.commonSuperType(null, env, type1, type2);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C commonSuperType(Object problemObject, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type1, C type2) {
        C implictBaseClassifier;
        if (type1 != null) {
            type1 = env.getUMLReflection().asOCLType(type1);
        }
        if (type2 != null) {
            type2 = env.getUMLReflection().asOCLType(type2);
        }
        if (ObjectUtil.equal(type1, type2)) {
            return type2;
        }
        OCLStandardLibrary<C> stdlib = env.getOCLStandardLibrary();
        if (type1 == stdlib.getT()) {
            return type2;
        }
        if (type2 == stdlib.getT()) {
            return type1;
        }
        if (type1 == stdlib.getOclVoid() || type1 == stdlib.getInvalid()) {
            return type2;
        }
        if (type2 == stdlib.getOclVoid() || type2 == stdlib.getInvalid()) {
            return type1;
        }
        if (type1 == stdlib.getOclAny() && !(type2 instanceof CollectionType)) {
            return type1;
        }
        if (type2 == stdlib.getOclAny() && !(type1 instanceof CollectionType)) {
            return type2;
        }
        if ((type1 == stdlib.getInteger() || type1 == stdlib.getUnlimitedNatural()) && type2 == stdlib.getReal()) {
            return type2;
        }
        if ((type2 == stdlib.getInteger() || type2 == stdlib.getUnlimitedNatural()) && type1 == stdlib.getReal()) {
            return type1;
        }
        if (type1 instanceof CollectionType && type2 instanceof CollectionType) {
            CollectionType ct1 = (CollectionType)type1;
            CollectionType ct2 = (CollectionType)type2;
            CollectionKind commonKind = TypeUtil.commonSuperType(ct1.getKind(), ct2.getKind());
            C resultElementType = TypeUtil.commonSuperType(problemObject, env, ct1.getElementType(), ct2.getElementType());
            return TypeUtil.resolveCollectionType(env, commonKind, resultElementType);
        }
        if (type1 instanceof MessageType && type2 instanceof MessageType) {
            return stdlib.getOclMessage();
        }
        if (type1 instanceof TypeType && type2 instanceof TypeType) {
            return stdlib.getOclType();
        }
        UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = env.getUMLReflection();
        if (type1 instanceof TupleType || type2 instanceof TupleType) {
            if (!(type1 instanceof TupleType) || !(type2 instanceof TupleType)) {
                String message = OCLMessages.bind(OCLMessages.TupleTypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
                TypeUtil.error(env, message, "commonSuperType", problemObject);
                return null;
            }
            List<P> props1 = uml.getAttributes(type1);
            List<P> props2 = uml.getAttributes(type2);
            if (props1.size() != props2.size()) {
                String message = OCLMessages.bind(OCLMessages.TupleFieldNumMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
                TypeUtil.error(env, message, "commonSuperType", problemObject);
                return null;
            }
            OCLFactory oclFactory = env.getOCLFactory();
            BasicEList tupleParts = new BasicEList();
            for (P prop1 : props1) {
                boolean found = false;
                for (P prop2 : props2) {
                    if (!uml.getName(prop1).equals(uml.getName(prop2))) continue;
                    C resultElementType = TypeUtil.commonSuperType(problemObject, env, TypeUtil.resolveType(env, uml.getOCLType(prop1)), TypeUtil.resolveType(env, uml.getOCLType(prop2)));
                    found = true;
                    Variable var = oclFactory.createVariable();
                    uml.setName(var, TypeUtil.getName(env, prop1));
                    uml.setType(var, resultElementType);
                    tupleParts.add(var);
                    break;
                }
                if (found) continue;
                String message = OCLMessages.bind(OCLMessages.TupleFieldNotFound_ERROR_, new Object[]{TypeUtil.getName(env, type1), TypeUtil.getName(env, prop1), TypeUtil.getName(env, type2)});
                TypeUtil.error(env, message, "commonSuperType", problemObject);
                return null;
            }
            return TypeUtil.resolveTupleType(env, tupleParts);
        }
        if (type1 instanceof PredefinedType || type2 instanceof PredefinedType) {
            String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
            TypeUtil.error(env, message, "commonSuperType", problemObject);
            return null;
        }
        C result = uml.getCommonSuperType(type1, type2);
        if (result == null && (implictBaseClassifier = TypeUtil.getImplicitRootClass(env)) != null && uml.isClass(type1) && uml.isClass(type2)) {
            result = implictBaseClassifier;
        }
        if (result == null) {
            String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, TypeUtil.getName(env, type1), TypeUtil.getName(env, type2));
            TypeUtil.error(env, message, "commonSuperType", problemObject);
            return null;
        }
        return result;
    }

    private static CollectionKind commonSuperType(CollectionKind kind1, CollectionKind kind2) {
        CollectionKind genericCollectionKind = CollectionKind.COLLECTION_LITERAL;
        switch (kind1) {
            case BAG_LITERAL: 
            case SEQUENCE_LITERAL: {
                if (kind2 == kind1) {
                    return kind1;
                }
                return genericCollectionKind;
            }
            case SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: 
                    case ORDERED_SET_LITERAL: {
                        return kind1;
                    }
                }
                return genericCollectionKind;
            }
            case ORDERED_SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: 
                    case ORDERED_SET_LITERAL: {
                        return kind2;
                    }
                }
                return genericCollectionKind;
            }
        }
        return genericCollectionKind;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> String getName(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object element) {
        return element == null ? null : env.getUMLReflection().getName(element);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        return type != null ? env.getTypeResolver().resolve(type) : type;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.SET_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveOrderedSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.ORDERED_SET_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveBagType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.BAG_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSequenceType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveCollectionType(env, CollectionKind.SEQUENCE_LITERAL, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveCollectionType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CollectionKind kind, C elementType) {
        return (C)env.getTypeResolver().resolveCollectionType(kind, elementType);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveTupleType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EList<? extends TypedElement<C>> parts) {
        return (C)env.getTypeResolver().resolveTupleType(parts);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveTypeType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        return (C)env.getTypeResolver().resolveTypeType(type);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveOperationMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        return (C)env.getTypeResolver().resolveOperationMessageType(operation);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> C resolveSignalMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C signal) {
        return (C)env.getTypeResolver().resolveSignalMessageType(signal);
    }

    private static void error(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, String problemMessage, String problemContext, Object problemObject) {
        OCLUtil.getAdapter(env, BasicEnvironment.class).utilityError(problemMessage, problemContext, problemObject);
    }
}

