/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.common.AbstractAtlSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlModelSelection
extends AbstractAtlSelection {
    private static final String DEFAULT_METAMODEL_NAME = "MM";
    private Text modelNameText;
    private Text metamodelNameText;
    private AtlModelSelectionBox loadResourceBox;
    private String defaultModelName;
    private Map<String, String> inputFromParent;
    private Map<String, String> outputFromParent;
    private Map<String, String> pathsFromParent;

    public AtlModelSelection(Shell parent, String title, String defaultModelName, Map<String, String> input, Map<String, String> output, Map<String, String> paths) {
        super(parent, title);
        this.defaultModelName = defaultModelName;
        this.inputFromParent = input;
        this.outputFromParent = output;
        this.pathsFromParent = paths;
    }

    @Override
    public void create() {
        super.create();
        this.modelNameText.setText(this.getDefaultName(this.defaultModelName, this.getExistingModels()));
        this.metamodelNameText.setText(this.getDefaultName(DEFAULT_METAMODEL_NAME, this.getExistingMetamodels()));
        this.metamodelNameText.setFocus();
        this.metamodelNameText.selectAll();
    }

    private Set<String> getExistingModels() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.inputFromParent.keySet());
        res.addAll(this.outputFromParent.keySet());
        return res;
    }

    private Set<String> getExistingMetamodels() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.inputFromParent.values());
        res.addAll(this.outputFromParent.values());
        return res;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group modelSection = new Group(container, 0);
        modelSection.setText(Messages.getString("AtlModelSelection.NAMING"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        modelSection.setLayout((Layout)layout);
        data = new GridData(768);
        modelSection.setLayoutData((Object)data);
        Label modelLabel = new Label((Composite)modelSection, 0);
        modelLabel.setText(Messages.getString("AtlModelSelection.MODEL_NAME"));
        modelLabel.setLayoutData((Object)new GridData());
        this.modelNameText = new Text((Composite)modelSection, 2048);
        this.modelNameText.setLayoutData((Object)new GridData(768));
        this.modelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlModelSelection.this.textChanged();
            }
        });
        Label metamodelLabel = new Label((Composite)modelSection, 0);
        metamodelLabel.setText(Messages.getString("AtlModelSelection.METAMODEL_NAME"));
        metamodelLabel.setLayoutData((Object)new GridData());
        this.metamodelNameText = new Text((Composite)modelSection, 2048);
        this.metamodelNameText.setLayoutData((Object)new GridData(768));
        this.metamodelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlModelSelection.this.textChanged();
            }
        });
        Group uriSection = new Group(container, 0);
        uriSection.setText(Messages.getString("AtlModelSelection.METAMODEL_LOCATION"));
        uriSection.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        uriSection.setLayoutData((Object)data);
        this.loadResourceBox = new AtlModelSelectionBox(this.getShell());
        Composite composite = (Composite)this.loadResourceBox.createDialogComposite((Composite)uriSection);
        composite.getChildren()[composite.getChildren().length - 1].dispose();
        composite.setLayoutData((Object)data);
        return container;
    }

    private void textChanged() {
        String modelMessage = this.checkText(Messages.getString("AtlModelSelection.MODEL"), this.modelNameText.getText());
        String metamodelMessage = this.checkText(Messages.getString("AtlModelSelection.METAMODEL"), this.metamodelNameText.getText());
        if (modelMessage != null) {
            this.nok(modelMessage);
        } else if (metamodelMessage != null) {
            this.nok(metamodelMessage);
        } else if (this.getExistingModels().contains(this.modelNameText.getText())) {
            this.nok(Messages.getString("AtlModelSelection.MODEL_EXISTS"));
        } else if (this.getExistingMetamodels().contains(this.metamodelNameText.getText())) {
            this.loadResourceBox.setText(this.pathsFromParent.get(this.metamodelNameText.getText()));
            this.warn(Messages.getString("AtlModelSelection.METAMODEL_EXISTS"));
        } else {
            this.ok();
        }
    }

    private String checkText(String type, String text) {
        if (text == null || "".equals(text)) {
            return Messages.getString("AtlModelSelection.SET_NAME", type);
        }
        if (!text.matches("[a-zA-Z0-9]+")) {
            return Messages.getString("AtlModelSelection.INVALID_NAME", type);
        }
        return null;
    }

    protected void computeResult() {
        String resource = this.loadResourceBox.getURIText();
        Object[] result = resource != null && !"".equals(resource) ? new Object[]{this.modelNameText.getText(), this.metamodelNameText.getText(), resource} : new Object[]{this.modelNameText.getText(), this.metamodelNameText.getText()};
        this.setResult(Arrays.asList(result));
    }

    private class AtlModelSelectionBox
    extends EcoreActionBarContributor.ExtendedLoadResourceAction.ExtendedLoadResourceDialog {
        private Shell shell;

        public AtlModelSelectionBox(Shell arg0) {
            super(arg0, null);
            this.shell = arg0;
        }

        public Shell getShell() {
            return this.shell;
        }

        public Control createDialogComposite(Composite parent) {
            return super.createDialogArea(parent);
        }

        public String getURIText() {
            String res = super.getURIText();
            if (res != null && res.contains(" ")) {
                res = res.split(" ")[0];
            }
            return res;
        }

        public void setText(String text) {
            this.uriField.setText(text);
        }
    }
}

