/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLOntology.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>OWL Ontology</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLbackwardCompatibleWith <em>OWLbackwardCompatibleWith</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLimports <em>OWLimports</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLversionInfo <em>OWLversionInfo</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLpriorVersion <em>OWLpriorVersion</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOWLincompatibleWith <em>OWLincompatibleWith</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlGraph <em>owlGraph</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlStatement <em>owlStatement</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse <em>owlUniverse</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology()
 * @model
 * @generated
 */
public interface OWLOntology extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>OWLbackwardCompatibleWith</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLOntology}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lbackward Compatible With</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLbackwardCompatibleWith</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OWLbackwardCompatibleWith()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLOntology"
	 * @generated
	 */
	EList getOWLbackwardCompatibleWith();

	/**
	 * Returns the value of the '<em><b>OWLimports</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLOntology}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Limports</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLimports</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OWLimports()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLOntology"
	 * @generated
	 */
	EList getOWLimports();

	/**
	 * Returns the value of the '<em><b>OWLversionInfo</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lversion Info</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLversionInfo</em>' containment reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OWLversionInfo()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSLiteral" containment="true"
	 * @generated
	 */
	EList getOWLversionInfo();

	/**
	 * Returns the value of the '<em><b>OWLpriorVersion</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLOntology}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lprior Version</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLpriorVersion</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OWLpriorVersion()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLOntology"
	 * @generated
	 */
	EList getOWLpriorVersion();

	/**
	 * Returns the value of the '<em><b>OWLincompatibleWith</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLOntology}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lincompatible With</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLincompatibleWith</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OWLincompatibleWith()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLOntology"
	 * @generated
	 */
	EList getOWLincompatibleWith();

	/**
	 * Returns the value of the '<em><b>owlGraph</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLGraph}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.owl.owlbase.OWLGraph#getGraphontology <em>graphontology</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owl Graph</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>owlGraph</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OwlGraph()
	 * @see org.eclipse.eodm.owl.owlbase.OWLGraph#getGraphontology
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLGraph" opposite="graphontology" required="true"
	 * @generated
	 */
	EList getOwlGraph();

	/**
	 * Returns the value of the '<em><b>owlStatement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.Statement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owl Statement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>owlStatement</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OwlStatement()
	 * @model type="org.eclipse.eodm.owl.owlbase.Statement" required="true"
	 * @generated
	 */
	EList getOwlStatement();

	/**
	 * Returns the value of the '<em><b>owlUniverse</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.owl.owlbase.Universe#getOntology <em>ontology</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owl Universe</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>owlUniverse</em>' reference.
	 * @see #setOwlUniverse(Universe)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLOntology_OwlUniverse()
	 * @see org.eclipse.eodm.owl.owlbase.Universe#getOntology
	 * @model opposite="ontology" required="true"
	 * @generated
	 */
	Universe getOwlUniverse();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse <em>owlUniverse</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>owlUniverse</em>' reference.
	 * @see #getOwlUniverse()
	 * @generated
	 */
	void setOwlUniverse(Universe value);

} // OWLOntology
