/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PackageOperations
extends NamespaceOperations {
    protected PackageOperations() {
    }

    public static boolean validateElementsPublicOrPrivate(Package package_, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator ownedElements = package_.getOwnedElements().iterator();
        while (ownedElements.hasNext()) {
            VisibilityKind visibility;
            Element ownedElement = (Element)ownedElements.next();
            if (!(ownedElement instanceof NamedElement) || (visibility = ((NamedElement)ownedElement).getVisibility()) == null || visibility == VisibilityKind.PUBLIC_LITERAL || visibility == VisibilityKind.PRIVATE_LITERAL) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 3, UMLPlugin.INSTANCE.getString("_UI_Package_ElementsPublicOrPrivate_diagnostic", PackageOperations.getMessageSubstitutions((Map)context, (Object)ownedElement, (Object)package_)), new Object[]{package_, ownedElement}));
        }
        return result;
    }

    public static Class createOwnedClass(Package package_, String name, boolean isAbstract) {
        Class ownedClass = (Class)package_.createOwnedType(name, UMLPackage.Literals.CLASS);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Package package_, String name) {
        return (Enumeration)package_.createOwnedType(name, UMLPackage.Literals.ENUMERATION);
    }

    public static PrimitiveType createOwnedPrimitiveType(Package package_, String name) {
        return (PrimitiveType)package_.createOwnedType(name, UMLPackage.Literals.PRIMITIVE_TYPE);
    }

    public static boolean isProfileApplied(Package package_, Profile profile) {
        return PackageOperations.getProfileApplication(package_, profile) != null;
    }

    public static EList applyProfile(Package package_, Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.valueOf(profile));
        }
        EPackage profileDefinition = profile.getDefinition();
        if (profileDefinition == null) {
            throw new IllegalArgumentException(String.valueOf(profile));
        }
        if (package_.getProfileApplication(profile) == null) {
            package_.createProfileApplication().setAppliedProfile(profile);
        }
        UniqueEList.FastCompare stereotypeApplications = new UniqueEList.FastCompare();
        StereotypeApplicationCopier copier = new StereotypeApplicationCopier(profile);
        TreeIterator allContents = PackageOperations.getAllContents((EObject)package_, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            Object object = allContents.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element instanceof Package) {
                Iterator profileApplications = ((Package)element).getProfileApplications().iterator();
                while (profileApplications.hasNext()) {
                    ProfileApplication profileApplication = (ProfileApplication)profileApplications.next();
                    if (profileApplication.getAppliedProfile() != profile) continue;
                    EList references = PackageOperations.getEAnnotation((EModelElement)profileApplication, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getReferences();
                    if (references.isEmpty()) {
                        references.add((Object)profileDefinition);
                        continue;
                    }
                    references.set(0, (Object)profileDefinition);
                }
            }
            Iterator sa = element.getStereotypeApplications().iterator();
            while (sa.hasNext()) {
                EObject stereotypeApplication = (EObject)sa.next();
                Stereotype stereotype = PackageOperations.getStereotype(stereotypeApplication);
                if (stereotype == null || stereotype.getProfile() != profile) continue;
                if (element.isStereotypeApplicable(stereotype)) {
                    EObject copy = copier.copy(stereotypeApplication);
                    Resource eResource = stereotypeApplication.eResource();
                    if (eResource != null) {
                        EList contents = eResource.getContents();
                        if (eResource == copy.eResource()) {
                            contents.move(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                        } else {
                            contents.set(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                        }
                    }
                }
                stereotypeApplications.add((Object)stereotypeApplication);
            }
        }
        copier.copyReferences();
        PackageOperations.destroyAll((Collection)stereotypeApplications);
        EList requiredExtensions = profile.getOwnedExtensions(true);
        return requiredExtensions.isEmpty() ? ECollections.EMPTY_ELIST : PackageOperations.applyAllRequiredStereotypes(package_);
    }

    public static EList unapplyProfile(Package package_, Profile profile) {
        if (profile == null || package_.getProfileApplication(profile) == null) {
            throw new IllegalArgumentException(String.valueOf(profile));
        }
        UniqueEList.FastCompare profileApplications = new UniqueEList.FastCompare();
        TreeIterator allContents = PackageOperations.getAllContents((EObject)package_, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            Object object = allContents.next();
            if (!(object instanceof Package)) continue;
            Iterator pa = ((Package)object).getProfileApplications().iterator();
            while (pa.hasNext()) {
                ProfileApplication profileApplication = (ProfileApplication)pa.next();
                if (profileApplication.getAppliedProfile() != profile) continue;
                profileApplications.add((Object)profileApplication);
            }
        }
        PackageOperations.destroyAll((Collection)profileApplications);
        return package_.getAllAppliedProfiles().contains((Object)profile) ? ECollections.EMPTY_ELIST : PackageOperations.unapplyAllNonApplicableStereotypes(package_);
    }

    protected static EList getAppliedProfiles(Package package_, EList appliedProfiles) {
        Iterator profileApplications = package_.getProfileApplications().iterator();
        while (profileApplications.hasNext()) {
            Profile appliedProfile = ((ProfileApplication)profileApplications.next()).getAppliedProfile();
            if (appliedProfile == null) continue;
            appliedProfiles.add((Object)appliedProfile);
        }
        return appliedProfiles;
    }

    public static EList getAppliedProfiles(Package package_) {
        return PackageOperations.getAppliedProfiles(package_, (EList)new UniqueEList.FastCompare());
    }

    public static Profile getAppliedProfile(Package package_, String qualifiedName) {
        Iterator profileApplications = package_.getProfileApplications().iterator();
        while (profileApplications.hasNext()) {
            Profile appliedProfile = ((ProfileApplication)profileApplications.next()).getAppliedProfile();
            if (appliedProfile == null || !PackageOperations.safeEquals((Object)appliedProfile.getQualifiedName(), (Object)qualifiedName)) continue;
            return appliedProfile;
        }
        return null;
    }

    public static Profile getAppliedProfile(Package package_, String qualifiedName, boolean recurse) {
        Profile appliedProfile = package_.getAppliedProfile(qualifiedName);
        if (appliedProfile == null && recurse) {
            Element owner = package_.getOwner();
            while (owner != null && appliedProfile == null) {
                if (owner instanceof Package) {
                    appliedProfile = ((Package)owner).getAppliedProfile(qualifiedName);
                }
                owner = owner.getOwner();
            }
        }
        return appliedProfile;
    }

    public static EList getAllProfileApplications(Package package_) {
        UniqueEList.FastCompare allProfileApplications = new UniqueEList.FastCompare((Collection)package_.getProfileApplications());
        Iterator allOwningPackages = package_.allOwningPackages().iterator();
        while (allOwningPackages.hasNext()) {
            allProfileApplications.addAll((Collection)((Package)allOwningPackages.next()).getProfileApplications());
        }
        return ECollections.unmodifiableEList((EList)allProfileApplications);
    }

    public static ProfileApplication getProfileApplication(Package package_, Profile profile) {
        Iterator profileApplications = package_.getProfileApplications().iterator();
        while (profileApplications.hasNext()) {
            ProfileApplication profileApplication = (ProfileApplication)profileApplications.next();
            if (profileApplication.getAppliedProfile() != profile) continue;
            return profileApplication;
        }
        return null;
    }

    public static ProfileApplication getProfileApplication(Package package_, Profile profile, boolean recurse) {
        ProfileApplication profileApplication = package_.getProfileApplication(profile);
        if (profileApplication == null && recurse) {
            Element owner = package_.getOwner();
            while (owner != null && profileApplication == null) {
                if (owner instanceof Package) {
                    profileApplication = ((Package)owner).getProfileApplication(profile);
                }
                owner = owner.getOwner();
            }
        }
        return profileApplication;
    }

    public static Interface createOwnedInterface(Package package_, String name) {
        return (Interface)package_.createOwnedType(name, UMLPackage.Literals.INTERFACE);
    }

    public static boolean isModelLibrary(Package package_) {
        return package_.getAppliedStereotype("Standard::ModelLibrary") != null;
    }

    public static EList getAllAppliedProfiles(Package package_) {
        EList allAppliedProfiles = PackageOperations.getAppliedProfiles(package_, (EList)new UniqueEList.FastCompare());
        Iterator allOwningPackages = package_.allOwningPackages().iterator();
        while (allOwningPackages.hasNext()) {
            PackageOperations.getAppliedProfiles((Package)allOwningPackages.next(), allAppliedProfiles);
        }
        return ECollections.unmodifiableEList((EList)allAppliedProfiles);
    }

    protected static EList getAllImportedPackages(Package package_, EList allImportedPackages) {
        Iterator packageImports = package_.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            Package importedPackage;
            PackageImport packageImport = (PackageImport)packageImports.next();
            if (packageImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL || (importedPackage = packageImport.getImportedPackage()) == null || !allImportedPackages.add((Object)importedPackage)) continue;
            PackageOperations.getAllImportedPackages(importedPackage, allImportedPackages);
        }
        return allImportedPackages;
    }

    protected static EList visibleMembers(Package package_, EList visibleMembers) {
        Iterator ownedMembers = package_.getOwnedMembers().iterator();
        while (ownedMembers.hasNext()) {
            PackageableElement ownedMember = (PackageableElement)ownedMembers.next();
            if (ownedMember.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            visibleMembers.add((Object)ownedMember);
        }
        Iterator elementImports = package_.getElementImports().iterator();
        while (elementImports.hasNext()) {
            PackageableElement importedElement;
            ElementImport elementImport = (ElementImport)elementImports.next();
            if (elementImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL || (importedElement = elementImport.getImportedElement()) == null) continue;
            visibleMembers.add((Object)importedElement);
        }
        return visibleMembers;
    }

    public static EList visibleMembers(Package package_) {
        EList visibleMembers = PackageOperations.visibleMembers(package_, (EList)new UniqueEList.FastCompare());
        Iterator allImportedPackages = PackageOperations.getAllImportedPackages(package_, (EList)new UniqueEList.FastCompare()).iterator();
        while (allImportedPackages.hasNext()) {
            PackageOperations.visibleMembers((Package)allImportedPackages.next(), visibleMembers);
        }
        return ECollections.unmodifiableEList((EList)visibleMembers);
    }

    public static boolean makesVisible(Package package_, NamedElement el) {
        if (package_.getOwnedMembers().contains((Object)el)) {
            return el.getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        Iterator elementImports = package_.getElementImports().iterator();
        while (elementImports.hasNext()) {
            ElementImport elementImport = (ElementImport)elementImports.next();
            if (!PackageOperations.safeEquals((Object)elementImport.getImportedElement(), (Object)el)) continue;
            return elementImport.getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        Iterator packageImports = package_.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            PackageImport packageImport = (PackageImport)packageImports.next();
            if (packageImport.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            Package importedPackage = packageImport.getImportedPackage();
            return importedPackage != null && importedPackage.visibleMembers().contains((Object)el);
        }
        return false;
    }

    public static boolean mustBeOwned(Package package_) {
        return false;
    }

    protected static boolean containsSpecializations(Package package_, Classifier classifier) {
        Iterator ownedTypes = package_.getOwnedTypes().iterator();
        while (ownedTypes.hasNext()) {
            Object ownedType = ownedTypes.next();
            if (!(ownedType instanceof Classifier) || !((Classifier)ownedType).allParents().contains((Object)classifier)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ EObject access$0(Element element, EClass eClass) {
        return UMLUtil.applyStereotype(element, eClass);
    }

    static /* synthetic */ NamedElement access$1(ENamedElement eNamedElement) {
        return UMLUtil.getNamedElement(eNamedElement);
    }

    protected static class StereotypeApplicationCopier
    extends EcoreUtil.Copier {
        protected final Profile profile;

        protected StereotypeApplicationCopier(Profile profile) {
            this.profile = profile;
        }

        protected EObject createCopy(EObject eObject) {
            Element baseElement = PackageOperations.getBaseElement(eObject);
            return baseElement == null ? super.createCopy(eObject) : PackageOperations.access$0(baseElement, this.getTarget(eObject.eClass()));
        }

        protected EClass getTarget(EClass eClass) {
            return (EClass)this.profile.getDefinition(PackageOperations.access$1((ENamedElement)eClass));
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            return (EStructuralFeature)this.profile.getDefinition(PackageOperations.access$1((ENamedElement)eStructuralFeature));
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (!eAttribute.isUnsettable() || eObject.eIsSet((EStructuralFeature)eAttribute)) {
                try {
                    if (eAttribute.getEType().eClass().getClassifierID() == 5) {
                        this.copyEEnumAttribute(eAttribute, eObject, copyEObject);
                    } else {
                        this.copyEDataTypeAttribute(eAttribute, eObject, copyEObject);
                    }
                }
                catch (Exception e) {
                    UMLPlugin.INSTANCE.log(e);
                }
            }
        }

        protected void copyEDataTypeAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            EDataType eDataType = eAttribute.getEAttributeType();
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            EAttribute targetEAttribute = (EAttribute)this.getTarget((EStructuralFeature)eAttribute);
            EDataType targetEDataType = targetEAttribute.getEAttributeType();
            EFactory targetEFactory = targetEDataType.getEPackage().getEFactoryInstance();
            if (targetEAttribute.isMany()) {
                EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEAttribute);
                if (eAttribute.isMany()) {
                    EList values = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                    int i = 0;
                    int size = values.size();
                    while (i < size) {
                        copyValues.add(i, targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, values.get(i))));
                        ++i;
                    }
                } else {
                    copyValues.add(targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, eObject.eGet((EStructuralFeature)eAttribute))));
                }
            } else {
                copyEObject.eSet((EStructuralFeature)targetEAttribute, targetEFactory.createFromString(targetEDataType, eFactory.convertToString(eDataType, eAttribute.isMany() ? ((EList)eObject.eGet((EStructuralFeature)eAttribute)).get(0) : eObject.eGet((EStructuralFeature)eAttribute))));
            }
        }

        protected void copyEEnumAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            EAttribute targetEAttribute = (EAttribute)this.getTarget((EStructuralFeature)eAttribute);
            EEnum targetEEnum = (EEnum)targetEAttribute.getEAttributeType();
            if (targetEAttribute.isMany()) {
                EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEAttribute);
                if (eAttribute.isMany()) {
                    EList values = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                    int i = 0;
                    int size = values.size();
                    while (i < size) {
                        EEnumLiteral value = targetEEnum.getEEnumLiteral(((EEnumLiteral)values.get(i)).getName());
                        if (value != null) {
                            copyValues.add((Object)value.getInstance());
                        }
                        ++i;
                    }
                } else {
                    EEnumLiteral value = targetEEnum.getEEnumLiteral(((EEnumLiteral)eObject.eGet((EStructuralFeature)eAttribute)).getName());
                    if (value != null) {
                        copyValues.add((Object)value.getInstance());
                    }
                }
            } else {
                EEnumLiteral value = targetEEnum.getEEnumLiteral(((EEnumLiteral)(eAttribute.isMany() ? ((EList)eObject.eGet((EStructuralFeature)eAttribute)).get(0) : eObject.eGet((EStructuralFeature)eAttribute))).getName());
                if (value != null) {
                    copyEObject.eSet((EStructuralFeature)targetEAttribute, (Object)value.getInstance());
                }
            }
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                Object value = eObject.eGet((EStructuralFeature)eReference);
                try {
                    EReference targetEReference = (EReference)this.getTarget((EStructuralFeature)eReference);
                    if (targetEReference.isMany()) {
                        EList copyValues = (EList)copyEObject.eGet((EStructuralFeature)targetEReference);
                        if (eReference.isMany()) {
                            copyValues.addAll(this.copyAll((Collection)((EList)value)));
                        } else if (value != null) {
                            copyValues.add((Object)this.copy((EObject)value));
                        }
                    } else {
                        copyEObject.eSet((EStructuralFeature)targetEReference, (Object)this.copy((EObject)(eReference.isMany() ? ((EList)value).get(0) : value)));
                    }
                }
                catch (Exception e) {
                    UMLPlugin.INSTANCE.log(e);
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                Object value = eObject.eGet((EStructuralFeature)eReference);
                try {
                    EReference targetEReference = (EReference)this.getTarget((EStructuralFeature)eReference);
                    if (targetEReference.isMany()) {
                        InternalEList copyValues = (InternalEList)copyEObject.eGet((EStructuralFeature)targetEReference);
                        if (eReference.isMany()) {
                            EReference targetEOpposite = targetEReference.getEOpposite();
                            int index = 0;
                            Iterator v = ((EList)value).iterator();
                            while (v.hasNext()) {
                                value = v.next();
                                Object copyValue = this.get(value);
                                if (copyValue == null) {
                                    if (targetEOpposite != null) continue;
                                    copyValues.addUnique(index++, value);
                                    continue;
                                }
                                if (targetEOpposite != null) {
                                    int position = copyValues.indexOf(copyValue);
                                    if (position == -1) {
                                        copyValues.addUnique(index++, copyValue);
                                        continue;
                                    }
                                    if (position == index) continue;
                                    copyValues.move(index++, copyValue);
                                    continue;
                                }
                                copyValues.addUnique(index++, copyValue);
                            }
                        } else if (value != null) {
                            Object copyValue = this.get(value);
                            if (copyValue == null) {
                                if (targetEReference.getEOpposite() == null) {
                                    copyValues.addUnique(value);
                                }
                            } else {
                                copyValues.addUnique(copyValue);
                            }
                        }
                    } else {
                        Object copyValue;
                        if (eReference.isMany()) {
                            value = ((EList)value).get(0);
                        }
                        if ((copyValue = this.get(value)) == null) {
                            if (targetEReference.getEOpposite() == null) {
                                copyEObject.eSet((EStructuralFeature)targetEReference, value);
                            }
                        } else {
                            copyEObject.eSet((EStructuralFeature)targetEReference, copyValue);
                        }
                    }
                }
                catch (Exception e) {
                    UMLPlugin.INSTANCE.log(e);
                }
            }
        }
    }
}

