/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMInteractionOperand;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMVisibleFrameWithPentagon;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsList;

public class LMCombinedFragment
extends LMVisibleFrameWithPentagon {
    private Color myHasColorBeforeViolated = null;

    LMCombinedFragment(AbsNode gdeNode) {
        super(gdeNode);
    }

    public void checkConsistancy() {
        super.checkConsistancy();
        this.checkInteractionOperands();
    }

    public int getInnerHorizontalPadding() {
        return 0;
    }

    public int getOuterHorizontalPadding() {
        return 3;
    }

    public int getTopInnerPadding() {
        return 20;
    }

    protected void setX(int x) {
        super.setX(x);
        for (LMFrame childFrame : this.getChildList()) {
            if (!(childFrame instanceof LMInteractionOperand)) continue;
            childFrame.setX(x + 0);
        }
    }

    protected void setWidth(int width) {
        super.setWidth(width);
        if (width < 0) {
            width = 0;
        }
        for (LMFrame childFrame : this.getChildList()) {
            if (!(childFrame instanceof LMInteractionOperand)) continue;
            childFrame.setWidth(width - 0);
        }
    }

    private void checkInteractionOperands() {
        try {
            ArrayList<LMFrame> operandList = new ArrayList<LMFrame>(this.getChildList().size());
            for (LMFrame lmFrame : this.getChildList()) {
                if (!(lmFrame instanceof LMInteractionOperand)) {
                    throw new IncorrectInteractionOperand("'CombinedFragment' contains frame other than 'InteractionOperand'");
                }
                LMInteractionOperand interactionOperand = (LMInteractionOperand)lmFrame;
                if (interactionOperand.getMountingLinksList().size() != this.getMountingLinksList().size()) {
                    throw new IncorrectInteractionOperand("'InteractionOperand' tied to wrong number of lifelines");
                }
                operandList.add(lmFrame);
            }
            Enumeration mountLinksEnum = this.mountingLinks();
            while (mountLinksEnum.hasMoreElements()) {
                LMMountingLink mountingLink1 = (LMMountingLink)mountLinksEnum.nextElement();
                LMMountingRegion region1 = mountingLink1.getMountingRegion();
                if (region1 == null) continue;
                LmBracketsList childBracketsList = region1.getChildBracketsList();
                if (operandList.size() != childBracketsList.size()) {
                    throw new IncorrectInteractionOperand("Number of 'MountingRegion's on lifeline differs from number of 'InteractionOperands's");
                }
                int operandIndex = 0;
                Iterator it = childBracketsList.iterator();
                while (it.hasNext()) {
                    LMLifeLineBracket subBracket = (LMLifeLineBracket)it.next();
                    if (!(subBracket instanceof LMMountingRegion)) {
                        throw new IncorrectInteractionOperand("'MountingRegion' on lifeline contains bracket other than 'MountingRegion'");
                    }
                    LMMountingRegion region2 = (LMMountingRegion)subBracket;
                    LMMountingLink mountingLink2 = region2.getMountingLink();
                    if (mountingLink2 == null) {
                        throw new IncorrectInteractionOperand("'MountingRegion' on lifeline contains sub-'MountingRegion' with no 'MountingLink'");
                    }
                    LMFrame lmFrame2 = mountingLink2.getFrame();
                    if (lmFrame2 == null) {
                        throw new IncorrectInteractionOperand("'MountingRegion' on lifeline contains sub-'MountingRegion' with broken 'MountingLink'");
                    }
                    if (!(lmFrame2 instanceof LMInteractionOperand)) {
                        throw new IncorrectInteractionOperand("'MountingRegion' on lifeline contains sub-'MountingRegion' tied to some frame other than 'InteractionOperand'");
                    }
                    LMInteractionOperand interactionOperand = (LMInteractionOperand)lmFrame2;
                    if (operandList.get(operandIndex) != interactionOperand) {
                        if (operandList.contains(interactionOperand)) {
                            throw new IncorrectInteractionOperand("'MountingRegion' #" + operandIndex + " on lifeline refers to wrong 'InteractionOperand'");
                        }
                        throw new IncorrectInteractionOperand("'MountingRegion' on lifeline contains sub-'MountingRegion' tied to some alien 'InteractionOperand'");
                    }
                    ++operandIndex;
                }
            }
            this.invalidateCombinedFragment(null);
        }
        catch (IncorrectInteractionOperand e) {
            this.invalidateCombinedFragment(e);
        }
    }

    private void invalidateCombinedFragment(IncorrectInteractionOperand explanation) {
        if (explanation == null && this.myHasColorBeforeViolated != null) {
            this.getGdeNode().setForeground(this.myHasColorBeforeViolated);
            this.myHasColorBeforeViolated = null;
        } else if (explanation != null && this.myHasColorBeforeViolated == null) {
            this.myHasColorBeforeViolated = this.getGdeNode().getForeground();
            this.getGdeNode().setForeground(explanation.getErrorColor());
        }
    }

    protected int getPentagonOffset() {
        return 1;
    }

    private static class IncorrectInteractionOperand
    extends Exception {
        private final Color myErrorColor;

        IncorrectInteractionOperand(String message) {
            this(message, Color.RED);
        }

        IncorrectInteractionOperand(String message, Color errorColor) {
            this(message, null, errorColor);
        }

        private IncorrectInteractionOperand(String message, Throwable cause, Color errorColor) {
            super(message, cause);
            this.myErrorColor = errorColor;
        }

        Color getErrorColor() {
            return this.myErrorColor;
        }
    }
}

