/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.internal.parser;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CallExp;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.LoopExp;
import org.eclipse.emf.ocl.expressions.NavigationCallExp;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.internal.parser.CompatibilityUtil;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.types.AnyType;
import org.eclipse.emf.ocl.types.ElementType;
import org.eclipse.emf.ocl.types.InvalidType;
import org.eclipse.emf.ocl.types.MessageType;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.PrimitiveInteger;
import org.eclipse.emf.ocl.types.PrimitiveReal;
import org.eclipse.emf.ocl.types.PrimitiveString;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.VoidType;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeTypeImpl;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.types.util.TypesSwitch;
import org.eclipse.emf.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.ecore.AssociationClassCallExp;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionRange;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.MessageExp;
import org.eclipse.ocl.ecore.NullLiteralExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TupleLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToNewASVisitor
implements Visitor {
    private Environment env;
    private TypesSwitch<EClassifier> typesSwitch;

    private ToNewASVisitor(Environment env) {
        this.env = env;
    }

    static ToNewASVisitor getInstance(Environment env) {
        return new ToNewASVisitor(env);
    }

    private void copyASTNode(org.eclipse.emf.ocl.utilities.ASTNode src, ASTNode dst) {
        dst.setStartPosition(src.getStartPosition());
        dst.setEndPosition(src.getEndPosition());
    }

    private void copyTypedASTNode(TypedASTNode src, org.eclipse.ocl.utilities.TypedASTNode dst) {
        dst.setTypeStartPosition(src.getTypeStartPosition());
        dst.setTypeEndPosition(src.getTypeEndPosition());
        this.copyASTNode(src, (ASTNode)dst);
    }

    private void copyCallingASTNode(org.eclipse.emf.ocl.utilities.CallingASTNode src, CallingASTNode dst) {
        dst.setPropertyStartPosition(src.getPropertyStartPosition());
        dst.setPropertyEndPosition(src.getPropertyEndPosition());
        this.copyASTNode(src, (ASTNode)dst);
    }

    void copyTypedElement(org.eclipse.emf.ocl.uml.TypedElement src, TypedElement<EClassifier> dst) {
        ETypedElement element = (ETypedElement)dst;
        element.setName(src.getName());
        element.setEType((EClassifier)CompatibilityUtil.getNewAS(this.env, (EObject)src.getType()));
    }

    void copyCollectionType(org.eclipse.emf.ocl.types.CollectionType src, CollectionType dst) {
        dst.setElementType((Object)((EClassifier)CompatibilityUtil.getNewAS(this.env, (EObject)src.getElementType())));
    }

    void copyTupleLiteralPart(TupleLiteralPart src, org.eclipse.ocl.expressions.TupleLiteralPart<EClassifier, EStructuralFeature> dst) {
        EStructuralFeature attribute = src.getAttribute();
        org.eclipse.ocl.expressions.TupleLiteralExp tuple = (org.eclipse.ocl.expressions.TupleLiteralExp)dst.eContainer();
        org.eclipse.ocl.ecore.TupleType type = (org.eclipse.ocl.ecore.TupleType)tuple.getType();
        for (EStructuralFeature p : type.oclProperties()) {
            if (!p.getName().equals(attribute.getName())) continue;
            dst.setAttribute((Object)p);
            break;
        }
    }

    private void copyNavigationCallExp(NavigationCallExp src, org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature> dst) {
        dst.setNavigationSource((Object)src.getNavigationSource());
        for (org.eclipse.emf.ocl.expressions.OCLExpression q : src.getQualifier()) {
            dst.getQualifier().add((Object)((OCLExpression)CompatibilityUtil.getNewAS(this.env, q)));
        }
        this.copyFeatureCallExp(src, (FeatureCallExp<EClassifier>)dst);
    }

    private void copyFeatureCallExp(org.eclipse.emf.ocl.expressions.FeatureCallExp src, FeatureCallExp<EClassifier> dst) {
        dst.setMarkedPre(src.isMarkedPre());
        this.copyCallExp(src, (org.eclipse.ocl.expressions.CallExp<EClassifier>)dst);
    }

    private void copyCallExp(CallExp src, org.eclipse.ocl.expressions.CallExp<EClassifier> dst) {
        dst.setSource((OCLExpression)CompatibilityUtil.getNewAS(this.env, src.getSource()));
        this.copyOCLExpression(src, (OCLExpression<EClassifier>)dst);
        this.copyCallingASTNode(src, (CallingASTNode)dst);
    }

    private void copyOCLExpression(org.eclipse.emf.ocl.expressions.OCLExpression src, OCLExpression<EClassifier> dst) {
        this.copyTypedElement(src, (TypedElement<EClassifier>)dst);
        this.copyASTNode(src, (ASTNode)dst);
    }

    private void copyPrimitiveLiteralExp(PrimitiveLiteralExp src, org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier> dst) {
        this.copyLiteralExp(src, (LiteralExp<EClassifier>)dst);
    }

    private void copyLiteralExp(org.eclipse.emf.ocl.expressions.LiteralExp src, LiteralExp<EClassifier> dst) {
        this.copyOCLExpression(src, (OCLExpression<EClassifier>)dst);
    }

    private void copyLoopExp(LoopExp src, org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter> dst) {
        dst.setBody((OCLExpression)CompatibilityUtil.getNewAS(this.env, src.getBody()));
        for (Object i : src.getIterator()) {
            dst.getIterator().add((Object)((org.eclipse.ocl.expressions.Variable)CompatibilityUtil.getNewAS(this.env, (org.eclipse.emf.ocl.expressions.Variable)i)));
        }
        this.copyCallExp(src, (org.eclipse.ocl.expressions.CallExp<EClassifier>)dst);
    }

    @Override
    public Object visitAssociationClassCallExp(org.eclipse.emf.ocl.expressions.AssociationClassCallExp ae) {
        AssociationClassCallExp result = EcoreFactory.eINSTANCE.createAssociationClassCallExp();
        result.setReferredAssociationClass((Object)ae.getReferredAssociationClass());
        for (Object q : ae.getQualifier()) {
            result.getQualifier().add((Object)((OCLExpression)CompatibilityUtil.getNewAS(this.env, (org.eclipse.emf.ocl.expressions.OCLExpression)q)));
        }
        this.copyNavigationCallExp(ae, (org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature>)result);
        return result;
    }

    @Override
    public Object visitBooleanLiteralExp(BooleanLiteralExp bl) {
        org.eclipse.ocl.ecore.BooleanLiteralExp result = EcoreFactory.eINSTANCE.createBooleanLiteralExp();
        result.setBooleanSymbol(bl.getBooleanSymbol());
        this.copyPrimitiveLiteralExp(bl, (org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitCollectionLiteralExp(CollectionLiteralExp cl) {
        org.eclipse.ocl.ecore.CollectionLiteralExp result = EcoreFactory.eINSTANCE.createCollectionLiteralExp();
        result.setKind(cl.getKind().asNewKind());
        for (Object p : cl.getPart()) {
            result.getPart().add((Object)((CollectionLiteralPart)CompatibilityUtil.getNewAS(this.env, (EObject)((org.eclipse.emf.ocl.expressions.CollectionLiteralPart)p))));
        }
        this.copyLiteralExp(cl, (LiteralExp<EClassifier>)result);
        return result;
    }

    public EObject visitCollectionItem(CollectionItem item) {
        org.eclipse.ocl.ecore.CollectionItem result = EcoreFactory.eINSTANCE.createCollectionItem();
        result.setItem((OCLExpression)CompatibilityUtil.getNewAS(this.env, item.getItem()));
        this.copyTypedElement(item, (TypedElement<EClassifier>)result);
        return result;
    }

    public EObject visitCollectionRange(org.eclipse.emf.ocl.expressions.CollectionRange range) {
        CollectionRange result = EcoreFactory.eINSTANCE.createCollectionRange();
        result.setFirst((OCLExpression)CompatibilityUtil.getNewAS(this.env, range.getFirst()));
        result.setLast((OCLExpression)CompatibilityUtil.getNewAS(this.env, range.getLast()));
        this.copyTypedElement(range, (TypedElement<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitConstraint(org.eclipse.emf.ocl.uml.Constraint constraint) {
        Constraint result = EcoreFactory.eINSTANCE.createConstraint();
        org.eclipse.ocl.ecore.ExpressionInOCL specification = EcoreFactory.eINSTANCE.createExpressionInOCL();
        specification.setBodyExpression((OCLExpression)CompatibilityUtil.getNewAS(this.env, constraint.getBody()));
        result.setSpecification((ExpressionInOCL)specification);
        result.setName(constraint.getName());
        result.setStereotype(constraint.getStereotype());
        ECollections.setEList((EList)result.getConstrainedElements(), (List)constraint.getConstrainedElement());
        return result;
    }

    @Override
    public Object visitEnumLiteralExp(org.eclipse.emf.ocl.expressions.EnumLiteralExp el) {
        EnumLiteralExp result = EcoreFactory.eINSTANCE.createEnumLiteralExp();
        result.setReferredEnumLiteral((Object)el.getReferredEnumLiteral());
        this.copyLiteralExp(el, (LiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitIfExp(org.eclipse.emf.ocl.expressions.IfExp i) {
        IfExp result = EcoreFactory.eINSTANCE.createIfExp();
        result.setCondition((OCLExpression)CompatibilityUtil.getNewAS(this.env, i.getCondition()));
        result.setThenExpression((OCLExpression)CompatibilityUtil.getNewAS(this.env, i.getThenExpression()));
        result.setElseExpression((OCLExpression)CompatibilityUtil.getNewAS(this.env, i.getElseExpression()));
        this.copyOCLExpression(i, (OCLExpression<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitIntegerLiteralExp(org.eclipse.emf.ocl.expressions.IntegerLiteralExp il) {
        IntegerLiteralExp result = EcoreFactory.eINSTANCE.createIntegerLiteralExp();
        result.setIntegerSymbol(il.getIntegerSymbol());
        this.copyPrimitiveLiteralExp(il, (org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitInvalidLiteralExp(InvalidLiteralExp il) {
        org.eclipse.ocl.ecore.InvalidLiteralExp result = EcoreFactory.eINSTANCE.createInvalidLiteralExp();
        this.copyLiteralExp(il, (LiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitIterateExp(org.eclipse.emf.ocl.expressions.IterateExp ie) {
        IterateExp result = EcoreFactory.eINSTANCE.createIterateExp();
        result.setResult((org.eclipse.ocl.expressions.Variable)CompatibilityUtil.getNewAS(this.env, ie.getResult()));
        this.copyLoopExp(ie, (org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter>)result);
        return result;
    }

    @Override
    public Object visitIteratorExp(org.eclipse.emf.ocl.expressions.IteratorExp ie) {
        IteratorExp result = EcoreFactory.eINSTANCE.createIteratorExp();
        this.copyLoopExp(ie, (org.eclipse.ocl.expressions.LoopExp<EClassifier, EParameter>)result);
        return result;
    }

    @Override
    public Object visitLetExp(LetExp l) {
        org.eclipse.ocl.ecore.LetExp result = EcoreFactory.eINSTANCE.createLetExp();
        result.setVariable((org.eclipse.ocl.expressions.Variable)CompatibilityUtil.getNewAS(this.env, l.getVariable()));
        result.setIn((OCLExpression)CompatibilityUtil.getNewAS(this.env, l.getIn()));
        this.copyOCLExpression(l, (OCLExpression<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitMessageExp(org.eclipse.emf.ocl.expressions.MessageExp m) {
        MessageExp result = EcoreFactory.eINSTANCE.createMessageExp();
        result.setTarget((OCLExpression)CompatibilityUtil.getNewAS(this.env, m.getTarget()));
        result.setCalledOperation((Object)((CallOperationAction)CompatibilityUtil.getNewAS(this.env, m.getCalledOperation())));
        result.setSentSignal((Object)((SendSignalAction)CompatibilityUtil.getNewAS(this.env, m.getSentSignal())));
        for (Object a : m.getArgument()) {
            result.getArgument().add((Object)((OCLExpression)CompatibilityUtil.getNewAS(this.env, (org.eclipse.emf.ocl.expressions.OCLExpression)a)));
        }
        this.copyOCLExpression(m, (OCLExpression<EClassifier>)result);
        this.copyCallingASTNode(m, (CallingASTNode)result);
        return result;
    }

    @Override
    public Object visitNullLiteralExp(org.eclipse.emf.ocl.expressions.NullLiteralExp il) {
        NullLiteralExp result = EcoreFactory.eINSTANCE.createNullLiteralExp();
        this.copyLiteralExp(il, (LiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitOperationCallExp(OperationCallExp oc) {
        org.eclipse.ocl.ecore.OperationCallExp result = EcoreFactory.eINSTANCE.createOperationCallExp();
        for (Object a : oc.getArgument()) {
            result.getArgument().add((Object)((OCLExpression)CompatibilityUtil.getNewAS(this.env, (org.eclipse.emf.ocl.expressions.OCLExpression)a)));
        }
        this.copyFeatureCallExp(oc, (FeatureCallExp<EClassifier>)result);
        EOperation refOperation = oc.getReferredOperation();
        refOperation = CompatibilityUtil.getNewOperation(refOperation, (EClassifier)result.getSource().getType(), oc.getSource().getType());
        result.setReferredOperation((Object)refOperation);
        return result;
    }

    @Override
    public Object visitPropertyCallExp(org.eclipse.emf.ocl.expressions.PropertyCallExp ae) {
        PropertyCallExp result = EcoreFactory.eINSTANCE.createPropertyCallExp();
        this.copyNavigationCallExp(ae, (org.eclipse.ocl.expressions.NavigationCallExp<EClassifier, EStructuralFeature>)result);
        EStructuralFeature refProperty = ae.getReferredProperty();
        if (ae.getSource() != null) {
            EClassifier sourceType = ae.getSource().getType();
            if (sourceType instanceof MessageType) {
                for (EStructuralFeature p : ((org.eclipse.ocl.types.MessageType)result.getSource().getType()).oclProperties()) {
                    EStructuralFeature next = p;
                    if (!next.getName().equals(refProperty.getName())) continue;
                    refProperty = next;
                    break;
                }
            } else if (sourceType instanceof org.eclipse.emf.ocl.types.TupleType) {
                for (EStructuralFeature p : ((TupleType)result.getSource().getType()).oclProperties()) {
                    EStructuralFeature next = p;
                    if (!next.getName().equals(refProperty.getName())) continue;
                    refProperty = next;
                    break;
                }
            }
        }
        result.setReferredProperty((Object)refProperty);
        return result;
    }

    @Override
    public Object visitRealLiteralExp(org.eclipse.emf.ocl.expressions.RealLiteralExp rl) {
        RealLiteralExp result = EcoreFactory.eINSTANCE.createRealLiteralExp();
        result.setRealSymbol(rl.getRealSymbol());
        this.copyPrimitiveLiteralExp(rl, (org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitStateExp(StateExp s) {
        org.eclipse.ocl.ecore.StateExp result = EcoreFactory.eINSTANCE.createStateExp();
        result.setReferredState((Object)s.getReferredState());
        this.copyOCLExpression(s, (OCLExpression<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitStringLiteralExp(org.eclipse.emf.ocl.expressions.StringLiteralExp sl) {
        StringLiteralExp result = EcoreFactory.eINSTANCE.createStringLiteralExp();
        result.setStringSymbol(sl.getStringSymbol());
        this.copyPrimitiveLiteralExp(sl, (org.eclipse.ocl.expressions.PrimitiveLiteralExp<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitTupleLiteralExp(org.eclipse.emf.ocl.expressions.TupleLiteralExp tl) {
        TupleLiteralExp result = EcoreFactory.eINSTANCE.createTupleLiteralExp();
        this.copyLiteralExp(tl, (LiteralExp<EClassifier>)result);
        for (Object p : tl.getPart()) {
            TupleLiteralPart oldPart = (TupleLiteralPart)p;
            org.eclipse.ocl.expressions.TupleLiteralPart newPart = (org.eclipse.ocl.expressions.TupleLiteralPart)CompatibilityUtil.getNewAS(this.env, oldPart);
            result.getPart().add((Object)newPart);
            this.copyTupleLiteralPart(oldPart, (org.eclipse.ocl.expressions.TupleLiteralPart<EClassifier, EStructuralFeature>)newPart);
        }
        return result;
    }

    @Override
    public Object visitTupleLiteralPart(TupleLiteralPart tp) {
        org.eclipse.ocl.ecore.TupleLiteralPart result = EcoreFactory.eINSTANCE.createTupleLiteralPart();
        result.setAttribute((Object)tp.getAttribute());
        result.setValue((OCLExpression)CompatibilityUtil.getNewAS(this.env, tp.getValue()));
        this.copyTypedASTNode(tp, (org.eclipse.ocl.utilities.TypedASTNode)result);
        this.copyTypedElement(tp, (TypedElement<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitTypeExp(TypeExp t) {
        org.eclipse.ocl.ecore.TypeExp result = EcoreFactory.eINSTANCE.createTypeExp();
        result.setReferredType((Object)((EClassifier)CompatibilityUtil.getNewAS(this.env, (EObject)t.getReferredType())));
        this.copyOCLExpression(t, (OCLExpression<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        org.eclipse.ocl.ecore.UnspecifiedValueExp result = EcoreFactory.eINSTANCE.createUnspecifiedValueExp();
        this.copyTypedASTNode(uv, (org.eclipse.ocl.utilities.TypedASTNode)result);
        this.copyOCLExpression(uv, (OCLExpression<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitVariable(org.eclipse.emf.ocl.expressions.Variable vd) {
        Variable result = EcoreFactory.eINSTANCE.createVariable();
        result.setRepresentedParameter((Object)vd.getRepresentedParameter());
        result.setInitExpression((OCLExpression)CompatibilityUtil.getNewAS(this.env, vd.getInitExpression()));
        this.copyTypedASTNode(vd, (org.eclipse.ocl.utilities.TypedASTNode)result);
        this.copyTypedElement(vd, (TypedElement<EClassifier>)result);
        return result;
    }

    @Override
    public Object visitVariableExp(VariableExp v) {
        org.eclipse.ocl.ecore.VariableExp result = EcoreFactory.eINSTANCE.createVariableExp();
        result.setReferredVariable((org.eclipse.ocl.expressions.Variable)CompatibilityUtil.getNewAS(this.env, v.getReferredVariable()));
        this.copyOCLExpression(v, (OCLExpression<EClassifier>)result);
        return result;
    }

    public CallOperationAction visitCallOperationAction(org.eclipse.emf.ocl.uml.CallOperationAction coa) {
        CallOperationAction result = EcoreFactory.eINSTANCE.createCallOperationAction();
        result.setOperation(coa.getOperation());
        return result;
    }

    public SendSignalAction visitSendSignalAction(org.eclipse.emf.ocl.uml.SendSignalAction ssa) {
        SendSignalAction result = EcoreFactory.eINSTANCE.createSendSignalAction();
        result.setSignal(ssa.getSignal());
        return result;
    }

    public EClassifier visitPredefinedType(EClassifier type) {
        if (this.typesSwitch == null) {
            this.typesSwitch = new TypesSwitch<EClassifier>(){
                OCLStandardLibrary<EClassifier> stdlib = EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLStandardLibrary();

                @Override
                public EClassifier caseAnyType(AnyType object) {
                    if (object == Types.OCL_ANY_TYPE) {
                        return (EClassifier)this.stdlib.getOclAny();
                    }
                    if (object == AnyTypeImpl.OCL_T) {
                        return (EClassifier)this.stdlib.getT();
                    }
                    if (object == AnyTypeImpl.OCL_T2) {
                        return (EClassifier)this.stdlib.getT2();
                    }
                    return EcoreFactory.eINSTANCE.createAnyType();
                }

                @Override
                public EClassifier caseElementType(ElementType object) {
                    if (object == Types.STATE) {
                        return (EClassifier)this.stdlib.getState();
                    }
                    if (object == Types.OCL_ELEMENT) {
                        return (EClassifier)this.stdlib.getOclElement();
                    }
                    org.eclipse.ocl.ecore.ElementType result = EcoreFactory.eINSTANCE.createElementType();
                    result.setName(object.getName());
                    return result;
                }

                @Override
                public EClassifier caseInvalidType(InvalidType object) {
                    return (EClassifier)this.stdlib.getInvalid();
                }

                @Override
                public EClassifier caseVoidType(VoidType object) {
                    return (EClassifier)this.stdlib.getOclVoid();
                }

                @Override
                public EClassifier casePrimitiveBoolean(PrimitiveBoolean object) {
                    return (EClassifier)this.stdlib.getBoolean();
                }

                @Override
                public EClassifier casePrimitiveInteger(PrimitiveInteger object) {
                    return (EClassifier)this.stdlib.getInteger();
                }

                @Override
                public EClassifier casePrimitiveReal(PrimitiveReal object) {
                    return (EClassifier)this.stdlib.getReal();
                }

                @Override
                public EClassifier casePrimitiveString(PrimitiveString object) {
                    return (EClassifier)this.stdlib.getString();
                }

                @Override
                public EClassifier caseTypeType(TypeType object) {
                    if (object == Types.OCL_TYPE) {
                        return (EClassifier)this.stdlib.getOclType();
                    }
                    return (EClassifier)OCLFactoryImpl.INSTANCE.createTypeType((Object)((EClassifier)CompatibilityUtil.getNewAS(ToNewASVisitor.this.env, (EObject)((TypeTypeImpl)object).getReferredType())));
                }

                @Override
                public EClassifier caseCollectionType(org.eclipse.emf.ocl.types.CollectionType object) {
                    if (object == CollectionTypeImpl.OCL_SET) {
                        return (EClassifier)this.stdlib.getSet();
                    }
                    if (object == CollectionTypeImpl.OCL_BAG) {
                        return (EClassifier)this.stdlib.getBag();
                    }
                    if (object == CollectionTypeImpl.OCL_ORDERED_SET) {
                        return (EClassifier)this.stdlib.getOrderedSet();
                    }
                    if (object == CollectionTypeImpl.OCL_SEQUENCE) {
                        return (EClassifier)this.stdlib.getSequence();
                    }
                    if (object == CollectionTypeImpl.OCL_COLLECTION) {
                        return (EClassifier)this.stdlib.getCollection();
                    }
                    return (EClassifier)OCLFactoryImpl.INSTANCE.createCollectionType(object.getKind().asNewKind(), (Object)((EClassifier)CompatibilityUtil.getNewAS(ToNewASVisitor.this.env, (EObject)object.getElementType())));
                }

                @Override
                public EClassifier caseMessageType(MessageType object) {
                    if (object == Types.OCL_MESSAGE) {
                        return (EClassifier)this.stdlib.getOclMessage();
                    }
                    if (object.getReferredOperation() != null) {
                        return (EClassifier)OCLFactoryImpl.INSTANCE.createOperationMessageType((Object)object.getReferredOperation());
                    }
                    return (EClassifier)OCLFactoryImpl.INSTANCE.createSignalMessageType((Object)object.getReferredSignal());
                }

                @Override
                public EClassifier caseTupleType(org.eclipse.emf.ocl.types.TupleType object) {
                    BasicEList parts = new BasicEList(object.getEStructuralFeatures().size());
                    for (EStructuralFeature p : object.getEStructuralFeatures()) {
                        Variable part = EcoreFactory.eINSTANCE.createVariable();
                        part.setName(p.getName());
                        part.setEType((EClassifier)CompatibilityUtil.getNewAS(ToNewASVisitor.this.env, (EObject)p.getEType()));
                        parts.add((Object)part);
                    }
                    return (EClassifier)OCLFactoryImpl.INSTANCE.createTupleType((List)parts);
                }

                @Override
                public EClassifier defaultCase(EObject object) {
                    if (object instanceof InvalidType) {
                        return (EClassifier)this.stdlib.getInvalid();
                    }
                    return null;
                }
            };
        }
        return this.typesSwitch.doSwitch((EObject)type);
    }
}

