/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.statemachine.custom;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionCreateElementCommand;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.uml2.uml.State;

public class StateMachineRegionPolicy
extends CreationEditPolicy {
    IFigure sizeOnDropFeedback = null;
    String dropLocation = "";

    public void eraseTargetFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").remove(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    protected Command getReparentCommand(ChangeBoundsRequest changeBoundsRequest) {
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand("move (re-parent) state");
        for (Object next : changeBoundsRequest.getEditParts()) {
            View view;
            EditPart ep;
            if (!(next instanceof EditPart) || (ep = (EditPart)next) instanceof LabelEditPart) continue;
            if (ep instanceof GroupEditPart) {
                cc.compose((IUndoableOperation)this.getReparentGroupCommand((GroupEditPart)ep));
            }
            if ((view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
                continue;
            }
            if (context == null || !this.shouldReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
            boolean cfr_ignored_0 = semantic instanceof State;
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    public Command getCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        if (this.understandsRequest(request)) {
            if (request instanceof CreateUnspecifiedTypeRequest) {
                CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
                for (IElementType elementType : unspecReq.getElementTypes()) {
                    if (!((IHintedType)elementType).getSemanticHint().equals(((IHintedType)StateMachineRegionPolicy.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Region_Shape")).getSemanticHint())) continue;
                    View existingRegionCompartmentView = (View)this.getHost().getModel();
                    View existingRegionView = (View)existingRegionCompartmentView.eContainer();
                    SemanticAdapter adaptableForExistingRegionView = new SemanticAdapter(null, (Object)existingRegionView);
                    CustomRegionCreateElementCommand createNewRegion = new CustomRegionCreateElementCommand((IAdaptable)adaptableForExistingRegionView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                    return new ICommandProxy(cc.reduce());
                }
            } else {
                if (request instanceof CreateViewRequest) {
                    CreateViewRequest create = (CreateViewRequest)request;
                    for (CreateViewRequest.ViewDescriptor descriptor : create.getViewDescriptors()) {
                        if (!((IHintedType)StateMachineRegionPolicy.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Region_Shape")).getSemanticHint().equals(descriptor.getSemanticHint())) continue;
                        SemanticAdapter compartment = new SemanticAdapter(null, (Object)((View)this.getHost().getModel()).eContainer());
                        CustomRegionCreateElementCommand command = new CustomRegionCreateElementCommand((IAdaptable)compartment, descriptor.getElementAdapter(), ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                        cc.compose((IUndoableOperation)command);
                    }
                    if (!cc.isEmpty()) {
                        return new ICommandProxy(cc.reduce());
                    }
                    return super.getCommand(request);
                }
                if (request instanceof ChangeBoundsRequest) {
                    return this.getReparentCommand((ChangeBoundsRequest)request);
                }
            }
            return super.getCommand(request);
        }
        return null;
    }

    private static IElementType getElementTypeByUniqueId(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)((Shape)this.sizeOnDropFeedback));
            ((Shape)this.sizeOnDropFeedback).setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").add(this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    public String getDropLocation() {
        return this.dropLocation;
    }

    public void showTargetFeedback(Request request) {
        Object newObject;
        if (request instanceof CreateRequest && (newObject = ((CreateRequest)request).getNewObject()) instanceof ContainerCreationDescription && "CreateRegionTool".equals(((ContainerCreationDescription)newObject).getName())) {
            IFigure targetFig = ((GraphicalEditPart)this.getHost()).getFigure();
            Rectangle targetFigBounds = targetFig.getBounds().getCopy();
            targetFig.translateToAbsolute((Translatable)targetFigBounds);
            Point mouseLocation = ((CreateRequest)request).getLocation();
            this.dropLocation = Zone.getZoneFromLocationInRectangleWithAbsoluteCoordinates(mouseLocation, targetFigBounds);
            if (Zone.isTop(this.dropLocation)) {
                targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
            } else if (Zone.isLeft(this.dropLocation)) {
                targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
            } else if (Zone.isRight(this.dropLocation)) {
                targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                targetFigBounds.translate(targetFigBounds.width, 0);
            } else if (Zone.isBottom(this.dropLocation)) {
                targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                targetFigBounds.translate(0, targetFigBounds.height);
            }
            this.getSizeOnDropFeedback().setBounds((Rectangle)new PrecisionRectangle(targetFigBounds));
        }
    }

    public static class Zone {
        public static final String NONE = "";
        public static final String TOP = "T";
        public static final String RIGHT = "R";
        public static final String BOTTOM = "B";
        public static final String LEFT = "L";

        public static String getZoneFromLocationInRectangleWithAbsoluteCoordinates(Point location, Rectangle rect) {
            double d1 = (double)location.y - 1.0 * (double)rect.height / (double)rect.width * (double)(rect.x - location.x) - (double)rect.y - (double)rect.height;
            double d2 = (double)location.y + 1.0 * (double)rect.height / (double)rect.width * (double)(rect.x - location.x) - (double)rect.y;
            if (d1 <= 0.0 && d2 <= 0.0) {
                return TOP;
            }
            if (d1 <= 0.0 && d2 > 0.0) {
                return LEFT;
            }
            if (d1 > 0.0 && d2 <= 0.0) {
                return RIGHT;
            }
            if (d1 > 0.0 && d2 > 0.0) {
                return BOTTOM;
            }
            return NONE;
        }

        public static boolean isTop(String s) {
            if (s == null) {
                return false;
            }
            return s.endsWith(TOP);
        }

        public static boolean isLeft(String s) {
            if (s == null) {
                return false;
            }
            return s.endsWith(LEFT);
        }

        public static boolean isBottom(String s) {
            if (s == null) {
                return false;
            }
            return s.endsWith(BOTTOM);
        }

        public static boolean isRight(String s) {
            if (s == null) {
                return false;
            }
            return s.endsWith(RIGHT);
        }
    }
}

