/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.InternalCrossReferencer;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.AbstractIndex;

public class ArchitectureIndex
extends AbstractIndex {
    private static final ArchitectureIndex INSTANCE = new ArchitectureIndex();
    private final ArchitectureDomainManager domainManager = ArchitectureDomainManager.getInstance();
    private final Map<Mode, AbstractIndex.Computation<Multimap<EObject, EStructuralFeature.Setting>>> crossReferences = new EnumMap<Mode, AbstractIndex.Computation<Multimap>>(Map.of(Mode.EXTERNAL_CROSS_REFERENCE, new AbstractIndex.Computation<Multimap>(this, this::computeExternalCrossReferences), Mode.INTERNAL_CROSS_REFERENCE, new AbstractIndex.Computation<Multimap>(this, this::computeInternalCrossReferences)));
    private final Map<EClass, AbstractIndex.Computation<Multimap<String, ADElement>>> elementsByQualifiedName = ArchitecturePackage.eINSTANCE.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(arg_0 -> ((EClass)ArchitecturePackage.Literals.AD_ELEMENT).isSuperTypeOf(arg_0)).collect(Collectors.toMap(Function.identity(), eClass -> new AbstractIndex.Computation<Multimap>(this, () -> this.computeQualifiedNameMap((EClass)eClass))));

    private ArchitectureIndex() {
        this.domainManager.addListener(this::domainManagerChanged);
    }

    public static ArchitectureIndex getInstance() {
        return INSTANCE;
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getCrossReferences(Mode crossReferenceMode) {
        return this.asyncGet(this.crossReference(crossReferenceMode));
    }

    private AbstractIndex.Computation<Multimap<EObject, EStructuralFeature.Setting>> crossReference(Mode mode) {
        return this.crossReferences.get((Object)mode);
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getExternalCrossReferences() {
        return this.getCrossReferences(Mode.EXTERNAL_CROSS_REFERENCE);
    }

    private Multimap<EObject, EStructuralFeature.Setting> computeExternalCrossReferences() {
        Set architectureDomains = ArchitectureDomainManager.getInstance().getRegisteredArchitectureDomains().stream().collect(Collectors.toSet());
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry next : EcoreUtil.ExternalCrossReferencer.find(architectureDomains).entrySet()) {
            result.putAll((Object)((EObject)next.getKey()), (Iterable)next.getValue());
        }
        return result.build();
    }

    public CompletableFuture<Multimap<EObject, EStructuralFeature.Setting>> getInternalCrossReferences() {
        return this.getCrossReferences(Mode.INTERNAL_CROSS_REFERENCE);
    }

    private Multimap<EObject, EStructuralFeature.Setting> computeInternalCrossReferences() {
        Set architectureDomains = ArchitectureDomainManager.getInstance().getRegisteredArchitectureDomains().stream().collect(Collectors.toSet());
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry next : InternalCrossReferencer.find(architectureDomains).entrySet()) {
            result.putAll((Object)((EObject)next.getKey()), (Iterable)next.getValue());
        }
        return result.build();
    }

    private void domainManagerChanged() {
        this.resetComputations();
    }

    public boolean isReferenced(Mode crossReferenceMode, Resource resource) {
        return this.isReferenced(crossReferenceMode, resource, null);
    }

    public boolean isReferenced(Mode crossReferenceMode, Resource resource, EReference reference) {
        return Optional.ofNullable(resource).map(Resource::getResourceSet).map(context -> this.isReferenced(crossReferenceMode, resource.getURI(), reference, (ResourceSet)context)).orElse(false);
    }

    public boolean isReferenced(EObject object) {
        return this.isReferenced(object, null);
    }

    public boolean isReferenced(EObject object, EReference reference) {
        return Optional.ofNullable(object).map(EObject::eResource).map(Resource::getResourceSet).map(context -> this.isReferenced(ArchitectureIndex.inferCrossReferenceMode(object), EcoreUtil.getURI((EObject)object), reference, (ResourceSet)context)).orElse(false);
    }

    private static Mode inferCrossReferenceMode(EObject object) {
        return object instanceof ADElement ? Mode.INTERNAL_CROSS_REFERENCE : (object != null && object.eContainer() != null ? ArchitectureIndex.inferCrossReferenceMode(object.eContainer()) : Mode.EXTERNAL_CROSS_REFERENCE);
    }

    public boolean isReferenced(Mode crossReferenceMode, URI uri, ResourceSet context) {
        return this.isReferenced(crossReferenceMode, uri, null, context);
    }

    public boolean isReferenced(Mode crossReferenceMode, URI uri, EReference reference, ResourceSet context) {
        return this.transform(this.crossReference(crossReferenceMode), ImmutableMultimap.of(), this.isReferencedFunction(crossReferenceMode, uri, reference, context));
    }

    public CompletableFuture<Boolean> isReferencedAsync(Mode crossReferenceMode, URI uri, EReference reference, ResourceSet context) {
        return this.asyncTransform(this.crossReference(crossReferenceMode), this.isReferencedFunction(crossReferenceMode, uri, reference, context));
    }

    private Function<Multimap<EObject, EStructuralFeature.Setting>, Boolean> isReferencedFunction(Mode crossReferenceMode, URI uri, EReference reference, ResourceSet context) {
        URIConverter converter = context.getURIConverter();
        Function<Object, Object> uriTrimmer = uri.hasFragment() ? Function.identity() : URI::trimFragment;
        Predicate<Map.Entry> referenceFilter = reference == null ? __ -> true : entry -> ((EStructuralFeature.Setting)entry.getValue()).getEStructuralFeature() == reference;
        Predicate<Multimap> isReferenced = xrefs -> xrefs.entries().stream().filter(referenceFilter).map(Map.Entry::getKey).map(EcoreUtil::getURI).map(uriTrimmer).map(arg_0 -> ((URIConverter)converter).normalize(arg_0)).anyMatch(uri::equals);
        return isReferenced::test;
    }

    public <T extends ADElement> CompletableFuture<Multimap<String, T>> getElementsByQualifiedName(EClass eClass) {
        if (ArchitecturePackage.Literals.AD_ELEMENT.isSuperTypeOf(eClass) && (eClass = this.findArchitectureEClass(eClass)) != null) {
            CompletableFuture<Multimap<String, T>> result = this.asyncGet(this.elementsByQualifiedName.get(eClass));
            return result;
        }
        return CompletableFuture.completedFuture(ImmutableMultimap.of());
    }

    private EClass findArchitectureEClass(EClass eClass) {
        if (eClass.getEPackage() == ArchitecturePackage.eINSTANCE) {
            return eClass;
        }
        for (EClass next : eClass.getEAllSuperTypes()) {
            if (next.getEPackage() != ArchitecturePackage.eINSTANCE) continue;
            return next;
        }
        return null;
    }

    public <T extends ADElement> Collection<T> getElementsByQualifiedName(EClass eClass, String name) {
        Collection<T> result;
        try {
            result = this.getElementsByQualifiedNameAsync(eClass, name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying Architecture Context models.", (Throwable)e);
            result = List.of();
        }
        return result;
    }

    public <T extends ADElement> CompletableFuture<Collection<T>> getElementsByQualifiedNameAsync(EClass eClass, String name) {
        return this.getElementsByQualifiedName(eClass).thenApply(map -> map.get((Object)name));
    }

    private Multimap<String, ADElement> computeQualifiedNameMap(EClass eClass) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        EcoreUtil.getAllContents((Collection)ArchitectureDomainManager.getInstance().getRegisteredArchitectureDomains()).forEachRemaining(object -> {
            if (eClass.isInstance(object)) {
                ADElement element = (ADElement)object;
                result.put((Object)element.getQualifiedName(), (Object)element);
            }
        });
        return result.build();
    }

    public Collection<ArchitectureContext> getAllExtensions(ArchitectureContext context) {
        try {
            return this.getAllExtensionsAsync(context).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error("Error querying Architecture Context models.", (Throwable)e);
            return List.of();
        }
    }

    public CompletableFuture<Collection<ArchitectureContext>> getAllExtensionsAsync(ArchitectureContext context) {
        return this.getInternalCrossReferences().thenApply(xrefs -> {
            LinkedHashSet<ArchitectureContext> result = new LinkedHashSet<ArchitectureContext>();
            ArrayDeque<ArchitectureContext> queue = new ArrayDeque<ArchitectureContext>(this.getExtensions(context, (Multimap<EObject, EStructuralFeature.Setting>)xrefs));
            ArchitectureContext next = (ArchitectureContext)queue.poll();
            while (next != null) {
                if (result.add(next)) {
                    queue.addAll(this.getExtensions(next, (Multimap<EObject, EStructuralFeature.Setting>)xrefs));
                }
                next = (ArchitectureContext)queue.poll();
            }
            return result;
        });
    }

    private Collection<ArchitectureContext> getExtensions(ArchitectureContext context, Multimap<EObject, EStructuralFeature.Setting> xrefs) {
        UserSpaceMapping mapping = new UserSpaceMapping((EObject)context);
        return xrefs.get((Object)mapping.toIndexSpace(context)).stream().filter(setting -> setting.getEStructuralFeature() == ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS).map(EStructuralFeature.Setting::getEObject).map(ArchitectureContext.class::cast).distinct().map(mapping::toUserSpace).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static enum Mode {
        EXTERNAL_CROSS_REFERENCE,
        INTERNAL_CROSS_REFERENCE;

    }

    private final class UserSpaceMapping {
        private final ResourceSet userContext;
        private final ResourceSet indexContext;

        UserSpaceMapping(EObject userContext) {
            this.userContext = EMFHelper.getResourceSet((EObject)userContext);
            this.indexContext = ArchitectureIndex.this.domainManager.getRegisteredArchitectureDomains().stream().map(EMFHelper::getResourceSet).filter(Objects::nonNull).findAny().orElse(null);
        }

        <T extends EObject> T toUserSpace(T indexObject) {
            return (T)this.userContext.getEObject(EcoreUtil.getURI(indexObject), true);
        }

        <T extends EObject> T toIndexSpace(T userObject) {
            return (T)(this.indexContext == null ? null : this.indexContext.getEObject(EcoreUtil.getURI(userObject), true));
        }
    }
}

