/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.matcher;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;

public class DisplayModeMouseEventMatcher
implements IMouseEventMatcher {
    private final DisplayMode displayMode;
    private final IMouseEventMatcher aggregate;

    @Deprecated
    public DisplayModeMouseEventMatcher(String displayMode) {
        this(DisplayMode.valueOf(displayMode), null);
    }

    public DisplayModeMouseEventMatcher(DisplayMode displayMode) {
        this(displayMode, null);
    }

    @Deprecated
    public DisplayModeMouseEventMatcher(String displayMode, IMouseEventMatcher aggregate) {
        this(DisplayMode.valueOf(displayMode), aggregate);
    }

    public DisplayModeMouseEventMatcher(DisplayMode displayMode, IMouseEventMatcher aggregate) {
        if (displayMode == null) {
            throw new IllegalArgumentException("displayMode can not be null.");
        }
        this.displayMode = displayMode;
        this.aggregate = aggregate;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
        if (cell != null) {
            boolean displayModeMatches = this.displayMode.equals((Object)cell.getDisplayMode());
            if (this.aggregate != null) {
                return displayModeMatches && this.aggregate.matches(natTable, event, regionLabels);
            }
            return displayModeMatches;
        }
        return false;
    }

    @Deprecated
    public static DisplayModeMouseEventMatcher displayMode(String displayMode, IMouseEventMatcher aggregate) {
        return new DisplayModeMouseEventMatcher(DisplayMode.valueOf(displayMode), aggregate);
    }

    @Deprecated
    public static DisplayModeMouseEventMatcher displayMode(String displayMode) {
        return DisplayModeMouseEventMatcher.displayMode(DisplayMode.valueOf(displayMode), null);
    }

    public static DisplayModeMouseEventMatcher displayMode(DisplayMode displayMode, IMouseEventMatcher aggregate) {
        return new DisplayModeMouseEventMatcher(displayMode, aggregate);
    }

    public static DisplayModeMouseEventMatcher displayMode(DisplayMode displayMode) {
        return DisplayModeMouseEventMatcher.displayMode(displayMode, null);
    }
}

