/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.action;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragModeWithKeySupport;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class AggregateDragMode
implements IDragMode,
IDragModeWithKeySupport {
    private MouseEvent initialEvent;
    private MouseEvent currentEvent;
    private final Collection<IDragMode> dragModes = new LinkedHashSet<IDragMode>();

    public AggregateDragMode() {
    }

    public AggregateDragMode(IDragMode ... dragModes) {
        IDragMode[] iDragModeArray = dragModes;
        int n = dragModes.length;
        int n2 = 0;
        while (n2 < n) {
            IDragMode dragMode = iDragModeArray[n2];
            this.addDragMode(dragMode);
            ++n2;
        }
    }

    public void addDragMode(IDragMode dragMode) {
        this.dragModes.add(dragMode);
    }

    public void removeDragMode(IDragMode dragMode) {
        this.dragModes.remove(dragMode);
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.currentEvent = this.initialEvent = event;
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseDown(natTable, event);
        }
        natTable.forceFocus();
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        this.currentEvent = event;
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseMove(natTable, event);
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseUp(natTable, event);
        }
    }

    protected MouseEvent getInitialEvent() {
        return this.initialEvent;
    }

    protected MouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public void keyPressed(NatTable natTable, KeyEvent event) {
        for (IDragMode dragMode : this.dragModes) {
            if (!(dragMode instanceof IDragModeWithKeySupport)) continue;
            ((IDragModeWithKeySupport)dragMode).keyPressed(natTable, event);
        }
    }

    @Override
    public void keyReleased(NatTable natTable, KeyEvent event) {
        for (IDragMode dragMode : this.dragModes) {
            if (!(dragMode instanceof IDragModeWithKeySupport)) continue;
            ((IDragModeWithKeySupport)dragMode).keyReleased(natTable, event);
        }
    }
}

